/*
 * Decompiled with CFR 0.152.
 */
class FGDataWriter {
    private static final int CHUNK_SIZE = 1024;
    private boolean m_bError = false;
    private byte[] m_data = null;
    private int m_dataAlloc = 0;
    private int m_dataPos = 0;
    private FGData m_sentInBuffer = null;
    private boolean m_bUseSentInBuffer = false;
    private byte[] m_buffer = new byte[8];

    void init() {
        this.releaseData();
    }

    void init(FGData fGData) {
        this.releaseData();
        this.m_sentInBuffer = fGData;
        this.m_bUseSentInBuffer = true;
    }

    public int getDataPos() {
        return this.m_dataPos;
    }

    public void setDataPos(int n) {
        this.m_dataPos = n;
    }

    boolean getError() {
        return this.m_bError;
    }

    void releaseData() {
        this.m_data = null;
        this.m_dataAlloc = 0;
        this.m_dataPos = 0;
        this.m_bError = false;
        this.m_sentInBuffer = null;
        this.m_bUseSentInBuffer = false;
    }

    void writeBoolean(boolean bl) {
        if (this.getError()) {
            return;
        }
        if (bl) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    void writeByte(byte by) {
        if (this.getError()) {
            return;
        }
        this.m_buffer[0] = by;
        this.writeToData(this.m_buffer, 1);
    }

    void writeInt(int n) {
        if (this.getError()) {
            return;
        }
        this.m_buffer[0] = (byte)((n & 0xFF000000) >> 24);
        this.m_buffer[1] = (byte)((n & 0xFF0000) >> 16);
        this.m_buffer[2] = (byte)((n & 0xFF00) >> 8);
        this.m_buffer[3] = (byte)(n & 0xFF);
        this.writeToData(this.m_buffer, 4);
    }

    void writeShort(short s) {
        if (this.getError()) {
            return;
        }
        this.m_buffer[0] = (byte)((s & 0xFF00) >> 8);
        this.m_buffer[1] = (byte)(s & 0xFF);
        this.writeToData(this.m_buffer, 2);
    }

    void writeLong(long l) {
        this.writeInt((int)l);
    }

    void writeUTF(FGString fGString) {
        if (this.getError()) {
            return;
        }
        int n = fGString.length();
        this.writeInt(n);
        this.writeToData(fGString.getNativeString().getBytes(), n);
    }

    void writeRaw(FGData fGData, int n) {
        if (n > fGData.m_dataLength) {
            FGEngine.fatal("attempt to write more data than we have to read from in writeRaw");
            return;
        }
        this.writeToData(fGData.m_data, n);
    }

    public FGData getData() {
        if (this.m_bUseSentInBuffer) {
            this.m_sentInBuffer.m_dataLength = this.m_dataPos;
            return this.m_sentInBuffer;
        }
        if (this.m_data == null) {
            FGData fGData = new FGData();
            return fGData;
        }
        FGData fGData = new FGData();
        fGData.adopt(this.m_data, this.m_dataPos, this.m_dataAlloc);
        this.releaseData();
        return fGData;
    }

    void writeToData(byte[] byArray, int n) {
        int n2 = this.m_dataPos + n;
        if (this.m_bUseSentInBuffer) {
            if (this.m_sentInBuffer.m_allocated < n2) {
                FGEngine.fatal("buffer overrun in FGDataWriter");
                return;
            }
            System.arraycopy(byArray, 0, this.m_sentInBuffer.m_data, this.m_dataPos, n);
        } else {
            this.ensureSpace(n2);
            System.arraycopy(byArray, 0, this.m_data, this.m_dataPos, n);
        }
        if (this.getError()) {
            return;
        }
        this.m_dataPos += n;
    }

    void ensureSpace(int n) {
        if (n <= this.m_dataAlloc) {
            return;
        }
        int n2 = (n + 1024) / 1024;
        int n3 = n2 * 1024;
        byte[] byArray = new byte[n3];
        if (this.m_data != null) {
            System.arraycopy(this.m_data, 0, byArray, 0, this.m_dataPos);
        }
        this.m_data = byArray;
        this.m_dataAlloc = n3;
    }
}

