/*
 * Decompiled with CFR 0.152.
 */
class FGPath {
    public static final byte MAX_WAYPOINTS = 32;
    public static final byte TILE_BLOCK = 127;
    public static final byte TILE_UNDEF = -1;
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_DOWN = 1;
    public static final int DIRECTION_LEFT = 2;
    public static final int DIRECTION_RIGHT = 3;
    public static final int DIRECTION_UPLEFT = 4;
    public static final int DIRECTION_UPRIGHT = 5;
    public static final int DIRECTION_DOWNLEFT = 6;
    public static final int DIRECTION_DOWNRIGHT = 7;
    private byte[] m_tiles;
    private int m_tilesX;
    private int m_tilesY;
    private int m_mapWidth;
    private int m_mapHeight;
    private int m_mapCellWidth;
    private int m_mapCellHeight;
    private int[] m_waypointsX = new int[32];
    private int[] m_waypointsY = new int[32];
    private int m_numWaypoints;

    public void init(int n, int n2, int n3, int n4) {
        this.m_mapWidth = n;
        this.m_mapHeight = n2;
        this.m_mapCellWidth = n3;
        this.m_mapCellHeight = n4;
        this.m_tilesX = this.m_mapWidth / this.m_mapCellWidth;
        this.m_tilesY = this.m_mapHeight / this.m_mapCellHeight;
        this.allocateTiles();
    }

    public void clearObstacles() {
        this.clearAllTiles();
    }

    public void addObstacleRect(int n, int n2, int n3, int n4) {
        int n5 = n / this.m_mapCellWidth;
        int n6 = (n + n3 - 1) / this.m_mapCellWidth;
        int n7 = n2 / this.m_mapCellWidth;
        int n8 = (n2 + n4 - 1) / this.m_mapCellWidth;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 >= this.m_tilesX) {
            n6 = this.m_tilesX - 1;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 >= this.m_tilesY) {
            n8 = this.m_tilesY - 1;
        }
        for (int i = n5; i <= n6; ++i) {
            for (int j = n7; j <= n8; ++j) {
                this.setTileValue(i, j, (byte)127);
            }
        }
    }

    public boolean findPath(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        this.m_numWaypoints = -1;
        this.clearNonBlockTiles();
        int n9 = n / this.m_mapCellWidth;
        int n10 = n2 / this.m_mapCellHeight;
        int n11 = n3 / this.m_mapCellWidth;
        int n12 = n4 / this.m_mapCellHeight;
        if (this.getTileValue(n9, n10) == 127 || this.getTileValue(n11, n12) == 127) {
            return false;
        }
        this.setTileValue(n11, n12, (byte)0);
        int n13 = 0;
        int n14 = this.m_tilesX * this.m_tilesY;
        boolean bl = false;
        while (!bl) {
            n8 = 0;
            for (n7 = 0; n7 < n14; ++n7) {
                if (this.m_tiles[n7] != n13) continue;
                n6 = n7 % this.m_tilesX;
                n5 = n7 / this.m_tilesX;
                int n15 = n6 - 1;
                int n16 = n6 + 1;
                int n17 = n5 - 1;
                int n18 = n5 + 1;
                if (n15 < 0) {
                    n15 = 0;
                }
                if (n16 >= this.m_tilesX) {
                    n16 = this.m_tilesX - 1;
                }
                if (n17 < 0) {
                    n17 = 0;
                }
                if (n18 >= this.m_tilesY) {
                    n18 = this.m_tilesY - 1;
                }
                for (int i = n15; i <= n16; ++i) {
                    for (int j = n17; j <= n18; ++j) {
                        if (this.getTileValue(i, j) != -1) continue;
                        this.setTileValue(i, j, (byte)(n13 + 1));
                    }
                }
                n8 = 1;
            }
            if (this.getTileValue(n9, n10) != -1) {
                bl = true;
            }
            if (n8 == 0) {
                return false;
            }
            ++n13;
        }
        this.m_numWaypoints = 0;
        n8 = -1;
        n7 = n9;
        n6 = n10;
        bl = false;
        while (!bl) {
            if (n7 == n11 && n6 == n12) {
                bl = true;
                continue;
            }
            n5 = this.getNextTile(n7, n6);
            if (n5 != n8) {
                if (n8 != -1) {
                    this.addWaypoint(n7, n6);
                }
                n8 = n5;
            }
            n7 = this.getNavX(n7, n6, n5);
            n6 = this.getNavY(n7, n6, n5);
        }
        this.m_waypointsX[this.m_numWaypoints] = n3;
        this.m_waypointsY[this.m_numWaypoints] = n4;
        ++this.m_numWaypoints;
        return true;
    }

    private void addWaypoint(int n, int n2) {
        this.m_waypointsX[this.m_numWaypoints] = n * this.m_mapCellWidth + this.m_mapCellWidth / 2;
        this.m_waypointsY[this.m_numWaypoints] = n2 * this.m_mapCellHeight + this.m_mapCellHeight / 2;
        ++this.m_numWaypoints;
    }

    public int getNextTile(int n, int n2) {
        int n3 = this.getTileValue(n, n2);
        if (n3 == 0) {
            FGEngine.fatal("getNextTile called on a tile value 0");
            return -1;
        }
        int n4 = n3 - 1;
        for (int i = 0; i < 8; ++i) {
            int n5 = this.getTileValue(n, n2, i);
            if (n5 != n4) continue;
            return i;
        }
        FGEngine.fatal("could not find tile in getNextTile");
        return -1;
    }

    public int getNavX(int n, int n2, int n3) {
        switch (n3) {
            case 0: 
            case 1: {
                return n;
            }
            case 2: 
            case 4: 
            case 6: {
                return n - 1;
            }
            case 3: 
            case 5: 
            case 7: {
                return n + 1;
            }
        }
        return n;
    }

    public int getNavY(int n, int n2, int n3) {
        switch (n3) {
            case 2: 
            case 3: {
                return n2;
            }
            case 0: 
            case 4: 
            case 5: {
                return n2 - 1;
            }
            case 1: 
            case 6: 
            case 7: {
                return n2 + 1;
            }
        }
        return n;
    }

    private int getTileValue(int n, int n2, int n3) {
        int n4 = this.getNavX(n, n2, n3);
        int n5 = this.getNavY(n, n2, n3);
        if (n4 < 0) {
            return -1;
        }
        if (n5 < 0) {
            return -1;
        }
        if (n4 >= this.m_tilesX) {
            return -1;
        }
        if (n5 >= this.m_tilesY) {
            return -1;
        }
        return this.getTileValue(n4, n5);
    }

    private void allocateTiles() {
        this.m_tiles = new byte[this.m_tilesX * this.m_tilesY];
        this.clearAllTiles();
    }

    private void clearAllTiles() {
        for (int i = 0; i < this.m_tilesX * this.m_tilesY; ++i) {
            this.m_tiles[i] = -1;
        }
    }

    private void clearNonBlockTiles() {
        for (int i = 0; i < this.m_tilesX * this.m_tilesY; ++i) {
            if (this.m_tiles[i] == 127) continue;
            this.m_tiles[i] = -1;
        }
    }

    private int getTileValue(int n, int n2) {
        return this.m_tiles[n2 * this.m_tilesX + n];
    }

    private void setTileValue(int n, int n2, byte by) {
        this.m_tiles[n2 * this.m_tilesX + n] = by;
    }

    public int getNumWaypoints() {
        return this.m_numWaypoints;
    }

    public int getWaypointX(int n) {
        return this.m_waypointsX[n];
    }

    public int getWaypointY(int n) {
        return this.m_waypointsY[n];
    }
}

