/*
 * Decompiled with CFR 0.152.
 */
class CVArmy {
    public static final int NUM_EXPLOSIONS_AT_ONCE = 5;
    public static final int LOSE_EXPLOSION_TIME = 2000;
    public static final int HIT_EXPLOSION_TIME = 250;
    int m_side;
    int m_civID;
    CVGameMode m_game;
    public int m_unitsStart;
    public CVUnit[] m_units = new CVUnit[16];
    public CVUnit[] m_skirmishers = new CVUnit[16];
    public int m_numUnitsInSkirmish;
    public long m_fixForwardMost;
    public int m_food;
    public int m_ore;
    int m_farmsControlled;
    int m_minesControlled;
    CVArtillery m_artillery = new CVArtillery();
    FGVector m_artilleryStart = new FGVector();
    FGAnimation[] m_unitWalkGFX = new FGAnimation[5];
    FGAnimation[] m_unitAttackGFX = new FGAnimation[5];
    FGImage m_castleGFX;
    FGImage m_farmImg;
    FGImage m_mineImg;
    FGString m_civName = new FGString();
    FGLayout m_unitGFX = new FGLayout();
    int m_castleDrawLocX;
    int m_castleDrawLocY;
    int m_unitOffsetY;
    int m_militaryTechLevel;
    int m_scienceTechLevel;
    int m_engineeringTechLevel;
    int m_projectileOffsetX;
    int m_projectileOffsetY;
    FGImage m_projectile;
    int m_burnX;
    int m_burnWidth;
    FGTimer m_burnTimer = new FGTimer();
    boolean m_bCastleExplosions;
    FGAnimation m_explosion = new FGAnimation();
    FGTimer m_explosionsTimer = new FGTimer();
    int[] m_explosionX = new int[5];
    int[] m_explosionY = new int[5];
    FGAnimation m_flameAnim = new FGAnimation();
    FGAnimation m_satelliteAnim = new FGAnimation();
    CVUnit m_fwdMostUnit;
    boolean m_bPaused;

    public CVArmy() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.m_units[n] = new CVUnit();
        }
        for (n = 0; n < 5; ++n) {
            this.m_unitWalkGFX[n] = new FGAnimation();
            this.m_unitAttackGFX[n] = new FGAnimation();
        }
    }

    public void tick() {
        if (this.m_bCastleExplosions && this.m_explosion.finishedPlaying()) {
            if (!this.m_explosionsTimer.isOver()) {
                this.makeCastleExplosion();
            } else {
                this.m_bCastleExplosions = false;
            }
        }
        this.m_fwdMostUnit = this.m_game.getForwardMostNonWallUnit(this.m_side);
    }

    public void makeCastleExplosion() {
        FGImage fGImage = this.m_explosion.getFrame(0);
        int n = fGImage.getWidth() / 3;
        int n2 = fGImage.getHeight() / 3;
        int n3 = this.m_castleDrawLocX + n;
        int n4 = this.m_castleGFX.getWidth() - n * 2;
        int n5 = this.m_castleDrawLocY + n2;
        int n6 = this.m_castleGFX.getHeight() - n2 * 2;
        for (int i = 0; i < 5; ++i) {
            this.m_explosionX[i] = n3 + this.m_game.m_engine.rand() % n4;
            this.m_explosionY[i] = n5 + this.m_game.m_engine.rand() % n6;
        }
        this.m_explosion.playOnce();
    }

    public void init(CVGameMode cVGameMode, int n) {
        this.m_game = cVGameMode;
        this.m_side = n;
        this.m_artillery.init(cVGameMode, this.m_side);
        this.clear();
        this.m_militaryTechLevel = -1;
        this.m_scienceTechLevel = -1;
        this.m_engineeringTechLevel = -1;
        this.m_bCastleExplosions = false;
        this.m_bPaused = false;
    }

    public void startCastleHitAnim() {
        this.castleExplosions(250);
    }

    public void startLoseBattleAnim() {
        this.castleExplosions(2000);
    }

    public void castleExplosions(int n) {
        this.m_bCastleExplosions = true;
        this.m_explosionsTimer.start(n);
        this.makeCastleExplosion();
    }

    public void drawCastle(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_castleDrawLocX - this.m_game.m_scroll;
        int n5 = this.m_castleDrawLocY;
        this.m_castleGFX.drawSelf(fGGraphics, n4, n5);
        CVGameMode cVGameMode = this.m_game;
        if (cVGameMode.m_engine.isLarge()) {
            int n6;
            int n7 = n4 + 1;
            n3 = n4 + this.m_castleGFX.getWidth() - this.m_game.m_milStructure.getWidth();
            n2 = n7 + this.m_game.m_engStructure.getWidth();
            n = n3 - n2;
            int n8 = n2 + (n - this.m_game.m_sciStructure.getWidth()) / 2;
            int n9 = n5 + this.m_castleGFX.getHeight() - 1;
            if (this.m_militaryTechLevel >= 4) {
                n6 = n9 - this.m_game.m_milStructure.getHeight();
                this.m_game.m_milStructure.drawSelf(fGGraphics, n3, n6);
            }
            if (this.m_engineeringTechLevel >= 4) {
                n6 = n9 - this.m_game.m_engStructure.getHeight();
                this.m_game.m_engStructure.drawSelf(fGGraphics, n7, n6);
            }
            if (this.m_scienceTechLevel >= 4) {
                n6 = n9 - this.m_game.m_sciStructure.getHeight();
                this.m_game.m_sciStructure.drawSelf(fGGraphics, n8, n6);
            }
        }
        if (this.m_bCastleExplosions) {
            FGImage fGImage = this.m_explosion.getCurrentFrame();
            for (n3 = 0; n3 < 5; ++n3) {
                n2 = this.m_explosionX[n3] - this.m_game.m_scroll - fGImage.getWidth() / 2;
                n = this.m_explosionY[n3] - fGImage.getHeight() / 2;
                fGImage.drawSelf(fGGraphics, n2, n);
            }
        }
    }

    public void drawBurn(FGGraphics fGGraphics) {
        if (this.m_burnTimer.isOver()) {
            return;
        }
        int n = this.m_flameAnim.getFrame(0).getWidth();
        int n2 = this.m_flameAnim.getFrame(0).getHeight();
        for (int i = 0; i <= this.m_burnWidth / 2; i += n - 3) {
            for (int j = 0; j < 2; ++j) {
                int n3 = i + this.m_burnX;
                if (j == 1) {
                    n3 = this.m_burnX + this.m_burnWidth - i - n;
                }
                int n4 = n3 + n / 2;
                int n5 = this.m_game.getTerrainY(n4) - n2 + this.m_unitOffsetY;
                int n6 = this.m_game.m_engine.rand() % 2;
                if (this.m_bPaused) {
                    n6 = j % 2;
                }
                FGImage fGImage = this.m_flameAnim.getFrame(n6);
                fGImage.drawSelf(fGGraphics, n3 -= this.m_game.m_scroll, n5);
            }
        }
    }

    public void registerNeededResources(FGResLoader fGResLoader) {
        boolean bl = true;
        FGString fGString = new FGString();
        CVGameMode cVGameMode = this.m_game;
        if (cVGameMode.m_engine.isSmall()) {
            bl = true;
            fGString.set("era_1.lyt");
        } else {
            if (this.m_side != 0) {
                bl = this.m_civID != this.m_game.m_era;
            }
            if (bl) {
                fGString.set("era_");
            } else {
                fGString.set("civ_");
            }
            fGString.add(this.m_game.m_era);
            fGString.add(".lyt");
        }
        this.m_unitGFX.init(fGString.getNativeString());
        this.m_unitGFX.registerNeededImages(fGResLoader);
        CVGameMode cVGameMode2 = this.m_game;
        if (cVGameMode2.m_engine.isSmall()) {
            fGResLoader.registerImage("castle_0.png");
        } else {
            this.registerCivResource(fGResLoader, "castle_", this.m_civID);
        }
        CVGameMode cVGameMode3 = this.m_game;
        if (cVGameMode3.m_engine.isSmall()) {
            fGResLoader.registerImage("farmBlue.png");
            fGResLoader.registerImage("mineBlue.png");
        } else if (this.m_side == 0) {
            fGResLoader.registerImage("farmBlue.png");
            fGResLoader.registerImage("mineBlue.png");
        } else {
            fGResLoader.registerImage("farmRed.png");
            fGResLoader.registerImage("mineRed.png");
        }
        fGResLoader.registerImage("flame1.png");
        fGResLoader.registerImage("flame2.png");
        fGResLoader.registerImage("satellite1.png");
        fGResLoader.registerImage("satellite2.png");
        fGResLoader.registerImage("satellite3.png");
    }

    public void getNeededResources(FGResLoader fGResLoader) {
        CVGameMode cVGameMode = this.m_game;
        this.m_castleGFX = cVGameMode.m_engine.isSmall() ? fGResLoader.getImage("castle_0.png") : this.getCivResource(fGResLoader, "castle_", this.m_civID);
        this.m_civName.set(this.m_game.getCivName(this.m_civID));
        this.m_unitGFX.getNeededImages(fGResLoader);
        this.m_unitOffsetY = this.m_unitGFX.getElementHeight("unit_offsetY");
        this.m_artillery.getNeededImages(this.m_unitGFX, fGResLoader);
        this.m_explosion.init(this.m_game.m_explosion);
        for (int i = 0; i < 5; ++i) {
            this.m_unitWalkGFX[i].init(250);
            this.m_unitAttackGFX[i].init(250);
        }
        this.fillAnimFromEraGraphics(this.m_unitWalkGFX[0], "infantryw_");
        this.fillAnimFromEraGraphics(this.m_unitWalkGFX[1], "rangedw_");
        this.fillAnimFromEraGraphics(this.m_unitWalkGFX[2], "mobilew_");
        this.fillAnimFromEraGraphics(this.m_unitWalkGFX[3], "wall_");
        this.fillAnimFromEraGraphics(this.m_unitWalkGFX[4], "fort_");
        this.fillAnimFromEraGraphics(this.m_unitAttackGFX[0], "infantrya_");
        this.fillAnimFromEraGraphics(this.m_unitAttackGFX[1], "rangeda_");
        this.fillAnimFromEraGraphics(this.m_unitAttackGFX[2], "mobilea_");
        FGString fGString = new FGString();
        fGString.add("rangeda_");
        fGString.add(this.m_unitAttackGFX[1].m_numFrames);
        int n = this.m_unitGFX.getElementX(fGString.getNativeString());
        int n2 = this.m_unitGFX.getElementY(fGString.getNativeString());
        int n3 = this.m_unitGFX.getElementX("shot");
        int n4 = this.m_unitGFX.getElementY("shot");
        this.m_projectile = this.m_unitGFX.getElementImage("shot");
        this.m_projectileOffsetX = n3 - n;
        this.m_projectileOffsetY = n4 - n2;
        CVGameMode cVGameMode2 = this.m_game;
        if (cVGameMode2.m_engine.isSmall()) {
            this.m_farmImg = fGResLoader.getImage("farmBlue.png");
            this.m_mineImg = fGResLoader.getImage("mineBlue.png");
        } else if (this.m_side == 0) {
            this.m_farmImg = fGResLoader.getImage("farmBlue.png");
            this.m_mineImg = fGResLoader.getImage("mineBlue.png");
        } else {
            this.m_farmImg = fGResLoader.getImage("farmRed.png");
            this.m_mineImg = fGResLoader.getImage("mineRed.png");
        }
        this.m_flameAnim.init(100);
        this.m_flameAnim.addFrame(fGResLoader.getImage("flame1.png"));
        this.m_flameAnim.addFrame(fGResLoader.getImage("flame2.png"));
        this.m_satelliteAnim.init(200);
        this.m_satelliteAnim.addFrame(fGResLoader.getImage("satellite1.png"));
        this.m_satelliteAnim.addFrame(fGResLoader.getImage("satellite2.png"));
        this.m_satelliteAnim.addFrame(fGResLoader.getImage("satellite3.png"));
        this.m_bCastleExplosions = false;
        this.m_burnTimer.start(0);
        this.m_burnX = -1;
        this.m_burnWidth = 0;
    }

    public void registerCivResource(FGResLoader fGResLoader, String string, int n) {
        FGString fGString = new FGString();
        fGString.set(string);
        fGString.add(n);
        fGString.add(".png");
        fGResLoader.registerImage(fGString.getNativeString());
    }

    public FGImage getCivResource(FGResLoader fGResLoader, String string, int n) {
        FGString fGString = new FGString();
        fGString.set(string);
        fGString.add(n);
        fGString.add(".png");
        return fGResLoader.getImage(fGString.getNativeString());
    }

    public void fillAnimFromEraGraphics(FGAnimation fGAnimation, String string) {
        Object object;
        boolean bl = true;
        FGString fGString = new FGString();
        int n = 1;
        do {
            fGString.set(string);
            fGString.add(n);
            object = this.m_unitGFX.getElementImage(fGString.getNativeString());
            if (object != null) {
                fGAnimation.addFrame((FGImage)object);
                ++n;
                continue;
            }
            bl = false;
        } while (bl);
        if (n == 0) {
            object = new FGString();
            ((FGString)object).set("Could not find any units with root=");
            ((FGString)object).add(string);
            FGEngine.fatal(((FGString)object).getNativeString());
        }
    }

    private FGImage getEraElement(String string) {
        FGImage fGImage = this.m_unitGFX.getElementImage(string);
        if (fGImage == null) {
            FGString fGString = new FGString();
            fGString.set("could not find era image: ");
            fGString.add(string);
            FGEngine.fatal(fGString.getNativeString());
        }
        return fGImage;
    }

    public void clear() {
        for (int i = 0; i < 16; ++i) {
            this.m_units[i].clear();
            this.m_skirmishers[i] = null;
        }
        this.clearSkirmish();
        this.m_fixForwardMost = -1L;
        this.m_food = this.m_game.m_engine.m_foodStart;
        this.m_ore = this.m_game.m_engine.m_oreStart;
        this.m_farmsControlled = 0;
        this.m_minesControlled = 0;
        this.m_artillery.m_bActive = false;
        this.m_castleDrawLocX = -1;
        this.m_castleDrawLocY = -1;
    }

    public void clearSkirmish() {
        for (int i = 0; i < 16; ++i) {
            this.m_skirmishers[i] = null;
            this.m_units[i].m_bInSkirmish = false;
        }
        this.m_numUnitsInSkirmish = 0;
    }

    public void clearArt() {
        this.m_castleGFX = null;
        this.m_farmImg = null;
        this.m_mineImg = null;
        this.m_artillery.clearArt();
        for (int i = 0; i < 5; ++i) {
            this.m_unitWalkGFX[i].clearArt();
            this.m_unitAttackGFX[i].clearArt();
        }
        this.m_unitGFX.clearArt();
    }

    public void pause() {
        this.m_bPaused = true;
        for (int i = 0; i < 5; ++i) {
            this.m_unitWalkGFX[i].pause();
            this.m_unitAttackGFX[i].pause();
        }
        this.m_burnTimer.pause();
        this.m_satelliteAnim.pause();
    }

    public void resume() {
        this.m_bPaused = false;
        for (int i = 0; i < 5; ++i) {
            this.m_unitWalkGFX[i].resume();
            this.m_unitAttackGFX[i].resume();
        }
        this.m_burnTimer.resume();
        this.m_satelliteAnim.resume();
    }

    public void capResources() {
        if (this.m_food < 0) {
            this.m_food = 0;
        }
        if (this.m_ore < 0) {
            this.m_ore = 0;
        }
        if (this.m_food > this.m_game.m_engine.m_maxFood) {
            this.m_food = this.m_game.m_engine.m_maxFood;
        }
        if (this.m_ore > this.m_game.m_engine.m_maxOre) {
            this.m_ore = this.m_game.m_engine.m_maxOre;
        }
    }

    public void startBurn(int n, int n2) {
        this.m_burnX = n;
        this.m_burnWidth = n2;
        this.m_burnTimer.start(this.m_game.m_engine.m_techValues[9]);
    }

    public boolean isInBurn(int n) {
        if (this.m_burnTimer.isOver()) {
            return false;
        }
        if (n < this.m_burnX) {
            return false;
        }
        return n <= this.m_burnX + this.m_burnWidth;
    }
}

