/*
 * Decompiled with CFR 0.152.
 */
class CVUIMode
extends CVMode {
    public static final int MENU_BACK = 1;
    public static final int MENU_EXIT = 2;
    public static final int MENU_EASY = 3;
    public static final int MENU_MEDIUM = 4;
    public static final int MENU_HARD = 5;
    public static final int MENU_PLAY = 7;
    public static final int MENU_SELECT_CIV_0 = 8;
    public static final int MENU_SELECT_CIV_1 = 9;
    public static final int MENU_SELECT_CIV_2 = 10;
    public static final int MENU_SELECT_CIV_3 = 11;
    public static final int MENU_CONTINUE_FROM_PAUSE = 12;
    public static final int MENU_QUICKPLAY = 13;
    public static final int MENU_OPTIONS = 14;
    public static final int MENU_HELP = 15;
    public static final int MENU_QUIT_GAME = 16;
    public static final int MENU_CONTINUE_FROM_MM = 17;
    public static final int MENU_REPLAY_LEVEL = 21;
    public static final int MENU_MAIN_MENU = 22;
    public static final int MENU_SHOW_TECH = 23;
    public static final int MENU_SHOW_ENEMY_TECH = 24;
    public static final int MENU_SOUND_IS_ON = 25;
    public static final int MENU_SOUND_IS_OFF = 26;
    public static final int MENU_ABOUT = 28;
    public static final int MENU_GAMELOBBY = 29;
    public static final int MENU_HELP_CONTROLS = 30;
    public static final int MENU_HELP_TIPS = 31;
    public static final int MENU_HELP_TUTORIAL = 32;
    public static final int MENU_BEST_TIMES = 33;
    public static final int MENU_LANGUAGE_0 = 34;
    public static final int MENU_LANGUAGE_1 = 35;
    public static final int MENU_LANGUAGE_2 = 36;
    public static final int MENU_LANGUAGE_3 = 37;
    public static final int MENU_LANGUAGE_4 = 38;
    public static final int MENU_LANGUAGE = 39;
    public static final int MENU_LOG = 40;
    public static final int MODE_NONE = -1;
    public static final int MODE_MENU = 0;
    public static final int MODE_TECH = 1;
    public static final int MODE_WINGAME = 2;
    public static final int MODE_FORM = 3;
    public static final int MODE_CONFIRM = 4;
    public static final int MODE_HIGHSCORES = 5;
    public static final int MODE_LOADLANGUAGE = 6;
    public static final int MODE_EXITING = 7;
    public static final int MODE_MRC = 8;
    public static final int MODE_EXIT_CONFIRMATION = 9;
    public static final int CONFIRM_SOUNDON = 0;
    public static final int CONFIRM_ABANDON = 1;
    public static final int CONFIRM_HARDERROR = 2;
    public static final int CONFIRM_MRC_DENIED = 3;
    public static final int CONFIRM_MRC_NETFAIL = 4;
    public static final int CONFIRM_EXIT = 5;
    public static final int TIME_TECH_SWEEP = 300;
    public static final int TIME_SHOW_TECH_SELECTION = 200;
    public static final int TECH_FAIL_NONE = 0;
    public static final int TECH_FAIL_ALREADY_HAVE = 1;
    public static final int TECH_FAIL_INACCESSABLE = 2;
    public static final int TECH_FAIL_DIFFLEVEL = 3;
    public static final int NUM_FIREWORKS = 5;
    public static final int TIME_FIREWORK_ANIM = 120;
    public static final int SMALL_TECHBOX_CAP_WIDTH = 3;
    public static final int SMALL_TECHBOX_HEIGHT = 11;
    public static final int TECHBOX_TYPE_HAVE = 0;
    public static final int TECHBOX_TYPE_AVAIL = 1;
    public static final int TECHBOX_TYPE_NOHAVE = 2;
    public static final int TECHBOX_TYPE_UNAVAIL = 3;
    public static final int TECHBOX_TYPE_SELECTION = 4;
    public static final int TECHBOX_TYPE_GREYED = 5;
    public static final int COLOR_TECHBOX_TYPE_HAVE = 0xFFF200;
    public static final int COLOR_TECHBOX_TYPE_AVAIL = 0xABA000;
    public static final int COLOR_TECHBOX_TYPE_NOHAVE = 0x464646;
    public static final int COLOR_TECHBOX_TYPE_UNAVAIL = 0;
    public static final int COLOR_TECHBOX_TYPE_SELECTION = 0xFFFFFF;
    public static final int COLOR_TECHBOX_TYPE_GREYED = 0x7F7F7F;
    public static final int WEB_BUFFER_SIZE = 1024;
    public int m_mode;
    public FGStdMenu m_currentMenu = null;
    public FGStdMenu m_mainMenu;
    public FGStdMenu m_difficultyMenu;
    public FGStdMenu m_civSelectMenu;
    public FGStdMenu m_pauseMenu;
    public FGStdMenu m_defeatMenu;
    public FGStdMenu m_optionsMenu;
    public FGStdMenu m_helpMenu;
    public FGStdMenu m_languageMenu;
    public FGImage m_bannerEdge;
    public FGImage m_bannerTile;
    int m_map;
    int m_difficulty;
    int m_civ;
    int m_era;
    int m_opponent;
    int m_descCenterY;
    boolean m_bSelectingTech;
    int m_techInspectSide;
    int[] m_techScroll = new int[3];
    int m_selectedTech;
    int m_techCellWidth;
    FGImage m_haveTechCap;
    FGImage m_haveTechTile;
    FGImage m_noHaveTechCap;
    FGImage m_noHaveTechTile;
    FGImage m_selectableTechCap;
    FGImage m_selectableTechTile;
    FGImage m_highlightTechCap;
    FGImage m_highlightTechTile;
    FGImage m_greyTechCap;
    FGImage m_greyTechTile;
    FGImage m_techArrow;
    FGImage m_milTechIcon;
    FGImage m_sciTechIcon;
    FGImage m_engTechIcon;
    FGImage m_arrowUp;
    FGImage m_arrowDown;
    FGTimer m_techSweepTimer = new FGTimer();
    boolean m_bSweepLeft;
    int m_techFailNotify;
    boolean m_bAtOptionsFromPause;
    boolean m_bQPChosen;
    boolean m_bDiffSelectReturnToCivSelect;
    FGLayout m_victoryLayout = new FGLayout();
    FGAnimation[] m_fireworks = new FGAnimation[5];
    int[] m_fireworksX = new int[5];
    int[] m_fireworksY = new int[5];
    FGForm m_form = new FGForm();
    FGStdMenu m_formReturnMenu;
    FGStdMenu m_helpMenuReturn;
    FGTimer m_modeTimer = new FGTimer();
    boolean m_bShowingTechSelection;
    int m_confirmMode;
    String m_confirmMessage;
    int m_hsHighlightScore;
    int m_hsHighlightDiff;
    int m_numVisibleScores;
    int m_focusIdx;
    FGString[] m_highScoreStrs = new FGString[10];
    int m_hsScroll;
    int m_changeLanguageTo;
    boolean m_bDrewLoadLanguage;
    boolean m_bConfirmedExit;
    boolean m_bDrewExiting;
    boolean m_bCalledExit;
    FGWeb m_web = new FGWeb();
    FGData m_webBuffer = new FGData();
    String m_mrcDeniedMsg;
    public int ok = 0;

    public CVUIMode() {
        int n;
        this.m_mainMenu = new CVMenu();
        this.m_difficultyMenu = new CVMenu();
        this.m_civSelectMenu = new CVMenu();
        this.m_pauseMenu = new CVMenu();
        this.m_defeatMenu = new CVMenu();
        this.m_optionsMenu = new CVMenu();
        this.m_helpMenu = new CVMenu();
        this.m_languageMenu = new CVMenu();
        for (n = 0; n < 5; ++n) {
            this.m_fireworks[n] = new FGAnimation();
        }
        for (n = 0; n < 10; ++n) {
            this.m_highScoreStrs[n] = new FGString();
        }
        this.m_mode = -1;
        this.m_selectedTech = 0;
    }

    public void init() {
        super.init();
        this.m_web.init();
        this.m_webBuffer.init(1024);
    }

    public void initMenu(FGStdMenu fGStdMenu) {
        fGStdMenu.init(this.m_engine.m_titleFont, this.m_engine.m_mainFont, null, null, 0xFF00FF, 0xFF00FF, 0xFF0000);
    }

    public int getTechCapWidth() {
        CVUIMode cVUIMode = this;
        if (cVUIMode.m_engine.isSmall()) {
            return 3;
        }
        return this.m_haveTechCap.getWidth();
    }

    public int getTechBoxHeight() {
        CVUIMode cVUIMode = this;
        if (cVUIMode.m_engine.isSmall()) {
            return 11;
        }
        return this.m_haveTechTile.getHeight();
    }

    public void drawTechBox(FGGraphics fGGraphics, int n, int n2, int n3, int n4) {
        CVUIMode cVUIMode = this;
        if (cVUIMode.m_engine.isSmall()) {
            int n5 = 0xFF00FF;
            int n6 = 0xFF00FF;
            switch (n3) {
                case 0: {
                    n5 = 0;
                    n6 = 0xFFF200;
                    break;
                }
                case 1: {
                    n5 = 0;
                    n6 = 0xABA000;
                    break;
                }
                case 4: {
                    n5 = 0xFFFFFF;
                    n6 = 0xFF00FF;
                    break;
                }
                case 5: {
                    n5 = 0x7F7F7F;
                    n6 = 0xFF00FF;
                    break;
                }
                case 2: {
                    n5 = 0;
                    n6 = 0x464646;
                    break;
                }
                case 3: {
                    n5 = 0;
                    n6 = 0;
                    break;
                }
                default: {
                    FGEngine.fatal("unknown techbox type");
                    return;
                }
            }
            if (n6 != 0xFF00FF) {
                fGGraphics.setColor(n6);
                fGGraphics.fillRect(n, n2, n4, this.getTechBoxHeight());
            }
            if (n5 != 0xFF00FF) {
                fGGraphics.setColor(n5);
                fGGraphics.drawRect(n, n2, n4, this.getTechBoxHeight());
            }
        } else {
            FGImage fGImage = null;
            FGImage fGImage2 = null;
            switch (n3) {
                case 0: {
                    fGImage = this.m_haveTechCap;
                    fGImage2 = this.m_haveTechTile;
                    break;
                }
                case 1: {
                    fGImage = this.m_selectableTechCap;
                    fGImage2 = this.m_selectableTechTile;
                    break;
                }
                case 4: {
                    fGImage = this.m_highlightTechCap;
                    fGImage2 = this.m_highlightTechTile;
                    break;
                }
                case 5: {
                    fGImage = this.m_greyTechCap;
                    fGImage2 = this.m_greyTechTile;
                    break;
                }
                case 2: 
                case 3: {
                    fGImage = this.m_noHaveTechCap;
                    fGImage2 = this.m_noHaveTechTile;
                    break;
                }
                default: {
                    FGEngine.fatal("unknown techbox type");
                    return;
                }
            }
            this.m_engine.drawCappedElement(fGGraphics, n, n2, fGImage, fGImage2, n4);
        }
    }

    public void tick() {
        if (this.m_mode == 2) {
            CVUIMode cVUIMode = this;
            if (!cVUIMode.m_engine.isSmall()) {
                for (int i = 0; i < 5; ++i) {
                    if (!this.m_fireworks[i].finishedPlaying()) continue;
                    this.startFirework(i);
                }
            }
        } else if (this.m_mode == 1 && this.m_bShowingTechSelection) {
            if (this.m_modeTimer.isOver()) {
                this.advanceFromTechMode();
            }
        } else if (this.m_mode == 6) {
            if (this.m_bDrewLoadLanguage) {
                this.m_engine.setLanguage(this.m_changeLanguageTo);
                this.setMenu(this.m_optionsMenu);
            }
        } else if (this.m_mode == 7) {
            if (this.m_bDrewExiting && !this.m_bCalledExit) {
                this.m_engine.exitApp();
                this.m_bCalledExit = true;
                this.setMenu(this.m_mainMenu);
            }
        } else if (this.m_mode == 8) {
            int n = this.m_web.getStatus();
            if (n == 5) {
                this.toConfirmMode(4);
            } else if (n == 6) {
                String string = this.readStr(this.m_webBuffer, 0, 4);
                if (!string.equals("INIT")) {
                    this.toConfirmMode(4);
                    return;
                }
                int n2 = 5;
                boolean bl = false;
                while (!bl) {
                    byte by = this.m_webBuffer.m_data[n2];
                    String string2 = this.readStr(this.m_webBuffer, ++n2);
                    n2 += string2.length();
                    if (string2.length() == 0) {
                        bl = true;
                        continue;
                    }
                    if (by == 1) {
                        try {
                            int n3 = Integer.parseInt(string2);
                            if (n3 == 0) {
                                this.postMRC();
                                return;
                            }
                            this.toConfirmMode(3);
                            return;
                        }
                        catch (Exception exception) {
                            this.toConfirmMode(4);
                            return;
                        }
                    }
                    if (n2 < this.m_webBuffer.m_dataLength) continue;
                    bl = true;
                }
                this.toConfirmMode(4);
            }
        }
    }

    private String readStr(FGData fGData, int n) {
        return this.readStr(fGData, n, 1000);
    }

    private String readStr(FGData fGData, int n, int n2) {
        if (fGData.m_dataLength <= n) {
            return "";
        }
        for (int i = n; i < fGData.m_dataLength; ++i) {
            if (fGData.m_data[i] != 0 && i - n < n2) continue;
            int n3 = i - n;
            String string = new String(fGData.m_data, n, n3);
            return string;
        }
        return "";
    }

    public void drawSelf(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        FGStringManager fGStringManager = this.m_engine.m_strings;
        this.m_engine.m_midletScreen.repaint();
        if (this.m_mode == 1) {
            this.drawTech(fGGraphics);
            return;
        }
        if (this.m_mode == 2) {
            this.drawWinGame(fGGraphics);
            return;
        }
        if (this.m_mode == 3) {
            this.m_engine.drawSplash(fGGraphics, false);
            this.m_form.drawSelf(fGGraphics);
            return;
        }
        if (this.m_mode == 4) {
            this.drawConfirm(fGGraphics);
            return;
        }
        if (this.m_mode == 5) {
            this.drawHighScores(fGGraphics);
            return;
        }
        if (this.m_mode == 6) {
            String string;
            switch (this.m_changeLanguageTo) {
                case 0: {
                    string = fGStringManager.getString("STR_LANG_CHANGE_E");
                    break;
                }
                case 1: {
                    string = fGStringManager.getString("STR_LANG_CHANGE_F");
                    break;
                }
                case 2: {
                    string = fGStringManager.getString("STR_LANG_CHANGE_I");
                    break;
                }
                case 3: {
                    string = fGStringManager.getString("STR_LANG_CHANGE_G");
                    break;
                }
                case 4: {
                    string = fGStringManager.getString("STR_LANG_CHANGE_S");
                    break;
                }
                default: {
                    string = "undef";
                }
            }
            this.drawMessageScreen(fGGraphics, string);
            this.m_bDrewLoadLanguage = true;
            return;
        }
        if (this.m_mode == 7) {
            this.drawMessageScreen(fGGraphics, this.m_engine.m_strings.getString("STR_EXITING"));
            this.m_bDrewExiting = true;
            return;
        }
        if (this.m_mode == 8) {
            this.drawMessageScreen(fGGraphics, this.m_engine.m_strings.getString("STR_VALIDATING"));
            return;
        }
        if (this.m_mode != 0) {
            return;
        }
        if (this.m_currentMenu == this.m_civSelectMenu) {
            this.drawCivSelect(fGGraphics);
            return;
        }
        if (this.m_currentMenu == this.m_mainMenu) {
            this.m_engine.drawSplash(fGGraphics, true);
        } else if (this.m_engine.m_gameMode.m_bGameInProgress) {
            this.m_engine.m_gameMode.drawSelf(fGGraphics);
        } else {
            this.m_engine.drawSplash(fGGraphics, false);
        }
        this.m_currentMenu.drawSelf(fGGraphics);
    }

    public void drawMessageScreen(FGGraphics fGGraphics, String string) {
        this.drawNotifyBK(fGGraphics);
        int n = (this.m_engine.getScreenHeight() - this.m_engine.m_mainFont.getHeight()) / 2;
        this.m_engine.m_mainFont.setJustify(2);
        this.m_engine.m_mainFont.drawText(fGGraphics, string, 0, n, this.m_engine.getScreenWidth());
        this.m_engine.m_mainFont.setJustify(0);
    }

    public void drawHighScores(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.m_engine.getScreenWidth();
        int n11 = this.m_engine.getScreenHeight();
        FGFont fGFont = this.m_engine.m_mainFont;
        this.m_engine.drawSplash(fGGraphics, false);
        String string = this.m_engine.m_strings.getString("STR_BEST_TIMES");
        this.m_engine.drawScreenTitle(fGGraphics, string);
        int n12 = 0;
        for (int i = 0; i < 10 && this.m_engine.m_highScores[i] != -1; ++i) {
            ++n12;
        }
        FGString fGString = new FGString();
        if (this.m_hsHighlightScore != -1) {
            if (this.m_focusIdx == -1) {
                fGString.add(this.m_engine.m_strings.getString("STR_YOUR_SCORE"));
                fGString.add(":  ");
                fGString.add(this.getTimeStr(this.m_hsHighlightScore));
            } else {
                fGString.add(this.m_engine.m_strings.getString("STR_NEW_HIGH_SCORE"));
                this.m_engine.save();
            }
        }
        if (n12 == 0) {
            fGString.set(this.m_engine.m_strings.getString("STR_NO_HS"));
        }
        int n13 = 0;
        int n14 = 0;
        if (fGString.length() > 0) {
            n13 = fGFont.getDisplayHeight(fGString.getNativeString(), n10);
            n14 = n13 + fGFont.getHeight();
        }
        int n15 = this.m_engine.getScreenTitleHeight(string);
        int n16 = n11 - n15 - this.m_engine.getSoftkeyAreaHeight() - n14;
        int n17 = this.getTechBoxHeight();
        int n18 = this.getTechBoxHeight() / 5;
        if (this.m_numVisibleScores == -1) {
            this.m_numVisibleScores = n16 / (n17 + n18);
            if (this.m_numVisibleScores > 10) {
                this.m_numVisibleScores = 10;
            }
            if (this.m_focusIdx != -1) {
                n9 = 10 - this.m_numVisibleScores;
                this.m_hsScroll = this.m_focusIdx - this.m_numVisibleScores / 2;
                if (this.m_hsScroll > n9) {
                    this.m_hsScroll = n9;
                }
                if (this.m_hsScroll < 0) {
                    this.m_hsScroll = 0;
                }
            }
        }
        n9 = n17 * this.m_numVisibleScores + n18 * (this.m_numVisibleScores - 1);
        int n19 = n15 + (n16 - n9) / 2;
        String string2 = "10.";
        int n20 = fGFont.getDisplayLength(string2);
        int n21 = fGFont.getSpaceWidth() * 3;
        int n22 = fGFont.getDisplayLength("00:00");
        for (n8 = 0; n8 < n12; ++n8) {
            int n23 = fGFont.getDisplayLength(this.m_highScoreStrs[n8].getNativeString());
            if (n23 <= n22) continue;
            n22 = n23;
        }
        n8 = 0;
        FGString fGString2 = new FGString();
        for (n7 = 0; n7 < 3; ++n7) {
            fGString2.set("(");
            fGString2.add(this.m_engine.getDifficultyStr(n7));
            fGString2.add(")");
            n6 = fGFont.getDisplayLength(fGString2.getNativeString());
            if (n6 <= n8) continue;
            n8 = n6;
        }
        n7 = n20 + n21 + n22 + n21 + n8;
        n6 = (n10 - n7) / 2 + n20;
        int n24 = n6 + n21;
        int n25 = n24 + n22 + n21;
        int n26 = (n17 - fGFont.getHeight()) / 2;
        FGString fGString3 = new FGString();
        int n27 = n19;
        int n28 = n7 + this.getTechCapWidth() * 2 + fGFont.getSpaceWidth() * 4;
        int n29 = (n10 - n28) / 2;
        for (n5 = 0; n5 < this.m_numVisibleScores; ++n5) {
            n4 = this.m_hsScroll + n5;
            n3 = n27 + n26;
            n2 = 2;
            if (this.m_focusIdx == n4) {
                n2 = 0;
            }
            this.drawTechBox(fGGraphics, n29, n27, n2, n28);
            fGString3.set("");
            fGString3.add(n4 + 1);
            fGString3.add(".");
            fGFont.setJustify(1);
            fGFont.drawText(fGGraphics, fGString3.getNativeString(), n6, n3);
            fGFont.setJustify(0);
            if (n4 < n12) {
                fGFont.drawText(fGGraphics, this.m_highScoreStrs[n4].getNativeString(), n24, n3);
                n = this.m_engine.m_hsDifficulties[n4];
                fGString2.set("(");
                fGString2.add(this.m_engine.getDifficultyStr(n));
                fGString2.add(")");
                fGFont.drawText(fGGraphics, fGString2.getNativeString(), n25, n3);
            }
            n27 += n17;
            n27 += n18;
        }
        n5 = n11 - this.m_arrowUp.getHeight() - 1;
        if (this.m_hsScroll > 0 && this.m_hsScroll < 10 - this.m_numVisibleScores) {
            n4 = n10 / 2 - this.m_arrowUp.getWidth();
            n3 = n10 / 2;
        } else {
            n4 = (n10 - this.m_arrowUp.getWidth()) / 2;
            n3 = (n10 - this.m_arrowDown.getWidth()) / 2;
        }
        if (this.m_hsScroll > 0) {
            this.m_arrowUp.drawSelf(fGGraphics, n4, n5);
        }
        if (this.m_hsScroll < 10 - this.m_numVisibleScores) {
            this.m_arrowDown.drawSelf(fGGraphics, n3, n5);
        }
        if (fGString.length() > 0) {
            n2 = n19 + n9;
            n = n11 - this.m_engine.getSoftkeyAreaHeight() - n2;
            int n30 = n2 + (n - n13) / 2;
            fGFont.setJustify(2);
            fGFont.drawText(fGGraphics, fGString.getNativeString(), 0, n30, n10);
            fGFont.setJustify(0);
        }
    }

    public FGString getTimeStr(int n) {
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        n -= n3 * 60;
        FGString fGString = new FGString();
        if (n2 > 0) {
            fGString.add(n2);
            fGString.add(":");
        }
        this.add2Digits(fGString, n3);
        fGString.add(":");
        this.add2Digits(fGString, n);
        return fGString;
    }

    private void add2Digits(FGString fGString, int n) {
        if (n < 10) {
            fGString.add("0");
        }
        fGString.add(n);
    }

    public void drawConfirm(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        FGFont fGFont = this.m_engine.m_mainFont;
        this.drawNotifyBK(fGGraphics);
        int n3 = fGFont.getDisplayHeight(this.m_confirmMessage, n);
        int n4 = (n2 - this.m_engine.getSoftkeyAreaHeight() - n3) / 2;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, this.m_confirmMessage, 0, n4, n);
        fGFont.setJustify(0);
    }

    public void drawConfirmExit(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        FGFont fGFont = this.m_engine.m_mainFont;
        this.drawNotifyBK(fGGraphics);
        int n3 = fGFont.getDisplayHeight(this.m_confirmMessage, n);
        int n4 = (n2 - this.m_engine.getSoftkeyAreaHeight() - n3) / 2;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, "Are you sure you want to exit?", 0, n4, n);
        fGFont.setJustify(0);
        this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_YES"), null, this.m_engine.m_strings.getString("STR_NO"));
    }

    private void drawNotifyBK(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        if (this.m_engine.m_splash.getNumElements() == 0) {
            fGGraphics.setColor(3030086);
            fGGraphics.fillRect(0, 0, n, n2);
        } else {
            this.m_engine.drawSplash(fGGraphics, false);
        }
    }

    public void drawCivSelect(FGGraphics fGGraphics) {
        int n;
        int n2;
        this.m_engine.drawSplash(fGGraphics, false);
        int n3 = this.m_engine.getScreenWidth();
        int n4 = this.m_engine.getScreenHeight();
        int n5 = 4;
        int n6 = n3 - 2 * n5;
        FGFont fGFont = this.m_engine.m_mainFont;
        int n7 = fGFont.getHeight();
        int n8 = this.m_civSelectMenu.getModel().getSelectionID();
        int n9 = n8 - 8;
        String string = this.m_engine.m_strings.getString("STR_SELECT_CIV");
        this.m_engine.drawScreenTitle(fGGraphics, string);
        int n10 = this.m_engine.getScreenTitleHeight(string);
        int n11 = this.m_engine.m_gameMode.m_redFrameLayout.getWidth();
        int n12 = this.m_engine.m_gameMode.m_redFrameLayout.getHeight();
        int n13 = (n3 - n11) / 2;
        CVUIMode cVUIMode = this;
        if (!cVUIMode.m_engine.isSmall()) {
            this.m_engine.m_gameMode.drawPortrait(fGGraphics, n13, n10, n9, 0);
            FGImage fGImage = this.m_engine.m_leftArrow;
            int n14 = n11 / 4;
            int n15 = n13 - n14 - fGImage.getWidth();
            n2 = n13 + n11 + n14;
            n = n10 + (n12 - fGImage.getHeight()) / 2;
            fGImage.drawSelf(fGGraphics, n15, n);
            fGImage.drawSelfFlippedH(fGGraphics, n2, n);
        }
        n10 += n12;
        int n16 = this.m_civSelectMenu.getModel().getSelectionIndex();
        this.m_civSelectMenu.drawElement(fGGraphics, n16, n10 += n7);
        n10 += this.m_bannerEdge.getHeight();
        FGString fGString = new FGString();
        fGString.set("STR_CIVDESC_");
        fGString.add(n9);
        String string2 = this.m_engine.m_strings.getString(fGString.getNativeString());
        n2 = fGFont.getDisplayHeight(string2, n6);
        n = n4 - n10 - this.m_engine.getSoftkeyAreaHeight();
        int n17 = n10 + (n - n2) / 2;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, string2, n5, n17, n6);
        fGFont.setJustify(0);
    }

    public String getTitle() {
        if (this.m_bSelectingTech) {
            return this.m_engine.m_strings.getString("STR_SELECT_TECH_TITLE");
        }
        if (this.m_techInspectSide == 0) {
            return this.m_engine.m_strings.getString("STR_TECH_TITLE");
        }
        return this.m_engine.m_strings.getString("STR_ENEMY_TECH_TITLE");
    }

    public void drawTech(FGGraphics fGGraphics) {
        int n;
        int n2;
        String string;
        FGFont fGFont = this.m_engine.m_mainFont;
        int n3 = this.m_engine.getScreenWidth();
        int n4 = this.m_engine.getScreenHeight();
        this.m_engine.drawSplash(fGGraphics, false);
        int n5 = this.getTechBoxHeight();
        int n6 = n5 / 4;
        int n7 = 0;
        if (!CVEngine.isSmall()) {
            string = this.getTitle();
            this.m_engine.drawScreenTitle(fGGraphics, string);
            n7 = this.m_engine.getScreenTitleHeight(string);
        }
        n7 += fGFont.getHeight() / 2;
        string = null;
        FGImage fGImage = null;
        switch (this.m_selectedTech) {
            case 0: {
                string = this.m_engine.m_strings.getString("STR_TECHTYPE_0");
                fGImage = this.m_milTechIcon;
                break;
            }
            case 1: {
                string = this.m_engine.m_strings.getString("STR_TECHTYPE_1");
                fGImage = this.m_sciTechIcon;
                break;
            }
            case 2: {
                string = this.m_engine.m_strings.getString("STR_TECHTYPE_2");
                fGImage = this.m_engTechIcon;
            }
        }
        FGString fGString = new FGString();
        fGString.set(string);
        fGString.add(" ");
        fGString.add(this.m_techScroll[this.m_selectedTech] + 1);
        int n8 = fGFont.getDisplayLength(fGString.getNativeString());
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, fGString.getNativeString(), 0, n7, n3);
        fGFont.setJustify(0);
        CVUIMode cVUIMode = this;
        if (!cVUIMode.m_engine.isSmall()) {
            n2 = n7 + (fGFont.getHeight() - fGImage.getHeight()) / 2;
            int n9 = (n3 - n8) / 2 - fGFont.getSpaceWidth() - fGImage.getWidth();
            n = (n3 + n8) / 2 + fGFont.getSpaceWidth();
            fGImage.drawSelf(fGGraphics, n9, n2);
            fGImage.drawSelf(fGGraphics, n, n2);
        }
        n7 += fGFont.getHeight();
        this.drawTechLine(fGGraphics, n7 += fGFont.getHeight() / 2, 0);
        n7 += n5;
        this.drawTechLine(fGGraphics, n7 += n6, 1);
        n7 += n5;
        this.drawTechLine(fGGraphics, n7 += n6, 2);
        n2 = n4 - this.m_engine.getSoftkeyAreaHeight() - (n7 += n5);
        String string2 = null;
        string2 = this.m_techFailNotify == 1 ? this.m_engine.m_strings.getString("STR_TECH_ALREADY_HAVE") : (this.m_techFailNotify == 2 ? this.m_engine.m_strings.getString("STR_TECH_INACCESSABLE") : (this.m_techFailNotify == 3 ? this.m_engine.m_strings.getString("STR_TECH_DIFFLEVEL") : this.m_engine.getTechDesc(this.m_selectedTech, this.m_techScroll[this.m_selectedTech])));
        n = 4;
        int n10 = n3 - n * 2;
        int n11 = fGFont.getDisplayHeight(string2, n10);
        int n12 = n7 + (n2 - n11) / 2;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, string2, n, n12, n10);
        fGFont.setJustify(0);
    }

    public void drawTechLine(FGGraphics fGGraphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        FGFont fGFont = this.m_engine.m_mainFont;
        int n6 = this.m_engine.getScreenWidth();
        int n7 = this.m_techArrow.getWidth() + this.m_techArrow.getWidth() / 2;
        int n8 = n + (this.getTechBoxHeight() - fGFont.getHeight()) / 2;
        int n9 = n + (this.getTechBoxHeight() - this.m_techArrow.getHeight()) / 2;
        int n10 = (n6 - this.m_techCellWidth) / 2;
        int n11 = this.m_techScroll[n2];
        if (n11 < 0) {
            n11 = 0;
        }
        int n12 = n10 - n11 * (this.m_techCellWidth + n7);
        if (n2 == this.m_selectedTech && !this.m_techSweepTimer.isOver()) {
            n5 = this.m_techCellWidth + n7;
            n4 = this.m_techSweepTimer.elapsedTime() * n5 / this.m_techSweepTimer.totalTime();
            n3 = n5 - n4;
            if (this.m_bSweepLeft) {
                n3 = -n3;
            }
            n12 += n3;
        }
        switch (n2) {
            case 0: {
                n5 = this.getDisplayTechValue(0);
                break;
            }
            case 1: {
                n5 = this.getDisplayTechValue(1);
                break;
            }
            case 2: {
                n5 = this.getDisplayTechValue(2);
                break;
            }
            default: {
                return;
            }
        }
        n4 = n12;
        for (n3 = 0; n3 < 10; ++n3) {
            int n13;
            boolean bl = true;
            if (n4 < -this.m_techCellWidth) {
                bl = false;
            }
            if (n4 > n6) {
                bl = false;
            }
            if (bl) {
                n13 = 1;
                if (n3 > this.m_engine.m_gameMode.m_techMax[this.m_engine.m_gameMode.m_difficulty]) {
                    n13 = 0;
                }
                int n14 = n5 >= n3 ? 0 : (this.m_bSelectingTech && n5 + 1 == n3 ? 1 : 2);
                if (n13 == 0) {
                    n14 = 3;
                }
                this.drawTechBox(fGGraphics, n4, n, n14, this.m_techCellWidth);
                if (this.m_selectedTech == n2 && n3 == n11) {
                    this.drawTechBox(fGGraphics, n4, n, 4, this.m_techCellWidth);
                }
                String string = this.m_engine.getTechName(n2, n3);
                fGFont.setJustify(2);
                fGFont.drawText(fGGraphics, string, n4, n8, this.m_techCellWidth);
                fGFont.setJustify(0);
                CVUIMode cVUIMode = this;
                if (!cVUIMode.m_engine.isSmall() && n13 == 0) {
                    this.drawTechBox(fGGraphics, n4, n, 5, this.m_techCellWidth);
                }
            }
            n4 += this.m_techCellWidth;
            if (n3 != 9) {
                n13 = n4 + (n7 - this.m_techArrow.getWidth()) / 2;
                this.m_techArrow.drawSelf(fGGraphics, n13, n9);
            }
            n4 += n7;
        }
    }

    public int getDisplayTechValue(int n) {
        if (this.m_bSelectingTech) {
            switch (n) {
                case 0: {
                    return this.m_engine.m_campaignMTech[this.m_techInspectSide];
                }
                case 1: {
                    return this.m_engine.m_campaignSTech[this.m_techInspectSide];
                }
                case 2: {
                    return this.m_engine.m_campaignETech[this.m_techInspectSide];
                }
            }
        } else {
            switch (n) {
                case 0: {
                    return this.m_engine.m_gameMode.m_armies[this.m_techInspectSide].m_militaryTechLevel;
                }
                case 1: {
                    return this.m_engine.m_gameMode.m_armies[this.m_techInspectSide].m_scienceTechLevel;
                }
                case 2: {
                    return this.m_engine.m_gameMode.m_armies[this.m_techInspectSide].m_engineeringTechLevel;
                }
            }
        }
        return -1;
    }

    public void drawWinGame(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_engine.getScreenWidth();
        int n5 = this.m_engine.getScreenHeight();
        CVGameMode cVGameMode = this.m_engine.m_gameMode;
        CVUIMode cVUIMode = this;
        if (cVUIMode.m_engine.isSmall()) {
            fGGraphics.setColor(14085631);
        } else {
            fGGraphics.setColor(cVGameMode.m_background.m_backgroundColor);
        }
        fGGraphics.fillRect(0, 0, n4, n5);
        CVUIMode cVUIMode2 = this;
        if (!cVUIMode2.m_engine.isSmall()) {
            n3 = n5 - cVGameMode.m_background.getHeight() - 2 * cVGameMode.TERRAIN_PIECE_WIDTH;
            cVGameMode.m_backgroundSky.drawSelf(fGGraphics, 0, n3);
            cVGameMode.m_background.drawSelf(fGGraphics, 0, n3);
        }
        n3 = (n4 - this.m_victoryLayout.getWidth()) / 2;
        int n6 = n5 - this.m_victoryLayout.getHeight();
        FGImage fGImage = cVGameMode.m_armies[0].m_castleGFX;
        this.m_victoryLayout.drawImageAt(fGGraphics, fGImage, "castle", n3, n6);
        this.m_victoryLayout.drawSelf(fGGraphics, n3, n6);
        CVUIMode cVUIMode3 = this;
        if (!cVUIMode3.m_engine.isSmall()) {
            for (int i = 0; i < 5; ++i) {
                FGImage fGImage2 = this.m_fireworks[i].getCurrentFrame();
                if (fGImage2 == null) continue;
                n2 = this.m_fireworksX[i] - fGImage2.getWidth() / 2;
                n = this.m_fireworksY[i] - fGImage2.getHeight() / 2;
                fGImage2.drawSelf(fGGraphics, n2, n);
            }
        }
        String string = this.m_engine.m_strings.getString("STR_WIN_WAR");
        this.m_engine.drawScreenTitle(fGGraphics, string);
        int n7 = this.m_engine.getScreenTitleHeight(string);
        n7 -= this.m_engine.m_titleFont.getHeight() / 2;
        n2 = cVGameMode.m_redFrameLayout.getWidth();
        n = cVGameMode.m_redFrameLayout.getHeight();
        CVUIMode cVUIMode4 = this;
        if (!cVUIMode4.m_engine.isSmall()) {
            int n8 = (n4 - n2) / 2;
            int n9 = n5 - this.m_victoryLayout.getHeight() - n7;
            int n10 = n7 + (n9 - n) / 2;
            int n11 = n8 - this.m_bannerEdge.getWidth();
            int n12 = n8 + n2;
            int n13 = n10 + (n - this.m_bannerEdge.getHeight()) / 2;
            this.m_bannerEdge.drawSelf(fGGraphics, n11, n13);
            this.m_bannerEdge.drawSelfFlippedH(fGGraphics, n12, n13);
            cVGameMode.drawPortrait(fGGraphics, n8, n10, cVGameMode.m_armies[0].m_civID, 0);
        }
    }

    public void takeControl(FGStdMenu fGStdMenu) {
        this.setMenu(fGStdMenu);
        this.m_engine.m_modeManager.setMode(this);
    }

    public void takeControl(int n) {
        this.m_mode = n;
        if (this.m_mode == 2) {
            this.m_engine.addHighScore();
            if (this.m_engine.m_campaignDifficulty == 1) {
                this.m_engine.m_bHardModeUnlocked = true;
            }
            CVUIMode cVUIMode = this;
            if (!cVUIMode.m_engine.isSmall()) {
                int n2 = this.m_fireworks[0].getDuration() / 5;
                for (int i = 0; i < 5; ++i) {
                    this.startFirework(i);
                    this.m_fireworks[i].m_timer.advance(n2 * i);
                }
            }
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_QUIT"));
        }
        this.m_engine.m_modeManager.setMode(this);
    }

    public void toHighScores(int n, int n2) {
        int n3;
        this.m_hsHighlightScore = n;
        this.m_hsHighlightDiff = n2;
        this.m_mode = 5;
        this.m_hsScroll = 0;
        this.m_numVisibleScores = -1;
        for (n3 = 0; n3 < 10; ++n3) {
            if (this.m_engine.m_highScores[n3] == -1) continue;
            this.m_highScoreStrs[n3].set(this.getTimeStr(this.m_engine.m_highScores[n3]));
        }
        this.m_focusIdx = -1;
        if (this.m_hsHighlightScore != -1) {
            for (n3 = 0; n3 < 10 && this.m_engine.m_highScores[n3] != -1; ++n3) {
                if (this.m_engine.m_highScores[n3] != this.m_hsHighlightScore || this.m_engine.m_hsDifficulties[n3] != this.m_hsHighlightDiff) continue;
                this.m_focusIdx = n3;
                break;
            }
        }
        this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_DONE"));
    }

    public void toFormMode(String string, String string2, FGStdMenu fGStdMenu) {
        this.m_formReturnMenu = fGStdMenu;
        this.m_form.init(this.m_engine.m_mainFont, this.m_arrowUp, this.m_arrowDown, string2, string, 0xFF00FF);
        this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        this.m_mode = 3;
    }

    public void toLoadLanguage() {
        this.m_mode = 6;
        this.m_bDrewLoadLanguage = false;
        this.m_engine.setSoftkeys(null, null, null);
    }

    public void toExit() {
        this.m_mode = 7;
        this.m_bDrewExiting = false;
        this.m_bCalledExit = false;
        this.m_engine.setSoftkeys(null, null, null);
    }

    public void takeControlConfirm(int n) {
        this.toConfirmMode(n);
        this.m_engine.m_modeManager.setMode(this);
    }

    public void toConfirmMode(int n) {
        this.m_confirmMode = n;
        this.m_mode = 4;
        switch (this.m_confirmMode) {
            case 0: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_ENABLE_SOUND");
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_YES"), null, this.m_engine.m_strings.getString("STR_NO"));
                break;
            }
            case 1: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_ABANDON_CONFIRM");
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_YES"), null, this.m_engine.m_strings.getString("STR_NO"));
                break;
            }
            case 2: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_HARD_ERROR");
                this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
                break;
            }
            case 4: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_MRC_NETFAIL");
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_RETRY"), null, this.m_engine.m_strings.getString("STR_EXIT"));
                break;
            }
            case 3: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_MRC_DENIED");
                this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_EXIT"));
                break;
            }
            case 5: {
                this.m_confirmMessage = this.m_engine.m_strings.getString("STR_EXIT_CONFIRM");
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_YES"), null, this.m_engine.m_strings.getString("STR_NO"));
                break;
            }
            default: {
                FGEngine.fatal("unknown confirm state");
            }
        }
    }

    public void startFirework(int n) {
        CVUIMode cVUIMode = this;
        if (cVUIMode.m_engine.isSmall()) {
            return;
        }
        int n2 = this.m_engine.getScreenWidth();
        int n3 = this.m_engine.getScreenHeight();
        int n4 = n2 / 10;
        int n5 = n2 - n4 * 2;
        int n6 = n3 - this.m_victoryLayout.getHeight() + this.m_engine.m_titleFont.getHeight();
        int n7 = this.m_engine.m_titleFont.getHeight();
        int n8 = n6 - n7;
        this.m_fireworksX[n] = n4 + this.m_engine.rand() % n5;
        this.m_fireworksY[n] = n7 + this.m_engine.rand() % n8;
        this.m_fireworks[n].playOnce();
    }

    public void takeControlTech() {
        this.m_techInspectSide = 0;
        this.toTechMode(true);
        this.m_engine.m_modeManager.setMode(this);
    }

    public void toTechMode(boolean bl) {
        int n;
        this.m_bShowingTechSelection = false;
        this.m_mode = 1;
        this.m_bSelectingTech = bl;
        this.m_techScroll[0] = this.getDisplayTechValue(0);
        this.m_techScroll[1] = this.getDisplayTechValue(1);
        this.m_techScroll[2] = this.getDisplayTechValue(2);
        if (this.m_bSelectingTech) {
            n = 0;
            while (n < 3) {
                int n2 = n++;
                this.m_techScroll[n2] = this.m_techScroll[n2] + 1;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.m_techScroll[n] < 0) {
                this.m_techScroll[n] = 0;
            }
            if (this.m_techScroll[n] <= 9) continue;
            this.m_techScroll[n] = 9;
        }
        this.m_techFailNotify = 0;
        if (this.m_bSelectingTech) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_QUIT"));
        } else {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        }
    }

    public void takeControlMRC() {
        this.toMRCMode();
        this.m_engine.m_modeManager.setMode(this);
    }

    public void toMRCMode() {
        if (!FGString.nativeEquals(this.m_engine.getProperty("MRC_ACTIVE"), "TRUE")) {
            this.postMRC();
            return;
        }
        String string = this.m_engine.getProperty("MRC_URL");
        if (string == null) {
            FGEngine.fatal("MRC is active, but MRC_URL is not set in jad.");
            return;
        }
        String string2 = this.m_engine.getProperty("MRC_CARRIER");
        if (string2 == null) {
            FGEngine.fatal("MRC is active, but MRC_CARRIER is not set in jad.");
            return;
        }
        String string3 = AuthCodeGenerator.getAppKey("civcasual", "rty657ytughjLIwerSADFSAxczvMbnERTdfgTRY56345RTYhjlGHsdfXCV");
        String string4 = this.m_engine.getProperty("CarrierDeviceId");
        if (string4 == null) {
            string4 = "TESTID-ebxxoi";
        }
        String string5 = string + "?";
        string5 = string5 + "auth=" + string3;
        string5 = string5 + "&carrier=" + string2;
        if (string2.equals("cing")) {
            string5 = string5 + "&subid=" + string4;
        }
        string5 = string5 + "&os=j2me";
        string5 = string5 + "&ver=1.0";
        this.m_web.getPage(string5, this.m_webBuffer);
        this.m_mode = 8;
        this.m_engine.setSoftkeys(null, null, null);
    }

    public void bypassMRC() {
        if (this.m_engine.m_modeManager.getCurrentMode() == this && this.m_mode == 4 && (this.m_confirmMode == 3 || this.m_confirmMode == 4)) {
            this.postMRC();
        }
    }

    public void postMRC() {
        this.m_engine.postMRC();
    }

    private void setMenu(FGStdMenu fGStdMenu) {
        this.m_mode = 0;
        this.m_currentMenu = fGStdMenu;
        if (fGStdMenu == null) {
            this.m_engine.setSoftkeys(null, null, null);
        } else if (fGStdMenu == this.m_mainMenu) {
            this.m_engine.m_gameMode.m_bGameInProgress = false;
            FGStringManager fGStringManager = this.m_engine.m_strings;
            this.initMenu(this.m_mainMenu);
            if (this.m_engine.m_campaignLevel != -100) {
                this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_CONTINUE"), 17);
            }
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_CAMPAIGN"), 7);
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_QUICKPLAY"), 13);
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_OPTIONS"), 14);
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_HELP"), 15);
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_ABOUT"), 28);
            if (FGApp.g_app.isGameLobbyActive()) {
                this.m_mainMenu.getModel().addMenuItem("Game Lobby", 29);
            }
            this.m_mainMenu.getModel().addMenuItem(fGStringManager.getString("STR_EXIT"), 2);
            this.m_mainMenu.modelChanged();
            int n = this.m_engine.m_splash.getElementY("title") + this.m_engine.m_splash.getElementHeight("title");
            int n2 = n + (this.m_engine.getScreenHeight() - n - this.m_mainMenu.getHeight()) / 2;
            int n3 = (this.m_engine.getScreenWidth() - this.m_mainMenu.getWidth()) / 2;
            this.m_mainMenu.setPos(n3, n2);
            this.m_engine.setSoftkeys(null, null, fGStringManager.getString("STR_EXIT"));
        } else if (fGStdMenu == this.m_defeatMenu) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        } else if (fGStdMenu == this.m_optionsMenu) {
            FGStringManager fGStringManager = this.m_engine.m_strings;
            this.initMenu(this.m_optionsMenu);
            if (this.m_engine.getSoundManager().getSoundOn()) {
                this.m_optionsMenu.getModel().addMenuItem(fGStringManager.getString("STR_SOUND_IS_ON"), 25);
            } else {
                this.m_optionsMenu.getModel().addMenuItem(fGStringManager.getString("STR_SOUND_IS_OFF"), 26);
            }
            boolean bl = true;
            if (this.m_engine.m_campaignLevel == -100) {
                bl = false;
            }
            if (this.m_bAtOptionsFromPause && !this.m_engine.m_gameMode.m_bIsCampaign) {
                bl = false;
            }
            this.m_optionsMenu.getModel().addMenuItem(fGStringManager.getString("STR_BEST_TIMES"), 33);
            if (!this.m_engine.isSingleLanguageBuild()) {
                this.m_optionsMenu.getModel().addMenuItem(fGStringManager.getString("STR_LANGUAGE"), 39);
            }
            this.m_optionsMenu.getModel().setTitle(fGStringManager.getString("STR_OPTIONS"));
            this.m_optionsMenu.modelChanged();
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        } else if (fGStdMenu == this.m_helpMenu) {
            this.m_helpMenu.getModel().setSelectionID(30);
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        } else if (fGStdMenu == this.m_pauseMenu) {
            this.m_pauseMenu.getModel().setSelectionID(12);
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        } else {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_BACK"));
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void keyPressed(int n) {
        this.ok = n;
        if (this.m_mode == 1) {
            this.techKey(n);
            return;
        }
        if (this.m_mode == 2) {
            if (n == this.m_engine.AVK_RIGHT_SOFT || n == this.m_engine.AVK_FIRE) {
                this.toHighScores(this.m_engine.getScore(), this.m_engine.m_campaignDifficulty);
            }
        } else {
            if (this.m_mode == 3) {
                if (n == this.m_engine.AVK_RIGHT_SOFT || n == this.m_engine.AVK_FIRE) {
                    this.dismissForm();
                    return;
                }
                this.m_form.handleKey(n);
                return;
            }
            if (this.m_mode == 4) {
                if (this.m_confirmMode == 0) {
                    if (n == this.m_engine.AVK_LEFT_SOFT) {
                        this.m_engine.getSoundManager().setSoundOn(true);
                        this.m_engine.save();
                        this.m_engine.postSoundConfirm();
                    } else if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.m_engine.getSoundManager().setSoundOn(false);
                        this.m_engine.save();
                        this.m_engine.postSoundConfirm();
                    }
                } else if (this.m_confirmMode == 1) {
                    if (n == this.m_engine.AVK_LEFT_SOFT) {
                        this.startNewCampaign();
                    } else if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.setMenu(this.m_mainMenu);
                    }
                } else if (this.m_confirmMode == 2) {
                    if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.setMenu(this.m_difficultyMenu);
                    }
                } else if (this.m_confirmMode == 3) {
                    if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.m_engine.exitApp();
                    }
                } else if (this.m_confirmMode == 4) {
                    if (n == this.m_engine.AVK_LEFT_SOFT) {
                        this.toMRCMode();
                    }
                    if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.m_engine.exitApp();
                    }
                } else if (this.m_confirmMode == 5) {
                    if (n == this.m_engine.AVK_LEFT_SOFT) {
                        this.toExit();
                    } else if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.setMenu(this.m_mainMenu);
                    }
                }
                return;
            }
            if (this.m_mode == 5) {
                int n2;
                if (this.m_numVisibleScores != -1) {
                    if (n == 1) {
                        --this.m_hsScroll;
                        if (this.m_hsScroll < 0) {
                            this.m_hsScroll = 0;
                        }
                    } else if (n == 6) {
                        ++this.m_hsScroll;
                        n2 = 10 - this.m_numVisibleScores;
                        if (this.m_hsScroll > n2) {
                            this.m_hsScroll = n2;
                        }
                    }
                }
                if (n != this.m_engine.AVK_RIGHT_SOFT && n != this.m_engine.AVK_FIRE) {
                    return;
                }
                if (this.m_hsHighlightScore == -1) {
                    this.setMenu(this.m_optionsMenu);
                    return;
                }
                this.setMenu(this.m_mainMenu);
                n2 = this.m_engine.getScore();
                FGApp.g_app.glPostScore(n2);
                return;
            }
        }
        if (this.m_mode != 0) {
            return;
        }
        if (this.m_currentMenu == this.m_civSelectMenu) {
            if (n == 2) {
                n = 1;
            } else if (n == 5) {
                n = 6;
            }
        }
        this.m_currentMenu.handleKey(n);
        if (n == this.m_engine.AVK_FIRE) {
            this.menuSelect(this.m_currentMenu.getModel().getSelectionID());
        }
        if (n == this.m_engine.AVK_RIGHT_SOFT || n == this.m_engine.AVK_CLR || n == this.m_engine.AVK_END) {
            if (this.m_currentMenu == this.m_mainMenu) {
                this.toConfirmMode(5);
            } else if (this.m_currentMenu == this.m_civSelectMenu) {
                this.setMenu(this.m_mainMenu);
            } else if (this.m_currentMenu == this.m_difficultyMenu) {
                if (this.m_bDiffSelectReturnToCivSelect) {
                    this.setMenu(this.m_civSelectMenu);
                } else {
                    this.setMenu(this.m_mainMenu);
                }
            } else if (this.m_currentMenu == this.m_pauseMenu) {
                this.menuSelect(12);
            } else if (this.m_currentMenu == this.m_optionsMenu) {
                if (this.m_bAtOptionsFromPause) {
                    this.setMenu(this.m_pauseMenu);
                } else {
                    this.setMenu(this.m_mainMenu);
                }
            } else if (this.m_currentMenu == this.m_defeatMenu) {
                this.setMenu(this.m_mainMenu);
            } else if (this.m_currentMenu == this.m_helpMenu) {
                this.setMenu(this.m_helpMenuReturn);
            } else if (this.m_currentMenu == this.m_languageMenu) {
                this.setMenu(this.m_optionsMenu);
            }
        }
    }

    public void techKey(int n) {
        if (this.m_bShowingTechSelection) {
            return;
        }
        if (n == this.m_engine.AVK_RIGHT_SOFT) {
            if (this.m_bSelectingTech) {
                this.setMenu(this.m_mainMenu);
            } else {
                this.setMenu(this.m_pauseMenu);
            }
            return;
        }
        this.m_techFailNotify = 0;
        if (n == 2) {
            if (this.m_techScroll[this.m_selectedTech] > 0) {
                int n2 = this.m_selectedTech;
                this.m_techScroll[n2] = this.m_techScroll[n2] - 1;
                this.m_techSweepTimer.start(300);
                this.m_bSweepLeft = true;
            }
        } else if (n == 5 && this.m_techScroll[this.m_selectedTech] < 9) {
            int n3 = this.m_selectedTech;
            this.m_techScroll[n3] = this.m_techScroll[n3] + 1;
            this.m_techSweepTimer.start(300);
            this.m_bSweepLeft = false;
        }
        if (!this.m_techSweepTimer.isOver()) {
            return;
        }
        if (n == 6) {
            ++this.m_selectedTech;
            if (this.m_selectedTech >= 3) {
                this.m_selectedTech = 0;
            }
        } else if (n == 1) {
            --this.m_selectedTech;
            if (this.m_selectedTech < 0) {
                this.m_selectedTech = 2;
            }
        }
        if (n == this.m_engine.AVK_FIRE) {
            if (this.m_bSelectingTech) {
                int[] nArray;
                int n4 = this.m_techScroll[this.m_selectedTech];
                switch (this.m_selectedTech) {
                    case 0: {
                        nArray = this.m_engine.m_campaignMTech;
                        break;
                    }
                    case 1: {
                        nArray = this.m_engine.m_campaignSTech;
                        break;
                    }
                    case 2: {
                        nArray = this.m_engine.m_campaignETech;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (n4 <= nArray[0]) {
                    this.m_techFailNotify = 1;
                } else if (n4 > this.m_engine.m_gameMode.m_techMax[this.m_engine.m_gameMode.m_difficulty]) {
                    this.m_techFailNotify = 3;
                } else if (n4 > nArray[0] + 1) {
                    this.m_techFailNotify = 2;
                } else {
                    nArray[0] = nArray[0] + 1;
                }
                if (this.m_techFailNotify == 0) {
                    this.m_modeTimer.start(200);
                    this.m_bShowingTechSelection = true;
                    this.m_engine.playSound(11);
                }
            } else {
                this.dismissAndSetMode(this.m_engine.m_gameMode);
            }
        }
    }

    public void dismissForm() {
        this.m_form.clear();
        this.setMenu(this.m_formReturnMenu);
    }

    public void keyReleased(int n) {
    }

    public void registerNeededResources(FGResLoader fGResLoader) {
        fGResLoader.registerImage("bannerL.png");
        fGResLoader.registerImage("bannerM.png");
        CVUIMode cVUIMode = this;
        if (!cVUIMode.m_engine.isSmall()) {
            fGResLoader.registerImage("buttonGoldL.png");
            fGResLoader.registerImage("buttonGoldM.png");
            fGResLoader.registerImage("buttonGrayL.png");
            fGResLoader.registerImage("buttonGrayM.png");
            fGResLoader.registerImage("buttonGreenL.png");
            fGResLoader.registerImage("buttonGreenM.png");
            fGResLoader.registerImage("buttonBorderL.png");
            fGResLoader.registerImage("buttonBorderM.png");
            fGResLoader.registerImage("buttonDitherL.png");
            fGResLoader.registerImage("buttonDitherM.png");
        }
        fGResLoader.registerImage("arrowLarge.png");
        CVUIMode cVUIMode2 = this;
        if (!cVUIMode2.m_engine.isSmall()) {
            fGResLoader.registerImage("iconWeapons.png");
            fGResLoader.registerImage("iconScience.png");
            fGResLoader.registerImage("iconEngineering.png");
        }
        this.m_victoryLayout.init("victory.lyt");
        this.m_victoryLayout.registerNoteName("castle");
        this.m_victoryLayout.registerNeededImages(fGResLoader);
        CVUIMode cVUIMode3 = this;
        if (!cVUIMode3.m_engine.isSmall()) {
            fGResLoader.registerImage("fireworks1.png");
            fGResLoader.registerImage("fireworks2.png");
            fGResLoader.registerImage("fireworks3.png");
        }
        fGResLoader.registerImage("arrowUp.png");
        fGResLoader.registerImage("arrowDown.png");
    }

    public void getNeededResources(FGResLoader fGResLoader) {
        int n;
        this.m_bannerEdge = fGResLoader.getImage("bannerL.png");
        this.m_bannerTile = fGResLoader.getImage("bannerM.png");
        CVUIMode cVUIMode = this;
        if (!cVUIMode.m_engine.isSmall()) {
            this.m_haveTechCap = fGResLoader.getImage("buttonGoldL.png");
            this.m_haveTechTile = fGResLoader.getImage("buttonGoldM.png");
            this.m_noHaveTechCap = fGResLoader.getImage("buttonGrayL.png");
            this.m_noHaveTechTile = fGResLoader.getImage("buttonGrayM.png");
            this.m_selectableTechCap = fGResLoader.getImage("buttonGreenL.png");
            this.m_selectableTechTile = fGResLoader.getImage("buttonGreenM.png");
            this.m_highlightTechCap = fGResLoader.getImage("buttonBorderL.png");
            this.m_highlightTechTile = fGResLoader.getImage("buttonBorderM.png");
            this.m_greyTechCap = fGResLoader.getImage("buttonDitherL.png");
            this.m_greyTechTile = fGResLoader.getImage("buttonDitherM.png");
        }
        this.m_techArrow = fGResLoader.getImage("arrowLarge.png");
        CVUIMode cVUIMode2 = this;
        if (!cVUIMode2.m_engine.isSmall()) {
            this.m_milTechIcon = fGResLoader.getImage("iconWeapons.png");
            this.m_sciTechIcon = fGResLoader.getImage("iconScience.png");
            this.m_engTechIcon = fGResLoader.getImage("iconEngineering.png");
        }
        this.m_victoryLayout.getNeededImages(fGResLoader);
        CVUIMode cVUIMode3 = this;
        if (!cVUIMode3.m_engine.isSmall()) {
            this.m_fireworks[0].init(120);
            this.m_fireworks[0].addFrame(fGResLoader.getImage("fireworks1.png"));
            this.m_fireworks[0].addFrame(fGResLoader.getImage("fireworks2.png"));
            this.m_fireworks[0].addFrame(fGResLoader.getImage("fireworks3.png"));
            this.m_fireworks[0].addFrame(null);
            this.m_fireworks[0].addFrame(null);
            for (n = 1; n < 5; ++n) {
                this.m_fireworks[n].init(this.m_fireworks[0]);
            }
        }
        this.m_arrowUp = fGResLoader.getImage("arrowUp.png");
        this.m_arrowDown = fGResLoader.getImage("arrowDown.png");
        n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                String string = this.m_engine.getTechName(i, j);
                int n2 = this.m_engine.m_mainFont.getDisplayLength(string);
                if (n >= n2) continue;
                n = n2;
            }
        }
        CVUIMode cVUIMode4 = this;
        this.m_techCellWidth = cVUIMode4.m_engine.isSmall() ? 3 + n : this.m_haveTechCap.getWidth() * 2 + n;
        this.initImmutableMenus();
    }

    public void initImmutableMenus() {
        FGStringManager fGStringManager = this.m_engine.m_strings;
        this.initMenu(this.m_difficultyMenu);
        this.m_difficultyMenu.getModel().addMenuItem(fGStringManager.getString("STR_EASY"), 3);
        this.m_difficultyMenu.getModel().addMenuItem(fGStringManager.getString("STR_MEDIUM"), 4);
        this.m_difficultyMenu.getModel().addMenuItem(fGStringManager.getString("STR_HARD"), 5);
        this.m_difficultyMenu.getModel().setTitle(fGStringManager.getString("STR_DIFFICULTY"));
        this.m_difficultyMenu.modelChanged();
        this.initMenu(this.m_civSelectMenu);
        this.m_civSelectMenu.getModel().addMenuItem(fGStringManager.getString("STR_CIVNAME_0"), 8);
        this.m_civSelectMenu.getModel().addMenuItem(fGStringManager.getString("STR_CIVNAME_1"), 9);
        this.m_civSelectMenu.getModel().addMenuItem(fGStringManager.getString("STR_CIVNAME_2"), 10);
        this.m_civSelectMenu.getModel().addMenuItem(fGStringManager.getString("STR_CIVNAME_3"), 11);
        this.m_civSelectMenu.getModel().setSelectionWrap(true);
        this.m_civSelectMenu.modelChanged();
        this.initMenu(this.m_pauseMenu);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_CONTINUE_GAME"), 12);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_QUIT_GAME"), 16);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_OPTIONS"), 14);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_HELP"), 15);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_SHOW_TECH"), 23);
        this.m_pauseMenu.getModel().addMenuItem(fGStringManager.getString("STR_SHOW_ENEMY_TECH"), 24);
        this.m_pauseMenu.modelChanged();
        this.initMenu(this.m_defeatMenu);
        this.m_defeatMenu.getModel().addMenuItem(fGStringManager.getString("STR_REPLAY_LEVEL"), 21);
        this.m_defeatMenu.getModel().addMenuItem(fGStringManager.getString("STR_QUIT_GAME"), 22);
        this.m_defeatMenu.getModel().setTitle(fGStringManager.getString("STR_DEFEAT"));
        this.m_defeatMenu.modelChanged();
        this.initMenu(this.m_helpMenu);
        this.m_helpMenu.getModel().addMenuItem(fGStringManager.getString("STR_CONTROLS"), 30);
        this.m_helpMenu.getModel().addMenuItem(fGStringManager.getString("STR_TIPS"), 31);
        CVUIMode cVUIMode = this;
        if (!cVUIMode.m_engine.isSmall()) {
            this.m_helpMenu.getModel().addMenuItem(fGStringManager.getString("STR_TUTORIAL"), 32);
        }
        this.m_helpMenu.getModel().setTitle(fGStringManager.getString("STR_HELP"));
        this.m_helpMenu.modelChanged();
        this.initMenu(this.m_languageMenu);
        if (this.m_engine.isLanguageAvailable(0)) {
            this.m_languageMenu.getModel().addMenuItem("English", 34);
        }
        if (this.m_engine.isLanguageAvailable(1)) {
            this.m_languageMenu.getModel().addMenuItem("Fran\u010f\u017c\u02ddais", 35);
        }
        if (this.m_engine.isLanguageAvailable(2)) {
            this.m_languageMenu.getModel().addMenuItem("Italiano", 36);
        }
        if (this.m_engine.isLanguageAvailable(3)) {
            this.m_languageMenu.getModel().addMenuItem("Deutsch", 37);
        }
        if (this.m_engine.isLanguageAvailable(4)) {
            this.m_languageMenu.getModel().addMenuItem("Espa\u010f\u017c\u02ddol", 38);
        }
        this.m_languageMenu.modelChanged();
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public void menuSelect(int n) {
        switch (n) {
            case 29: {
                FGApp.g_app.toGameLobbyMenu();
                return;
            }
            case 15: {
                this.m_helpMenuReturn = this.m_currentMenu;
                this.setMenu(this.m_helpMenu);
                break;
            }
            case 40: {
                this.toFormMode("log", "log.txt", this.m_helpMenu);
                break;
            }
            case 30: {
                this.toFormMode(this.m_engine.m_strings.getString("STR_CONTROLS"), this.m_engine.getLanguageFilename("help").getNativeString(), this.m_helpMenu);
                break;
            }
            case 31: {
                this.toFormMode(this.m_engine.m_strings.getString("STR_TIPS"), this.m_engine.getLanguageFilename("tips").getNativeString(), this.m_helpMenu);
                break;
            }
            case 32: {
                if (this.m_engine.m_gameMode.m_bGameInProgress) {
                    this.m_engine.m_gameMode.toTutorial();
                    this.m_engine.m_gameMode.m_bTutorialReturnToHelpMenu = true;
                    this.dismissAndSetMode(this.m_engine.m_gameMode);
                    break;
                }
                this.m_engine.m_gameMode.startNewGame(this.m_engine.m_forcedMapID, 0, 0, 0, 0, false);
                this.m_engine.m_gameMode.toExternalTutorialMode();
                this.dismissAndSetMode(this.m_engine.m_gameMode);
                break;
            }
            case 7: {
                if (this.m_engine.m_campaignLevel == -100) {
                    this.startNewCampaign();
                    break;
                }
                this.toConfirmMode(1);
                break;
            }
            case 13: {
                this.m_map = this.m_engine.m_forcedMapID;
                this.m_civ = this.m_engine.rand() % 4;
                this.m_opponent = this.m_era = this.m_engine.rand() % 4;
                this.m_bQPChosen = true;
                this.m_bDiffSelectReturnToCivSelect = false;
                this.setMenu(this.m_difficultyMenu);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.m_civ = n - 8;
                this.m_bDiffSelectReturnToCivSelect = true;
                this.setMenu(this.m_difficultyMenu);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (n == 5 && !this.m_engine.m_bHardModeUnlocked) {
                    this.toConfirmMode(2);
                    return;
                }
                this.m_difficulty = n - 3 + 0;
                if (this.m_bQPChosen) {
                    this.m_engine.m_gameMode.startNewGame(this.m_map, this.m_difficulty, this.m_era, this.m_civ, this.m_opponent, false);
                    this.dismissAndSetMode(this.m_engine.m_gameMode);
                    break;
                }
                this.m_engine.startNewCampaign(this.m_civ, this.m_difficulty);
                break;
            }
            case 2: {
                this.toConfirmMode(5);
                break;
            }
            case 16: {
                this.setMenu(this.m_mainMenu);
                break;
            }
            case 17: {
                if (this.m_engine.deservesTech(0)) {
                    this.toTechMode(true);
                    return;
                }
                this.m_engine.startCurrentWar();
                this.dismissAndSetMode(this.m_engine.m_gameMode);
                break;
            }
            case 12: {
                this.dismissAndSetMode(this.m_engine.m_gameMode);
                break;
            }
            case 21: {
                this.m_engine.startCurrentWar();
                this.dismissAndSetMode(this.m_engine.m_gameMode);
                break;
            }
            case 22: {
                this.setMenu(this.m_mainMenu);
                break;
            }
            case 23: {
                this.m_techInspectSide = 0;
                this.toTechMode(false);
                break;
            }
            case 24: {
                this.m_techInspectSide = 1;
                this.toTechMode(false);
                break;
            }
            case 14: {
                if (this.m_currentMenu == this.m_mainMenu) {
                    this.m_bAtOptionsFromPause = false;
                } else if (this.m_currentMenu == this.m_pauseMenu) {
                    this.m_bAtOptionsFromPause = true;
                } else {
                    FGEngine.fatal("invalid entry state for options menu mode");
                }
                this.setMenu(this.m_optionsMenu);
                break;
            }
            case 25: {
                this.m_engine.getSoundManager().setSoundOn(false);
                this.m_engine.save();
                this.setMenu(this.m_optionsMenu);
                break;
            }
            case 26: {
                this.m_engine.getSoundManager().setSoundOn(true);
                this.m_engine.save();
                this.m_engine.playSound(3);
                this.setMenu(this.m_optionsMenu);
                break;
            }
            case 28: {
                this.toFormMode(this.m_engine.m_strings.getString("STR_ABOUT"), this.m_engine.getLanguageFilename("about").getNativeString(), this.m_mainMenu);
                break;
            }
            case 33: {
                this.toHighScores(-1, -1);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.m_changeLanguageTo = n - 34;
                this.toLoadLanguage();
                break;
            }
            case 39: {
                this.setMenu(this.m_languageMenu);
            }
        }
    }

    public void startNewCampaign() {
        this.m_map = this.m_engine.m_forcedMapID;
        this.m_opponent = 0;
        this.m_era = 0;
        this.m_bQPChosen = false;
        this.setMenu(this.m_civSelectMenu);
    }

    public void advanceFromTechMode() {
        if (this.m_engine.deservesTech(0)) {
            this.toTechMode(true);
            return;
        }
        this.m_engine.startCurrentWar();
        this.dismissAndSetMode(this.m_engine.m_gameMode);
    }

    public void dismissAndSetMode(CVMode cVMode) {
        this.m_engine.m_modeManager.clearModeStack();
        this.m_engine.m_modeManager.setMode(cVMode);
    }

    public void languageChanged() {
        this.initImmutableMenus();
    }
}

