/*
 * Decompiled with CFR 0.152.
 */
class FGMenuModel {
    public static final int MAX_MENU_ITEMS = 16;
    protected FGString m_title = new FGString();
    protected FGString[] m_strings = new FGString[16];
    protected int[] m_ids = new int[16];
    protected boolean[] m_bEnabled = new boolean[16];
    protected int m_numMenuItems = 0;
    protected int m_currentSelection = 0;
    protected boolean m_bSelectionWrap;

    public void setSelectionWrap(boolean bl) {
        this.m_bSelectionWrap = bl;
    }

    public FGMenuModel() {
        for (int i = 0; i < 16; ++i) {
            this.m_strings[i] = new FGString();
        }
    }

    public void reset() {
        this.m_title.set("");
        this.m_numMenuItems = 0;
        this.m_currentSelection = 0;
        this.setSelectionWrap(false);
    }

    public void addMenuItem(String string, int n) {
        if (this.m_numMenuItems >= 16) {
            return;
        }
        this.m_strings[this.m_numMenuItems].set(string);
        this.m_ids[this.m_numMenuItems] = n;
        this.m_bEnabled[this.m_numMenuItems] = true;
        ++this.m_numMenuItems;
    }

    public void selectionUp() {
        --this.m_currentSelection;
        if (this.m_currentSelection < 0) {
            this.m_currentSelection = this.m_bSelectionWrap ? this.m_numMenuItems - 1 : 0;
        }
    }

    public void selectionDown() {
        ++this.m_currentSelection;
        if (this.m_currentSelection >= this.m_numMenuItems) {
            this.m_currentSelection = this.m_bSelectionWrap ? 0 : this.m_numMenuItems - 1;
        }
    }

    public int getSelectionID() {
        return this.m_ids[this.m_currentSelection];
    }

    public int getSelectionIndex() {
        return this.m_currentSelection;
    }

    public void setSelectionID(int n) {
        for (int i = 0; i < this.m_numMenuItems; ++i) {
            if (n != this.m_ids[i]) continue;
            this.m_currentSelection = i;
        }
    }

    public FGString getSelectionString() {
        return this.m_strings[this.m_currentSelection];
    }

    public void setTitle(String string) {
        this.m_title = new FGString(string);
    }

    public FGString getTitle() {
        return this.m_title;
    }

    public int getNumItems() {
        return this.m_numMenuItems;
    }
}

