/*
 * Decompiled with CFR 0.152.
 */
class CVLoadingMode
extends CVMode {
    public static final int UPDATE_TIME = 200;
    public static final int SOURCE_CVENGINE = 0;
    public static final int SOURCE_CVGAMEMODE = 1;
    public static final int COLOR_LOGOBK = 3030086;
    public static final int COLOR_PROGBAR = 16342272;
    public static final int TIME_LOGO = 2000;
    public static final int LOGO_OASYS = 0;
    public static final int LOGO_FG = 1;
    public static final int LOGO_NONE = 2;
    public boolean m_bDoneLoading;
    FGResLoader m_loader;
    int m_source;
    boolean m_bDrewFull;
    int m_logoMode;
    FGTimer m_logoTimer = new FGTimer();
    FGImage m_logo;
    boolean m_bDrewOasysLogo;
    boolean m_bCalledPrimaryInit;

    public void init() {
        super.init();
        this.m_bDoneLoading = false;
    }

    public void takeControl(FGResLoader fGResLoader, int n) {
        this.m_bDoneLoading = false;
        this.m_bDrewFull = false;
        this.m_loader = fGResLoader;
        this.m_source = n;
        if (this.m_source != 0 && fGResLoader.allResourcesLoaded()) {
            this.advanceMode(true);
            return;
        }
        if (this.m_source == 0) {
            this.m_engine.m_modeManager.setMode(this);
            this.setLogoMode(0);
            this.m_bCalledPrimaryInit = false;
        } else {
            this.m_engine.m_modeManager.pushMode(this);
        }
    }

    public void setLogoMode(int n) {
        this.m_logoMode = n;
        if (this.m_logoMode == 0) {
            this.m_logo = FGImage.createImage("ologo.png");
            this.m_bDrewOasysLogo = false;
        } else if (this.m_logoMode == 1) {
            if (!CVEngine.isSmall()) {
                this.m_logo = null;
                this.m_logo = FGImage.createImage("fglogo.png");
            }
            this.m_bDrewOasysLogo = true;
        } else {
            this.m_logo = null;
        }
        int n2 = 2000;
        if (CVEngine.isSmall()) {
            n2 /= 2;
        }
        this.m_logoTimer.start(n2);
        this.m_logoTimer.pause();
    }

    public void advanceLogoMode() {
        if (this.m_logoMode == 0) {
            this.setLogoMode(1);
        } else if (this.m_logoMode == 1) {
            this.setLogoMode(2);
            if (this.m_loader.allResourcesLoaded()) {
                this.advanceMode(false);
            }
        }
    }

    public void tick() {
        if (this.m_logoTimer.isPaused()) {
            this.m_logoTimer.resume();
        }
        if (this.m_bDrewOasysLogo && !this.m_bCalledPrimaryInit) {
            this.m_bCalledPrimaryInit = true;
            this.m_engine.primaryInit();
        }
        if (this.m_logoMode != 2 && this.m_logoTimer.isOver() && this.m_bCalledPrimaryInit) {
            this.advanceLogoMode();
        }
        if (!this.m_bCalledPrimaryInit) {
            return;
        }
        if (this.m_bDoneLoading) {
            return;
        }
        FGTimer fGTimer = new FGTimer();
        fGTimer.start(200);
        do {
            this.m_loader.loadNextResource();
            if (!this.m_loader.allResourcesLoaded()) continue;
            if (!this.m_bDrewFull) {
                return;
            }
            if (this.m_logoMode == 2) {
                this.advanceMode(false);
            }
            return;
        } while (!fGTimer.isOver());
    }

    public void advanceMode(boolean bl) {
        this.m_bDoneLoading = true;
        if (this.m_source == 0) {
            this.m_engine.getNeededResources();
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_mainMenu);
            return;
        }
        if (this.m_source == 1) {
            this.m_engine.m_gameMode.postEraLoad();
            if (!bl) {
                this.m_engine.m_modeManager.popMode();
            }
            return;
        }
        FGEngine.fatal("illegal source sent to CVLoadingMode");
    }

    public void drawSelf(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3 = this.m_engine.getScreenWidth();
        int n4 = this.m_engine.getScreenHeight();
        int n5 = this.m_loader.getProgress(0);
        boolean bl = false;
        int n6 = 0;
        if (this.m_logoMode == 0) {
            bl = true;
            this.m_bDrewOasysLogo = true;
            n6 = 3030086;
        } else if (this.m_logoMode == 1) {
            if (CVEngine.isSmall()) {
                this.m_bDrewOasysLogo = true;
                n6 = 3030086;
            } else {
                n6 = 0;
            }
            bl = true;
        }
        if (bl) {
            if (this.m_logo != null) {
                fGGraphics.setColor(n6);
                fGGraphics.fillRect(0, 0, n3, n4);
                n2 = (n3 - this.m_logo.getWidth()) / 2;
                n = (n4 - this.m_logo.getHeight()) / 2;
                this.m_logo.drawSelf(fGGraphics, n2, n);
            }
            if (!CVEngine.isSmall()) {
                return;
            }
        } else {
            this.m_engine.drawSplash(fGGraphics, true);
        }
        n2 = 5;
        n = 10;
        int n7 = n4 - n2 * 2;
        int n8 = n3 - n * 2;
        fGGraphics.setColor(16342272);
        fGGraphics.drawRect(n, n7, n8, n2);
        int n9 = n5 * n8 / 100;
        fGGraphics.fillRect(n, n7, n9, n2);
        if (n5 >= 100) {
            this.m_bDrewFull = true;
        }
    }

    public void keyPressed(int n) {
        boolean bl = false;
        if (this.m_engine.getSku().equals("SKU_J2SE") || this.m_engine.getSku().equals("SKU_EMULATOR")) {
            bl = true;
        }
        if (n == this.m_engine.AVK_RIGHT_SOFT && this.m_source != 0 && this.m_source == 1) {
            return;
        }
        if (!bl) {
            return;
        }
        if (this.m_bCalledPrimaryInit) {
            this.advanceLogoMode();
        }
    }

    public void activate() {
        super.activate();
        this.m_engine.setSoftkeys(null, null, null);
    }

    public void deactivate() {
        super.deactivate();
    }

    public void pause() {
    }

    public void resume() {
    }
}

