/*
 * Decompiled with CFR 0.152.
 */
class FGDataReader {
    private FGData m_data;
    private int m_dataPos;
    private boolean m_bError;
    private byte[] m_buffer = new byte[8];

    public FGDataReader() {
        this.releaseData();
    }

    public void init(FGData fGData) {
        this.releaseData();
        if (fGData == null) {
            return;
        }
        this.m_data = fGData;
    }

    public int getDataPos() {
        return this.m_dataPos;
    }

    public void setDataPos(int n) {
        this.m_dataPos = n;
    }

    public void releaseData() {
        this.m_data = null;
        this.m_bError = false;
        this.m_dataPos = 0;
    }

    public boolean getError() {
        return this.m_bError;
    }

    public boolean readBoolean() {
        if (this.getError()) {
            return false;
        }
        byte by = this.readByte();
        return by != 0;
    }

    public byte readByte() {
        if (this.getError()) {
            return 0;
        }
        this.readFromData(this.m_buffer, 1);
        return this.m_buffer[0];
    }

    public short readShort() {
        if (this.getError()) {
            return 0;
        }
        this.readFromData(this.m_buffer, 2);
        short s = (short)((this.unsigned(this.m_buffer[0]) << 8) + this.unsigned(this.m_buffer[1]));
        return s;
    }

    public int readInt() {
        if (this.getError()) {
            return 0;
        }
        this.readFromData(this.m_buffer, 4);
        int n = (this.unsigned(this.m_buffer[0]) << 24) + (this.unsigned(this.m_buffer[1]) << 16) + (this.unsigned(this.m_buffer[2]) << 8) + this.unsigned(this.m_buffer[3]);
        return n;
    }

    public long readLong() {
        return this.readInt();
    }

    public FGString readUTF() {
        int n = this.readInt();
        FGData fGData = new FGData();
        fGData.init(n + 1);
        this.readFromData(fGData.m_data, n);
        fGData.m_dataLength = n;
        FGString fGString = new FGString();
        fGString.set(fGData);
        return fGString;
    }

    public void readRaw(FGData fGData, int n) {
        if (n > fGData.m_allocated) {
            FGEngine.fatal("Reading past end of buffer in ReadRaw");
            return;
        }
        this.readFromData(fGData.m_data, n);
        fGData.m_dataLength = n;
    }

    public void readFromData(byte[] byArray, int n) {
        int n2 = this.m_dataPos + n;
        if (n2 > this.m_data.m_dataLength) {
            this.m_bError = true;
            return;
        }
        System.arraycopy(this.m_data.m_data, this.m_dataPos, byArray, 0, n);
        this.m_dataPos += n;
    }

    public static short endianSwap(short s) {
        s = (short)(s >> 8 | s << 8);
        return s;
    }

    public static int endianSwap(int n) {
        n = n >> 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00 | n << 24;
        return n;
    }

    public int unsigned(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }
}

