/*
 * Decompiled with CFR 0.152.
 */
class FGStringManager {
    public int m_numStrings;
    public FGString[] m_strIDs;
    public FGString[] m_strings;

    public boolean init(String string) {
        int n;
        this.m_numStrings = 0;
        this.m_strIDs = null;
        this.m_strings = null;
        FGData fGData = FGEngine.getEngine().getFileSystem().getFile(string);
        if (fGData == null) {
            return false;
        }
        this.m_numStrings = 0;
        for (n = 0; n < fGData.m_dataLength; ++n) {
            if (fGData.m_data[n] != 61) continue;
            ++this.m_numStrings;
        }
        this.m_strIDs = new FGString[this.m_numStrings];
        this.m_strings = new FGString[this.m_numStrings];
        for (n = 0; n < this.m_numStrings; ++n) {
            this.m_strIDs[n] = null;
            this.m_strings[n] = null;
        }
        n = 0;
        int n2 = 0;
        do {
            int n3;
            FGString fGString;
            if (!(fGString = FGStringManager.getLine(fGData, n)).startsWith("//") && (n3 = fGString.indexOf('=')) != -1) {
                FGString fGString2 = fGString.substring(0, n3).trim();
                FGString fGString3 = fGString.substring(n3 + 1).trim();
                if (n2 >= this.m_numStrings) {
                    FGEngine.fatal("more tweaks in tweaks file than was allocated for. This is an internal error in FGTweaks that must be due to a bug.");
                    return false;
                }
                this.m_strIDs[n2] = fGString2;
                this.m_strings[n2] = fGString3;
                ++n2;
            }
            n += fGString.length();
        } while (++n < fGData.m_dataLength);
        this.m_numStrings = n2;
        return true;
    }

    boolean stringExists(String string) {
        int n = this.getStrIdx(string);
        return n != -1;
    }

    String getString(String string) {
        return this.getFGString(string).getNativeString();
    }

    FGString getFGString(String string) {
        int n = this.getStrIdx(string);
        if (n == -1) {
            return new FGString("UNDEF");
        }
        return this.m_strings[n];
    }

    private int getStrIdx(String string) {
        for (int i = 0; i < this.m_numStrings; ++i) {
            if (!this.m_strIDs[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static FGString getLine(FGData fGData, int n) {
        FGString fGString = new FGString();
        if (fGData.m_dataLength <= n) {
            return fGString;
        }
        int n2 = n;
        do {
            char c;
            if ((c = (char)fGData.m_data[n2]) == '\n' || c == '\r') {
                return fGString;
            }
            fGString.add(c);
        } while (++n2 < fGData.m_dataLength);
        return fGString;
    }
}

