/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave;

import com.tqm.agave.Main;
import com.tqm.agave.MainLogic;
import com.tqm.agave.system.canvas.MIDP2Canvas;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class MainScreen {
    private MainLogic mainLogic;
    private Main main;
    private Canvas _activeCanvas;
    private Thread _thread;
    public boolean wantFinish = false;
    private int _limitMs;
    private static int frameTick;
    private Image backBuffer;
    private Graphics backBufferGraphics;
    private boolean _keyBack;
    private boolean _keyClear;
    private String _platformName;
    private long _interruptInterval;
    private int keyBuffer;
    private long keyPressedTime;
    private boolean checkKeyRepeated;
    private boolean beginKeyRepeated;
    public static int KEY_REPEAT_TIME_FIRST;
    public static int KEY_REPEAT_TIME_NORMAL;
    private final int[] autodetectKeyState = new int[10];
    private final int[][] extendedKeyState = new int[20][3];
    private final int[] auxCounter = new int[20];

    public MainScreen(MainLogic mainLogic, Main main) {
        this.mainLogic = mainLogic;
        this.main = main;
        this.mainLogic.setCanvasReference(this);
        this.backBuffer = null;
        this.backBufferGraphics = null;
        this._platformName = System.getProperty("microedition.platform");
    }

    public final void setSize(int n, int n2) {
        MainLogic.width = n;
        MainLogic.height = n2;
        MainLogic.halfWidth = MainLogic.width / 2;
        MainScreen.sizeChanged(n, n2);
    }

    public static void sizeChanged(int n, int n2) {
        if (Main.hasLandscapeSupport()) {
            if (n > n2) {
                MainLogic.tmpWidth = n;
                MainLogic.tmpHeight = n2;
                MainLogic.tmpHalfWidth = n / 2;
                return;
            }
            MainLogic.width = n;
            MainLogic.height = n2;
            MainLogic.halfWidth = n / 2;
            return;
        }
        MainLogic.width = n;
        MainLogic.height = n2;
        MainLogic.halfWidth = n / 2;
    }

    public static boolean hasProperDimensions() {
        if (Main.hasLandscapeSupport()) {
            return MainLogic.width <= MainLogic.height;
        }
        return true;
    }

    public final void createBackBuffer() {
        this.backBuffer = Image.createImage((int)MainLogic.width, (int)MainLogic.height);
        this.backBufferGraphics = this.backBuffer.getGraphics();
    }

    public final void setInterruptInterval(long interval) {
        this._interruptInterval = 0L;
    }

    public final void setMaxFps$13462e() {
        this._limitMs = 62;
    }

    public final void useKeyBack(boolean use) {
        this._keyBack = true;
    }

    public final void useKeyClear(boolean use) {
        this._keyClear = false;
    }

    public final boolean goToUrl(String url) throws ConnectionNotFoundException {
        return this.main.platformRequest(url);
    }

    public final void finish() {
        this.wantFinish = true;
    }

    public final void exit() {
        if (this.wantFinish) {
            this.main.exitMidlet();
        }
    }

    public final boolean isReadyToFinish() {
        return this.wantFinish;
    }

    public final boolean hasKeyClear() {
        return this._keyClear;
    }

    public final String getPlatformName() {
        return this._platformName;
    }

    public final int getKeyBuffer() {
        return this.keyBuffer;
    }

    public final void think() {
        System.currentTimeMillis();
        int n = this.keyBuffer;
        MainScreen mainScreen = this;
        if (mainScreen.checkKeyRepeated) {
            long l = System.currentTimeMillis();
            if (mainScreen.beginKeyRepeated) {
                if (l - mainScreen.keyPressedTime > (long)KEY_REPEAT_TIME_FIRST) {
                    mainScreen.beginKeyRepeated = false;
                    mainScreen.keyPressedTime = l;
                    mainScreen.mainLogic.keyRepeated(mainScreen.translateKeyCode(n));
                }
            } else if (l - mainScreen.keyPressedTime > (long)KEY_REPEAT_TIME_NORMAL) {
                mainScreen.keyPressedTime = l;
                mainScreen.mainLogic.keyRepeated(mainScreen.translateKeyCode(n));
            }
        }
        this.mainLogic.think();
        ++MainLogic.counter;
        System.currentTimeMillis();
    }

    public final void draw(Graphics graphics) {
        System.currentTimeMillis();
        if (Main.hasBackBufferSupport()) {
            this.drawImpl(this.backBufferGraphics);
            graphics.drawImage(this.backBuffer, 0, 0, 20);
        } else {
            this.drawImpl(graphics);
        }
        if (Main.hasGarbageCollectorFix()) {
            Runtime.getRuntime().gc();
        }
        System.currentTimeMillis();
    }

    private void drawImpl(Graphics g) {
        this.mainLogic.draw(g);
    }

    public final void tick(int n) {
        frameTick = n > 500 ? this._limitMs : n;
        long l = this._limitMs - frameTick;
        if (l > 0L) {
            frameTick = this._limitMs;
            try {
                Thread.sleep(l);
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public final void handleInterruption(long prevTime, long currTime) {
        if (currTime - prevTime > this._interruptInterval) {
            this.mainLogic.notifyInterruption();
        }
    }

    public final void keyPressed(int key) {
        this.keyBuffer = key;
        this.checkKeyRepeated = true;
        this.beginKeyRepeated = true;
        this.keyPressedTime = System.currentTimeMillis();
        this.mainLogic.keyPressed(this.translateKeyCode(key));
    }

    public final void keyReleased(int key) {
        if (key == this.keyBuffer) {
            this.checkKeyRepeated = false;
        }
        this.mainLogic.keyReleased(this.translateKeyCode(key));
    }

    public final void pointerPressed(int x, int y) {
        this.mainLogic.pointerPressed(x, y);
    }

    public final void pointerReleased(int x, int y) {
        this.mainLogic.pointerReleased(x, y);
    }

    public final void pointerDragged(int x, int y) {
        this.mainLogic.pointerDragged(x, y);
    }

    public final void showNotify() {
        this.mainLogic.notifyInterruption();
    }

    public final void hideNotify() {
        this.mainLogic.notifyInterruption();
    }

    public final void commandAction$3ac0e660(Command c) {
        this.mainLogic.commmandAction(c);
    }

    private int translateKeyCode(int n) {
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < 10; ++i) {
            if (this.autodetectKeyState[i] != n) continue;
            n2 = i;
            break;
        }
        switch (n2) {
            case 0: {
                return 88;
            }
            case 1: {
                return 85;
            }
            case 2: {
                return 86;
            }
            case 3: {
                return 87;
            }
            case 4: {
                return 91;
            }
            case 5: {
                return 89;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 95;
            }
            case 9: {
                return 96;
            }
            case 7: {
                return 92;
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public final void retrieveKeyCodes$44c588bf(String var1_1, boolean var2_4) {
        block76: {
            for (var3_6 = 0; var3_6 < 10; ++var3_6) {
                this.autodetectKeyState[var3_6] = 0x7FFFFFFF;
            }
            for (var3_6 = 0; var3_6 < 20; ++var3_6) {
                for (var4_8 = 0; var4_8 < 3; ++var4_8) {
                    this.extendedKeyState[var3_6][var4_8] = 0x7FFFFFFF;
                }
            }
            for (var3_6 = 0; var3_6 < 20; ++var3_6) {
                this.auxCounter[var3_6] = 0;
            }
            var3_7 = new int[]{122, 80, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, -1, -4, -5, -2, -3, -8, -9, -10, -16, -11, -6, -7, -12, -13, -14, -15, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -59, -60, -61, -62, -202, -203, -204};
            for (var4_8 = 0; var4_8 < var3_7.length; ++var4_8) {
                var6_10 = var3_7[var4_8];
                var5_9 = this;
                var7_13 = 0x7FFFFFFF;
                var8_14 = 0;
                var9_15 = "n/a";
                var10_16 = false;
                try {
                    var7_13 = var5_9._activeCanvas.getGameAction(var6_10);
                    var8_14 = 1;
                }
                catch (Exception v0) {}
                try {
                    var9_15 = var5_9._activeCanvas.getKeyName(var6_10).toLowerCase();
                    var10_16 = true;
                }
                catch (Exception v1) {}
                if (var8_14 != 0 && var7_13 != 0x7FFFFFFF && !MainScreen.isStandardKeyboardKeyCode(var6_10)) {
                    switch (var7_13) {
                        case 6: {
                            if (var5_9.isRetrieved(3) || MainScreen.contains(var9_15, "selection") || MainScreen.contains(var9_15, "wybor") || MainScreen.contains(var9_15, "n/a")) break;
                            var5_9.autodetectKeyState[3] = var8_14 = var6_10;
                            break;
                        }
                        case 1: {
                            if (var5_9.isRetrieved(1) || MainScreen.contains(var9_15, "selection") || MainScreen.contains(var9_15, "wybor") || MainScreen.contains(var9_15, "n/a")) break;
                            var5_9.autodetectKeyState[1] = var8_14 = var6_10;
                            break;
                        }
                        case 5: {
                            if (var5_9.isRetrieved(2) || MainScreen.contains(var9_15, "selection") || MainScreen.contains(var9_15, "wybor") || MainScreen.contains(var9_15, "n/a")) break;
                            var5_9.autodetectKeyState[2] = var8_14 = var6_10;
                            break;
                        }
                        case 2: {
                            if (var5_9.isRetrieved(0) || MainScreen.contains(var9_15, "selection") || MainScreen.contains(var9_15, "wybor") || MainScreen.contains(var9_15, "n/a")) break;
                            var5_9.autodetectKeyState[0] = var8_14 = var6_10;
                            break;
                        }
                        case 8: {
                            if (var5_9.isRetrieved(4) || MainScreen.contains(var9_15, "soft") || MainScreen.contains(var9_15, "call") || MainScreen.contains(var9_15, "send") || MainScreen.contains(var9_15, "confirm") || MainScreen.contains(var9_15, "enter") || MainScreen.contains(var9_15, "space") || var9_15.equals("z")) break;
                            var5_9.autodetectKeyState[4] = var8_14 = var6_10;
                        }
                    }
                }
                if (!var10_16 || var9_15 == null || var9_15.equals("n/a") || MainScreen.isStandardKeyboardKeyCode(var6_10)) continue;
                if (MainScreen.contains(var9_15, "soft")) {
                    if (!var5_9.isRetrieved(5) && (MainScreen.contains(var9_15, "1") || MainScreen.contains(var9_15, "left"))) {
                        var5_9.autodetectKeyState[5] = var8_14 = var6_10;
                    }
                    if (!var5_9.isRetrieved(6) && (MainScreen.contains(var9_15, "2") || MainScreen.contains(var9_15, "4") || MainScreen.contains(var9_15, "right"))) {
                        var5_9.autodetectKeyState[6] = var8_14 = var6_10;
                    }
                    if (!var5_9.isRetrieved(7) && MainScreen.contains(var9_15, "3") && var6_10 != -8) {
                        var5_9.autodetectKeyState[7] = var8_14 = var6_10;
                    }
                    if (var5_9.isRetrieved(8) || !MainScreen.contains(var9_15, "3") || var6_10 != -8) continue;
                    var5_9.autodetectKeyState[8] = var8_14 = var6_10;
                    continue;
                }
                if (MainScreen.contains(var9_15, "selection") || MainScreen.contains(var9_15, "wybor")) {
                    if (!var5_9.isRetrieved(5) && (MainScreen.contains(var9_15, "left") || MainScreen.contains(var9_15, "lewo"))) {
                        var5_9.autodetectKeyState[5] = var8_14 = var6_10;
                    }
                    if (var5_9.isRetrieved(6) || !MainScreen.contains(var9_15, "right") && !MainScreen.contains(var9_15, "prawo")) continue;
                    var5_9.autodetectKeyState[6] = var8_14 = var6_10;
                    continue;
                }
                if (MainScreen.contains(var9_15, "action")) {
                    if (!var5_9.isRetrieved(5) && MainScreen.contains(var9_15, "left")) {
                        var5_9.autodetectKeyState[5] = var8_14 = var6_10;
                    }
                    if (var5_9.isRetrieved(6) || !MainScreen.contains(var9_15, "right")) continue;
                    var5_9.autodetectKeyState[6] = var8_14 = var6_10;
                    continue;
                }
                if (MainScreen.contains(var9_15, "game")) {
                    if (!var5_9.isRetrieved(5) && MainScreen.contains$3b99ba1e(var9_15, "a")) {
                        var5_9.autodetectKeyState[5] = var8_14 = var6_10;
                    }
                    if (var5_9.isRetrieved(6) || !MainScreen.contains$3b99ba1e(var9_15, "b")) continue;
                    var5_9.autodetectKeyState[6] = var8_14 = var6_10;
                    continue;
                }
                if (MainScreen.contains(var9_15, "z")) {
                    if (var5_9.isRetrieved(7)) continue;
                    var5_9.autodetectKeyState[7] = var8_14 = var6_10;
                    continue;
                }
                if (!var5_9.isRetrieved(4) && (MainScreen.contains(var9_15, "navi-center") || MainScreen.contains(var9_15, "center") || MainScreen.contains(var9_15, "select"))) {
                    var5_9.autodetectKeyState[4] = var8_14 = var6_10;
                    continue;
                }
                if (!var5_9.isRetrieved(0) && MainScreen.contains(var9_15, "left") && !MainScreen.contains(var9_15, "action")) {
                    var5_9.autodetectKeyState[0] = var8_14 = var6_10;
                    continue;
                }
                if (!var5_9.isRetrieved(2) && MainScreen.contains(var9_15, "right") && !MainScreen.contains(var9_15, "action")) {
                    var5_9.autodetectKeyState[2] = var8_14 = var6_10;
                    continue;
                }
                if (!(var5_9.isRetrieved(1) || !MainScreen.contains(var9_15, "up") || MainScreen.contains(var9_15, "side") || MainScreen.contains(var9_15, "scroll") || MainScreen.contains(var9_15, "vol") || MainScreen.contains(var9_15, "flip"))) {
                    var5_9.autodetectKeyState[1] = var8_14 = var6_10;
                    continue;
                }
                if (!(var5_9.isRetrieved(3) || !MainScreen.contains(var9_15, "down") || MainScreen.contains(var9_15, "side") || MainScreen.contains(var9_15, "scroll") || MainScreen.contains(var9_15, "vol") || MainScreen.contains(var9_15, "flip"))) {
                    var5_9.autodetectKeyState[3] = var8_14 = var6_10;
                    continue;
                }
                if (!var5_9.isRetrieved(8) && (MainScreen.contains(var9_15, "end") || MainScreen.contains(var9_15, "on/off") || MainScreen.contains(var9_15, "back") || MainScreen.contains(var9_15, "call"))) {
                    var5_9.autodetectKeyState[8] = var8_14 = var6_10;
                    continue;
                }
                if ((var2_4 == 0 || var5_9.isRetrieved(9)) && (var2_4 != 0 || var5_9.isRetrieved(8)) || !MainScreen.contains(var9_15, "clear") && !MainScreen.contains(var9_15, "del") && (!var9_15.equals("c") || var7_13 != 0)) continue;
                if (var2_4 == 0) {
                    var5_9.autodetectKeyState[9] = var8_14 = var6_10;
                    var5_9.autodetectKeyState[8] = var8_14 = var6_10;
                    continue;
                }
                var5_9.autodetectKeyState[9] = var8_14 = var6_10;
            }
            var4_8 = 0;
            if (var1_1 == null) break block76;
            var6_11 = var1_1;
            if (var6_11 == null) ** GOTO lbl-1000
            var2_5 = var6_11.toLowerCase();
            if (MainScreen.contains(var2_5, "sony") || MainScreen.contains(var2_5, "ericsson")) {
                v2 = 1;
            } else if (MainScreen.contains(var2_5, "nokia")) {
                v2 = 2;
            } else if (MainScreen.contains(var2_5, "symbian os")) {
                v2 = 100;
            } else if (MainScreen.contains(var2_5, "symbianj2me")) {
                v2 = 101;
            } else lbl-1000:
            // 2 sources

            {
                v2 = 0;
            }
            var4_8 = v2;
        }
        var5_9 = this;
        if (var5_9.autodetectKeyState[7] == 0x7FFFFFFF && var5_9.autodetectKeyState[8] == 0x7FFFFFFF && var5_9.autodetectKeyState[9] == 0x7FFFFFFF && var5_9.autodetectKeyState[5] == -6 && var5_9.autodetectKeyState[6] == -7) {
            var2_4 = var5_9.autodetectKeyState[5];
            var5_9.autodetectKeyState[5] = var1_2 = var5_9.autodetectKeyState[6];
            var5_9.autodetectKeyState[6] = var2_4;
        }
        var6_12 = var4_8;
        var5_9 = this;
        for (var2_4 = 0; var2_4 < var5_9.autodetectKeyState.length; ++var2_4) {
            if (var5_9.isRetrieved(var2_4)) continue;
            var1_3 = 0x7FFFFFFF;
            switch (var6_12) {
                case 1: {
                    switch (var2_4) {
                        case 0: {
                            var1_3 = -3;
                            break;
                        }
                        case 2: {
                            var1_3 = -4;
                            break;
                        }
                        case 1: {
                            var1_3 = -1;
                            break;
                        }
                        case 3: {
                            var1_3 = -2;
                            break;
                        }
                        case 4: {
                            var1_3 = -5;
                            break;
                        }
                        case 5: {
                            var1_3 = -6;
                            break;
                        }
                        case 6: {
                            var1_3 = -7;
                            break;
                        }
                        case 8: {
                            var1_3 = -11;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (var2_4) {
                        case 0: {
                            var1_3 = -3;
                            break;
                        }
                        case 2: {
                            var1_3 = -4;
                            break;
                        }
                        case 1: {
                            var1_3 = -1;
                            break;
                        }
                        case 3: {
                            var1_3 = -2;
                            break;
                        }
                        case 4: {
                            var1_3 = -5;
                            break;
                        }
                        case 5: {
                            var1_3 = -6;
                            break;
                        }
                        case 6: {
                            var1_3 = -7;
                        }
                    }
                    break;
                }
                case 100: {
                    switch (var2_4) {
                        case 4: {
                            var1_3 = 13;
                        }
                    }
                    break;
                }
                case 101: {
                    switch (var2_4) {
                        case 4: {
                            var1_3 = -5;
                        }
                    }
                }
            }
            if (var1_3 == 0x7FFFFFFF) continue;
            var8_14 = var1_3;
            var1_3 = var2_4;
            var5_9.autodetectKeyState[var1_3] = var8_14;
        }
    }

    private static boolean isStandardKeyboardKeyCode(int n) {
        return n >= 48 && n <= 57 || n == 42 || n == 35;
    }

    private static boolean contains(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    private static boolean contains$3b99ba1e(String string, String string2) {
        return string.indexOf(string2, 4) != -1;
    }

    private boolean isRetrieved(int n) {
        return this.autodetectKeyState[n] != Integer.MAX_VALUE;
    }

    public final void startCanvas() {
        this._thread = new Thread((Runnable)this._activeCanvas);
        this._thread.start();
    }

    public final Displayable createCanvas(int n, MainScreen mainScreen) throws ClassNotFoundException {
        this._activeCanvas = MainScreen.createMIDP2Canvas(mainScreen, true);
        return this._activeCanvas;
    }

    private static Canvas createMIDP2Canvas(MainScreen mainScreen, boolean bl) throws ClassNotFoundException {
        Class.forName("javax.microedition.lcdui.game.GameCanvas");
        Canvas canvas = null;
        Class<?> clazz = Class.forName("com.tqm.agave.system.canvas.MIDP2Canvas");
        try {
            canvas = (Canvas)clazz.newInstance();
            ((MIDP2Canvas)canvas).init(mainScreen, bl);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return canvas;
    }

    static {
        KEY_REPEAT_TIME_FIRST = 50;
        KEY_REPEAT_TIME_NORMAL = 50;
    }
}

