/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.menu;

import com.tqm.agave.menu.Cell;
import com.tqm.agave.menu.Container;
import com.tqm.agave.ui.GraphicFont;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class TextLabel
extends Cell {
    private String[] _text;
    private int _fontType;
    private Font _font;
    private GraphicFont _gFont;
    private int _interLine;
    private int _fontColorActive = -16777216;
    private int _fontColorInactive = -4144960;
    private int _vMargin;
    private int _hMargin;

    public TextLabel(String string, int n, Font font, GraphicFont graphicFont, int n2) {
        super(n2);
        this._text = new String[]{string};
        this._fontType = 1;
        switch (this._fontType) {
            case 2: {
                this._gFont = graphicFont;
                break;
            }
            case 1: {
                this._font = font;
            }
        }
        this._interLine = 1;
    }

    public final void draw(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int n5 = this.getX() + this._hMargin;
        int n6 = this.getY() + this._vMargin;
        for (int i = 0; i < this._text.length; ++i) {
            switch (this._fontType) {
                case 1: {
                    if (this.isActive()) {
                        graphics.setColor(this._fontColorActive);
                    } else {
                        graphics.setColor(this._fontColorInactive);
                    }
                    graphics.setFont(this._font);
                    graphics.drawString(this._text[i].trim(), n5, n6, this.getAnchorType() & 0xD | 0x10);
                    break;
                }
                case 2: {
                    this._gFont.drawString(graphics, this._text[i].trim(), n5, n6, this.getAnchorType() & 0xD | 0x10);
                }
            }
            n6 += this.getFontHeight() + this._interLine;
        }
        graphics.setClip(n, n2, n3, n4);
    }

    public final void setAnchor(int n) {
        super.setAnchor(n);
        this._vMargin = 1;
        this._hMargin = 1;
        if ((this.getAnchorType() & 1) != 0) {
            this._hMargin = this.getWidth() >> 1;
        } else if ((this.getAnchorType() & 8) != 0) {
            this._hMargin = this.getWidth() - 1;
        }
        if ((this.getAnchorType() & 2) != 0) {
            this._vMargin = this.getHeight() - this._text.length * (this.getFontHeight() + this._interLine) >> 1;
            return;
        }
        if ((this.getAnchorType() & 0x40) != 0) {
            this._vMargin = this.getHeight() - 1 - this._text.length * (this.getFontHeight() + this._interLine);
        }
    }

    public final void setSize(int n, int n2) {
        block13: {
            String string;
            int n3;
            block12: {
                int n4;
                int n5 = this.getWidth();
                n3 = this.getHeight();
                super.setSize(n, n2);
                string = TextLabel.rollIntoString(this._text);
                if (n5 != this.getWidth() || n3 > this.getHeight()) break block12;
                String string2 = string;
                TextLabel textLabel = this;
                switch (textLabel._fontType) {
                    case 1: {
                        n4 = textLabel._font.stringWidth(string2);
                        break;
                    }
                    case 2: {
                        n4 = textLabel._gFont.getStringWidth(string2);
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                if (n4 < this.getWidth()) break block13;
            }
            int n6 = this.getWidth();
            String string3 = string;
            TextLabel textLabel = this;
            switch (textLabel._fontType) {
                case 1: {
                    String[] stringArray = Container.wrapText(string3, n6, textLabel._font);
                    break;
                }
                case 2: {
                    String[] stringArray = Container.wrapText(string3, n6, textLabel._gFont);
                    break;
                }
                default: {
                    String[] stringArray = this._text = null;
                }
            }
            if (n3 < this._text.length * (this.getFontHeight() + this._interLine)) {
                super.setSize(-1, this._text.length * (this.getFontHeight() + this._interLine) + 2);
            }
        }
        this.setAnchor(this.getAnchorType());
    }

    public final void setColor(int n, int n2) {
        switch (n2) {
            case 1: {
                this._fontColorActive = n;
                return;
            }
            case 2: {
                this._fontColorInactive = n;
            }
        }
    }

    private int getFontHeight() {
        switch (this._fontType) {
            case 1: {
                return this._font.getHeight();
            }
            case 2: {
                return this._gFont.getHeight();
            }
        }
        return 0;
    }

    private static String rollIntoString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public final void replaceContent(Object content) {
        this._text = new String[]{(String)content};
        this.setSize(this.getWidth(), -1);
        this.onContentChange();
    }

    public final String toString() {
        return TextLabel.rollIntoString(this._text);
    }
}

