/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave.ui;

import com.tqm.agave.Main;
import com.tqm.agave.MainLogic;
import com.tqm.agave.system.image.MIDP1Image;
import com.tqm.agave.system.image.MIDP2Image;
import com.tqm.agave.system.image.NokiaImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameImage {
    private static Vector loadedGameImage = new Vector();
    public String name;
    private int width;
    private int height;
    private MIDP1Image midp1Image;
    private MIDP2Image midp2Image;
    private NokiaImage nokiaImage;

    private GameImage(String name, int width, int height, MIDP1Image image) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.midp1Image = image;
    }

    private GameImage(String name, int width, int height, MIDP2Image image) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.midp2Image = image;
    }

    private GameImage(String name, int width, int height, NokiaImage image) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.nokiaImage = image;
    }

    public static boolean dispose(String name) {
        return loadedGameImage.removeElement(GameImage.find(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameImage find(String string) {
        Enumeration enumeration = loadedGameImage.elements();
        Vector vector = loadedGameImage;
        synchronized (vector) {
            while (enumeration.hasMoreElements()) {
                GameImage gameImage = (GameImage)enumeration.nextElement();
                if (gameImage.name.compareTo(string) != 0) continue;
                return gameImage;
            }
        }
        return null;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public static Image createSystemSpriteImage(String fileName) {
        GameImage gameImage = GameImage.createImage(fileName);
        if (Main.getImageType() == 2) {
            return gameImage.midp1Image.image;
        }
        return gameImage.midp2Image.image;
    }

    public static GameImage createTqmSpriteImage(String string) {
        return GameImage.createImage(string);
    }

    private static GameImage createImage(String string) {
        Object object = GameImage.find(string);
        if (object == null) {
            switch (Main.getImageType()) {
                case 2: {
                    object = MIDP1Image.createImage(string);
                    int n = ((MIDP1Image)object).getWidth();
                    int n2 = ((MIDP1Image)object).getHeight();
                    object = new GameImage(string, n, n2, MIDP1Image.createImage(string));
                    break;
                }
                case 1: {
                    object = MIDP2Image.createImage(string);
                    int n = ((MIDP2Image)object).getWidth();
                    int n3 = ((MIDP2Image)object).getHeight();
                    object = new GameImage(string, n, n3, MIDP2Image.createImage(string));
                    break;
                }
                case 3: {
                    object = NokiaImage.createImage(string);
                    int n = ((NokiaImage)object).getWidth();
                    int n4 = ((NokiaImage)object).getHeight();
                    object = new GameImage(string, n, n4, NokiaImage.createImage(string));
                }
            }
            loadedGameImage.addElement(object);
        }
        return object;
    }

    public final void drawRegion$36d9c437(Graphics object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = object.getTranslateX();
        int n9 = object.getTranslateY();
        if (n6 + n3 >= -n8 && n7 + n4 >= -n9 && n7 <= MainLogic.height - n9 && n6 <= MainLogic.width - n8) {
            switch (Main.getImageType()) {
                case 2: {
                    n5 = n4;
                    n4 = n3;
                    n3 = n2;
                    n2 = n;
                    Graphics graphics = object;
                    object = this.midp1Image;
                    n8 = graphics.getTranslateX();
                    n9 = graphics.getTranslateY();
                    int n10 = graphics.getClipX() - n8;
                    int n11 = graphics.getClipY() - n9;
                    int n12 = graphics.getClipWidth();
                    int n13 = graphics.getClipHeight();
                    if (Main.hasClipRectFix()) {
                        int n14 = n5;
                        int n15 = n4;
                        n5 = n6;
                        Graphics graphics2 = graphics;
                        int n16 = graphics2.getClipX();
                        int n17 = graphics2.getClipY();
                        int n18 = graphics2.getClipWidth();
                        int n19 = graphics2.getClipHeight();
                        if (n5 < n16 + n18 || n7 < n17 + n19 || n5 + n15 > n16 || n7 + n14 > n17) {
                            int n20 = Math.max(n16, n5);
                            int n21 = Math.max(n17, n7);
                            n5 = Math.min(n16 + n18, n5 + n15) - n20;
                            n15 = Math.min(n17 + n19, n7 + n14) - n21;
                            graphics2.setClip(n20, n21, n5, n15);
                        }
                    } else {
                        graphics.clipRect(n6, n7, n4, n5);
                    }
                    graphics.drawImage(object.image, n6 - n2, n7 - n3, 20);
                    graphics.setClip(n10 + n8, n11 + n9, n12, n13);
                    return;
                }
                case 1: {
                    n8 = n7;
                    n7 = n6;
                    n6 = n5;
                    n5 = n4;
                    n4 = n3;
                    n3 = n2;
                    n2 = n;
                    Graphics graphics = object;
                    object = this.midp2Image;
                    graphics.drawRegion(object.image, n2, n3, n4, n5, n6, n7, n8, 20);
                    return;
                }
                case 3: {
                    this.nokiaImage.drawRegion$36d9c437((Graphics)object, n, n2, n3, n4, n5, n6, n7);
                }
            }
        }
    }
}

