/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.Utils;
import com.tqm.fantasydefense.game.Unit;
import com.tqm.fantasydefense.shop.secret.SecretElixir;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import javax.microedition.lcdui.Graphics;

public final class Enemy
extends Unit {
    private final int BASE_HEALTHBAR_LENGTH;
    private int _speed;
    public int _health;
    private int _baseHealth;
    private int _road;
    private int _frame;
    public int _distanceFromEnd;
    private int _tileX;
    private int _tileY;
    private int _startX;
    private int _startY;
    private int _destX;
    private int _destY;
    private int _step;
    private int _finalStep;
    private int _destRoadNode;
    private int _hit;
    private int _damage;
    private int _hit2;
    private int _damage2;
    private int _slowdownTime;
    private int _poisonTime;
    private int _fireTime;
    private int _dieTime;
    private int _poisonTimedDmg;
    private int _poisonDelayTime;
    private int _fireTimedDmg;
    private int _fireDelayTime;
    private boolean _left = true;
    private static int additionalGold = 0;
    private static int tmpX;
    private static int tmpY;
    private static int time;
    private static SecretElixir[] secretElixir;
    private static int drawBiasX;
    private static int drawBiasY;
    private int tmpAdd;

    private void nextWalkNode(int n) {
        if (n <= 0 || n >= GameTemplate.roads.getRoadNodeCount(this._road)) {
            return;
        }
        if (n == 1) {
            this._tileX = GameTemplate.roads.getRoadNodeX(this._road, 0) - 1;
            this._tileY = GameTemplate.roads.getRoadNodeY(this._road, 0) - 1;
        }
        this._startX = this._tileX * 28 - this._tileY * 13;
        this._startY = this._tileY * 26;
        tmpX = GameTemplate.roads.getRoadNodeX(this._road, n);
        tmpY = GameTemplate.roads.getRoadNodeY(this._road, n);
        if (n == GameTemplate.roads.getRoadNodeCount(this._road) - 1) {
            if (tmpX > 0) {
                --tmpX;
            } else if (tmpX < 0) {
                ++tmpX;
            } else if (tmpY > 0) {
                --tmpY;
            } else if (tmpY < 0) {
                ++tmpY;
            }
        }
        this._tileX += tmpX;
        this._tileY += tmpY;
        this._destX = this._tileX * 28 - this._tileY * 13;
        this._destY = this._tileY * 26;
        this._step = 0;
        if (tmpX != 0) {
            this._finalStep = Math.abs(tmpX * 40) * 10;
            return;
        }
        if (tmpY != 0) {
            this._finalStep = Math.abs(tmpY * 36) * 10;
        }
    }

    public Enemy(int n, int n2, int n3) {
        this._road = n;
        this._destRoadNode = 1;
        this.nextWalkNode(this._destRoadNode);
        this._distanceFromEnd = this.calculateDistanceFromRoadEnd();
        this._left = GameTemplate.roads.getRoadNodeX(this._road, this._destRoadNode) > 0 || GameTemplate.roads.getRoadNodeY(this._road, this._destRoadNode) < 0;
        this._x = this._startX;
        this._x = this._startY;
        this._type = n2;
        this._frame = 0;
        this._hit = 0;
        this._slowdownTime = 0;
        this._poisonTime = 0;
        this._fireTime = 0;
        this._dieTime = 0;
        switch (this._type) {
            case 0: {
                this._speed = 15;
                this._health = 250;
                this._width = GameTemplate.orc.getWidth();
                this._height = GameTemplate.orc.getHeight();
                break;
            }
            case 1: {
                this._speed = 20;
                this._health = 150;
                this._width = GameTemplate.skeleton.getWidth();
                this._height = GameTemplate.skeleton.getHeight();
                break;
            }
            case 2: {
                this._speed = 10;
                this._health = 400;
                this._width = GameTemplate.iceElemental.getWidth();
                this._height = GameTemplate.iceElemental.getHeight();
                break;
            }
            case 3: {
                this._speed = 10;
                this._health = 400;
                this._width = GameTemplate.fireElemental.getWidth();
                this._height = GameTemplate.fireElemental.getHeight();
                break;
            }
            case 4: {
                this._speed = 25;
                this._health = 100;
                this._width = GameTemplate.witch.getWidth();
                this._height = GameTemplate.witch.getHeight();
                break;
            }
            case 5: {
                this._speed = 20;
                this._health = 200;
                this._width = GameTemplate.ghost.getWidth();
                this._height = GameTemplate.ghost.getHeight();
                break;
            }
            case 6: {
                this._speed = 15;
                this._health = 350;
                this._width = GameTemplate.drake.getWidth();
                this._height = GameTemplate.drake.getHeight();
                break;
            }
            case 7: {
                this._speed = 5;
                this._health = 1500;
                this._width = GameTemplate.deathKnight.getWidth();
                this._height = GameTemplate.deathKnight.getHeight();
                break;
            }
            case 8: {
                this._speed = 5;
                this._health = 2500;
                this._width = GameTemplate.demon.getWidth();
                this._height = GameTemplate.demon.getHeight();
                break;
            }
            default: {
                this._speed = 10;
            }
        }
        if (secretElixir == null) {
            secretElixir = SecretItemsManager.getInstance().getElixirs();
        }
        if (GameTemplate._elixirsActive) {
            if (secretElixir[6].isActive()) {
                this._speed = this._speed * (100 - secretElixir[6].getPower()) / 100;
            } else if (secretElixir[7].isActive()) {
                this._speed = this._speed * (100 - secretElixir[7].getPower()) / 100;
            }
            additionalGold = secretElixir[8].isActive() ? 2 : 0;
        }
        this._health += this._health * n3 / 100;
        this._baseHealth = this._health;
        int n4 = GameTemplate.orc.getWidth() / 2;
        Enemy enemy = this;
        n2 = 0;
        switch (enemy._type) {
            case 0: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 6;
                break;
            }
            case 8: {
                n2 = 7;
            }
        }
        this.BASE_HEALTHBAR_LENGTH = n4 + n2 * (GameTemplate.orc.getWidth() / 11);
    }

    public final void drawShadow(Graphics g) {
        GameTemplate.shadow.setPosition(this._x + GameTemplate.viewX - (GameTemplate.shadow.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - (GameTemplate.shadow.getHeight() >> 1) + 13);
        GameTemplate.shadow.setFrame(0);
        GameTemplate.shadow.paint(g);
    }

    public final void draw(Graphics graphics) {
        drawBiasX = 0;
        drawBiasY = 0;
        if (!GameTemplate._pause) {
            this._frame += 96;
            this._frame = this._type == 0 ? (this._frame %= 2048) : (this._type == 1 ? (this._frame %= 2048) : (this._type == 2 || this._type == 3 ? (this._frame %= 2048) : (this._type == 7 ? (this._frame %= 2048) : (this._frame %= 1024))));
        }
        if (this._dieTime <= 4) {
            switch (this._type) {
                case 0: {
                    drawBiasY = 2;
                    if (this._left) {
                        GameTemplate.orc.setTransform(0);
                    } else {
                        GameTemplate.orc.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.orc.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.orc.setFrame(this._frame >> 8);
                    GameTemplate.orc.paint(graphics);
                    break;
                }
                case 1: {
                    drawBiasY = 4;
                    if (this._left) {
                        GameTemplate.skeleton.setTransform(0);
                    } else {
                        GameTemplate.skeleton.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.skeleton.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.skeleton.setFrame(this._frame >> 8);
                    GameTemplate.skeleton.paint(graphics);
                    break;
                }
                case 2: {
                    drawBiasY = 12;
                    if (this._left) {
                        GameTemplate.iceElemental.setTransform(0);
                    } else {
                        GameTemplate.iceElemental.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.iceElemental.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.iceElemental.setFrame(this._frame >> 8);
                    GameTemplate.iceElemental.paint(graphics);
                    break;
                }
                case 3: {
                    drawBiasY = 12;
                    if (this._left) {
                        GameTemplate.fireElemental.setTransform(0);
                    } else {
                        GameTemplate.fireElemental.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.fireElemental.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.fireElemental.setFrame(this._frame >> 8);
                    GameTemplate.fireElemental.paint(graphics);
                    break;
                }
                case 4: {
                    if (this._left) {
                        GameTemplate.witch.setTransform(0);
                    } else {
                        GameTemplate.witch.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.witch.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height);
                    GameTemplate.witch.setFrame(this._frame >> 8);
                    GameTemplate.witch.paint(graphics);
                    break;
                }
                case 5: {
                    if (this._left) {
                        GameTemplate.ghost.setTransform(0);
                    } else {
                        GameTemplate.ghost.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.ghost.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height);
                    GameTemplate.ghost.setFrame(this._frame >> 8);
                    GameTemplate.ghost.paint(graphics);
                    break;
                }
                case 7: {
                    drawBiasY = 4;
                    if (this._left) {
                        GameTemplate.deathKnight.setTransform(0);
                    } else {
                        GameTemplate.deathKnight.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.deathKnight.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.deathKnight.setFrame(this._frame >> 8);
                    GameTemplate.deathKnight.paint(graphics);
                    break;
                }
                case 6: {
                    if (this._left) {
                        GameTemplate.drake.setTransform(0);
                    } else {
                        GameTemplate.drake.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.drake.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height);
                    GameTemplate.drake.setFrame(this._frame >> 8);
                    GameTemplate.drake.paint(graphics);
                    break;
                }
                case 8: {
                    drawBiasY = 12;
                    if (this._left) {
                        GameTemplate.demon.setTransform(0);
                    } else {
                        GameTemplate.demon.setTransform(2);
                        drawBiasX = -drawBiasX;
                    }
                    GameTemplate.demon.setPosition(this._x + GameTemplate.viewX - (this._width >> 1) + 20, this._y + drawBiasY + GameTemplate.viewY - this._height + 13);
                    GameTemplate.demon.setFrame(this._frame >> 8);
                    GameTemplate.demon.paint(graphics);
                }
            }
        }
        if (this._health > 0) {
            graphics.setColor(GameLogic.GAME_LIFE_COLOR1);
            if (this.isAir()) {
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() - 2 - this._height, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
                graphics.setColor(GameLogic.GAME_LIFE_COLOR2);
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() - 2 - this._height + 1, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
                graphics.setColor(-16777216);
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() - 2 - this._height + 2, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
            } else {
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() / 2 - 2 - this._height + 13, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
                graphics.setColor(GameLogic.GAME_LIFE_COLOR2);
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() / 2 - 2 - this._height + 13 + 1, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
                graphics.setColor(-16777216);
                graphics.fillRect(this._x + GameTemplate.viewX - this.BASE_HEALTHBAR_LENGTH / 2 + 20, this._y + GameTemplate.viewY - GameTemplate.poison.getHeight() / 2 - 2 - this._height + 13 + 2, this.BASE_HEALTHBAR_LENGTH * this._health / this._baseHealth, 1);
            }
        }
        if (this._poisonTime > 0) {
            if (this.isAir()) {
                GameTemplate.poison.setPosition(this._x + GameTemplate.viewX - (GameTemplate.poison.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - this._height - GameTemplate.poison.getHeight());
            } else {
                GameTemplate.poison.setPosition(this._x + GameTemplate.viewX - (GameTemplate.poison.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - this._height - GameTemplate.poison.getHeight() / 2 + 13);
            }
            GameTemplate.poison.setFrame(this._poisonTime / 2 % 3);
            GameTemplate.poison.paint(graphics);
        }
        if (this._slowdownTime > 0) {
            if (this.isAir()) {
                GameTemplate.ice.setPosition(this._x + this._width / 4 + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - GameTemplate.ice.getHeight());
                if (this._type == 5) {
                    GameTemplate.ice.setPosition(GameTemplate.ice.getX(), GameTemplate.ice.getY() + 5);
                }
            } else {
                GameTemplate.ice.setPosition(this._x + this._width / 4 + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - (GameTemplate.ice.getHeight() << 1) / 3 + 13);
            }
            if ((time = 72 - this._slowdownTime) <= 6) {
                GameTemplate.ice.setFrame(time % 11);
            } else if (this._slowdownTime < 4) {
                GameTemplate.ice.setFrame((11 - this._slowdownTime) % 11);
            } else {
                GameTemplate.ice.setFrame(6);
            }
            GameTemplate.ice.paint(graphics);
        }
        if (this._fireTime > 0) {
            if (this.isAir()) {
                GameTemplate.fire.setPosition(this._x + this._width / 4 + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height * 3 / 4);
                if (this._type == 5) {
                    GameTemplate.fire.setPosition(GameTemplate.fire.getX(), GameTemplate.fire.getY() + 5);
                }
            } else {
                GameTemplate.fire.setPosition(this._x + this._width / 4 + GameTemplate.viewX - (this._width >> 1) + 20, this._y + GameTemplate.viewY - this._height / 2 + 13);
            }
            GameTemplate.fire.setFrame(this._fireTime % 6);
            GameTemplate.fire.paint(graphics);
        }
        if (this._dieTime > 0) {
            if (this.isAir()) {
                GameTemplate.fxDeathMoney.setPosition(this._x + GameTemplate.viewX - (GameTemplate.fxDeathMoney.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - GameTemplate.fxDeathMoney.getHeight());
            } else {
                GameTemplate.fxDeathMoney.setPosition(this._x + GameTemplate.viewX - (GameTemplate.fxDeathMoney.getWidth() >> 1) + 20, this._y + GameTemplate.viewY - GameTemplate.fxDeathMoney.getHeight() + 13);
            }
            GameTemplate.fxDeathMoney.setFrame((this._dieTime - 1) % 8);
            GameTemplate.fxDeathMoney.paint(graphics);
        }
    }

    private int nodeDistance(int n) {
        int n2 = 0;
        if (n <= 0) {
            return 0;
        }
        int n3 = GameTemplate.roads.getRoadNodeX(this._road, n);
        n = GameTemplate.roads.getRoadNodeY(this._road, n);
        if (n3 != 0) {
            n2 = 0 + Math.abs(n3 * 28);
        } else if (n != 0) {
            n2 = 0 + Math.abs(n * 26);
        }
        return n2;
    }

    private int calculateDistanceFromRoadEnd() {
        int n = 0 + this.nodeDistance(this._destRoadNode) * (this._finalStep - this._step) / this._finalStep;
        for (int i = this._destRoadNode + 1; i < GameTemplate.roads.getRoadNodeCount(this._road); ++i) {
            n += this.nodeDistance(i);
        }
        return n;
    }

    public final int getReward() {
        switch (this._type) {
            case 0: {
                return 5 + additionalGold;
            }
            case 1: {
                return 3 + additionalGold;
            }
            case 2: {
                return 10 + additionalGold;
            }
            case 3: {
                return 10 + additionalGold;
            }
            case 4: {
                return 5 + additionalGold;
            }
            case 5: {
                return 5 + additionalGold;
            }
            case 7: {
                return 20 + additionalGold;
            }
            case 6: {
                return 10 + additionalGold;
            }
            case 8: {
                return 30 + additionalGold;
            }
        }
        return 0;
    }

    public final boolean think() {
        if (this._poisonTime > 0) {
            --this._poisonTime;
            if (this._poisonTime % 3 == 0) {
                --this._health;
            }
        }
        if (this._poisonDelayTime > 0) {
            --this._poisonDelayTime;
            if (this._poisonDelayTime == 0) {
                int n = this._poisonTimedDmg;
                this._poisonTime = n * 3;
            }
        }
        if (this._fireTime > 0) {
            --this._fireTime;
            if (this._fireTime % 3 == 0) {
                --this._health;
            }
        }
        if (this._fireDelayTime > 0) {
            --this._fireDelayTime;
            if (this._fireDelayTime == 0) {
                this.receiveFire(this._fireTimedDmg);
            }
        }
        if (this._health <= 0 && this._dieTime > 8) {
            return false;
        }
        if (this._slowdownTime > 0) {
            --this._slowdownTime;
        }
        this._distanceFromEnd = this.calculateDistanceFromRoadEnd();
        if (this._hit > 0) {
            if (this._health - this._damage - this._damage2 <= 0) {
                this._distanceFromEnd = 1000000;
            }
            --this._hit;
            if (this._hit == 0) {
                this._health -= this._damage;
                this._damage = 0;
            }
        }
        if (this._hit2 > 0) {
            if (this._health - this._damage - this._damage2 <= 0) {
                this._distanceFromEnd = 1000000;
            }
            --this._hit2;
            if (this._hit2 == 0) {
                this._health -= this._damage2;
                this._damage2 = 0;
            }
        }
        if (this._health <= 0) {
            ++this._dieTime;
            this._distanceFromEnd = 1000000;
        }
        Utils.initInterpolation(this._startX, this._startY, this._destX, this._destY);
        int[] nArray = Utils.nextInterpolatedPosCustomStep(this._step, this._finalStep);
        this._x = nArray[0];
        this._y = nArray[1];
        if (this._step >= this._finalStep) {
            if (this._destRoadNode < GameTemplate.roads.getRoadNodeCount(this._road)) {
                ++this._destRoadNode;
                this.nextWalkNode(this._destRoadNode);
                this._left = GameTemplate.roads.getRoadNodeX(this._road, this._destRoadNode) > 0 || GameTemplate.roads.getRoadNodeY(this._road, this._destRoadNode) < 0;
            } else if (GameTemplate.myCastle._castleHp > 0 && this._health - this._damage - this._damage2 > 0) {
                GameTemplate.myCastle._castleHit = true;
                GameTemplate.myCastle._castleHp = this._type != 8 && this._type != 7 ? --GameTemplate.myCastle._castleHp : (GameTemplate.myCastle._castleHp -= 3);
            }
        }
        if (this._step < this._finalStep) {
            this._step = this._slowdownTime > 0 ? (this._step += this._speed >> 1) : (this._step += this._speed);
            if (this._step > this._finalStep) {
                this._step = this._finalStep;
            }
        }
        return true;
    }

    public final boolean shadowVisible() {
        return this._x + GameTemplate.viewX + (this._width >> 1) + 20 >= 0 && this._y + GameTemplate.viewY + 26 >= 0 && this._x + GameTemplate.viewX - (this._width >> 1) + 20 <= GameLogic.width && this._y + GameTemplate.viewY - this._height + 13 <= GameLogic.height;
    }

    public final boolean isAir() {
        return this._type == 4 || this._type == 5 || this._type == 6;
    }

    public final boolean isUndead() {
        return this._type == 7 || this._type == 5 || this._type == 1;
    }

    public final void addToMarker() {
        if (this.visible()) {
            return;
        }
        this.tmpAdd = this.isAir() ? 0 : 13;
        if (this._y + GameTemplate.viewY + this.tmpAdd < 0) {
            ++GameTemplate.markerTop;
            return;
        }
        if (this._y + GameTemplate.viewY - this._height + this.tmpAdd > GameLogic.height - 8 * GameTemplate.pasekUI.getHeight() / 10) {
            ++GameTemplate.markerBottom;
            return;
        }
        if (this._x + GameTemplate.viewX + (this._width >> 1) + 20 < 0) {
            ++GameTemplate.markerLeft;
            return;
        }
        if (this._x + GameTemplate.viewX - (this._width >> 1) + 20 > GameLogic.width) {
            ++GameTemplate.markerRight;
        }
    }

    public final boolean visible() {
        return this.isAir() ? this._x + GameTemplate.viewX + (this._width >> 1) + 20 >= 0 && this._y + GameTemplate.viewY >= 0 && this._x + GameTemplate.viewX - (this._width >> 1) + 20 <= GameLogic.width && this._y + GameTemplate.viewY - this._height <= GameLogic.height - 8 * GameTemplate.pasekUI.getHeight() / 10 : this._x + GameTemplate.viewX + (this._width >> 1) + 20 >= 0 && this._y + GameTemplate.viewY + 13 >= 0 && this._x + GameTemplate.viewX - (this._width >> 1) + 20 <= GameLogic.width && this._y + GameTemplate.viewY - this._height + 13 <= GameLogic.height - 8 * GameTemplate.pasekUI.getHeight() / 10;
    }

    public final void receiveHit(int damage) {
        this._health -= damage;
        this._hit = 0;
    }

    public final void receiveTimedHitDragon(int damage, int time) {
        this._hit = time;
        this._damage += damage;
    }

    public final void receiveTimedHitCatapult(int damage, int time) {
        this._hit2 = time;
        this._damage2 += damage;
    }

    public final void receiveSlowdown$13462e() {
        if (this._type != 2) {
            this._slowdownTime = 72;
        }
    }

    public final void receivePoison(int damage) {
        this._poisonTime = damage * 3;
    }

    public final void receiveTimedPoison(int n, int n2) {
        if (this._poisonDelayTime > 0) {
            this._poisonTimedDmg += Math.abs(n2 - this._poisonDelayTime) / 3;
            if (n2 < this._poisonDelayTime) {
                this._poisonDelayTime = n2;
                return;
            }
        } else {
            this._poisonDelayTime = n2;
            this._poisonTimedDmg = n;
        }
    }

    public final void receiveFire(int damage) {
        if (this._type != 3) {
            this._fireTime = damage * 3;
        }
    }

    public final void receiveTimedFire(int n, int n2) {
        if (this._fireDelayTime > 0) {
            this._fireTimedDmg += Math.abs(n2 - this._fireDelayTime) / 3;
            if (n2 < this._fireDelayTime) {
                this._fireDelayTime = n2;
                return;
            }
        } else {
            this._fireTimedDmg = n;
            this._fireDelayTime = n2;
        }
    }
}

