/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.shop.ShopManager;
import com.tqm.fantasydefense.shop.secret.AbstractSecretItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public abstract class AbstractShop {
    protected static GameLogic gameLogic;
    private static ShopManager shopManager;
    private int currRackItem = 0;
    private boolean gemsQuestionMode = false;

    public static void setGameLogic(GameLogic gameLogic) {
        AbstractShop.gameLogic = gameLogic;
    }

    public static void setShopManager(ShopManager shopManager) {
        AbstractShop.shopManager = shopManager;
    }

    public final void initSprites() {
        this.loadSprites();
        this.setSpritesPositions();
        this.initOthersShopData();
    }

    public final void draw(Graphics graphics) {
        this.drawShopItems(graphics);
        if (this.gemsQuestionMode) {
            Graphics graphics2 = graphics;
            shopManager.drawItemDesc(graphics2);
        } else {
            this.drawShopItemDesc(graphics);
        }
        this.drawBottomIcons(graphics);
    }

    protected void drawBottomIcons(Graphics g) {
        this.drawEnterAndBackIcons(g);
    }

    protected final void drawEnterAndBackIcons(Graphics g) {
        GameLogic.drawEnterIcon(g);
        if (!this.gemsQuestionMode) {
            GameLogic.drawBackIcon(g);
        }
    }

    protected static void drawShopItemDescWithPrice(Graphics g, AbstractSecretItem item) {
        Graphics graphics = g;
        shopManager.drawItemDesc(graphics);
        AbstractShop.drawShopPriceSprite(g, item.getPrice(), item.isUnlocked());
    }

    public final void keyPressed(int n) {
        switch (n) {
            case 53: 
            case 89: 
            case 91: {
                this.onEnterKeyPressed();
                return;
            }
            case 90: 
            case 95: {
                this.onBackKeyPressed();
                return;
            }
        }
        if (!this.gemsQuestionMode) {
            this.onOthersKeyPressed(n);
        }
    }

    protected final boolean onEnterForBuyKeyPressed(AbstractSecretItem abstractSecretItem) {
        if (this.gemsQuestionMode) {
            this.gemsQuestionMode = false;
            shopManager.goToShopGemsAfterGemsQuestion();
            return false;
        }
        if (!abstractSecretItem.buy(0)) {
            this.gemsQuestionMode = true;
            AbstractShop.setDescTextWithTitle(MainLogic.strings[276], MainLogic.strings[198]);
            return false;
        }
        return true;
    }

    protected final boolean onBackForBuyKeyPressed$255f299(int n) {
        if (this.gemsQuestionMode) {
            return false;
        }
        GameLogic.changeState(17, n, 2, false);
        return true;
    }

    protected final void setSelectionMark(int n, Sprite sprite) {
        if (this.currRackItem == n) {
            sprite.setFrame(1);
            return;
        }
        sprite.setFrame(0);
    }

    protected final int getCurrRackItem() {
        return this.currRackItem;
    }

    protected final void setCurrRackItem(int currRackItem) {
        this.currRackItem = currRackItem;
    }

    protected final void onLeftAndRightKeyPressed(int n, int n2) {
        switch (n) {
            case 54: 
            case 86: {
                if (this.currRackItem >= n2 - 1) break;
                ++this.currRackItem;
                this.setSelectionDesc();
                return;
            }
            case 52: 
            case 88: {
                if (this.currRackItem <= 0) break;
                --this.currRackItem;
                this.setSelectionDesc();
            }
        }
    }

    protected static void drawUnlockState(Graphics g, Sprite sprite, AbstractSecretItem secretItem) {
        AbstractShop.drawUnlockState(g, sprite, secretItem, sprite.getX());
    }

    protected static void drawUnlockState(Graphics graphics, Sprite sprite, AbstractSecretItem abstractSecretItem, int n) {
        if (!abstractSecretItem.isUnlocked()) {
            abstractSecretItem = shopManager.getPadlockSprite();
            abstractSecretItem.setPosition(n + sprite.getWidth() / 2 - abstractSecretItem.getWidth() / 2, shopManager.getRackBottomY() - abstractSecretItem.getHeight() - shopManager.getRackSprite().getHeight() / 10);
            abstractSecretItem.paint(graphics);
        }
    }

    protected static void drawActiveState(Graphics g, Sprite sprite, AbstractSecretItem secretItem) {
        AbstractShop.drawActiveState(g, sprite, secretItem, sprite.getX());
    }

    protected static void drawActiveState(Graphics graphics, Sprite sprite, AbstractSecretItem abstractSecretItem, int n) {
        if (abstractSecretItem.isActive()) {
            abstractSecretItem = shopManager.getActiveSprite();
            abstractSecretItem.setPosition(n + sprite.getWidth() / 2 - abstractSecretItem.getWidth() / 2, shopManager.getRackBottomY() - abstractSecretItem.getHeight() - shopManager.getRackSprite().getHeight() / 10);
            abstractSecretItem.paint(graphics);
        }
    }

    protected static int getRackItemX(Sprite sprite, int n) {
        return sprite.getX() + sprite.getWidth() + n;
    }

    protected static int getRackItemY(Sprite sprite) {
        return shopManager.getRackItemY(sprite);
    }

    protected static int getFirstRackItemX(int n, Sprite[] spriteArray) {
        int n2 = 0;
        for (int i = 0; i < spriteArray.length; ++i) {
            n2 += spriteArray[i].getWidth();
        }
        return (MainLogic.width - (n2 += (spriteArray.length - 1) * n)) / 2;
    }

    protected static void setDescTextWithTitle(String text, String title) {
        shopManager.setDescTextWithTitle(text, title);
    }

    protected static void setFramedPaperDefaultPosition() {
        shopManager.setFramedPaperPosition((MainLogic.width - shopManager.getFramedPaper().getWideFrameWidth()) / 2, shopManager.getRackSprite().getY() + shopManager.getRackSprite().getHeight());
    }

    protected static void setItemDescDefaultSize() {
        shopManager.setItemDescDefaultSize();
    }

    protected static void drawShopPriceSprite(Graphics g, int price, boolean isUnlocked) {
        shopManager.drawShopPriceSprite(g, price, isUnlocked);
    }

    protected static void drawItemDesc(Graphics g) {
        shopManager.drawItemDesc(g);
    }

    protected static FramedPaper getFramedPaper() {
        return shopManager.getFramedPaper();
    }

    protected static Sprite getRackSprite() {
        return shopManager.getRackSprite();
    }

    protected static Sprite getPriceSprite() {
        return shopManager.getPriceSprite();
    }

    protected static void setPriceCrystalPosition(int price) {
        shopManager.setPriceCrystalPosition(price);
    }

    protected static int getTitleStressY() {
        return shopManager.getTitleStressY();
    }

    protected static Container getItemDesc() {
        return shopManager.getItemDesc();
    }

    protected static boolean isGemsShopAfterQuestion() {
        return shopManager.isGemsShopAfterQuestion();
    }

    protected static boolean isGemsShopFromWorldMap() {
        return shopManager.isGemsShopFromWorldMap();
    }

    protected static void goToShopGems() {
        ShopManager.goToShopGems();
    }

    protected static void goToScreenBeforeGemsShop() {
        shopManager.goToScreenBeforeGemsShop();
    }

    protected static void resetShopGemsAfterGemsQuestionSettings() {
        shopManager.resetShopGemsAfterGemsQuestionSettings();
    }

    protected abstract void drawShopItems(Graphics var1);

    protected abstract void drawShopItemDesc(Graphics var1);

    protected abstract void loadSprites();

    protected abstract void setSpritesPositions();

    protected abstract void initOthersShopData();

    protected abstract void onEnterKeyPressed();

    protected abstract void onBackKeyPressed();

    protected abstract void onOthersKeyPressed(int var1);

    protected abstract void setSelectionDesc();
}

