/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.Resources;
import com.tqm.fantasydefense.shop.AbstractShop;
import com.tqm.fantasydefense.shop.secret.SecretCastleDefender;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class ShopCastleDragons
extends AbstractShop {
    private Sprite dragonSprite;
    private Sprite hydraSprite;
    private Sprite wyvernSprite;
    private Image statisticsImage;
    private Sprite statisticsIconSprite;
    private Sprite statisticsLineSprite;
    private Sprite specialitiesSprite;
    private SecretCastleDefender[] dragons;
    private boolean questionMode;
    private int itemDescWidth;
    private int itemDescHeight;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;

    public ShopCastleDragons(SecretCastleDefender[] dragons) {
        this.dragons = dragons;
        this.questionMode = false;
    }

    protected final void loadSprites() {
        this.dragonSprite = GameLogic.loadSprite(13);
        this.hydraSprite = GameLogic.loadSprite(14);
        this.wyvernSprite = GameLogic.loadSprite(21);
        this.statisticsLineSprite = GameLogic.loadSprite(118);
        this.statisticsIconSprite = GameLogic.loadSprite(134);
        this.specialitiesSprite = GameLogic.loadSprite(111);
        try {
            this.statisticsImage = Image.createImage((String)("/com/tqm/fantasydefense/" + Resources.imgNames[116] + ".png"));
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    protected final void setSpritesPositions() {
        int n = -this.wyvernSprite.getWidth() / 3;
        int n2 = ShopCastleDragons.getFirstRackItemX(n, new Sprite[]{this.dragonSprite, this.hydraSprite, this.wyvernSprite});
        this.wyvernSprite.setPosition(n2, ShopCastleDragons.getRackItemY(this.wyvernSprite));
        this.dragonSprite.setPosition(ShopCastleDragons.getRackItemX(this.wyvernSprite, n), ShopCastleDragons.getRackItemY(this.dragonSprite));
        this.hydraSprite.setPosition(ShopCastleDragons.getRackItemX(this.dragonSprite, n), ShopCastleDragons.getRackItemY(this.hydraSprite));
        n = ShopCastleDragons.getFramedPaper().getY() + ShopCastleDragons.getFramedPaper().getLowFrameHeight() - this.statisticsLineSprite.getHeight() * 5 / 2;
        n2 = n + this.statisticsLineSprite.getHeight() / 2 - this.statisticsIconSprite.getHeight() / 2;
        this.statisticsIconSprite.setPosition(ShopCastleDragons.getFramedPaper().getPaperX() + ShopCastleDragons.getFramedPaper().getHorizontalPaperMargin(), n2);
        this.statisticsLineSprite.setPosition(ShopCastleDragons.getFramedPaper().getPaperX() + 2 * ShopCastleDragons.getFramedPaper().getHorizontalPaperMargin() + this.statisticsIconSprite.getWidth(), n);
        n = ShopCastleDragons.getItemDesc().getX() + ShopCastleDragons.getItemDesc().getWidth() - (this.specialitiesSprite.getWidth() << 1);
        this.specialitiesSprite.setPosition(n, ShopCastleDragons.getTitleStressY() - this.specialitiesSprite.getHeight() - 2);
    }

    protected final void initOthersShopData() {
        ShopCastleDragons.setFramedPaperDefaultPosition();
        int filledPaperHeight = ShopCastleDragons.getItemDesc().getY() + ShopCastleDragons.getItemDesc().getHeight() - this.statisticsIconSprite.getY();
        this.itemDescWidth = ShopCastleDragons.getItemDesc().getWidth();
        this.itemDescHeight = ShopCastleDragons.getItemDesc().getHeight() - filledPaperHeight - ShopCastleDragons.getFramedPaper().getVerticalPaperMargin();
        this.setItemDescSize();
        this.setSelectionDesc();
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(13);
        MainLogic.disposeImage(14);
        MainLogic.disposeImage(21);
        MainLogic.disposeImage(118);
        MainLogic.disposeImage(134);
        MainLogic.disposeImage(116);
        MainLogic.disposeImage(39);
        MainLogic.disposeImage(82);
        this.dragonSprite = null;
        this.hydraSprite = null;
        this.wyvernSprite = null;
        this.statisticsLineSprite = null;
        this.statisticsIconSprite = null;
        this.statisticsImage = null;
        this.specialitiesSprite = null;
    }

    protected final void drawShopItems(Graphics g) {
        this.setSelectionMark(0, this.wyvernSprite);
        this.wyvernSprite.paint(g);
        this.setSelectionMark(1, this.dragonSprite);
        this.dragonSprite.paint(g);
        this.setSelectionMark(2, this.hydraSprite);
        this.hydraSprite.paint(g);
        Graphics graphics = g;
        ShopCastleDragons shopCastleDragons = this;
        ShopCastleDragons.drawUnlockState(graphics, shopCastleDragons.wyvernSprite, shopCastleDragons.dragons[0]);
        ShopCastleDragons.drawUnlockState(graphics, shopCastleDragons.dragonSprite, shopCastleDragons.dragons[1]);
        ShopCastleDragons.drawUnlockState(graphics, shopCastleDragons.hydraSprite, shopCastleDragons.dragons[2]);
        graphics = g;
        shopCastleDragons = this;
        ShopCastleDragons.drawActiveState(graphics, shopCastleDragons.wyvernSprite, shopCastleDragons.dragons[0]);
        ShopCastleDragons.drawActiveState(graphics, shopCastleDragons.dragonSprite, shopCastleDragons.dragons[1]);
        ShopCastleDragons.drawActiveState(graphics, shopCastleDragons.hydraSprite, shopCastleDragons.dragons[2]);
    }

    protected final void drawShopItemDesc(Graphics graphics) {
        if (this.questionMode) {
            ShopCastleDragons.drawItemDesc(graphics);
            return;
        }
        ShopCastleDragons.drawShopItemDescWithPrice(graphics, this.dragons[this.getCurrRackItem()]);
        Graphics graphics2 = graphics;
        ShopCastleDragons shopCastleDragons = this;
        shopCastleDragons.statisticsIconSprite.paint(graphics2);
        shopCastleDragons.statisticsLineSprite.paint(graphics2);
        int n = 0;
        switch (shopCastleDragons.getCurrRackItem()) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
            }
        }
        graphics2.drawRegion(shopCastleDragons.statisticsImage, 0, shopCastleDragons.statisticsImage.getHeight() / 2, shopCastleDragons.statisticsImage.getWidth() * n / 5, shopCastleDragons.statisticsImage.getHeight() / 2, 0, shopCastleDragons.statisticsLineSprite.getX() + (shopCastleDragons.statisticsLineSprite.getWidth() - shopCastleDragons.statisticsImage.getWidth()) / 2, shopCastleDragons.statisticsLineSprite.getY() + (shopCastleDragons.statisticsLineSprite.getHeight() - shopCastleDragons.statisticsImage.getHeight() / 2) / 2, 20);
        int n2 = this.dragons[this.getCurrRackItem()].getSpecialSkill();
        if (n2 != -1) {
            this.clipX = graphics.getClipX();
            this.clipY = graphics.getClipY();
            this.clipWidth = graphics.getClipWidth();
            this.clipHeight = graphics.getClipHeight();
            if (ShopCastleDragons.getItemDesc().getTransY() < 0) {
                graphics.setClip(this.specialitiesSprite.getX(), ShopCastleDragons.getItemDesc().getY(), this.specialitiesSprite.getWidth(), ShopCastleDragons.getTitleStressY() - ShopCastleDragons.getFramedPaper().getPaperY());
            }
            this.specialitiesSprite.setPosition(this.specialitiesSprite.getX(), ShopCastleDragons.getTitleStressY() - this.specialitiesSprite.getHeight() - 2 + ShopCastleDragons.getItemDesc().getTransY());
            this.specialitiesSprite.setFrame(n2);
            this.specialitiesSprite.paint(graphics);
            graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
    }

    protected final void onEnterKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setItemDescSize();
            this.setSelectionDesc();
            return;
        }
        if (this.getCurrRackItem() == 0 || this.dragons[this.getCurrRackItem() - 1].isUnlocked()) {
            if (!this.onEnterForBuyKeyPressed(this.dragons[this.getCurrRackItem()])) {
                ShopCastleDragons.setItemDescDefaultSize();
                return;
            }
        } else {
            this.questionMode = true;
            ShopCastleDragons.setItemDescDefaultSize();
            ShopCastleDragons.setDescTextWithTitle(MainLogic.strings[302], MainLogic.strings[198]);
        }
    }

    protected final void onBackKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setItemDescSize();
            this.setSelectionDesc();
            return;
        }
        if (!this.onBackForBuyKeyPressed$255f299(243)) {
            this.setItemDescSize();
        }
    }

    protected final void onOthersKeyPressed(int key) {
        if (!this.questionMode) {
            this.onLeftAndRightKeyPressed(key, 3);
        }
    }

    protected final void setSelectionDesc() {
        switch (this.getCurrRackItem()) {
            case 0: {
                ShopCastleDragons.setDescTextWithTitle(MainLogic.strings[137], MainLogic.strings[134]);
                break;
            }
            case 1: {
                ShopCastleDragons.setDescTextWithTitle(MainLogic.strings[138], MainLogic.strings[135]);
                break;
            }
            case 2: {
                ShopCastleDragons.setDescTextWithTitle(MainLogic.strings[139], MainLogic.strings[136]);
            }
        }
        ShopCastleDragons.setPriceCrystalPosition(this.dragons[this.getCurrRackItem()].getPrice());
    }

    private void setItemDescSize() {
        ShopCastleDragons.getItemDesc().setSize(this.itemDescWidth, this.itemDescHeight);
    }
}

