/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop.secret;

import com.tqm.fantasydefense.shop.secret.AbstractSecretItem;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import com.tqm.wrapper.WrapperController;

public final class SecretElixir
extends AbstractSecretItem {
    private SecretElixir exclusiveElixir;
    private int power;
    private int elixirType;
    private int[] elixirEffects;

    public SecretElixir(int price, int elixirType, int elixirEffect, int power, int statsItemId) {
        super(price, statsItemId);
        this.construct(elixirType, power);
        this.elixirEffects = new int[]{elixirEffect};
    }

    public SecretElixir(int price, int elixirType, int[] elixirEffects, int power, int statsItemId) {
        super(price, statsItemId);
        this.construct(elixirType, power);
        this.elixirEffects = elixirEffects;
    }

    private void construct(int elixirType, int power) {
        this.elixirType = elixirType;
        this.power = power;
    }

    public final void setExclusiveElixir(SecretElixir exclusiveElixir) {
        this.exclusiveElixir = exclusiveElixir;
    }

    protected final int getRMSId() {
        switch (this.elixirType) {
            case 1: {
                return 32;
            }
            case 3: {
                return 34;
            }
            case 5: {
                return 36;
            }
            case 7: {
                return 38;
            }
            case 0: {
                return 31;
            }
            case 2: {
                return 33;
            }
            case 4: {
                return 35;
            }
            case 6: {
                return 37;
            }
            case 8: {
                return 39;
            }
            case 9: {
                return 40;
            }
            case 10: {
                return 41;
            }
            case 11: {
                return 42;
            }
        }
        return -1;
    }

    public final int getPower() {
        return this.power;
    }

    public final int[] getElixirEffects() {
        return this.elixirEffects;
    }

    public final SecretElixir getExclusiveElixir() {
        return this.exclusiveElixir;
    }

    public final void lockAndDeactivate() {
        this.setActive(false);
        this.setUnlocked(false);
    }

    public final void grantElixirAsReward() {
        this.unlockAndActivate();
        this.saveUnlockWithActivateToRMS();
        if (this.exclusiveElixir != null) {
            this.exclusiveElixir.setActive(false);
            this.exclusiveElixir.setUnlocked(false);
            this.exclusiveElixir.saveUnlockWithActivateToRMS();
        }
    }

    public final boolean buy(int n) {
        if (this.isUnlocked()) {
            return true;
        }
        if (this.isEnoughGems()) {
            this.reduceGems();
            this.buyWithUnlockAndActivate(n);
            if (this.exclusiveElixir != null) {
                this.exclusiveElixir.setActive(false);
                this.exclusiveElixir.setUnlocked(false);
                this.exclusiveElixir.saveUnlockWithActivateToRMS();
            }
            SecretItemsManager.getInstance().updateElixirPrices();
            return true;
        }
        WrapperController.logNotEnoughTokens();
        return false;
    }
}

