/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.wrapper;

import com.tqm.wrapper.Country;
import com.tqm.wrapper.PaymentLevel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class Operator {
    String name;
    String id;
    Country country;
    private Vector _smsc;
    private Hashtable _paymentLevels;
    private Vector _mnc;

    Operator(String string, String string2, String string3) {
        this.name = string;
        this.id = string2;
        this._smsc = new Vector();
        this._paymentLevels = new Hashtable();
        this._mnc = new Vector();
        if (string3 != null && string3.length() > 0) {
            int n = string3.indexOf(",");
            while (n >= 0) {
                this._mnc.addElement(string3.substring(0, n));
                string3 = string3.substring(n + 1, string3.length());
                n = string3.indexOf(",");
            }
            this._mnc.addElement(string3);
        }
    }

    final void addSmsc(String smsc) {
        this._smsc.addElement(smsc);
    }

    final Enumeration getSmsc() {
        return this._smsc.elements();
    }

    final void addPaymentLevel(PaymentLevel paymentLevel) {
        this._paymentLevels.put(paymentLevel.id, paymentLevel);
    }

    final PaymentLevel getPaymentLevelById(String id) {
        return (PaymentLevel)this._paymentLevels.get(id);
    }

    final PaymentLevel getScorePaymentLevel() {
        Enumeration e = this._paymentLevels.elements();
        while (e.hasMoreElements()) {
            PaymentLevel pl = (PaymentLevel)e.nextElement();
            if (pl.paymentLevelType != 0) continue;
            return pl;
        }
        return null;
    }

    final Enumeration getMnc() {
        return this._mnc.elements();
    }

    final boolean containsMnc(String mnc) {
        return this._mnc.contains(mnc);
    }

    final String toXml() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<o id=\"").append(this.id).append("\" n=\"").append(this.name).append("\" mn=\"");
        Enumeration<Object> enumeration = this._mnc.elements();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement()).append(",");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("\">");
        enumeration = this._smsc.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<sm>").append((String)enumeration.nextElement()).append("</sm>");
        }
        enumeration = this._paymentLevels.elements();
        while (enumeration.hasMoreElements()) {
            PaymentLevel paymentLevel = (PaymentLevel)enumeration.nextElement();
            stringBuffer.append("<" + (paymentLevel.paymentLevelType == 0 ? "s" : "l") + " ").append("id=\"").append(paymentLevel.id).append("\" k=\"").append(paymentLevel.keyword).append("\" sc=\"").append(paymentLevel.shortcode).append("\" pr=\"").append(paymentLevel.price).append("\" bt=\"").append(paymentLevel.billingType).append("\"/>");
        }
        stringBuffer.append("</o>");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        object = (Operator)object;
        return ((Operator)object).name.equals(this.name) && ((Operator)object).id.equals(this.id);
    }

    public final String toString() {
        return this.name;
    }
}

