/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

public class Vector2D {
    public static float TO_RADIANS = 0.017453294f;
    public static float TO_DEGREES = 57.295776f;
    public double x;
    public double y;

    public Vector2D() {
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Vector2D other) {
        this.x = other.x;
        this.y = other.y;
    }

    public Vector2D cpy() {
        return new Vector2D(this.x, this.y);
    }

    public Vector2D set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2D set(Vector2D other) {
        this.x = other.x;
        this.y = other.y;
        return this;
    }

    public Vector2D add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2D add(Vector2D other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Vector2D sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2D sub(Vector2D other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Vector2D mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D nor() {
        double len = this.len();
        if (len != 0.0) {
            this.x /= len;
            this.y /= len;
        }
        return this;
    }

    public double angle() {
        double angle = this.y / this.x * (double)TO_DEGREES;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public Vector2D rotate(float angle) {
        float rad = angle * TO_RADIANS;
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double newX = this.x * cos - this.y * sin;
        double newY = this.x * sin + this.y * cos;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public double dist(Vector2D other) {
        double distX = this.x - other.x;
        double distY = this.y - other.y;
        return Math.sqrt(distX * distX + distY * distY);
    }

    public double dist(double x, double y) {
        double distX = this.x - x;
        double distY = this.y - y;
        return Math.sqrt(distX * distX + distY * distY);
    }
}

