/*
 * Decompiled with CFR 0.152.
 */
package com.am.ashamidlet;

import com.am.asha_inapp.PaymentStat;
import com.am.asha_statistic.JSONException;
import com.am.asha_statistic.JSONObject;
import com.am.ashamidlet.Settings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Stat
implements PaymentStat {
    private static final int INTERVAL = 10;
    private static String URL_STAT;
    private static String URL_PAYMENT;
    private static final String URL_STAT_DEF = "http://mainprocess.net/usgn";
    private static final String URL_PAYMENT_DEF = "http://mainprocess.net/nnpp";
    private RecordStore statStore = null;
    private String repositoryName = "stat_repo";
    private String APP_ID = "test";
    private String UNIC_ID;
    private String SESSION_ID;
    private int timeOn;
    private JSONObject appInfo;
    private JSONObject deviceInfo;
    private JSONObject geoInfo;
    private final Timer tm = new Timer();
    private TimerTask tt;

    public Stat() {
        this.APP_ID = Settings.get("APP_ID");
        this.UNIC_ID = this.getUnicId();
        this.SESSION_ID = this.getHash();
        URL_STAT = Settings.get("URL_STAT");
        if (URL_STAT.equals("null")) {
            System.err.println("WARNING!!! URL_STAT for statistics not loaded from settings! Set default");
            URL_STAT = URL_STAT_DEF;
        }
        if ((URL_PAYMENT = Settings.get("URL_PAYMENT")).equals("null")) {
            System.err.println("WARNING!!! URL_PAYMENT for statistics not loaded from settings! Set default");
            URL_PAYMENT = URL_PAYMENT_DEF;
        }
        try {
            this.appInfo = Stat.createAppInfo();
            this.deviceInfo = Stat.createDeviceInfo(this.UNIC_ID);
            this.geoInfo = Stat.createGeoInfo();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.tt = new TimerTask(){

            public void run() {
                Stat stat = Stat.this;
                stat.timeOn = stat.timeOn + 10;
                Stat.this.sendStat();
            }
        };
        this.tm.scheduleAtFixedRate(this.tt, 0L, 10000L);
    }

    public void sendStat() {
        JSONObject stat = new JSONObject();
        try {
            stat.put("app_id", this.APP_ID);
            stat.put("time_on", this.timeOn);
            stat.put("session_id", this.SESSION_ID);
            stat.put("app_info", this.appInfo);
            stat.put("device_info", this.deviceInfo);
            stat.put("geo_info", this.geoInfo);
            Stat.sendToServer(stat.toString(), URL_STAT);
        }
        catch (JSONException ex) {
            ex.getMessage();
        }
    }

    private String getUnicId() {
        String unicId = "null";
        try {
            this.statStore = RecordStore.openRecordStore((String)this.repositoryName, (boolean)true);
            if (this.statStore.getNumRecords() == 0) {
                unicId = this.getHash();
                this.saveUnicId(unicId);
                return unicId;
            }
            byte[] dataStore = this.statStore.getRecord(1);
            unicId = new String(dataStore);
            return unicId;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            unicId = this.getHash();
            e.printStackTrace();
            return unicId;
        }
    }

    private String getHash() {
        long time = System.currentTimeMillis();
        StringBuffer id = new StringBuffer(Long.toString(time, 16).toUpperCase());
        id.append(Integer.toHexString(new Object().hashCode()).toUpperCase());
        return id.toString();
    }

    private void saveUnicId(String unicId) {
        try {
            this.statStore = RecordStore.openRecordStore((String)this.repositoryName, (boolean)true);
            if (!this.isRecordExist(unicId)) {
                byte[] record = unicId.getBytes();
                this.statStore.addRecord(record, 0, record.length);
            }
            this.statStore.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private boolean isRecordExist(String productName) {
        boolean recordExist;
        block3: {
            recordExist = false;
            try {
                if (this.statStore == null) break block3;
                RecordEnumeration paymentEnum = this.statStore.enumerateRecords(null, null, false);
                while (paymentEnum.hasNextElement()) {
                    String element = new String(paymentEnum.nextRecord());
                    if (!element.equals(productName)) continue;
                    recordExist = true;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recordExist;
    }

    private static JSONObject createAppInfo() throws JSONException {
        JSONObject appInfo = new JSONObject();
        appInfo.put("package", "");
        appInfo.put("app_name", "");
        appInfo.put("used_traff", "");
        return appInfo;
    }

    private static JSONObject createDeviceInfo(String unicId) throws JSONException {
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("uniq_id", unicId);
        return deviceInfo;
    }

    private static JSONObject createGeoInfo() throws JSONException {
        JSONObject geoInfo = new JSONObject();
        geoInfo.put("admin_area", "");
        return geoInfo;
    }

    private static synchronized void sendToServer(String jsonStr, String url) {
        block20: {
            HttpConnection connection = null;
            OutputStream outputStream = null;
            try {
                try {
                    connection = (HttpConnection)Connector.open((String)url);
                    connection.setRequestMethod("POST");
                    outputStream = connection.openOutputStream();
                    outputStream.write(jsonStr.getBytes());
                    int status = connection.getResponseCode();
                    System.out.println("status=" + status);
                }
                catch (Exception e) {
                    System.out.println("Ex");
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception error) {
                            error.printStackTrace();
                        }
                    }
                    if (outputStream == null) break block20;
                    try {
                        outputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void sendPaymentStat(String cost, String currency) {
        JSONObject inAppState = new JSONObject();
        JSONObject inAppInfo = new JSONObject();
        try {
            inAppInfo.put("appid", this.APP_ID);
            inAppInfo.put("cost", cost);
            inAppInfo.put("currency", currency);
            inAppState.put("inAppInfo", inAppInfo);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Stat.sendToServer(inAppState.toString(), URL_PAYMENT);
    }
}

