/*
 * Decompiled with CFR 0.152.
 */
package com.am.blockapplib.utils;

import com.am.blockapplib.utils.BalTime;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class BalSettings {
    public static final String MICROEDITION_PLATFORM = "microedition.platform";
    private static Hashtable text = new Hashtable();
    public static final String SEPARATOR = "|";
    private static boolean initialized = false;
    public static final String PATH_TO_BLOCKER_SETTINGS = "/settings.txt";

    public static void initTextRes() throws IOException {
        new BalSettings().readFile(PATH_TO_BLOCKER_SETTINGS);
    }

    private static void silentInitTextRes() {
        try {
            BalSettings.initTextRes();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Wrong encoding in /settings.txt");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Error reading file /settings.txt");
            e.printStackTrace();
        }
    }

    public static String getString(String key) {
        if (!initialized) {
            BalSettings.silentInitTextRes();
        }
        String result = null;
        Object value = text.get(key);
        result = value != null ? (String)value : " ";
        return result;
    }

    public static Font getFont(String key) {
        String fontName = BalSettings.getString(key);
        if (fontName.equals("SMALL")) {
            return Font.getFont((int)64, (int)2, (int)8);
        }
        if (fontName.equals("LARGE")) {
            return Font.getFont((int)64, (int)2, (int)16);
        }
        return Font.getFont((int)64, (int)2, (int)0);
    }

    public static String getLocalizedString(String key) {
        String locale = System.getProperty("microedition.locale");
        if (locale.length() > 2) {
            locale = locale.substring(0, 2);
        }
        locale = locale.toUpperCase();
        String localizedKey = String.valueOf(key) + "_" + locale;
        String localizedValue = BalSettings.getString(localizedKey);
        if (localizedValue.equals(" ")) {
            System.out.println("[Settings] Warning: Can not find localized (locale = " + locale + ") for key = " + localizedKey);
            localizedValue = BalSettings.getString(key);
        }
        return localizedValue;
    }

    private void readFile(String filename) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), "UTF-8");
        String line = null;
        while ((line = this.readLine(reader)) != null) {
            String[] result;
            if (line.length() == 0 || (result = this.split(line, SEPARATOR))[0].substring(0, 2).equals("//")) continue;
            text.put(result[0], result[1]);
        }
        ((Reader)reader).close();
    }

    public static BalTime getTime(String key) {
        String timeString = BalSettings.getString(key);
        System.out.println("time = " + timeString);
        return new BalTime(timeString);
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(new String(original.substring(0, index)));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            int loop = 0;
            while (loop < nodes.size()) {
                result[loop] = (String)nodes.elementAt(loop);
                ++loop;
            }
        }
        return result;
    }

    public static int getInt(String key) {
        return BalSettings.getInt(key, 10);
    }

    public static int getInt(String key, int radix) {
        int val = 0;
        try {
            val = Integer.parseInt(BalSettings.getString(key), radix);
        }
        catch (NumberFormatException e) {
            System.out.println("[Settings] ERROR: Using getInt for key " + key + ". Value for this key is not int! (Value = " + BalSettings.getString(key) + ", radix = " + radix + ")");
        }
        return val;
    }
}

