/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GCanvas
implements GameConstants,
Constants,
ConstantsTFC,
ConstantsReanim {
    static int ANGLE_MO = 210808;
    static int ANGLE_DE = 1000000;
    static int PLANT_ANGLE_X = 24;
    static int MOWERS_ANGLE_X = 15;
    static int PROJECTILES_ANGLE_X = 24;
    static int PLANT_X = 0;
    static int PLANT_FRAME_X = 10;
    static int ATTACK_ZOMBIE_X = -46;
    static int GRID_ITEM_X = 52;
    static int[] NORMAL_REMOVEY = new int[]{-25, -35, -48, -53, -61};
    static int[] ZOMBIES_REMOVEY = new int[]{-30, -40, -47, -55, -65};
    static final int ANGLE_MO_320 = 210808;
    static final int ANGLE_DE_320 = 1000000;
    static final int PLANT_ANGLE_X_320 = 4;
    static final int MOWERS_ANGLE_X_320 = -3;
    static final int PROJECTILES_ANGLE_X_320 = 14;
    static final int PLANT_X_320 = 12000;
    static final int PLANT_FRAME_X_320 = 10;
    static final int ATTACK_ZOMBIE_X_320 = -26;
    static final int GRID_ITEM_X_320 = 25;
    static final int[] NORMAL_REMOVEY_320 = new int[]{-20, -20, -23, -22, -22};
    static final int[] ZOMBIES_REMOVEY_320 = new int[]{-20, -20, -23, -22, -22};
    static boolean m_bGCanvasInit = false;
    static Graphics m_Graphics;
    static StringBuffer m_sDisplayStr;
    static Image[] m_imgWhiteAlpha;

    static void init() {
        m_bGCanvasInit = true;
        GCanvas.createWhiteAlphaImgs(Graphic.m_nWidth / 10, Graphic.m_nHeight / 10, m_imgWhiteAlpha);
        ANGLE_MO = 210808;
        ANGLE_DE = 1000000;
        PLANT_ANGLE_X = 4;
        MOWERS_ANGLE_X = -3;
        PROJECTILES_ANGLE_X = 14;
        PLANT_X = 12000;
        PLANT_FRAME_X = 10;
        ATTACK_ZOMBIE_X = -26;
        GRID_ITEM_X = 25;
        NORMAL_REMOVEY = NORMAL_REMOVEY_320;
        ZOMBIES_REMOVEY = ZOMBIES_REMOVEY_320;
    }

    static int getAttackX() {
        return 0;
    }

    static int getGridItemX() {
        if (GameController.m_nLevel >= 40) {
            return GRID_ITEM_X;
        }
        return 0;
    }

    static int getShovelX() {
        if (GameController.m_nLevel >= 40) {
            return PLANT_ANGLE_X;
        }
        return 0;
    }

    static int getShovelY(int n, int n2) {
        int n3 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n2 < 0 || n2 > 4) {
                n2 = 0;
            }
            n3 = NORMAL_REMOVEY[n2] + GFCanvas.getImageHeight(230);
        }
        int n4 = 0;
        int n5 = 0;
        return n3 + n4 + n5;
    }

    static int getZombiesX() {
        return 0;
    }

    static int getZombiesY(int n, int n2) {
        int n3 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n2 < 0 || n2 > 4) {
                n2 = 0;
            }
            n3 = ZOMBIES_REMOVEY[n2];
        }
        int n4 = 0;
        int n5 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n < 165) {
                n4 = (165 - n) * ANGLE_MO / ANGLE_DE;
            } else if (n > 290) {
                n5 = (n - 290) * ANGLE_MO / ANGLE_DE;
            }
        }
        return n3 + n4 + n5;
    }

    static int getEveryPlantX(int n) {
        return 0;
    }

    static int getPlantX() {
        return 0;
    }

    static int getPlantY(int n, int n2) {
        int n3 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n2 < 0 || n2 > 4) {
                n2 = 0;
            }
            n3 = NORMAL_REMOVEY[n2];
        }
        int n4 = 0;
        int n5 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n < 165) {
                n4 = (165 - n) * ANGLE_MO / ANGLE_DE;
            } else if (n > 290) {
                n5 = (n - 290) * ANGLE_MO / ANGLE_DE;
            }
        }
        return n3 + n4 + n5;
    }

    static int getProjectilesX() {
        if (GameController.m_nLevel >= 40) {
            return PROJECTILES_ANGLE_X;
        }
        return 0;
    }

    static int getProjectilesY(int n, int n2) {
        int n3 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n2 < 0 || n2 > 4) {
                n2 = 0;
            }
            n3 = NORMAL_REMOVEY[n2];
        }
        int n4 = 0;
        int n5 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n < 165) {
                n4 = (165 - n) * ANGLE_MO / ANGLE_DE;
            } else if (n > 290) {
                n5 = (n - 290) * ANGLE_MO / ANGLE_DE;
            }
        }
        return n3 + n4 + n5;
    }

    static int getMowersX() {
        if (GameController.m_nLevel >= 40) {
            return MOWERS_ANGLE_X;
        }
        return 0;
    }

    static int getMowersY(int n, int n2) {
        int n3 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n2 < 0 || n2 > 4) {
                n2 = 0;
            }
            n3 = NORMAL_REMOVEY[n2];
        }
        int n4 = 0;
        int n5 = 0;
        if (GameController.m_nLevel >= 40) {
            if (n < 165) {
                n4 = (165 - n) * ANGLE_MO / ANGLE_DE;
            } else if (n > 290) {
                n5 = (n - 290) * ANGLE_MO / ANGLE_DE;
            }
        }
        return n3 + n4 + n5;
    }

    static void resetVars() {
    }

    static void onImagesReload() {
    }

    static void createWhiteAlphaImgs(int n, int n2, Image[] imageArray) {
        int[] nArray = new int[n * n2];
        int n3 = imageArray.length;
        int n4 = FP.toIntRound(FP.fpDiv(409600, n3 * 4096));
        for (int i = 0; i < n3; ++i) {
            int n5 = (i + 1) * n4 * 255 / 100;
            int n6 = Math.min(n5, 255) << 24;
            for (int j = 0; j < n * n2; ++j) {
                nArray[j] = n6 | 0xFFFFFF;
            }
            GCanvas.m_imgWhiteAlpha[i] = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
        }
    }

    static void drawGame(Graphics graphics) {
        int n = GCanvasController.m_nShakeCurrX + -ViewPort.m_nViewX;
        int n2 = GCanvasController.m_nShakeCurrY + -ViewPort.m_nViewY;
        int n3 = GModel.getDrawAreaOffsetX();
        int n4 = GModel.getDrawAreaOffsetY();
        GCanvas.drawBackgroundLayer(graphics, n3 + n, n4 + n2);
        GCanvas.drawLaneLayer(graphics, n, n2);
        GCanvas.drawGameLayer(graphics, n, n2, n3, n4);
        GCanvas.drawHUDLayer(graphics, 0, 0);
        GCanvas.drawCursorLayer(graphics, n, n2);
        Hints.drawHint(graphics, 0, 0);
        AwardScreen.drawAwardWhiteFade(graphics);
        if (GFUIState.m_nUIState == -1 && AwardScreen.m_nAwardFadingState == -1) {
            GCanvas.drawSoftkeys(graphics);
        }
        ReanimView.drawDebugInfo(graphics, 8);
        ReanimView.drawDebugImgs(graphics);
    }

    static void drawSoftkeys(Graphics graphics) {
        if (TouchController.m_bHighlightedSoftkeyRight) {
            HandlerButton.draw(graphics, GFMain.m_RightHighlightedGameSoftkeyButton);
        } else {
            HandlerButton.draw(graphics, GFMain.m_RightGameSoftkeyButton);
        }
        if (TouchController.m_bHighlightedSoftkeyLeft) {
            HandlerButton.draw(graphics, GFMain.m_LeftHighlightedGameSoftkeyButton);
        } else {
            HandlerButton.draw(graphics, GFMain.m_LeftGameSoftkeyButton);
        }
        if (GFHint.m_nCurrentHint == 10) {
            if (GFMain.m_LeftGameSoftkeyButton[3] == 1000) {
                int n;
                int n2;
                if (TouchController.m_bHighlightedSoftkeyLeft) {
                    int n3 = GFMain.m_LeftHighlightedGameSoftkeyButton[2];
                    n2 = GFMain.m_LeftHighlightedGameSoftkeyButton[0] + GFCanvas.getImageWidth(n3) / 2;
                    n = GFMain.m_LeftHighlightedGameSoftkeyButton[1] - GFCanvas.getImageHeight(n3);
                } else {
                    int n4 = GFMain.m_LeftGameSoftkeyButton[2];
                    n2 = GFMain.m_LeftGameSoftkeyButton[0] + GFCanvas.getImageWidth(n4) / 2;
                    n = GFMain.m_LeftGameSoftkeyButton[1] - GFCanvas.getImageHeight(n4);
                }
                Hints.drawHintArrow(graphics, n2, n, 33, false);
            } else if (GFMain.m_RightGameSoftkeyButton[3] == 1000) {
                int n;
                int n5;
                if (TouchController.m_bHighlightedSoftkeyRight) {
                    int n6 = GFMain.m_RightHighlightedGameSoftkeyButton[2];
                    n5 = GFMain.m_RightHighlightedGameSoftkeyButton[0] + GFCanvas.getImageWidth(n6) / 2;
                    n = GFMain.m_RightHighlightedGameSoftkeyButton[1] - GFCanvas.getImageHeight(n6);
                } else {
                    int n7 = GFMain.m_RightGameSoftkeyButton[2];
                    n5 = GFMain.m_RightGameSoftkeyButton[0] + GFCanvas.getImageWidth(n7) / 2;
                    n = GFMain.m_RightGameSoftkeyButton[1] - GFCanvas.getImageHeight(n7);
                }
                Hints.drawHintArrow(graphics, n5, n, 33, false);
            }
        }
    }

    static void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, Graphic.m_nDeviceWidth, Graphic.m_nDeviceHeight);
        graphics.setColor(n);
        graphics.fillRect(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static void drawBackgroundLayer(Graphics graphics, int n, int n2) {
        GFCanvas.setClipFullScreen(graphics, 2);
        graphics.setColor(15);
        GFCanvas.fillRect(graphics, 0, 0, Layer.getLayerProperty(2, 3), Layer.getLayerProperty(2, 4), 2);
        GFCanvas.drawImage(graphics, GModel.m_nBackgroundImgID, n, n2, 20, 2);
    }

    static void drawLaneLayer(Graphics graphics, int n, int n2) {
        GFCanvas.setClipFullScreen(graphics, 2);
        int n3 = 0;
        if (GModel.m_lBoardGridAsDirt > 0L) {
            if (GameController.m_nGameState == 5) {
                n3 = GameController.m_nLevel == 0 ? 1 : 3;
                GCanvas.drawLanes(graphics, n, n2, true, n3);
                SodRoll.drawSodRolls(graphics);
            } else if (GModel.m_bLevelUp) {
                n3 = GameController.m_nLevel == 1 ? 1 : 3;
                GCanvas.drawLanes(graphics, n, n2, false, n3);
            } else if (GameController.m_nGameState == 0 || GameController.m_nGameState == 1 || GameController.m_nGameState == 4) {
                n3 = GameController.m_nLevel == 0 ? 1 : 3;
                GCanvas.drawLanes(graphics, n, n2, false, n3);
            } else if ((GameController.m_nGameState == 2 || GameController.m_nGameState == 3) && GameController.m_nLevel != 0) {
                n3 = GameController.m_nLevel == 1 ? 1 : 3;
                GCanvas.drawLanes(graphics, n, n2, false, n3);
            }
        }
    }

    static void drawLanes(Graphics graphics, int n, int n2, boolean bl, int n3) {
        if (GameController.m_nGameMode != 0) {
            return;
        }
        if (!bl) {
            GFCanvas.setClipFullScreen(graphics, 2);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n3 == 1) {
            boolean bl2;
            Cursor.getGridRowPos(2, 0);
            n4 = n + Cursor.GRID_POS[Cursor.GRID_POS_X] + -6;
            n5 = n2 + Cursor.GRID_POS[Cursor.GRID_POS_Y] + 4;
            if (bl) {
                n6 = FP.toInt(SodRoll.getSodFPX(0)) - Cursor.GRID_POS[Cursor.GRID_POS_X];
                n7 = GFCanvas.getImageHeight(226);
                GFCanvas.setClip(graphics, n4, n5, n6, n7, 2);
            }
            GFCanvas.drawImage(graphics, 226, n4, n5, 20, 2);
            boolean bl3 = bl2 = GFHint.m_nCurrentHint == 2 || SeedBank.m_nSelectedSeedTypeToPlant == 3 && (GFHint.m_nCurrentHint == 4 || GFHint.m_nCurrentHint == 5);
            if (bl2) {
                Hints.drawHintFade(graphics, n4, n5, GFCanvas.getImageWidth(226), GFCanvas.getImageHeight(226));
            }
        } else if (n3 == 3) {
            if (!bl) {
                Cursor.getGridRowPos(1, 0);
                n4 = n + Cursor.GRID_POS[Cursor.GRID_POS_X] + -7;
                n5 = n2 + Cursor.GRID_POS[Cursor.GRID_POS_Y] + 4;
                GFCanvas.drawImage(graphics, 223, n4, n5, 20, 2);
            } else {
                GFCanvas.setClipFullScreen(graphics, 2);
                Cursor.getGridRowPos(2, 0);
                n4 = n + Cursor.GRID_POS[Cursor.GRID_POS_X] + -6;
                n5 = n2 + Cursor.GRID_POS[Cursor.GRID_POS_Y] + 4;
                GFCanvas.drawImage(graphics, 226, n4, n5, 20, 2);
                Cursor.getGridRowPos(1, 0);
                n4 = n + Cursor.GRID_POS[Cursor.GRID_POS_X] + -7;
                n5 = n2 + Cursor.GRID_POS[Cursor.GRID_POS_Y] + 4;
                n6 = FP.toInt(SodRoll.getSodFPX(0)) - Cursor.GRID_POS[Cursor.GRID_POS_X];
                n7 = GFCanvas.getImageHeight(223);
                GFCanvas.setClip(graphics, n4, n5, n6, n7, 2);
                GFCanvas.drawImage(graphics, 223, n4, n5, 20, 2);
            }
        }
    }

    static void drawGameLayer(Graphics graphics, int n, int n2, int n3, int n4) {
        GFParticleEngine.drawParticles(graphics, -1, n, n2);
        Hints.drawShovelAlphaHintPlants(graphics, n, n2);
        for (int i = 0; i < GModel.m_nGameBoardRows; ++i) {
            GCanvas.drawGridItems(graphics, n, n2, i, 0);
            GCanvas.drawMowers(graphics, n, n2, i);
            GCanvas.drawPlants(graphics, n, n2, i);
            GCanvas.drawGridItems(graphics, n, n2, i, 1);
            GCanvas.drawZombies(graphics, n, n2, i);
            GCanvas.drawProjectiles(graphics, n, n2, i);
            GFParticleEngine.drawParticles(graphics, i, n, n2);
        }
        GFParticleEngine.drawParticles(graphics, 6, n, n2);
        HUDView.drawSunCounter(graphics);
        GCanvas.drawCoins(graphics, n, n2);
        GFBoardTexts.drawTexts(graphics);
        GCanvas.drawZombieMarkers(graphics, GCanvasController.m_nShakeCurrX, GCanvasController.m_nShakeCurrY);
        GCanvas.drawGameOverText(graphics);
        GCanvas.drawWhiteScreenFade(graphics, GCanvasController.m_nScreenFadeImgIndex);
    }

    static void drawCursorLayer(Graphics graphics, int n, int n2) {
        if (GameController.m_nGameState != 0) {
            return;
        }
        TouchGameController.drawPlantableSeed(graphics, n, n2);
        if (Cursor.m_nCursorType == 3 && Plants.getPlantIndexAtPos(Cursor.m_nCursorPos) != -1) {
            TouchGameController.drawPlantableSeedAlpha(graphics, n, n2);
        }
        if (Cursor.m_nCursorPos != -1 && (Cursor.m_nCursorType == 1 || Cursor.m_nCursorType == 3)) {
            GCanvas.drawCursor(graphics, n, n2);
        }
    }

    static void drawHUDLayer(Graphics graphics, int n, int n2) {
        if (GameController.m_nGameState != 0) {
            return;
        }
        HUDView.drawHUD(graphics, n, n2);
        Conveyor.draw(graphics, n, n2);
    }

    static void drawCursor(Graphics graphics, int n, int n2) {
        int n3;
        GFCanvas.setClipFullScreen(graphics, 2);
        int n4 = 0xFFFF00;
        int n5 = GraphicsUtil.getPingPongDrawFrame(5, Cursor.m_nCursorFrame);
        if (Cursor.m_nCursorType == 3) {
            if (Plants.getPlantIndexAtPos(Cursor.m_nCursorPos) == -1) {
                n4 = 0xFF2F2F;
            }
        } else if (!(Cursor.bSeedAtCursorPlantable(Cursor.m_nCursorPos, SeedBank.m_nSelectedSeedTypeToPlant, Cursor.m_nCursorType) || Cursor.m_nCursorType == 2 || Cursor.m_nCursorType == 0 && SeedBank.m_nSelectedSeedTypeToPlant < 0)) {
            n4 = 0xFF2F2F;
        }
        Cursor.getGridPosRect(Cursor.m_nCursorPos, Cursor.m_nCursorType);
        int n6 = Cursor.GRID_POS[Cursor.GRID_POS_X];
        int n7 = Cursor.GRID_POS[Cursor.GRID_POS_Y];
        int n8 = Cursor.GRID_POS[Cursor.GRID_POS_W];
        int n9 = Cursor.GRID_POS[Cursor.GRID_POS_H];
        if (Cursor.m_nCursorType == 1 && !GModel.m_bConveyorLevel) {
            n3 = 7;
            n7 = n7 - 30 + Cursor.m_nCursorPos * n3;
        }
        if (Cursor.CURSOR_MOVE[Cursor.CURSOR_STATE] != 0) {
            n6 = FP.toInt(Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_X]);
            n7 = FP.toInt(Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_Y]);
        }
        if (Cursor.m_nCursorType == 0 || Cursor.m_nCursorType == 3) {
            n6 += n;
            n7 += n2;
        }
        if (Cursor.m_nCursorType == 1) {
            // empty if block
        }
        if (n6 > PLANT_FRAME_X) {
            n7 += GCanvas.getPlantY(n6, Cursor.m_nCursorPos / 9);
        }
        n6 = n6 + GCanvas.getEveryPlantX(n6) + GCanvas.getPlantX();
        if (Cursor.m_nCursorType == 0) {
            ++n6;
            n7 += 6;
            if (SeedBank.m_nSelectedSeedTypeToPlant >= 0) {
                GCanvas.drawPlantableSeed(graphics, SeedBank.m_nSelectedSeedTypeToPlant, n6, n7, n8, n9);
            }
            if (n4 == 0xFF2F2F) {
                GCanvas.drawCursorComplete(graphics, n6, n7, n8, n9, "\u0127", n5);
            } else {
                GCanvas.drawCursorComplete(graphics, n6, n7, n8, n9, "\u0017", n5);
            }
        } else if (Cursor.m_nCursorType == 3) {
            GCanvas.drawCursorShovel(graphics, n6, n7, n8, n9);
        } else if (Cursor.m_nCursorType == 1) {
            n3 = HUDModel.HUD_COMPONENT_SEEDS * HUDModel.HUD_PAN_MAX_VALS;
            if (Layer.isLandscape(2)) {
                n6 += FP.toInt(HUDModel.m_HudPanComponents[n3 + HUDModel.HUD_PAN_FP_CURR_POS]);
            }
            n8 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(SeedPicker.m_nSeedSelected));
            n9 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(SeedPicker.m_nSeedSelected));
            if (Cursor.bSeedAtCursorPlantable(-1, -1, Cursor.m_nCursorType)) {
                GCanvas.drawCursorComplete(graphics, n6, n7, n8, n9, "\u0017", n5);
            } else {
                GCanvas.drawCursorComplete(graphics, n6, n7, n8, n9, "\u0127", n5);
            }
        } else if (Cursor.m_nCursorType == 2) {
            GCanvas.drawCursorComplete(graphics, n6, n7, n8, n9, "\u0127", n5);
        }
    }

    static void drawCursorComplete(Graphics graphics, int n, int n2, int n3, int n4, String string, int n5) {
        GFCanvas.drawImage(graphics, string.charAt(0), n - n5, n2 - n5, 20, 2);
        GFCanvas.drawImage(graphics, string.charAt(0), 1, n + n3 + n5, n2 - n5, 24, 2);
        GFCanvas.drawImage(graphics, string.charAt(0), 2, n - n5, n2 + n4 + n5, 36, 2);
        GFCanvas.drawImage(graphics, string.charAt(0), 3, n + n3 + n5, n2 + n4 + n5, 40, 2);
    }

    static void drawCursorShovel(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (TouchGameController.m_nPlantableSeedAlphaFrame > 0) {
            n5 = GraphicsUtil.getPingPongDrawFrame(9, TouchGameController.m_nPlantableSeedAlphaFrame);
        }
        if (n5 != -1) {
            int n6 = n2;
            int n7 = n;
            n7 += n3 / 3;
            if ((n4 - GFCanvas.getImageHeight(230)) / 2 != 0) {
                n6 += (n4 - GFCanvas.getImageHeight(230)) / 2;
            }
            n6 -= n3;
            n7 += n5 * 2;
            n6 -= n5 * 2;
            int n8 = n2 / (n4 > 0 ? n4 : 1) - 1;
            if (n8 < 0) {
                n8 = 0;
            }
            n6 += GCanvas.getShovelY(n7, n8);
            GFCanvas.drawImage(graphics, 230, n7 += GCanvas.getShovelX(), n6, 20, 2);
        }
    }

    static void drawPlantableSeed(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GFCanvas.setClipFullScreen(graphics, 2);
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n);
        short s2 = (short)"\u0013\u0014\u0015\"\u001b\"\"\u001d\u0017\u0016 \u0018$\u0019!\u001c\u001a\u001e\u001f#%&'()*+,-.0".charAt(s);
        if (s2 == -1) {
            int n6 = GFCanvas.getImageWidth("\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(s));
            int n7 = GFCanvas.getImageHeight("\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(s));
            int n8 = n2 + (n4 - n6 >> 1);
            int n9 = n7 > n5 >> 1 ? n5 - n7 : n5 - n7 >> 1;
            int n10 = n3 + n9;
            GCanvas.drawPlant(graphics, s, n8, n10);
            return;
        }
        int n11 = SeedBank.SEED_SCALED_REANIM_IMG_INDEXES[n];
        if (n11 != -1) {
            int n12 = GFCanvas.getImageWidth(ReanimScaler.SCALED_IMGS[n11]);
            int n13 = GFCanvas.getImageHeight(ReanimScaler.SCALED_IMGS[n11]);
            int n14 = n2 + (n4 - n12 >> 1);
            int n15 = n13 > n5 >> 1 ? n5 - n13 : n5 - n13 >> 1;
            int n16 = n3 + n15;
            GFCanvas.drawImage(graphics, ReanimScaler.SCALED_IMGS[n11], n14, n16, 20, 2);
        }
    }

    static void drawPlants(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (int i = 0; i < Plants.MAX_NUM_PLANTS && n8 < Plants.m_nPlants; ++i) {
            boolean bl;
            int n14;
            int n15;
            int n16;
            if (!Plants.isPlantAtIndex(i)) continue;
            n4 = Plants.PLANT_MAX_VALS * i;
            n9 = Plants.getRow(i);
            if (n9 != n3) continue;
            n5 = Plants.PLANTS[n4 + Plants.PLANT_TYPE];
            n6 = Plants.PLANTS[n4 + Plants.PLANT_X] + n;
            n7 = Plants.PLANTS[n4 + Plants.PLANT_Y] + n2;
            n6 += GCanvas.getEveryPlantX(n6);
            if (n5 == 24) {
                n7 += Plants.PLANTS[n4 + Plants.PLANT_PARAM_1];
            }
            GFCanvas.setClipFullScreen(graphics, 2);
            n10 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_INDEX];
            if (n5 == 30 || n5 == 29) {
                n16 = Plants.PLANTS[n4 + Plants.PLANT_POS];
                Plants.getPlantsOnLawn(n16);
                if (Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] != -1) continue;
                Plants.getPlantOffsets(n5);
                n11 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_FRAME];
                n12 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_START_TRACK_INDEX];
                n13 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
                n15 = n6 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + GCanvas.getPlantX();
                n14 = n7 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + GCanvas.getPlantY(n6, n3);
                ReanimView.drawReanim(graphics, n10, n11, n15, n14, n12, n13, 0, false);
                ++n8;
            }
            Plants.getPlantOffsets(n5);
            boolean bl2 = bl = n5 != 13 && n5 != 24 && n5 != 30 && n5 != 29;
            if (bl) {
                n16 = n6 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_SHADOW_X] + GCanvas.getPlantX();
                n15 = n7 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_SHADOW_Y] + GCanvas.getPlantY(n6, n3);
                GCanvas.drawShadow(graphics, n16, n15, false);
            }
            if (n5 == 7 || n5 == 12) {
                n16 = "\uffff\uffff6\uffff\uffff\t\uffff\u0002\uffff\uffff\uffff\uffff\u0002\r\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff6\t\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n5);
                n6 += Util.GetRandom(n16) - n16 / 2;
                n7 += Util.GetRandom(n16) - n16 / 2;
            }
            if (n10 != -1) {
                if ((n5 == 30 || n5 == 29) && Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] == -1) continue;
                n11 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_FRAME];
                n12 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_START_TRACK_INDEX];
                n13 = Plants.PLANTS[n4 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
                n16 = n6 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + GCanvas.getPlantX();
                n15 = n7 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + GCanvas.getPlantY(n6, n3);
                if (GameController.m_nLevel >= 40 || GModel.PLANT_ROW[n3] == 3) {
                    n14 = Plants.PLANTS[n4 + Plants.PLANT_POS];
                    Plants.getPlantsOnLawn(n14);
                    if (Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_UNDER_PLANT] != -1 && (GameController.m_nLevel >= 40 || Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] != 1 && Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] != 0)) {
                        int n17 = GModel.PLANT_ROW[n3] == 3 ? 29 : 30;
                        Plants.getPlantOffsets(n17);
                        int n18 = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_UNDER_PLANT];
                        int n19 = Plants.PLANT_MAX_VALS * n18;
                        if (n19 < 0) {
                            return;
                        }
                        n6 = Plants.PLANTS[n19 + Plants.PLANT_X] + n;
                        n7 = Plants.PLANTS[n19 + Plants.PLANT_Y] + n2;
                        n6 += GCanvas.getEveryPlantX(n6);
                        int n20 = Plants.PLANTS[n19 + Plants.PLANT_REANIM_INDEX];
                        int n21 = Plants.PLANTS[n19 + Plants.PLANT_REANIM_FRAME];
                        int n22 = Plants.PLANTS[n19 + Plants.PLANT_REANIM_START_TRACK_INDEX];
                        int n23 = Plants.PLANTS[n19 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
                        int n24 = n6 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + GCanvas.getPlantX();
                        int n25 = n7 + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + GCanvas.getPlantY(n6, n3);
                        ReanimView.drawReanim(graphics, n20, n21, n24, n25, n22, n23, 0, false);
                    }
                }
                ReanimView.drawReanim(graphics, n10, n11, n16, n15, n12, n13, 0, false);
            } else {
                n7 += GCanvas.getPlantY(n6, n3);
                GCanvas.drawPlant(graphics, n5, n6 += GCanvas.getPlantX(), n7);
            }
            ++n8;
        }
    }

    static void drawPlant(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0) {
            GFCanvas.drawImage(graphics, "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n), n2, n3, 20, 2);
        }
    }

    static void drawPlantHealthBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Plants.PLANT_MAX_VALS * n;
        int n6 = Plants.PLANTS[n5 + Plants.PLANT_HEALTH];
        short s = (short)"\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n2);
        GCanvas.drawHealthBar(graphics, n3, n4 - 4, 30, 4, n6, s, 0x696969, 0xFF2F2F, 15);
    }

    static void drawZombies(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = -1;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        for (int i = 0; i < 100 && n17 < Zombies.m_nZombies; ++i) {
            int n22;
            int n23;
            n4 = Zombies.ZOMBIE_MAX_VALS * i;
            if (!Zombies.isZombieAtIndex(i) || (n20 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_ROW]) != n3) continue;
            n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
            boolean bl = Zombies.isFlagSet(9, i);
            Zombies.getZombieOffsets(n5, bl);
            n8 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_ALTITUDE]);
            n6 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_CENTRE_X]) + n;
            n7 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_TOP_Y]) + n2 + n8;
            n18 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_INDEX];
            n15 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS];
            n16 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_START_TRACK_INDEX];
            n21 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_STATE];
            if (n8 > 0) {
                n23 = Zombies.getZombieAltitudeClipH(i);
                GFCanvas.setClip(graphics, 0, n7 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] - n8, Layer.getLayerProperty(2, 3), n23, 2);
            } else {
                GFCanvas.setClipFullScreen(graphics, 2);
            }
            int n24 = bl ? 1 : 0;
            if (n5 == 13 && n21 == 38) {
                n6 += Util.GetRandom(2) - 1;
                n7 += Util.GetRandom(2) - 1;
            }
            if (Zombies.bDrawShadow(i)) {
                n23 = n6 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_X] + GCanvas.getZombiesX();
                n22 = n7 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_Y] - n8 + GCanvas.getZombiesY(n6, n3);
                GCanvas.drawShadow(graphics, n23, n22, bl);
            }
            if (n21 == 39) {
                n6 += Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_X];
                n7 += Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BURN_Y] - n8;
            }
            n23 = GCanvas.getZombiesY(n6, n3);
            n22 = GCanvas.getZombiesX();
            if (n18 != -1) {
                int n25 = n6 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] + n22;
                int n26 = n7 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + n23;
                n19 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_FRAME];
                ReanimView.drawReanim(graphics, n18, n19, n25, n26, n16, n15, n24, bl);
            } else {
                GCanvas.drawZombie(graphics, n5, n6 += n22, n7 += n23);
            }
            if (Zombies.isFlagSet(4, i) && n5 != 21 && n5 != 22) {
                int n27 = Reanim.getReanimID(n18);
                char c = "\u0013*:ISar\u0081\u0092\u00a0\u00ab\u00bb\u00cb\u00df\u00e7\u00fa\u0131\uffff\uffff\u014a\uffff\u015e\uffff\uffff\uffff\uffff\u017f\uffff\uffff\uffff\uffff\u01a0\u01ab\uffff\u01b7\uffff\uffff\uffff\uffff\uffff\u01de\u01e2\uffff\uffff\uffff\u0200\uffff\u020a\uffff\u0220\uffff".charAt(n27);
                Reanim.getTrackDrawPos(n18, c, Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_REANIM_FRAME], bl);
                if (Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_BUTTERED_COUNTDOWN] > 0) {
                    n9 = n6 + n22 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_X];
                    n10 = n7 + n23 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_BUTTER_Y];
                    GFCanvas.drawImage(graphics, 269, n9, n10, 20, 2);
                }
                if (Zombies.isFlagSet(12, i)) {
                    n11 = n6 + n22 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_X];
                    n12 = n7 + n23 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_MIND_CONTROL_Y];
                }
                if (Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] > 0) {
                    n13 = n6 + n22 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_X] + Reanim.m_nTrackPosX + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_X];
                    n14 = n7 + n23 + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_CHILLLED_Y];
                    GFSprite.draw(graphics, 31, n13, n14, Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_CHILLED_COUNTDOWN]);
                }
            }
            ++n17;
        }
    }

    static void drawZombie(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0) {
            GFCanvas.drawImage(graphics, "\u0006\u0142\u01fa}\u016e\u00e9\u019d\u0226\u00d8\u00a8\u01c4\u01ab=\u01ca\u011b^\u009d?\u01d4\u018f\u00a3\uffff\uffff".charAt(n), n2, n3, 20, 2);
        }
    }

    static void drawMowers(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < Mowers.MAX_NUM_MOWERS && n8 < Mowers.m_nMowers; ++i) {
            n4 = Mowers.MOWER_MAX_VALS * i;
            if (!Mowers.isMowerAtIndex(i) || Mowers.MOWERS[n4 + Mowers.MOWER_ROW] != n3) continue;
            GFCanvas.setClipFullScreen(graphics, 2);
            n5 = Mowers.MOWERS[n4 + Mowers.MOWER_TYPE];
            n6 = FP.toInt(Mowers.MOWERS[n4 + Mowers.MOWER_FP_X]) + (short)"\u0003\u0003".charAt(n5) + n;
            n7 = FP.toInt(Mowers.MOWERS[n4 + Mowers.MOWER_FP_Y]) + (short)"\u0000\u0000".charAt(n5) + n2;
            GCanvas.drawMower(graphics, n5, n6, n7 += GCanvas.getMowersY(n6 += GCanvas.getMowersX(), n3));
            ++n8;
        }
    }

    static void drawMower(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0) {
            GFCanvas.drawImage(graphics, "\u00ec\u018b".charAt(n), n2, n3, 20, 2);
        }
    }

    static void drawGridItems(Graphics graphics, int n, int n2, int n3, int n4) {
        if (GridItem.m_nGridItems <= 0) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < GridItem.MAX_NUM_GRID_ITEMS && n10 < GridItem.m_nGridItems; ++i) {
            n5 = GridItem.GRID_ITEM_MAX_VALS * i;
            if (!GridItem.isGridItemAtIndex(i) || GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_RENDER_ORDER] != n4 || GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_POS] / 9 != n3) continue;
            n6 = GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_TYPE];
            n7 = FP.toInt(GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_X]) + n;
            n8 = FP.toInt(GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_Y]) + n2;
            int n11 = GCanvas.getPlantY(n7, n3);
            n8 += n11;
            if (n6 >= 0 && GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_STATE] != 2) {
                int n12;
                int n13;
                if (n6 == 1) {
                    n13 = 0;
                    n12 = GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_3];
                    if (n12 != -1) {
                        n13 = Plants.PLANTS[n12 * Plants.PLANT_MAX_VALS + Plants.PLANT_PARAM_1];
                    }
                    GFCanvas.setClip(graphics, n7, n8 + n13, 270 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)), GFCanvas.getImageHeight(GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_1]) - n13, 2);
                    n9 = FP.toInt(GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_2]);
                    GFCanvas.drawImage(graphics, GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_1], n7, n8 + n9, 20, 2);
                } else if (n6 == 2) {
                    GFCanvas.setClipFullScreen(graphics, 2);
                    if (GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_STATE] == 3) {
                        GFCanvas.drawImage(graphics, GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_2], n7, n8, 3, 2);
                    } else {
                        GFCanvas.drawImage(graphics, GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_1], n7, n8, 3, 2);
                    }
                } else if (n6 == 0) {
                    GFCanvas.setClipFullScreen(graphics, 2);
                    n13 = GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_X];
                    n12 = GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_Y];
                    GFCanvas.drawImage(graphics, "\u0223\u0146\u0095".charAt(n6), n13, n12, 20, 2);
                } else {
                    GFCanvas.setClipFullScreen(graphics, 2);
                    GFCanvas.drawImage(graphics, "\u0223\u0146\u0095".charAt(n6), n7, n8, 20, 2);
                }
            }
            ++n10;
        }
    }

    static void drawShadow(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = bl ? 24 : 20;
        GFCanvas.drawImage(graphics, 532, n, n2, n3, 2);
    }

    static void drawZombieHealthBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = Zombies.ZOMBIE_MAX_VALS * n;
        short s = (short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(n2);
        int n6 = Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_HEALTH_BODY];
        int n7 = 0xFF2F2F;
        if (Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_CHILLED_COUNTDOWN] > 0) {
            n7 = 38655;
        }
        GCanvas.drawHealthBar(graphics, n3 - 15, n4 - 4, 30, 4, n6, s, 0x696969, n7, 15);
    }

    static void drawHealthBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GraphicsUtil.drawShadedRect(graphics, n, n2, n3, n4, n7, n7, 1, 0);
        --n4;
        --n3;
        if ((Layer.getLayerProperty(2, 5) & 4) != 0) {
            ++n;
        } else if ((Layer.getLayerProperty(2, 5) & 2) != 0) {
            ++n2;
        } else {
            ++n;
            ++n2;
        }
        int n10 = Util.getPercentage(n5, n6, n3);
        GraphicsUtil.fillShadedRect(graphics, n, n2, n10, n4, n8, n8, 1, 0);
        if (n3 - n10 > 0) {
            GraphicsUtil.fillShadedRect(graphics, n += n10, n2, n3 - n10, n4, n9, n9, 1, 0);
        }
    }

    static void drawProjectiles(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < Projectiles.MAX_NUM_PROJECTILES && n10 < Projectiles.m_nProjectiles; ++i) {
            if (Projectiles.PROJECTILES[i * Projectiles.PROJECTILE_MAX_VALS + Projectiles.PROJECTILE_TYPE] == -1) continue;
            GFCanvas.setClipFullScreen(graphics, 2);
            n4 = Projectiles.PROJECTILE_MAX_VALS * i;
            int n11 = Projectiles.PROJECTILES[n4 + Projectiles.PROJECTILE_ROW];
            if (n11 != n3) continue;
            n5 = Projectiles.PROJECTILES[n4 + Projectiles.PROJECTILE_TYPE];
            Projectiles.getRect(i, false);
            n6 = Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_X] + n;
            n7 = Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_Y] + n2;
            Cursor.getGridRowPos(n11, 0);
            Projectiles.getProjectileOffsets(n5);
            n8 = n6 + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_SHADOW_X];
            if (n5 != 10) {
                n9 = n5 == 6 || n5 == 3 || n5 == 5 || n5 == 4 || n5 == 8 || n5 == 9 ? Cursor.GRID_POS[Cursor.GRID_POS_Y] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_SHADOW_Y] + n2 : n7 + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_SHADOW_Y] + n2;
            }
            if (n5 != 10) {
                GFCanvas.drawImage(graphics, 122, n8 += GCanvas.getProjectilesX(), n9 += GCanvas.getProjectilesY(n6, n3), 20, 2);
            }
            GCanvas.drawProjectile(graphics, n5, n6, n7 += GCanvas.getProjectilesY(n6 += GCanvas.getProjectilesX(), n3));
            ++n10;
        }
    }

    static void drawProjectile(Graphics graphics, int n, int n2, int n3) {
        if (n >= 0) {
            GFCanvas.drawImage(graphics, "C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(n), n2, n3, 20, 2);
        }
    }

    static void drawCoins(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < Coins.MAX_NUM_COINS && n8 < Coins.m_nCoins; ++i) {
            if (!Coins.isCoinAtIndex(i)) continue;
            GFCanvas.setClipFullScreen(graphics, 2);
            n3 = Coins.COIN_MAX_VALS * i;
            n4 = Coins.COINS[n3 + Coins.COIN_TYPE];
            n5 = Coins.COINS[n3 + Coins.COIN_SEED_TYPE];
            n6 = FP.toInt(Coins.COINS[n3 + Coins.COIN_FP_X]) + n;
            n7 = FP.toInt(Coins.COINS[n3 + Coins.COIN_FP_Y]) + n2;
            GCanvas.drawCoin(graphics, n4, n6, n7, n5);
            ++n8;
        }
    }

    static void drawCoin(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 >= 0) {
            GFCanvas.drawImage(graphics, (short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4), n2, n3, 20, 2);
        } else if (n >= 0) {
            GFCanvas.drawImage(graphics, "\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n), n2, n3, 20, 2);
        }
    }

    static void drawGameOverText(Graphics graphics) {
        if (GameController.m_nGameState == 1 && GCanvasController.m_nGameOverFadeFrame >= 0) {
            int n = Util.getPercentage(GCanvasController.m_nGameOverFadeFrame, 20, -1);
            GFCanvas.setClipFullScreen(graphics, 2);
            if (n < 100) {
                GFCanvas.drawAlphaRegion(graphics, n, 0, 0, Layer.getLayerProperty(2, 3), Layer.getLayerProperty(2, 4), 2);
            } else {
                GraphicsUtil.fillShadedRect(graphics, 0, 0, Layer.getLayerProperty(2, 3), Layer.getLayerProperty(2, 4), 15, 15, 1, 0);
            }
            if (GCanvasController.m_nGameOverFadeTextFrame >= 0 && (n = Util.getPercentage(20 - GCanvasController.m_nGameOverFadeTextFrame, 20, -1)) < 100) {
                int n2 = GFText.getStringWidth(275, 8);
                int n3 = GFFont.getFontHeight(8);
                int n4 = Layer.getXCenter(2) - n2 / 2;
                int n5 = Layer.getYCenter(2) - n3 / 2;
                int n6 = 10;
                int n7 = 5;
                if (n > 0) {
                    GraphicsUtil.drawAlphaRegion(graphics, n, n4 - n6, n5 - n7, n2 + n6 * 2, n3 + n7 * 2, true);
                    GFCanvas.drawAlphaRegion(graphics, n, n4 - n6, n5 - n7, n2 + n6 * 2, n3 + n7 * 2, 2);
                } else {
                    GFCanvas.drawAlphaRegion(graphics, 70, n4 - n6, n5 - n7, n2 + n6 * 2, n3 + n7 * 2, 2);
                }
                GFText.drawString(graphics, 275, n4, n5, 8, 1, 1);
            }
        }
    }

    static void drawZombieMarkers(Graphics graphics, int n, int n2) {
        if ((Layer.getLayerProperty(2, 5) & 1) != 0) {
            return;
        }
        GFCanvas.setClipFullScreen(graphics, 2);
        int n3 = n;
        int n4 = ViewPort.m_nViewW - ViewPort.m_nViewX + n - GFCanvas.getImageWidth(561);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 8;
        int n10 = GFFont.getCharWidth(' ', n9);
        for (int i = 0; i < GCanvasController.ZOMBIE_MARKER_FRAMES.length; ++i) {
            if (GCanvasController.ZOMBIE_MARKER_FRAMES[i] < 0) continue;
            n7 = GraphicsUtil.getPingPongDrawFrame(9, GCanvasController.ZOMBIE_MARKER_FRAMES[i]);
            Cursor.getGridRowPos(i, 0);
            n5 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + Cursor.GRID_POS[Cursor.GRID_POS_H] / 2 + n2;
            n6 = n5 - GFFont.getFontHeight(n9) / 2;
            if (GCanvasController.ZOMBIE_MARKER_FLIPPED[i]) {
                GFCanvas.drawImage(graphics, 561, 1, n3 + n7, n5, 6, 2);
                if (GCanvasController.ZOMBIE_MARKER_NUMBERS[i] <= 0) continue;
                n8 = Text.getNumberWidth(GCanvasController.ZOMBIE_MARKER_NUMBERS[i], n9) + n10;
                Text.DrawAlignedNumber(graphics, GCanvasController.ZOMBIE_MARKER_NUMBERS[i], n3 + n7 + n8, n6, n9, 1, false);
                continue;
            }
            GFCanvas.drawImage(graphics, 561, n4 - n7, n5, 6, 2);
            if (GCanvasController.ZOMBIE_MARKER_NUMBERS[i] <= 0) continue;
            n8 = Text.getNumberWidth(GCanvasController.ZOMBIE_MARKER_NUMBERS[i], n9) + n10;
            Text.DrawAlignedNumber(graphics, GCanvasController.ZOMBIE_MARKER_NUMBERS[i], n4 - n7 - n8, n6, n9, 1, false);
        }
    }

    static void drawRightTriangleOutline(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(n4);
        int n5 = Layer.getDefaultX(n, n2, 2);
        int n6 = Layer.getDefaultY(n, n2, 2);
        graphics.drawLine(n5, n6 -= n3 / 2, n5, n6 + n3);
        graphics.drawLine(n5, n6, n5 + n3, n6 + n3 / 2);
        graphics.drawLine(n5, n6 + n3, n5 + n3, n6 + n3 / 2);
    }

    static void drawWhiteScreenFade(Graphics graphics, int n) {
        if (n >= 0 && n < m_imgWhiteAlpha.length) {
            GFCanvas.drawTiledArea(graphics, m_imgWhiteAlpha[n], 0, 0, Layer.getLayerProperty(2, 3), Layer.getLayerProperty(2, 4), 20, 2);
        }
    }

    static {
        m_sDisplayStr = new StringBuffer(32);
        m_imgWhiteAlpha = new Image[15];
    }
}

