/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GFParticleEngine
implements Constants,
GameConstants {
    static final int PARTICLE_PROPERTIES_LIFE = 0;
    static final int PARTICLE_PROPERTIES_POS_X = 1;
    static final int PARTICLE_PROPERTIES_POS_Y = 2;
    static final int PARTICLE_PROPERTIES_VEL_X = 3;
    static final int PARTICLE_PROPERTIES_VEL_Y = 4;
    static final int PARTICLE_PROPERTIES_TYPE = 5;
    static final int PARTICLE_PROPERTIES_FLAGS = 6;
    static final int PARTICLE_PROPERTIES_RENDER_ORDER = 7;
    static final int PARTICLE_PROPERTIES_ANIMATION_DELAY = 8;
    static final int PARTICLE_PROPERTIES_PARAM_1 = 9;
    static final int PARTICLE_PROPERTIES_PARAM_2 = 10;
    static final int PARTICLE_PROPERTIES_PARAM_3 = 11;
    static final int PARTICLE_PROPERTIES_PARAM_4 = 12;
    static final int NUM_PARTICLE_PROPERTIES = 13;
    static final int PARTICLE_FLAG_COLOR_BLUE = 0;
    static final int PARTICLE_FLAG_COLOR_GREEN = 1;
    static final int PARTICLE_FLAG_COLOR_RED = 2;
    static final int PARTICLE_FLAG_COLOR_YELLOW = 3;
    static final int PARTICLE_FLAG_COLOR_WHITE = 4;
    static final int PARTICLE_FLAG_COLOR_PURPLE = 5;
    static final int PARTICLE_FLAG_HIDE = 6;
    static final int PARTICLE_FLAG_FADE_IN = 7;
    static final int PARTICLE_FLAG_FADE_OUT = 8;
    static final int PARTICLE_FLAG_STAND_BY = 9;
    static final int PARTICLE_FLAG_TRAIL_ANIM_STARTER = 10;
    static final int PARTICLE_FLAG_DELAYED_ANIMATION = 14;
    static final int PARTICLE_FLAG_SHAKE = 15;
    static final int PARTICLE_MAX_GENERIC_FLAGS = 15;
    static int m_nParticles = 0;
    static int[] PARTICLE_DATA = new int[3328];
    static int[] NEW_PARTICLE_DATA = new int[13];

    static void resetVars() {
        Util.resetArray(PARTICLE_DATA, 0);
        m_nParticles = 0;
    }

    static final void killParticleType(int n, boolean bl) {
        if (m_nParticles > 0) {
            int n2 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n2 = i * 13;
                if (i >= m_nParticles) break;
                if (PARTICLE_DATA[n2] == -1 || PARTICLE_DATA[n2 + 5] != n || (!bl || !GFParticleEngine.isFlagSet(6, n2)) && bl) continue;
                GFParticleEngine.PARTICLE_DATA[n2 + 0] = -1;
            }
        }
    }

    public static void recycleParticles(boolean bl) {
        int n = 0;
        int n2 = 0;
        if (m_nParticles > 0) {
            for (int i = 0; i < m_nParticles; ++i) {
                n2 = n * 13;
                if (++n > m_nParticles) {
                    return;
                }
                if (!bl && PARTICLE_DATA[n2 + 0] != -1 || !bl && PARTICLE_DATA[n2] != -1) continue;
                if (m_nParticles == 1 || bl) {
                    GFParticleEngine.PARTICLE_DATA[0] = -1;
                    m_nParticles = 0;
                    return;
                }
                for (int j = n2 + 13; j < PARTICLE_DATA.length && j < m_nParticles * 13; ++j) {
                    GFParticleEngine.PARTICLE_DATA[j - 13] = PARTICLE_DATA[j];
                    GFParticleEngine.PARTICLE_DATA[j] = -1;
                }
                --m_nParticles;
            }
        }
    }

    public static boolean isFlagSet(int n, int n2) {
        return (PARTICLE_DATA[n2 * 13 + 6] & 1 << n) != 0;
    }

    public static void setFlag(int n, int n2) {
        int n3 = n2 * 13 + 6;
        PARTICLE_DATA[n3] = PARTICLE_DATA[n3] | 1 << n;
    }

    public static void unSetFlag(int n, int n2) {
        int n3 = n2 * 13 + 6;
        PARTICLE_DATA[n3] = PARTICLE_DATA[n3] & ~(1 << n);
    }

    public static void resetFlags(int n) {
        GFParticleEngine.PARTICLE_DATA[n * 13 + 6] = 0;
    }

    static int addParticle() {
        if (m_nParticles + 1 < 256) {
            int n = m_nParticles * 13;
            ++m_nParticles;
            for (int i = 0; i < 13; ++i) {
                GFParticleEngine.PARTICLE_DATA[n + i] = NEW_PARTICLE_DATA[i];
                GFParticleEngine.NEW_PARTICLE_DATA[i] = 0;
            }
            return m_nParticles - 1;
        }
        return -1;
    }

    public static void updateParticles() {
        if (m_nParticles > 0) {
            int n = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n = i * 13;
                if (PARTICLE_DATA[n] == -1) continue;
                int n2 = PARTICLE_DATA[n + 5];
                HandlerParticle.updateParticle(i);
            }
            GFParticleEngine.recycleParticles(false);
        }
    }

    static void drawParticles(Graphics graphics, int n, int n2, int n3) {
        if (m_nParticles > 0) {
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n8 = i * 13;
                if (PARTICLE_DATA[n8] == -1 || PARTICLE_DATA[n8 + 7] != n) continue;
                GFCanvas.setClipFullScreen(graphics, 2);
                HandlerParticle.drawParticle(graphics, i, n2, n3);
            }
            graphics.setClip(n4, n5, n6, n7);
        }
    }
}

