/*
 * Decompiled with CFR 0.152.
 */
public class GridItem
implements GameConstants,
Constants {
    static int m_nGridItems;
    static int GRID_ITEM_TYPE;
    static int GRID_ITEM_FP_X;
    static int GRID_ITEM_FP_Y;
    static int GRID_ITEM_POS;
    static int GRID_ITEM_STATE;
    static int GRID_ITEM_RENDER_ORDER;
    static int GRID_ITEM_COUNTDOWN;
    static int GRID_ITEM_PARAM_1;
    static int GRID_ITEM_PARAM_2;
    static int GRID_ITEM_PARAM_3;
    static int GRID_ITEM_MAX_VALS;
    static int MAX_NUM_GRID_ITEMS;
    static final int[] GRID_ITEMS;

    static void init() {
    }

    static void resetVarsNewLevel() {
        Util.resetArray(GRID_ITEMS, -1);
        m_nGridItems = 0;
    }

    static int addGridItem(int n, int n2, int n3, int n4) {
        if (n >= 0) {
            int n5 = 0;
            for (int i = 0; i < MAX_NUM_GRID_ITEMS; ++i) {
                if (GridItem.isGridItemAtIndex(i)) continue;
                n5 = GRID_ITEM_MAX_VALS * i;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_TYPE] = n;
                if (n == 0) {
                    Cursor.getGridPosRect(n2, 0);
                    int n6 = Plants.getTopPlant(n2, 0);
                    int n7 = n6 * Plants.PLANT_MAX_VALS;
                    int n8 = Plants.PLANTS[n7 + Plants.PLANT_TYPE];
                    int n9 = n8 == 4 ? 464 : 358;
                    int n10 = GFCanvas.getImageWidth(n9);
                    Plants.getPlantOffsets(n8);
                    int n11 = Plants.PLANTS[n7 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + n10 - 8;
                    int n12 = n2 / 9;
                    int n13 = Plants.PLANTS[n7 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + GCanvas.getPlantY(Plants.PLANTS[n7 + Plants.PLANT_X], n12);
                    GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_X] = n11;
                    GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_Y] = n13;
                } else {
                    GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_X] = GridItem.getStartFPX(n, n2) + GCanvas.getGridItemX() * 4096;
                    GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_FP_Y] = GridItem.getStartFPY(n, n2);
                }
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_POS] = n2;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_STATE] = 0;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_RENDER_ORDER] = n3;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_COUNTDOWN] = n4;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_2] = 0;
                GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_PARAM_3] = -1;
                GridItem.setUniqueAttribs(i, n);
                ++m_nGridItems;
                return i;
            }
        }
        return -1;
    }

    static void setUniqueAttribs(int n, int n2) {
        int n3 = GRID_ITEM_MAX_VALS * n;
        if (n2 == 1) {
            int n4 = Util.GetRandom((short)"\u0146\u0145\u0144".length());
            GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_PARAM_1] = (short)"\u0146\u0145\u0144".charAt(n4);
            GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_STATE] = 2;
        } else if (n2 == 2) {
            int n5 = 149;
            int n6 = 388;
            int n7 = GRID_ITEMS[n3 + GRID_ITEM_POS] / 9;
            if (GModel.PLANT_ROW[n7] == 3) {
                if (GameController.m_nLevel >= 30) {
                    n5 = 470;
                    n5 = 559;
                    n6 = 559;
                } else {
                    n5 = 82;
                    n5 = 174;
                    n6 = 174;
                }
            }
            GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_PARAM_1] = n5;
            GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_PARAM_2] = n6;
        }
    }

    static int getStartFPX(int n, int n2) {
        Cursor.getGridPosRect(n2, 0);
        return (Cursor.GRID_POS[Cursor.GRID_POS_X] + (short)"\u0014\u0000\u0011".charAt(n)) * 4096;
    }

    static int getStartFPY(int n, int n2) {
        Cursor.getGridPosRect(n2, 0);
        return (Cursor.GRID_POS[Cursor.GRID_POS_Y] + (short)"\u0000\u0005\u001c".charAt(n)) * 4096;
    }

    static boolean isGridItemAtIndex(int n) {
        return GRID_ITEMS[GRID_ITEM_MAX_VALS * n + GRID_ITEM_TYPE] != -1;
    }

    static int getGridItemTypeAtPos(int n) {
        if (m_nGridItems <= 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_GRID_ITEMS && n2 < m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n3 = i * GRID_ITEM_MAX_VALS;
            if (GRID_ITEMS[n3 + GRID_ITEM_POS] == n) {
                return GRID_ITEMS[n3 + GRID_ITEM_TYPE];
            }
            ++n2;
        }
        return -1;
    }

    static int getGridItemIndexAtPos(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_GRID_ITEMS && n2 < m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n3 = i * GRID_ITEM_MAX_VALS;
            if (GRID_ITEMS[n3 + GRID_ITEM_POS] == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    static void update() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_GRID_ITEMS && n < m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n2 = i * GRID_ITEM_MAX_VALS;
            n3 = GRID_ITEMS[n2 + GRID_ITEM_TYPE];
            if (n3 == 1) {
                if (GModel.m_bEnableGraveStones) {
                    GridItem.updateGrave(i);
                }
            } else if (n3 == 2) {
                GridItem.updateCrater(i);
            }
            ++n;
        }
    }

    static void killGridItem(int n) {
        if (GRID_ITEMS[n * GRID_ITEM_MAX_VALS + GRID_ITEM_TYPE] != -1) {
            GridItem.GRID_ITEMS[n * GridItem.GRID_ITEM_MAX_VALS + GridItem.GRID_ITEM_TYPE] = -1;
            --m_nGridItems;
        }
    }

    static void killGridItemAtPos(int n) {
        int n2 = GridItem.getGridItemIndexAtPos(n);
        if (n2 >= 0 && GRID_ITEMS[n2 * GRID_ITEM_MAX_VALS + GRID_ITEM_TYPE] != -1) {
            GridItem.GRID_ITEMS[n2 * GridItem.GRID_ITEM_MAX_VALS + GridItem.GRID_ITEM_TYPE] = -1;
            --m_nGridItems;
        }
    }

    static int getGridItemTypeCount(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < MAX_NUM_GRID_ITEMS && n2 < m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n3 = i * GRID_ITEM_MAX_VALS;
            if (GRID_ITEMS[n3 + GRID_ITEM_TYPE] == n) {
                ++n4;
            }
            ++n2;
        }
        return n4;
    }

    static void updateGrave(int n) {
        int n2 = n * GRID_ITEM_MAX_VALS;
        if (GRID_ITEMS[n2 + GRID_ITEM_COUNTDOWN] < 18) {
            int n3 = n2 + GRID_ITEM_COUNTDOWN;
            GRID_ITEMS[n3] = GRID_ITEMS[n3] + 1;
            if (GRID_ITEMS[n2 + GRID_ITEM_COUNTDOWN] >= 0) {
                GridItem.GRID_ITEMS[n2 + GridItem.GRID_ITEM_STATE] = 1;
                int n4 = GFCanvas.getImageHeight(GRID_ITEMS[n2 + GRID_ITEM_PARAM_1]);
                GridItem.GRID_ITEMS[n2 + GridItem.GRID_ITEM_PARAM_2] = FP.fpAnimateCurve(0, 18, GRID_ITEMS[n2 + GRID_ITEM_COUNTDOWN], n4 * 4096, 0, 6);
                GCanvasController.doGraveRiseDirt(n, 15, 1);
            }
        } else {
            GridItem.GRID_ITEMS[n2 + GridItem.GRID_ITEM_STATE] = 0;
        }
    }

    static void updateCrater(int n) {
        int n2 = n * GRID_ITEM_MAX_VALS;
        int n3 = n2 + GRID_ITEM_COUNTDOWN;
        GRID_ITEMS[n3] = GRID_ITEMS[n3] - 1;
        if (GRID_ITEMS[n2 + GRID_ITEM_COUNTDOWN] == 1620) {
            GridItem.GRID_ITEMS[n2 + GridItem.GRID_ITEM_STATE] = 3;
        } else if (GRID_ITEMS[n2 + GRID_ITEM_COUNTDOWN] <= 0) {
            GridItem.killGridItem(n);
        }
    }

    static {
        GRID_ITEM_TYPE = 0;
        GRID_ITEM_FP_X = GRID_ITEM_TYPE + 1;
        GRID_ITEM_FP_Y = GRID_ITEM_FP_X + 1;
        GRID_ITEM_POS = GRID_ITEM_FP_Y + 1;
        GRID_ITEM_STATE = GRID_ITEM_POS + 1;
        GRID_ITEM_RENDER_ORDER = GRID_ITEM_STATE + 1;
        GRID_ITEM_COUNTDOWN = GRID_ITEM_RENDER_ORDER + 1;
        GRID_ITEM_PARAM_1 = GRID_ITEM_COUNTDOWN + 1;
        GRID_ITEM_PARAM_2 = GRID_ITEM_PARAM_1 + 1;
        GRID_ITEM_PARAM_3 = GRID_ITEM_PARAM_2 + 1;
        GRID_ITEM_MAX_VALS = GRID_ITEM_PARAM_3 + 1;
        MAX_NUM_GRID_ITEMS = 54;
        GRID_ITEMS = new int[MAX_NUM_GRID_ITEMS * GRID_ITEM_MAX_VALS];
    }
}

