/*
 * Decompiled with CFR 0.152.
 */
public class GCanvasController
implements Constants,
GameConstants {
    static int m_nGameOverFadeFrame;
    static int m_nGameOverFadeTextFrame;
    static int m_nShakeX;
    static int m_nShakeY;
    static int m_nShakeCurrX;
    static int m_nShakeCurrY;
    static int m_nShakeFrame;
    static int m_nGlobalAnimationFrame;
    static int[] ZOMBIE_MARKER_FRAMES;
    static int[] ZOMBIE_MARKER_NUMBERS;
    static boolean[] ZOMBIE_MARKER_FLIPPED;
    static boolean levelLoaded;
    static int m_nScreenFadeFrame;
    static int m_nScreenFadeImgIndex;
    static int[] BACKGROUND_ROW_IMG_IDS;

    static void init() {
    }

    static void createGameImages() {
        HUDModel.init(GCanvas.m_Graphics);
        CrazyDave.createImgs(GCanvas.m_Graphics);
    }

    static void releaseGameImages() {
    }

    static void redrawEverything() {
    }

    static void resetVarsNewLevel() {
        m_nGlobalAnimationFrame = 0;
        m_nGameOverFadeFrame = -1;
        m_nGameOverFadeTextFrame = -1;
        m_nShakeFrame = 0;
        Util.resetArray(ZOMBIE_MARKER_FRAMES, -1);
        Util.resetArray(ZOMBIE_MARKER_NUMBERS, -1);
        Util.resetArray(ZOMBIE_MARKER_FLIPPED, false);
        Util.resetArray(BACKGROUND_ROW_IMG_IDS, -1);
        m_nScreenFadeFrame = -1;
        m_nScreenFadeImgIndex = -1;
    }

    public static void trashImages() {
    }

    public static void updateAnims() {
        ++m_nGlobalAnimationFrame;
        HUDModel.updateAnims();
        GFBoardTexts.updateTexts();
        GCanvasController.updateCursor();
        GCanvasController.updateGameOverFade();
        Reanim.updateReanimGlobalFrame();
        GCanvasController.updateShakeBoard();
        Cursor.updateCursorZoomToDest();
        GCanvasController.updateScreenFade(false);
    }

    static void updateCursor() {
        if (GameController.m_nGameStateFrame % 2 == 0 && ++Cursor.m_nCursorFrame > GraphicsUtil.getPingPongMaxFrame(5)) {
            Cursor.m_nCursorFrame = 0;
        }
    }

    static void updateGameOverFade() {
        if (GameController.m_nGameState == 1) {
            if (m_nGameOverFadeFrame >= 0 && m_nGameOverFadeFrame < 20 && ++m_nGameOverFadeFrame == 20) {
                m_nGameOverFadeTextFrame = 0;
            }
            if (m_nGameOverFadeTextFrame >= 0 && m_nGameOverFadeTextFrame >= 0 && m_nGameOverFadeTextFrame < 20) {
                ++m_nGameOverFadeTextFrame;
            }
        }
    }

    public static void doPowieExposion(int n) {
        if (Plants.isPlantAtIndex(n)) {
            int n2 = Plants.PLANT_MAX_VALS * n;
            int n3 = Plants.PLANTS[n2 + Plants.PLANT_TYPE];
            Plants.getHitRect(n);
            int n4 = Plants.PLANT_RECT[Plants.PLANT_RECT_X] + Plants.PLANT_RECT[Plants.PLANT_RECT_W] / 2;
            int n5 = Plants.PLANT_RECT[Plants.PLANT_RECT_Y] + Plants.PLANT_RECT[Plants.PLANT_RECT_H] / 2;
            int n6 = Plants.PLANT_RECT[Plants.PLANT_RECT_W] / 2;
            GFParticleEmitter.doParticlePowieClouds(n4, n5, n6, Util.getRandValue(10, 15), Plants.getRow(n));
            int n7 = (short)"\u0000\u0003\u0002\u0006\u0005\u0001\u0000\u0000\u0000\u0000\u0002\u0004\u0002\u0002\u0004\u0003\u0003\u0003\u0002\u0003\u0000\u0004\u0003\u0006\u0002\u0001\u0000\u0000\u0000\u0003\u0000\u0000".charAt(0) * 4096;
            n5 += GCanvas.getPlantY(n4, n / 9);
            ParticleRadial.createParticle(0, n4 += GCanvas.getPlantX(), n5, 0, n7, 0, 0, 0 + Plants.getRow(n));
            GCanvasController.shakeBoard(5, 5, 4);
        }
    }

    public static void doCatapultExposion(int n) {
        if (Zombies.isZombieAtIndex(n)) {
            int n2 = Zombies.ZOMBIE_MAX_VALS * n;
            int n3 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_TYPE];
            int n4 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_ROW];
            Zombies.getHitRect(n);
            int n5 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_CENTRE_X]);
            int n6 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] / 2;
            int n7 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] / 2;
            GFParticleEmitter.doParticlePowieClouds(n5, n6, n7, Util.getRandValue(10, 15) / 2, n4);
            boolean bl = Zombies.isFlagSet(9, n);
            int n8 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_INDEX];
            int n9 = Reanim.getReanimID(n8);
            int n10 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FRAME];
            int n11 = Reanim.getTrackImgID(n8, 167, n10);
            if (n11 >= 0) {
                GFParticleEmitter.doParticleCatapultExplode(3, n5, n6, n4, n11, bl);
            }
            if ((n11 = Reanim.getTrackImgID(n8, 175, n10)) >= 0) {
                GFParticleEmitter.doParticleCatapultExplode(3, n5, n6, n4, n11, bl);
            }
            if ((n11 = Reanim.getTrackImgID(n8, 174, n10)) >= 0) {
                GFParticleEmitter.doParticleCatapultExplode(3, n5, n6, n4, n11, bl);
            }
            GCanvasController.shakeBoard(3, 3, 3);
        }
    }

    public static void doSproingExplosion(int n) {
        if (Zombies.isZombieAtIndex(n)) {
            int n2 = Zombies.ZOMBIE_MAX_VALS * n;
            int n3 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_TYPE];
            int n4 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_ROW];
            Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
            int n5 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_INDEX];
            int n6 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_FRAME];
            int n7 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_START_TRACK_INDEX];
            int n8 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS];
            Reanim.getReanimFrameDims(n5, n6, n7, n8);
            int n9 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_CENTRE_X]);
            int n10 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Reanim.m_nReanimFrameH / 2;
            int n11 = Reanim.m_nReanimFrameW / 2;
            GFParticleEmitter.doParticlePowieClouds(n9, n10, n11, Util.getRandValue(10, 15), n4);
            int n12 = (short)"\u0000\u0003\u0002\u0006\u0005\u0001\u0000\u0000\u0000\u0000\u0002\u0004\u0002\u0002\u0004\u0003\u0003\u0003\u0002\u0003\u0000\u0004\u0003\u0006\u0002\u0001\u0000\u0000\u0000\u0003\u0000\u0000".charAt(0) * 4096;
            ParticleRadial.createParticle(0, n9, n10, 0, n12, 0, 0, n4);
            GCanvasController.shakeBoard(5, 5, 4);
        }
    }

    public static void doSpudowExplosion(int n) {
        if (Plants.isPlantAtIndex(n)) {
            int n2 = Plants.PLANT_MAX_VALS * n;
            int n3 = Plants.PLANTS[n2 + Plants.PLANT_TYPE];
            Plants.getPlantOffsets(n3);
            int n4 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_INDEX];
            int n5 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_FRAME];
            int n6 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_START_TRACK_INDEX];
            int n7 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
            Reanim.getReanimFrameDims(n4, n5, n6, n7);
            int n8 = Plants.PLANTS[n2 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + Reanim.m_nReanimFrameW / 2;
            int n9 = Plants.PLANTS[n2 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + Reanim.m_nReanimFrameH / 2;
            int n10 = Reanim.m_nReanimFrameW / 4;
            GFParticleEmitter.doParticlePotatoPieces(n8, n9 - n10, n10, Util.getRandValue(10, 15), Plants.getRow(n));
            int n11 = (short)"\u0000\u0003\u0002\u0006\u0005\u0001\u0000\u0000\u0000\u0000\u0002\u0004\u0002\u0002\u0004\u0003\u0003\u0003\u0002\u0003\u0000\u0004\u0003\u0006\u0002\u0001\u0000\u0000\u0000\u0003\u0000\u0000".charAt(0) * 4096;
            ParticleRadial.createParticle(0, n8, n9, 0, n11, 3, 0, 0 + Plants.getRow(n));
            GCanvasController.shakeBoard(3, 3, 4);
        }
    }

    public static void doDirt(int n, int n2) {
        if (Plants.isPlantAtIndex(n)) {
            int n3 = Plants.PLANT_MAX_VALS * n;
            int n4 = Plants.PLANTS[n3 + Plants.PLANT_TYPE];
            Plants.getPlantOffsets(n4);
            int n5 = Plants.PLANTS[n3 + Plants.PLANT_REANIM_INDEX];
            if (n5 >= 0) {
                int n6 = Plants.PLANTS[n3 + Plants.PLANT_REANIM_FRAME];
                int n7 = Plants.PLANTS[n3 + Plants.PLANT_REANIM_START_TRACK_INDEX];
                int n8 = Plants.PLANTS[n3 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
                Reanim.getReanimFrameDims(n5, n6, n7, n8);
                int n9 = Plants.PLANTS[n3 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + Reanim.m_nReanimFrameX + Reanim.m_nReanimFrameW / 2;
                int n10 = Plants.PLANTS[n3 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + Reanim.m_nReanimFrameY + Reanim.m_nReanimFrameH;
                int n11 = Reanim.m_nReanimFrameW / 4;
                int n12 = n2 == 15 || n2 == 16 ? Util.getRandValue(5, 8) : Util.getRandValue(10, 16);
                GFParticleEmitter.doParticleDirtPieces(n2, n9, n10, n11, n11, n12, Plants.getRow(n));
            }
        }
    }

    public static void doGraveDiggerEat(int n) {
        if (Plants.isPlantAtIndex(n)) {
            int n2 = Plants.PLANT_MAX_VALS * n;
            int n3 = Plants.PLANTS[n2 + Plants.PLANT_TYPE];
            Plants.getPlantOffsets(n3);
            int n4 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_INDEX];
            if (n4 >= 0) {
                int n5 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_FRAME];
                int n6 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_START_TRACK_INDEX];
                int n7 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
                Reanim.getReanimFrameDims(n4, n5, n6, n7);
                int n8 = Plants.PLANTS[n2 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + Reanim.m_nReanimFrameX + Reanim.m_nReanimFrameW / 2;
                int n9 = Plants.PLANTS[n2 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] + Reanim.m_nReanimFrameY + 23;
                int n10 = Reanim.m_nReanimFrameW / 4;
                GFParticleEmitter.doParticleDirtPieces(18, n8, n9, n10, 0, 1, Plants.getRow(n));
            }
        }
    }

    public static void doDiggerTunnelDirt(int n, int n2, int n3) {
        if (Zombies.isZombieAtIndex(n)) {
            int n4 = Zombies.ZOMBIE_MAX_VALS * n;
            int n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
            int n6 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_ROW];
            Zombies.getZombieOffsets(n5, Zombies.isFlagSet(9, n));
            int n7 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] / 2;
            int n8 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_CENTRE_X]);
            int n9 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Zombies.getZombieAltitudeClipH(n) - n7;
            GFParticleEmitter.doParticleDirtPieces(n2, n8, n9, n7, n7, n3, n6);
        }
    }

    public static void doZombieGraveRiseDirt(int n, int n2, int n3) {
        if (Zombies.isZombieAtIndex(n)) {
            int n4 = Zombies.ZOMBIE_MAX_VALS * n;
            int n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
            int n6 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_ROW];
            int n7 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_PARAM_1];
            Cursor.getGridPosRect(n7, 0);
            int n8 = GFCanvas.getImageWidth((short)"\u0223\u0146\u0095".charAt(1));
            int n9 = GFCanvas.getImageHeight((short)"\u0223\u0146\u0095".charAt(1));
            int n10 = Cursor.GRID_POS[Cursor.GRID_POS_X] + (short)"\u0014\u0000\u0011".charAt(1) + n8 / 2;
            int n11 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + (short)"\u0000\u0005\u001c".charAt(1) + n9;
            int n12 = 0;
            if (n2 == 15) {
                n12 = n8 / 3;
                n11 -= n12;
            } else if (n2 == 20) {
                n11 -= GFSprite.getFrameHeight(GFParticle.getSpriteID(n2)) / 2;
            }
            GFParticleEmitter.doParticleDirtPieces(n2, n10, n11, n12, n12, n3, n6);
        }
    }

    public static void doGraveRiseDirt(int n, int n2, int n3) {
        if (GridItem.isGridItemAtIndex(n)) {
            int n4 = GridItem.GRID_ITEM_MAX_VALS * n;
            int n5 = GridItem.GRID_ITEMS[n4 + GridItem.GRID_ITEM_POS] / 9;
            int n6 = GridItem.GRID_ITEMS[n4 + GridItem.GRID_ITEM_PARAM_1];
            int n7 = GFCanvas.getImageWidth(n6);
            int n8 = GFCanvas.getImageHeight(n6);
            int n9 = FP.toInt(GridItem.GRID_ITEMS[n4 + GridItem.GRID_ITEM_FP_X]) + n7 / 2;
            int n10 = FP.toInt(GridItem.GRID_ITEMS[n4 + GridItem.GRID_ITEM_FP_Y]) + n8;
            int n11 = n7 / 3;
            GFParticleEmitter.doParticleDirtPieces(n2, n9, n10, n11, n11, n3, n5);
        }
    }

    public static void doDiggerRiseDirt(int n) {
        if (Zombies.isZombieAtIndex(n)) {
            int n2 = Zombies.ZOMBIE_MAX_VALS * n;
            int n3 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_TYPE];
            int n4 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_ROW];
            Zombies.getZombieOffsets(n3, Zombies.isFlagSet(9, n));
            int n5 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_CENTRE_X]);
            int n6 = FP.toInt(Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Zombies.getZombieAltitudeClipH(n);
            GFParticle.createParticle(20, n5, n6, 0, 0, n4);
            int n7 = GFSprite.getFrameHeight(17);
            GFParticleEmitter.doParticleDirtPieces(15, n5, n6, n7, n7, 10, n4);
        }
    }

    public static void doJalapenoExplosion(int n) {
        if (Plants.isPlantAtIndex(n)) {
            int n2 = Plants.PLANT_MAX_VALS * n;
            int n3 = Plants.getRow(n);
            int n4 = Plants.PLANTS[n2 + Plants.PLANT_POS];
            Cursor.getGridPosRect(n4, 0);
            int n5 = GFSprite.getFrameWidth(4);
            int n6 = Cursor.GRID_POS[Cursor.GRID_POS_X] + Cursor.GRID_POS[Cursor.GRID_POS_W] / 2;
            int n7 = GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5));
            int n8 = n7 + 270;
            int n9 = GameController.m_nLevel >= 40 ? GFSprite.getFrameHeight(4) >> 2 : GFSprite.getFrameHeight(4) >> 1;
            int n10 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + Cursor.GRID_POS[Cursor.GRID_POS_H] - n9;
            int n11 = GFParticle.getParticleLifeTotalFrames(6, -1) + 1;
            int n12 = n7;
            int n13 = 0;
            while (n12 < n8) {
                ParticleRadial.createParticle(6, n12, n10, 0, 0, 4, n13, n3);
                int n14 = -FP.getRandFPValueAsFP(4096 * (short)"\u0000\u0003\u0002\u0006\u0005\u0001\u0000\u0000\u0000\u0000\u0002\u0004\u0002\u0002\u0004\u0003\u0003\u0003\u0002\u0003\u0000\u0004\u0003\u0006\u0002\u0001\u0000\u0000\u0000\u0003\u0000\u0000".charAt(5), 4096 * (short)"\u0000\u0004\u0003\b\u0007\u0003\u0000\u0000\u0000\u0000\u0003\b\u0003\u0003\t\u0004\u0004\u0004\u0003\u0006\u0000\u0005\u0004\b\u0005\u0007\u0000\u0000\u0000\u0005\u0000\u0000".charAt(5));
                ParticleRadial.createParticle(5, n12, n10, 0, n14, 5, n11 + n13, n3);
                if (GameController.m_nLevel >= 40 && n12 < 165) {
                    n10 -= 10;
                }
                n12 += n5;
                ++n13;
            }
            GCanvasController.shakeBoard(5, 5, 3);
        }
    }

    public static void doProjectileSplat(int n, int n2) {
        int n3 = Zombies.ZOMBIE_MAX_VALS * n;
        int n4 = Projectiles.PROJECTILE_MAX_VALS * n2;
        int n5 = Projectiles.PROJECTILES[n4 + Projectiles.PROJECTILE_TYPE];
        int n6 = Projectiles.PROJECTILES[n4 + Projectiles.PROJECTILE_ROW];
        short s = (short)"C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(n5);
        int n7 = GFCanvas.getImageHeight(s) / 2;
        int n8 = FP.toInt(Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_CENTRE_X]) + Util.getRandValue(-n7, n7);
        int n9 = FP.toInt(Projectiles.PROJECTILES[n4 + Projectiles.PROJECTILE_FP_Y]) + n7 + Util.getRandValue(-n7, n7);
        int n10 = -1;
        int n11 = -1;
        int n12 = 10;
        if (n5 == 1) {
            n10 = 8;
            n11 = 10;
        } else if (n5 == 5 || n5 == 7 || n5 == 2) {
            n10 = 9;
            n11 = 11;
        } else if (n5 == 10) {
            n10 = 26;
            n11 = 26;
        } else {
            n10 = 7;
            n11 = 9;
        }
        GFParticle.createParticle(n10, n8, n9, 0, 0, n6);
        GFParticleEmitter.doParticleSplatPieces(n12, n8, n9, n7, Util.getRandValue(3, 5), n11, n6);
    }

    public static void doProjectileTrail(int n) {
        if (Util.GetRandom(2) == 0) {
            int n2 = Projectiles.PROJECTILE_MAX_VALS * n;
            int n3 = Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_TYPE];
            int n4 = Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_ROW];
            short s = (short)"C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(n3);
            int n5 = GFCanvas.getImageHeight(s) / 2;
            int n6 = FP.toInt(Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_FP_X]);
            int n7 = FP.toInt(Projectiles.PROJECTILES[n2 + Projectiles.PROJECTILE_FP_Y]) + n5;
            int n8 = -1;
            if (n3 == 1) {
                n8 = 12;
            } else if (n3 == 10) {
                n8 = 13;
            }
            int n9 = FP.getRandFPValueAsFP(-6433, 6433);
            int n10 = FP.getRandFPValueAsFP(4096 * "\u0000\u0003\u0002\u0006\u0005\u0001\u0000\u0000\u0000\u0000\u0002\u0004\u0002\u0002\u0004\u0003\u0003\u0003\u0002\u0003\u0000\u0004\u0003\u0006\u0002\u0001\u0000\u0000\u0000\u0003\u0000\u0000".charAt(n8), 4096 * "\u0000\u0004\u0003\b\u0007\u0003\u0000\u0000\u0000\u0000\u0003\b\u0003\u0003\t\u0004\u0004\u0004\u0003\u0006\u0000\u0005\u0004\b\u0005\u0007\u0000\u0000\u0000\u0005\u0000\u0000".charAt(n8));
            int n11 = FP.fpMul(FP.fpCos(n9), n10);
            int n12 = FP.fpMul(FP.fpSin(n9), n10);
            ParticleRadial.createParticle(n8, n6, n7, n11, n12, GFParticle.getSpriteID(n8), 0, n4);
        }
    }

    public static void doFumeShroomPuffs(int n) {
        int n2 = Plants.PLANT_MAX_VALS * n;
        int n3 = Plants.PLANTS[n2 + Plants.PLANT_TYPE];
        Plants.getPlantOffsets(n3);
        int n4 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_INDEX];
        int n5 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_FRAME];
        int n6 = Reanim.getTrackImgID(n4, 479, n5);
        if (n6 >= 0) {
            Reanim.getTrackDrawPos(n4, 479, n5, false);
            int n7 = Plants.PLANTS[n2 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + Reanim.m_nTrackPosX + GFCanvas.getImageWidth(Reanim.TRACK_IMGS[n6]);
            int n8 = Plants.PLANTS[n2 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + Reanim.m_nTrackPosY + GFCanvas.getImageHeight(Reanim.TRACK_IMGS[n6]) / 2;
            GFParticleEmitter.doParticleFumeShroomPuffs(25, n7, n8, Plants.getRow(n));
        }
    }

    public static void doFumeShroomZombieSplats(int n, int[] nArray) {
        int n2 = GFParticle.getSpriteID(26);
        int n3 = GFSprite.getFrameHeight(n2) / 2;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            int n5 = n4 * Zombies.ZOMBIE_MAX_VALS;
            int n6 = Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_ROW];
            Zombies.getHitRect(n4);
            int n7 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] / 2 + Util.getRandValue(-n3, n3);
            int n8 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y] + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] / 2 + Util.getRandValue(-n3, n3);
            GFParticle.createParticle(26, n7, n8, 0, 0, n6);
            GFParticleEmitter.doParticleSplatPieces(10, n7, n8, n3, Util.getRandValue(3, 5), 26, n6);
        }
    }

    public static void doAwardStars(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = Coins.COIN_MAX_VALS * n;
        int n5 = Coins.COINS[n4 + Coins.COIN_TYPE];
        int n6 = Coins.COINS[n4 + Coins.COIN_SEED_TYPE];
        if (n6 != -1) {
            n3 = GFCanvas.getImageWidth((short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n6));
            n2 = GFCanvas.getImageHeight((short)"\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n6));
        } else {
            n3 = GFCanvas.getImageWidth((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n5));
            n2 = GFCanvas.getImageHeight((short)"\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n5));
        }
        int n7 = FP.toInt(Coins.COINS[n4 + Coins.COIN_FP_X]) + n3 / 2;
        int n8 = FP.toInt(Coins.COINS[n4 + Coins.COIN_FP_Y]) + n2 / 2;
        if (bl) {
            GFParticleEmitter.doParticleAwardStars(23, n7, n8, n3 / 2, Util.getRandValue(15, 20), 22);
            GFParticleEmitter.doParticleAwardStars(23, n7, n8, n3 / 2, Util.getRandValue(15, 20), 23);
        } else {
            GFParticleEmitter.doParticleAwardStars(24, n7, n8, n3 / 2, 1, 22);
            GFParticleEmitter.doParticleAwardStars(24, n7, n8, n3 / 2, 1, 23);
        }
    }

    static void shakeBoard(int n, int n2, int n3) {
        m_nShakeX = n;
        m_nShakeY = n2;
        m_nShakeFrame = n3;
    }

    static void updateShakeBoard() {
        if (m_nShakeFrame > 0) {
            --m_nShakeFrame;
            if (m_nShakeX != 0) {
                m_nShakeCurrX = Util.GetRandom(2 * m_nShakeX) - m_nShakeX;
            }
            if (m_nShakeY != 0) {
                m_nShakeCurrY = Util.GetRandom(2 * m_nShakeY) - m_nShakeY;
            }
        } else {
            m_nShakeCurrY = 0;
            m_nShakeCurrX = 0;
        }
    }

    public static void doIceShroomExplosion(int n) {
        if (Plants.isPlantAtIndex(n)) {
            m_nScreenFadeFrame = 9;
            GCanvasController.updateScreenFade(true);
            int n2 = Plants.PLANT_MAX_VALS * n;
            int n3 = Plants.PLANTS[n2 + Plants.PLANT_TYPE];
            Plants.getPlantOffsets(n3);
            int n4 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_INDEX];
            int n5 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_FRAME];
            int n6 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_START_TRACK_INDEX];
            int n7 = Plants.PLANTS[n2 + Plants.PLANT_REANIM_HIDDEN_TRACKS];
            Reanim.getReanimFrameDims(n4, n5, n6, n7);
            int n8 = Plants.PLANTS[n2 + Plants.PLANT_X] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] + Reanim.m_nReanimFrameW / 2;
            int n9 = Plants.PLANTS[n2 + Plants.PLANT_Y] + Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] + Reanim.m_nReanimFrameH / 2;
            int n10 = Reanim.m_nReanimFrameW / 2;
            GFParticleEmitter.doParticleIceShroomFlakes(14, n8, n9, n10, Util.getRandValue(20, 30));
        }
    }

    public static void doIceTrap(int n, int n2) {
        if (Zombies.isZombieAtIndex(n) && Zombies.isFlagSet(4, n)) {
            int n3 = Zombies.ZOMBIE_MAX_VALS * n;
            int n4 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_TYPE];
            int n5 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_ROW];
            int n6 = GFSprite.getFrameHeight(GFParticle.getSpriteID(27));
            Zombies.getZombieOffsets(n4, Zombies.isFlagSet(9, n));
            int n7 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_INDEX];
            int n8 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_FRAME];
            int n9 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_START_TRACK_INDEX];
            int n10 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_REANIM_HIDDEN_TRACKS];
            Reanim.getReanimFrameDims(n7, n8, n9, n10);
            int n11 = FP.toInt(Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_CENTRE_X]) + (Reanim.m_nReanimFrameW >> 2);
            int n12 = FP.toInt(Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + GCanvas.getZombiesY(n11, n5) + Reanim.m_nReanimFrameY + Reanim.m_nReanimFrameH;
            GFParticle.createParticle(27, n11, n12, 0, 0, n5, n2, 0);
        }
    }

    public static void doDoomExplosion(int n) {
        if (Plants.isPlantAtIndex(n)) {
            m_nScreenFadeFrame = 18;
            GCanvasController.updateScreenFade(true);
            int n2 = Plants.getRow(n);
            Plants.getHitRect(n);
            int n3 = Plants.PLANT_RECT[Plants.PLANT_RECT_X] + Plants.PLANT_RECT[Plants.PLANT_RECT_W] / 2;
            int n4 = Plants.PLANT_RECT[Plants.PLANT_RECT_Y] + Plants.PLANT_RECT[Plants.PLANT_RECT_H] / 2;
            GFParticle.createParticle(28, n3, n4 - 5, 0, 0, n2, -1, 0);
            int n5 = GFSprite.getFrameHeight(GFParticle.getSpriteID(29)) / 2;
            GFParticleEmitter.doParticleDoomClouds(29, n3, n4 - 15, n5, n5 / 2, 10, n2);
            GFParticle.createParticle(30, n3, n4 - 5, 0, 0, n2, -1, 32768);
            GCanvasController.shakeBoard(3, 3, 12);
        }
    }

    static void updateScreenFade(boolean bl) {
        if (m_nScreenFadeFrame > 0) {
            if (!bl) {
                --m_nScreenFadeFrame;
            }
            int n = FP.fpAnimateCurve(18, 0, m_nScreenFadeFrame, (GCanvas.m_imgWhiteAlpha.length - 1) * 4096, 0, 6);
            m_nScreenFadeImgIndex = FP.toInt(n);
        } else {
            m_nScreenFadeImgIndex = -1;
        }
    }

    public static void doPoolSplash(int n, int n2, int n3) {
        if (Zombies.isZombieAtIndex(n)) {
            int n4 = Zombies.ZOMBIE_MAX_VALS * n;
            int n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
            int n6 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_ROW];
            Zombies.getZombieOffsets(n5, Zombies.isFlagSet(9, n));
            short s = (short)"M\u000f\u0205b\u01cb\u009f\u0154\u010b\u0113\u0168\u017e\u00d1O\u0088\u00ce\u00ce<@D\u00de@\u0084\u0090\u0180\u00b9S<\u017f\u0005\u00dc\u023b\n\u0139.".charAt(GFParticle.getSpriteID(31));
            int n7 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_CENTRE_X]) + n2;
            int n8 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_DRAW_Y] + Zombies.getZombieAltitudeClipH(n) - GFCanvas.getImageHeight(s) + n3;
            GFParticle.createParticle(31, n7, n8, 0, 0, n6);
        }
    }

    public static void doMowerSplash(int n) {
        if (Mowers.isMowerAtIndex(n)) {
            int n2 = Mowers.MOWER_MAX_VALS * n;
            int n3 = Mowers.MOWERS[n2 + Mowers.MOWER_ROW];
            short s = (short)"M\u000f\u0205b\u01cb\u009f\u0154\u010b\u0113\u0168\u017e\u00d1O\u0088\u00ce\u00ce<@D\u00de@\u0084\u0090\u0180\u00b9S<\u017f\u0005\u00dc\u023b\n\u0139.".charAt(GFParticle.getSpriteID(31));
            int n4 = 28;
            int n5 = 27;
            int n6 = FP.toInt(Mowers.MOWERS[n2 + Mowers.MOWER_FP_X]) + 0 + n4 / 2;
            int n7 = FP.toInt(Mowers.MOWERS[n2 + Mowers.MOWER_FP_Y]) + 6 + n5 - GFCanvas.getImageHeight(s);
            GFParticle.createParticle(31, n6, n7, 0, 0, n3);
        }
    }

    static {
        ZOMBIE_MARKER_FRAMES = new int[6];
        ZOMBIE_MARKER_NUMBERS = new int[6];
        ZOMBIE_MARKER_FLIPPED = new boolean[6];
        levelLoaded = false;
        BACKGROUND_ROW_IMG_IDS = new int[6];
    }
}

