/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class TouchController
implements TouchConstants {
    static boolean m_bTouchInitalised = false;
    static final int INFO_NONE = -1;
    static final int INFO_X = 0;
    static final int INFO_Y = 1;
    static final int INFO_SIZE = 2;
    static int[] m_nPressInfo;
    static int[] m_nReleaseInfo;
    static int[] m_nDragInfo;
    static int[] m_nLastTouchedInfo;
    static final int MAX_DRAG_EVENTS = 10;
    static int m_nDragInsertPointer;
    static int m_nDragUnhandledPointer;
    static long m_lDragHoldStartTime;
    static long m_lDragHeldTime;
    static boolean m_bPressDirtyDataFlag;
    static boolean m_bDragDirtyDataFlag;
    static boolean m_bReleaseDirtyDataFlag;
    static boolean m_bTouchLock;
    static int m_nTouchHeldFrameCounter;
    static short[] ATOMIC_ZONES;
    static int m_nAtomicZonesInsertPointer;
    static int m_nTouchState;
    static int m_nVirtualKeyZone;
    static int m_nSimulatedUnhandledKeyFlags;
    static int m_nSimulatedPressedKeyFlags;
    static int m_nSimulatedHeldKeyFlags;
    static int m_nSimulatedReleasedKeyFlags;
    static boolean m_bActiveDuplicateZones;
    static long[] ACTIVE_ZONES;
    static short[] ACTIVE_ZONE_ID;
    static final int ACTIVE_ZONES_LEFT_SHIFT = 48;
    static final int ACTIVE_ZONES_TOP_SHIFT = 32;
    static final int ACTIVE_ZONES_RIGHT_SHIFT = 16;
    static final int ACTIVE_ZONES_BTM_SHIFT = 0;
    static final long ACTIVE_ZONE_MASK = 65535L;
    static int m_nActiveZoneInsertPointer;
    static final int ACTIVE_ZONE_UPDATE_NONE = 0;
    static final int ACTIVE_ZONE_UPDATE_GROUP = 1;
    static final int ACTIVE_ZONE_UPDATE_MOVING = 2;
    static int m_nZoneArrayOffset;
    static int m_nZoneArrayNumZones;
    static int m_nZoneArrayUpdateNeeded;
    static int m_nZoneArrayOffsetedNumZones;
    static int m_nHitZonesInsertPointer;
    static int[] HIT_ZONES;
    static final int HIT_ZONE_ID_MASK = 65535;
    static final short HIT_ZONE_INVERT_Z_MASK = Short.MAX_VALUE;
    static final int HIT_ZONE_Z_SHIFT = 16;
    static int[] SORTING_ZONES;
    static final int SORTING_TOP_SHIFT = 20;
    static final int SORTING_LEFT_SHIFT = 10;
    static final int SORTING_INDEX_SHIFT = 0;
    static final int SORTING_INDEX_MASK = 1023;
    static long[] SWAPPING_ZONES;
    static long m_lScrollbarCoords;
    static boolean m_bScrollbarOnscreen;
    static boolean m_bHighlighted;
    static boolean m_bHighlightedSoftkeyRight;
    static boolean m_bHighlightedSoftkeyLeft;

    TouchController() {
    }

    static void init() {
        m_nPressInfo = new int[2];
        m_nReleaseInfo = new int[2];
        m_nDragInfo = new int[20];
        m_nLastTouchedInfo = new int[2];
        TouchController.clearTouchEventArrays();
        ACTIVE_ZONES = new long[85];
        ACTIVE_ZONE_ID = new short[85];
        HIT_ZONES = new int[85];
        m_nHitZonesInsertPointer = 0;
        ATOMIC_ZONES = new short[85];
        m_nAtomicZonesInsertPointer = 0;
        for (int i = 0; i < 85; ++i) {
            TouchController.ACTIVE_ZONES[i] = -1L;
            TouchController.ACTIVE_ZONE_ID[i] = -1;
            TouchController.HIT_ZONES[i] = -1;
            TouchController.ATOMIC_ZONES[i] = -1;
        }
        if (!m_bTouchInitalised) {
            TouchController.initZoneTypeRect();
        }
        m_nActiveZoneInsertPointer = 0;
        m_nZoneArrayOffset = -1;
        m_nZoneArrayNumZones = -1;
        m_nZoneArrayOffsetedNumZones = -1;
        m_nZoneArrayUpdateNeeded = 0;
        SORTING_ZONES = new int[85];
        SWAPPING_ZONES = new long[85];
        m_nVirtualKeyZone = -1;
        m_bTouchInitalised = true;
    }

    static boolean isTouchAllowed() {
        if (GFLoader.m_bLoading) {
            return false;
        }
        return GFUIState.m_nUIState != -1 || GameController.m_nGameState != 2 && GameController.m_nGameState != 3 && GameController.m_nGameState != 5;
    }

    static void clearTouchEventArrays() {
        for (int i = 0; i < 2; ++i) {
            TouchController.m_nPressInfo[i] = -1;
            TouchController.m_nReleaseInfo[i] = -1;
            for (int j = 0; j < 10; ++j) {
                TouchController.m_nDragInfo[i] = -1;
            }
            TouchController.m_nLastTouchedInfo[i] = -1;
        }
        m_nDragInsertPointer = 0;
        m_nDragUnhandledPointer = 0;
        m_bPressDirtyDataFlag = false;
        m_bDragDirtyDataFlag = false;
        m_bReleaseDirtyDataFlag = false;
        TouchController.resetHighlights();
        m_bTouchLock = false;
        m_nTouchHeldFrameCounter = 0;
    }

    static void initZoneTypeRect() {
        int n = 0;
        for (int i = 0; i < 44; ++i) {
            int n2 = TouchController.getStateArrayOffset(i);
            n = n2 + TouchController.getStateZoneCount(i);
            for (int j = n2; j < n; ++j) {
                if (TouchConstants.TOUCH_ZONE_TYPE[j] != 2) continue;
                int n3 = j;
                TouchConstants.TOUCH_ZONE_LEFT[n3] = (short)(TouchConstants.TOUCH_ZONE_LEFT[n3] - TouchController.getOrientedZonePadLeft(j));
                int n4 = j;
                TouchConstants.TOUCH_ZONE_TOP[n4] = (short)(TouchConstants.TOUCH_ZONE_TOP[n4] - TouchController.getOrientedZonePadTop(j));
                int n5 = j;
                TouchConstants.TOUCH_ZONE_RIGHT[n5] = (short)(TouchConstants.TOUCH_ZONE_RIGHT[n5] + TouchController.getOrientedZonePadRight(j));
                int n6 = j;
                TouchConstants.TOUCH_ZONE_BTM[n6] = (short)(TouchConstants.TOUCH_ZONE_BTM[n6] + TouchController.getOrientedZonePadBtm(j));
                TouchController.setTouchZoneDataInstantly(j, TouchConstants.TOUCH_ZONE_LEFT[j], TouchConstants.TOUCH_ZONE_TOP[j], TouchConstants.TOUCH_ZONE_RIGHT[j], TouchConstants.TOUCH_ZONE_BTM[j], true);
            }
        }
    }

    static void resetVars() {
        TouchController.clearActiveZoneData();
        m_nZoneArrayOffset = -1;
        m_nZoneArrayNumZones = -1;
        m_nZoneArrayOffsetedNumZones = -1;
        m_nZoneArrayUpdateNeeded = 0;
        m_lDragHoldStartTime = -1L;
        m_lDragHeldTime = 0L;
    }

    static void clearActiveZoneData() {
        if (m_nActiveZoneInsertPointer > 0) {
            for (int i = 0; i < 85; ++i) {
                TouchController.ACTIVE_ZONES[i] = -1L;
                TouchController.ACTIVE_ZONE_ID[i] = -1;
            }
            m_nActiveZoneInsertPointer = 0;
        }
        m_bActiveDuplicateZones = false;
    }

    static void resetAllTouchZonesPositions(boolean bl) {
        int n = 0;
        for (int i = 0; i < 44; ++i) {
            int n2 = TouchController.getStateArrayOffset(i);
            n = n2 + TouchController.getStateZoneCount(i);
            for (int j = n2; j < n; ++j) {
                if (TouchConstants.TOUCH_ZONE_TYPE[j] != 2) {
                    TouchConstants.TOUCH_ZONE_TOP[j] = -1;
                    TouchConstants.TOUCH_ZONE_LEFT[j] = -1;
                    TouchConstants.TOUCH_ZONE_BTM[j] = -1;
                    TouchConstants.TOUCH_ZONE_RIGHT[j] = -1;
                    continue;
                }
                if (!bl) continue;
                TouchConstants.TOUCH_ZONE_TOP[j] = -1;
                TouchConstants.TOUCH_ZONE_LEFT[j] = -1;
                TouchConstants.TOUCH_ZONE_BTM[j] = -1;
                TouchConstants.TOUCH_ZONE_RIGHT[j] = -1;
            }
        }
    }

    static void clearCurrentStateTouchZonePositions(boolean bl) {
        for (int i = m_nZoneArrayOffset; i < m_nZoneArrayOffsetedNumZones; ++i) {
            if (bl) {
                if ((TouchConstants.TOUCH_ZONE_FLAGS[i] & 4) == 0) continue;
                TouchConstants.TOUCH_ZONE_LEFT[i] = -1;
                TouchConstants.TOUCH_ZONE_TOP[i] = -1;
                TouchConstants.TOUCH_ZONE_RIGHT[i] = -1;
                TouchConstants.TOUCH_ZONE_BTM[i] = -1;
                continue;
            }
            TouchConstants.TOUCH_ZONE_LEFT[i] = -1;
            TouchConstants.TOUCH_ZONE_TOP[i] = -1;
            TouchConstants.TOUCH_ZONE_RIGHT[i] = -1;
            TouchConstants.TOUCH_ZONE_BTM[i] = -1;
        }
    }

    static void clearTouchZone(int n) {
        TouchConstants.TOUCH_ZONE_LEFT[n] = -1;
        TouchConstants.TOUCH_ZONE_TOP[n] = -1;
        TouchConstants.TOUCH_ZONE_RIGHT[n] = -1;
        TouchConstants.TOUCH_ZONE_BTM[n] = -1;
    }

    static int zoneUpdateNeeded() {
        int n = 0;
        boolean bl = m_nZoneArrayNumZones != 0;
        for (int i = m_nZoneArrayOffset; i < m_nZoneArrayOffsetedNumZones; ++i) {
            if ((TouchConstants.TOUCH_ZONE_FLAGS[i] & 4) == 0) {
                bl = false;
                if (TouchConstants.TOUCH_ZONE_LEFT[i] == -1) {
                    n = 1;
                    break;
                }
            } else if (TouchConstants.TOUCH_ZONE_LEFT[i] != -1) {
                bl = false;
            }
            if ((TouchConstants.TOUCH_ZONE_FLAGS[i] & 1) == 0) continue;
            n = 2;
        }
        if (bl && n == 0) {
            n = 1;
        }
        return n;
    }

    static void setClippedImgZoneData(int n, Graphics graphics) {
        if (m_nZoneArrayUpdateNeeded == 2 && n != -1 && (TouchConstants.TOUCH_ZONE_FLAGS[n] & 1) == 0) {
            return;
        }
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        TouchController.updateActiveZoneData(n, n2, n3, n2 + graphics.getClipWidth(), n3 + graphics.getClipHeight());
    }

    static void setImgZoneData(int n, int n2, int n3, int n4, int n5, int n6) {
        if (m_nZoneArrayUpdateNeeded == 2 && n != -1 && (TouchConstants.TOUCH_ZONE_FLAGS[n] & 1) == 0) {
            return;
        }
        if (n6 != 20) {
            if (n6 == 36) {
                n3 -= n5;
            } else if (n6 == 6) {
                n3 -= n5 >> 1;
            } else if (n6 == 33) {
                n2 -= n4 >> 1;
                n3 -= n5;
            } else if (n6 == 3) {
                n2 -= n4 >> 1;
                n3 -= n5 >> 1;
            } else if (n6 == 17) {
                n2 -= n4 >> 1;
            } else if (n6 == 40) {
                n2 -= n4;
                n3 -= n5;
            } else if (n6 == 10) {
                n2 -= n4;
                n3 -= n5 >> 1;
            } else if (n6 == 24) {
                n2 -= n4;
            }
        }
        TouchController.setTouchZoneDataInstantly(n, n2, n3, n2 + n4, n3 + n5, true);
        TouchController.updateActiveZoneData(n, TouchConstants.TOUCH_ZONE_LEFT[n], TouchConstants.TOUCH_ZONE_TOP[n], TouchConstants.TOUCH_ZONE_RIGHT[n], TouchConstants.TOUCH_ZONE_BTM[n]);
    }

    static void setTextZoneData(int n, int n2, int n3, int n4, int n5, int n6) {
        if (m_nZoneArrayUpdateNeeded == 2 && n != -1 && (TouchConstants.TOUCH_ZONE_FLAGS[n] & 1) == 0) {
            return;
        }
        if (n6 == 2) {
            n2 -= n4 / 2;
        } else if (n6 == 3) {
            n2 -= n4;
        } else {
            TouchController.updateActiveZoneData(n, n2, n3, n2 + n4, n3 + n5);
        }
    }

    static void updateActiveZoneData(int n, int n2, int n3, int n4, int n5) {
        if (m_nActiveZoneInsertPointer < 85) {
            TouchController.ACTIVE_ZONES[TouchController.m_nActiveZoneInsertPointer] = (long)n2 << 48 | (long)n3 << 32 | (long)n4 << 16 | (long)n5;
            TouchController.ACTIVE_ZONE_ID[TouchController.m_nActiveZoneInsertPointer] = (short)n;
            if (n == -1) {
                m_bActiveDuplicateZones = true;
            }
            ++m_nActiveZoneInsertPointer;
        }
    }

    static void setTouchZoneDataInstantly(int n, int n2, int n3, int n4, int n5, boolean bl) {
        TouchConstants.TOUCH_ZONE_LEFT[n] = (short)(n2 - TouchController.getOrientedZonePadLeft(n));
        TouchConstants.TOUCH_ZONE_TOP[n] = (short)(n3 - TouchController.getOrientedZonePadTop(n));
        TouchConstants.TOUCH_ZONE_RIGHT[n] = (short)(n4 + TouchController.getOrientedZonePadRight(n));
        TouchConstants.TOUCH_ZONE_BTM[n] = (short)(n5 + TouchController.getOrientedZonePadBtm(n));
        if (bl) {
            TouchController.setTouchZones(n, TouchConstants.TOUCH_ZONE_LEFT[n], TouchConstants.TOUCH_ZONE_TOP[n], TouchConstants.TOUCH_ZONE_RIGHT[n], TouchConstants.TOUCH_ZONE_BTM[n]);
        }
    }

    static void setTouchZones(int n, int n2, int n3, int n4, int n5) {
        int n6 = 2;
        int n7 = Layer.getDefaultX(n2, n3, n6);
        int n8 = Layer.getDefaultY(n2, n3, n6);
        int n9 = n4 - n2;
        int n10 = n5 - n3;
        int n11 = n9;
        int n12 = n10;
        if ((Layer.getLayerProperty(n6, 5) & 2) != 0) {
            n8 -= n9;
            n11 = n10;
            n12 = n9;
        } else if ((Layer.getLayerProperty(n6, 5) & 4) != 0) {
            n7 -= n10;
            n11 = n10;
            n12 = n9;
        }
        TouchConstants.TOUCH_ZONE_LEFT[n] = (short)n7;
        TouchConstants.TOUCH_ZONE_TOP[n] = (short)n8;
        TouchConstants.TOUCH_ZONE_RIGHT[n] = (short)(n7 + n11);
        TouchConstants.TOUCH_ZONE_BTM[n] = (short)(n8 + n12);
    }

    static short getOrientedZonePadLeft(int n) {
        if (TouchCallback.isOrientedLeft()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 32 & 0xFFFFL);
        }
        if (TouchCallback.isOrientedRight()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] & 0xFFFFL);
        }
        return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 48 & 0xFFFFL);
    }

    static short getOrientedZonePadRight(int n) {
        if (TouchCallback.isOrientedLeft()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] & 0xFFFFL);
        }
        if (TouchCallback.isOrientedRight()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 32 & 0xFFFFL);
        }
        return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 16 & 0xFFFFL);
    }

    static short getOrientedZonePadTop(int n) {
        if (TouchCallback.isOrientedLeft()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 16 & 0xFFFFL);
        }
        if (TouchCallback.isOrientedRight()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 48 & 0xFFFFL);
        }
        return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 32 & 0xFFFFL);
    }

    static short getOrientedZonePadBtm(int n) {
        if (TouchCallback.isOrientedLeft()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 48 & 0xFFFFL);
        }
        if (TouchCallback.isOrientedRight()) {
            return (short)(TouchConstants.TOUCH_ZONE_PAD[n] >> 16 & 0xFFFFL);
        }
        return (short)(TouchConstants.TOUCH_ZONE_PAD[n] & 0xFFFFL);
    }

    static void sortActiveDuplicateZoneData() {
        int n;
        int n2 = 0;
        for (n = 0; n < m_nActiveZoneInsertPointer; ++n) {
            if (ACTIVE_ZONE_ID[n] != -1) continue;
            int n3 = (int)(ACTIVE_ZONES[n] >>> 48 & 0xFFFFL);
            int n4 = (int)(ACTIVE_ZONES[n] >>> 32 & 0xFFFFL);
            TouchController.SORTING_ZONES[n2] = n4 << 20 | n3 << 10 | n;
            ++n2;
        }
        QSort.sort(SORTING_ZONES, 0, n2);
        System.arraycopy(ACTIVE_ZONES, 0, SWAPPING_ZONES, 0, m_nActiveZoneInsertPointer - 1);
        int n5 = m_nZoneArrayOffset;
        int n6 = 0;
        block1: for (int i = 0; i < m_nActiveZoneInsertPointer; ++i) {
            if (ACTIVE_ZONE_ID[i] != -1) continue;
            n = SORTING_ZONES[n6] & 0x3FF;
            ++n6;
            if (i != n) {
                TouchController.ACTIVE_ZONES[i] = SWAPPING_ZONES[n];
            }
            while (n5 < m_nZoneArrayOffsetedNumZones) {
                if ((TouchConstants.TOUCH_ZONE_FLAGS[n5] & 8) != 0) {
                    TouchController.ACTIVE_ZONE_ID[i] = TouchConstants.TOUCH_ZONE_ID[n5];
                    ++n5;
                    continue block1;
                }
                ++n5;
            }
        }
    }

    static void fillZoneArrays() {
        if (m_nActiveZoneInsertPointer > 0 && m_nZoneArrayUpdateNeeded != 0) {
            if (m_bActiveDuplicateZones) {
                TouchController.sortActiveDuplicateZoneData();
            }
            if (m_nZoneArrayUpdateNeeded == 1) {
                for (int i = 0; i < m_nActiveZoneInsertPointer; ++i) {
                    short s = ACTIVE_ZONE_ID[i];
                    short s2 = TouchController.getOrientedZonePadLeft(s);
                    short s3 = TouchController.getOrientedZonePadTop(s);
                    short s4 = TouchController.getOrientedZonePadRight(s);
                    short s5 = TouchController.getOrientedZonePadBtm(s);
                    TouchConstants.TOUCH_ZONE_LEFT[s] = (short)((ACTIVE_ZONES[i] >>> 48 & 0xFFFFL) - (long)s2);
                    TouchConstants.TOUCH_ZONE_TOP[s] = (short)((ACTIVE_ZONES[i] >>> 32 & 0xFFFFL) - (long)s3);
                    TouchConstants.TOUCH_ZONE_RIGHT[s] = (short)((ACTIVE_ZONES[i] >>> 16 & 0xFFFFL) + (long)s4);
                    TouchConstants.TOUCH_ZONE_BTM[s] = (short)((ACTIVE_ZONES[i] & 0xFFFFL) + (long)s5);
                    if (TouchConstants.TOUCH_ZONE_TYPE[s] != 0) continue;
                    TouchController.setTouchZones(s, TouchConstants.TOUCH_ZONE_LEFT[s], TouchConstants.TOUCH_ZONE_TOP[s], TouchConstants.TOUCH_ZONE_RIGHT[s], TouchConstants.TOUCH_ZONE_BTM[s]);
                }
            } else if (m_nZoneArrayUpdateNeeded == 2) {
                for (int i = 0; i < m_nActiveZoneInsertPointer; ++i) {
                    short s = ACTIVE_ZONE_ID[i];
                    if ((TouchConstants.TOUCH_ZONE_FLAGS[s] & 1) == 0) continue;
                    short s6 = TouchController.getOrientedZonePadLeft(s);
                    short s7 = TouchController.getOrientedZonePadTop(s);
                    short s8 = TouchController.getOrientedZonePadRight(s);
                    short s9 = TouchController.getOrientedZonePadBtm(s);
                    TouchConstants.TOUCH_ZONE_LEFT[s] = (short)((ACTIVE_ZONES[i] >>> 48 & 0xFFFFL) - (long)s6);
                    TouchConstants.TOUCH_ZONE_TOP[s] = (short)((ACTIVE_ZONES[i] >>> 32 & 0xFFFFL) - (long)s7);
                    TouchConstants.TOUCH_ZONE_RIGHT[s] = (short)((ACTIVE_ZONES[i] >>> 16 & 0xFFFFL) + (long)s8);
                    TouchConstants.TOUCH_ZONE_BTM[s] = (short)((ACTIVE_ZONES[i] & 0xFFFFL) + (long)s9);
                }
            }
            TouchController.clearActiveZoneData();
            m_nZoneArrayUpdateNeeded = TouchController.zoneUpdateNeeded();
        }
    }

    static void setScrollbarZone(int n, int n2, int n3, int n4) {
        m_lScrollbarCoords = (long)n << 48 | (long)n2 << 32 | (long)(n + n3) << 16 | (long)(n2 + n4);
        m_bScrollbarOnscreen = true;
    }

    static void updatePressInfo(int n, int n2) {
        TouchController.m_nPressInfo[0] = n;
        TouchController.m_nPressInfo[1] = n2;
        TouchController.m_nLastTouchedInfo[0] = n;
        TouchController.m_nLastTouchedInfo[1] = n2;
        m_bPressDirtyDataFlag = true;
        m_bTouchLock = true;
        m_lDragHoldStartTime = System.currentTimeMillis();
        m_lDragHeldTime = 0L;
    }

    static void updateReleaseInfo(int n, int n2) {
        if (m_bTouchLock) {
            TouchController.m_nReleaseInfo[0] = n;
            TouchController.m_nReleaseInfo[1] = n2;
            m_bReleaseDirtyDataFlag = true;
        }
        m_lDragHoldStartTime = -1L;
    }

    static void updateDragInfo(int n, int n2) {
        if (m_nDragInsertPointer != m_nDragUnhandledPointer || !m_bDragDirtyDataFlag) {
            TouchController.m_nDragInfo[TouchController.m_nDragInsertPointer * 2 + 0] = n;
            TouchController.m_nDragInfo[TouchController.m_nDragInsertPointer * 2 + 1] = n2;
            m_nDragInsertPointer = (m_nDragInsertPointer + 1) % 10;
            m_bDragDirtyDataFlag = true;
        }
        m_lDragHeldTime = System.currentTimeMillis() - m_lDragHoldStartTime;
        m_bTouchLock = true;
    }

    static void skipRemainingTransparentActions() {
        m_nHitZonesInsertPointer = 0;
    }

    static void changeState(int n) {
        m_nTouchState = n;
        TouchController.clearActiveZoneData();
        m_nZoneArrayOffset = TouchController.getStateArrayOffset(n);
        m_nZoneArrayNumZones = TouchController.getStateZoneCount(n);
        m_nZoneArrayOffsetedNumZones = m_nZoneArrayOffset + m_nZoneArrayNumZones;
        m_lScrollbarCoords = -1L;
        m_bScrollbarOnscreen = false;
        TouchController.clearTouchEventArrays();
        TouchController.skipRemainingTransparentActions();
        m_nAtomicZonesInsertPointer = 0;
        if (TouchCallback.menuNeedsScrolling(n)) {
            TouchController.clearCurrentStateTouchZonePositions(true);
            m_nZoneArrayUpdateNeeded = 1;
        } else {
            m_nZoneArrayUpdateNeeded = TouchController.zoneUpdateNeeded();
        }
    }

    static void changeOrientation() {
        TouchController.clearActiveZoneData();
        TouchController.resetAllTouchZonesPositions(true);
        m_nZoneArrayUpdateNeeded = 1;
    }

    static void update() {
        TouchController.fillZoneArrays();
        if (m_bTouchLock) {
            ++m_nTouchHeldFrameCounter;
        }
        TouchController.resetHighlights();
    }

    static void resetHighlights() {
        m_bHighlighted = false;
        m_bHighlightedSoftkeyLeft = false;
        m_bHighlightedSoftkeyRight = false;
    }

    static void handleInput() {
        if (m_bPressDirtyDataFlag) {
            TouchController.handlePressEvent();
        } else if (m_bDragDirtyDataFlag) {
            TouchController.handleDragEvent();
        } else if (m_bReleaseDirtyDataFlag && m_bTouchLock) {
            TouchController.handleReleaseEvent();
        } else if (m_bTouchLock) {
            TouchController.handleLastTouchedEvent();
        }
        TouchCallback.updateKeysPressed();
    }

    static void handlePressEvent() {
        TouchController.checkZones(m_nPressInfo[0], m_nPressInfo[1], true);
        for (int i = 0; i < m_nHitZonesInsertPointer; ++i) {
            short s = (short)(HIT_ZONES[i] & 0xFFFF);
            TouchController.handleAction(TouchConstants.TOUCH_ZONE_ACTION_PRESS[s], s, m_nPressInfo[0], m_nPressInfo[1]);
        }
        m_bPressDirtyDataFlag = false;
    }

    static void handleLastTouchedEvent() {
        TouchController.checkZones(m_nLastTouchedInfo[0], m_nLastTouchedInfo[1], false);
        if (m_nAtomicZonesInsertPointer > 0) {
            TouchController.updateAtomicValidity();
        }
        if (m_nHitZonesInsertPointer > 0) {
            for (int i = 0; i < m_nHitZonesInsertPointer; ++i) {
                short s = (short)(HIT_ZONES[i] & 0xFFFF);
                if (!TouchController.allowAction(s)) continue;
                TouchController.handleAction(TouchConstants.TOUCH_ZONE_ACTION_DRAG[s], s, m_nLastTouchedInfo[0], m_nLastTouchedInfo[1]);
            }
        }
        if (m_lDragHoldStartTime != -1L) {
            m_lDragHeldTime = System.currentTimeMillis() - m_lDragHoldStartTime;
        }
    }

    static void handleReleaseEvent() {
        TouchController.checkZones(m_nReleaseInfo[0], m_nReleaseInfo[1], false);
        if (m_nAtomicZonesInsertPointer > 0) {
            TouchController.updateAtomicValidity();
        }
        for (int i = 0; i < m_nHitZonesInsertPointer; ++i) {
            short s = (short)(HIT_ZONES[i] & 0xFFFF);
            if (!TouchController.allowAction(s)) continue;
            TouchController.handleAction(TouchConstants.TOUCH_ZONE_ACTION_RELEASE[s], s, m_nReleaseInfo[0], m_nReleaseInfo[1]);
        }
        TouchController.m_nLastTouchedInfo[0] = -1;
        TouchController.m_nLastTouchedInfo[1] = -1;
        m_bReleaseDirtyDataFlag = false;
        m_bTouchLock = false;
        m_nTouchHeldFrameCounter = 0;
        if (m_nVirtualKeyZone != -1) {
            TouchController.simulateKeyRelease();
        }
        m_nAtomicZonesInsertPointer = 0;
    }

    static void handleDragEvent() {
        boolean bl = true;
        int n = m_nDragUnhandledPointer;
        while (m_bDragDirtyDataFlag) {
            int n2;
            int n3;
            if (!bl && n == m_nDragInsertPointer) {
                m_nDragUnhandledPointer = n;
                m_bDragDirtyDataFlag = false;
                break;
            }
            int n4 = m_nDragInfo[n * 2 + 0];
            int n5 = m_nDragInfo[n * 2 + 1];
            TouchController.checkZones(n4, n5, false);
            if (m_nAtomicZonesInsertPointer > 0) {
                TouchController.updateAtomicValidity();
            }
            if (m_nHitZonesInsertPointer > 0) {
                for (n3 = 0; n3 < m_nHitZonesInsertPointer; ++n3) {
                    n2 = HIT_ZONES[n3] & 0xFFFF;
                    if (!TouchController.allowAction(n2)) continue;
                    TouchController.handleAction(TouchConstants.TOUCH_ZONE_ACTION_DRAG[n2], n2, n4, n5);
                }
            }
            if (m_bScrollbarOnscreen) {
                n3 = (int)(m_lScrollbarCoords >>> 48 & 0xFFFFL);
                n2 = (int)(m_lScrollbarCoords >>> 32 & 0xFFFFL);
                int n6 = (int)(m_lScrollbarCoords >>> 16 & 0xFFFFL);
                int n7 = (int)(m_lScrollbarCoords & 0xFFFFL);
                int n8 = m_nLastTouchedInfo[0];
                int n9 = m_nLastTouchedInfo[1];
                if (n4 > n3 && n4 < n6 && n5 < n7 && n5 > n2) {
                    int n10 = 0;
                    int n11 = 0;
                    if (!bl) {
                        int n12 = (n - 1 + 10) % 10 * 2 + 0;
                        int n13 = (n - 1 + 10) % 10 * 2 + 1;
                        n10 = n4 - m_nDragInfo[n12];
                        n11 = n5 - m_nDragInfo[n13];
                    } else if (n8 != -1 && n8 > n3 && n8 < n6 && n9 < n7 && n9 > n2) {
                        n10 = n4 - n8;
                        n11 = n5 - n9;
                    }
                    if (TouchCallback.isOrientedLeft() || TouchCallback.isOrientedRight()) {
                        TouchController.handleScrollBar(n10, n11, true);
                    } else {
                        TouchController.handleScrollBar(n10, n11, false);
                    }
                }
            }
            bl = false;
            TouchController.m_nLastTouchedInfo[0] = n4;
            TouchController.m_nLastTouchedInfo[1] = n5;
            n = (n + 1) % 10;
        }
    }

    static boolean checkCurrentHitZone(int n) {
        for (int i = 0; i < m_nHitZonesInsertPointer; ++i) {
            int n2 = HIT_ZONES[i] & 0xFFFF;
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    static void handleScrollBar(int n, int n2, boolean bl) {
        if (bl) {
            if (TouchCallback.isOrientedRight()) {
                TouchCallback.scrollTextWindow(n);
            } else {
                TouchCallback.scrollTextWindow(-n);
            }
        } else {
            TouchCallback.scrollTextWindow(-n2);
        }
    }

    static void checkZones(int n, int n2, boolean bl) {
        short s;
        int n3;
        int n4 = -1;
        m_nHitZonesInsertPointer = 0;
        for (n3 = m_nZoneArrayOffset; n3 < m_nZoneArrayOffsetedNumZones; ++n3) {
            if (n < TouchConstants.TOUCH_ZONE_LEFT[n3] || n > TouchConstants.TOUCH_ZONE_RIGHT[n3] || n2 > TouchConstants.TOUCH_ZONE_BTM[n3] || n2 < TouchConstants.TOUCH_ZONE_TOP[n3]) continue;
            s = (short)(~TouchConstants.TOUCH_ZONE_Z[n3] & Short.MAX_VALUE);
            TouchController.HIT_ZONES[TouchController.m_nHitZonesInsertPointer] = s << 16 | TouchConstants.TOUCH_ZONE_ID[n3];
            m_nHitZonesInsertPointer = Math.min(m_nHitZonesInsertPointer + 1, 85);
            if (n4 == -1 || TouchConstants.TOUCH_ZONE_Z[n4] < TouchConstants.TOUCH_ZONE_Z[n3]) {
                n4 = n3;
            }
            if (!bl || (TouchConstants.TOUCH_ZONE_FLAGS[n3] & 0x10) == 0) continue;
            TouchController.ATOMIC_ZONES[TouchController.m_nAtomicZonesInsertPointer] = (short)n3;
            ++m_nAtomicZonesInsertPointer;
        }
        if (m_nHitZonesInsertPointer > 1) {
            if ((TouchConstants.TOUCH_ZONE_FLAGS[n4] & 2) != 0) {
                QSort.sort(HIT_ZONES, 0, m_nHitZonesInsertPointer);
                for (n3 = 1; n3 < m_nHitZonesInsertPointer; ++n3) {
                    s = (short)(HIT_ZONES[n3] & 0xFFFF);
                    if ((TouchConstants.TOUCH_ZONE_FLAGS[s] & 2) != 0) continue;
                    m_nHitZonesInsertPointer = n3 + 1;
                    break;
                }
            } else {
                TouchController.HIT_ZONES[0] = n4;
                m_nHitZonesInsertPointer = 1;
            }
        }
        if (!TouchController.checkCurrentHitZone(m_nVirtualKeyZone)) {
            TouchController.simulateKeyRelease();
        }
    }

    static void simulateKeyPress(int n, int n2) {
        if (m_nVirtualKeyZone == -1) {
            m_nVirtualKeyZone = n;
            m_nSimulatedUnhandledKeyFlags |= n2;
            m_nSimulatedPressedKeyFlags |= n2;
            m_nSimulatedHeldKeyFlags |= n2;
        }
    }

    static void simulateKeyRelease() {
        m_nVirtualKeyZone = -1;
        m_nSimulatedReleasedKeyFlags = m_nSimulatedPressedKeyFlags;
        m_nSimulatedPressedKeyFlags = 0;
        m_nSimulatedHeldKeyFlags = 0;
    }

    static int GetSimulatedLastPressedKeys() {
        int n = m_nSimulatedUnhandledKeyFlags;
        m_nSimulatedUnhandledKeyFlags = 0;
        return n;
    }

    static int GetSimulatedHeldKeys() {
        return m_nSimulatedHeldKeyFlags;
    }

    static int GetSimulatedLastReleasedKey() {
        int n = m_nSimulatedReleasedKeyFlags;
        m_nSimulatedReleasedKeyFlags = 0;
        return n;
    }

    static void updateAtomicValidity() {
        for (int i = 0; i < m_nAtomicZonesInsertPointer; ++i) {
            boolean bl = false;
            for (int j = 0; j < m_nHitZonesInsertPointer; ++j) {
                short s = (short)(HIT_ZONES[j] & 0xFFFF);
                if (ATOMIC_ZONES[i] != s) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            TouchController.ATOMIC_ZONES[i] = -1;
        }
    }

    static boolean allowAction(int n) {
        if ((TouchConstants.TOUCH_ZONE_FLAGS[n] & 0x10) != 0) {
            for (int i = 0; i < m_nAtomicZonesInsertPointer; ++i) {
                if (ATOMIC_ZONES[i] != n) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    static void handleAction(int n, int n2, int n3, int n4) {
        switch (n) {
            case -1: {
                return;
            }
            case 68: {
                TouchCallback.setUIMenuCurrentSelection(TouchConstants.TOUCH_ZONE_TYPEID[n2]);
                return;
            }
            case 69: {
                m_bHighlightedSoftkeyRight = true;
                return;
            }
            case 70: {
                m_bHighlightedSoftkeyLeft = true;
                return;
            }
            case 71: {
                GFUIState.switchStateOrPerformAction(35, false, false);
                GFMain.clearKeysPressed();
                return;
            }
        }
        if (!TouchGameController.handleAction(n, n2, n3, n4)) {
            TouchCallback.gotoStateOrPerformAction(n);
        }
    }

    static int getStateArrayOffset(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += TouchConstants.TOUCH_ZONE_ID[n2] + 1;
        }
        return n2 + 1;
    }

    static int getStateZoneCount(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += TouchConstants.TOUCH_ZONE_ID[n2] + 1;
        }
        return TouchConstants.TOUCH_ZONE_ID[n2];
    }

    static {
        m_nTouchState = -1;
    }
}

