/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui;

import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.layout.ScreenStack;
import com.slg.j2me.lib.sys.Application;
import com.slg.j2me.lib.sys.FixedPoint;

public class Transition {
    int time;
    int duration;
    GuiContainer target;
    int event;
    int x0;
    int y0;
    int dx;
    int dy;

    public Transition(int _delay, int _duration, GuiContainer _target, int _event, int _dx, int _dy) {
        this.time = -_delay;
        this.duration = _duration;
        this.target = _target;
        this.event = _event;
        this.x0 = this.target.clipRect.x0;
        this.y0 = this.target.clipRect.y0;
        this.dx = _dx;
        this.dy = _dy;
    }

    public void process() {
        this.time += Application.lastFrameTime;
        if (this.time > this.duration) {
            if (this.event > 0) {
                ScreenStack.instance.handleEvent(this.event);
            }
            ScreenStack.finishTask(this);
            this.time = this.duration;
            this.target.clipRect.x0 = (short)(this.x0 + this.dx);
            this.target.clipRect.y0 = (short)(this.y0 + this.dy);
        } else if (this.time > 0) {
            long t = ((long)this.time << 22) / (long)this.duration;
            int s = FixedPoint.sinLut((int)t);
            this.target.clipRect.x0 = (short)(this.x0 + (s * this.dx < 0 ? -(-(s * this.dx) >> 16) : s * this.dx >> 16));
            this.target.clipRect.y0 = (short)(this.y0 + (s * this.dy < 0 ? -(-(s * this.dy) >> 16) : s * this.dy >> 16));
        }
    }
}

