/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.pizza.animated;

import com.rocktasticgames.pizza.animated.AnimatedElement;
import com.rocktasticgames.pizza.main.MainActivity;
import com.rocktasticgames.pizza.utils.ColorMatrixColorFilter;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CookItem
extends AnimatedElement {
    public static final ColorMatrixColorFilter filter_burnt = new ColorMatrixColorFilter(4);
    public static final long BURN_CLEAR_TIME = 1500L;
    private Image readybmp;
    private Image selection;
    private Image plusbmp;
    private boolean empty;
    private long cook_time;
    private long start_time;
    private String itemres = "";
    private boolean ready_signal = false;
    private boolean warn_signal = false;
    private boolean burnt_signal = false;
    private boolean isplus = false;

    public CookItem(MainActivity mainActivity, String string, Image image, float f, float f2, float f3, float f4, int n, long l, long l2, long l3) {
        super(mainActivity, string, f, f2, f3, f4, n, l);
        this.empty = false;
        this.start_time = l2;
        this.cook_time = l3;
        this.readybmp = image;
        this.itemres = string;
    }

    public CookItem(Image image, Image image2, float f, float f2, float f3, float f4, int n, long l) {
        super(image, f, f2, f3, f4, n, l);
        this.empty = true;
        this.readybmp = image2;
    }

    public void setCooking(MainActivity mainActivity, String string, Image image, long l, long l2) {
        super.setPNG(string);
        this.readybmp = image;
        this.empty = false;
        this.start_time = l;
        this.cook_time = l2;
        this.itemres = string;
    }

    public String getItemResource() {
        return this.itemres;
    }

    public void setEmpty(Image image, Image image2) {
        super.setPNG(image);
        this.readybmp = image2;
        this.empty = true;
        this.ready_signal = false;
        this.warn_signal = false;
        this.burnt_signal = false;
        this.isplus = false;
    }

    public void setReadyBMP(Image image) {
        this.readybmp = image;
    }

    public void setPlusBMP(Image image) {
        this.plusbmp = image;
        this.isplus = true;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isPlus() {
        return this.isplus;
    }

    public boolean isSelectable() {
        return !this.empty && !this.burnt_signal;
    }

    public void setSelected(MainActivity mainActivity, String string) {
        try {
            this.selection = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deselect() {
        if (this.selection != null) {
            this.selection = null;
            System.gc();
        }
    }

    public boolean fetchReadySignal(long l) {
        if (!(this.empty || this.burnt_signal || l <= this.start_time + this.cook_time || this.ready_signal || this.warn_signal)) {
            this.ready_signal = true;
            this.start_time = l;
            return true;
        }
        return false;
    }

    public boolean fetchWarnSignal(long l) {
        if (!this.empty && !this.burnt_signal && l > this.start_time + 9000L && this.ready_signal && !this.warn_signal) {
            this.ready_signal = false;
            this.warn_signal = true;
            return true;
        }
        return false;
    }

    public boolean fetchBurntSignal(long l) {
        if (!this.empty && this.warn_signal && l > this.start_time + 18000L) {
            this.burnt_signal = true;
            this.warn_signal = false;
            this.start_time = l;
            return true;
        }
        return false;
    }

    public boolean clearBurntTime(long l) {
        return this.burnt_signal && l > this.start_time + 1500L;
    }

    public boolean isReady(long l) {
        return this.ready_signal;
    }

    public boolean isWarn(long l) {
        return this.warn_signal;
    }

    protected void drawTime(Graphics graphics, long l) {
        if (this.isplus) {
            graphics.drawImage(this.plusbmp, 0, 0, 3);
            return;
        }
        if (this.selection != null) {
            graphics.drawImage(this.selection, 0, 0, 3);
        }
        if (this.burnt_signal) {
            graphics.drawImage(filter_burnt.applyTo(this.bmp), 0, 0, 3);
        } else {
            this.draw(graphics);
        }
        if ((this.ready_signal || this.warn_signal) && !this.empty) {
            graphics.drawImage(this.readybmp, 0, 0, 3);
        } else if (l > this.start_time && !this.empty && !this.burnt_signal) {
            int[] nArray = new int[this.bmp.getWidth() * this.bmp.getHeight()];
            this.bmp.getRGB(nArray, 0, this.bmp.getWidth(), 0, 0, this.bmp.getWidth(), this.bmp.getHeight());
            int n = 0;
            while ((long)n < (long)this.bmp.getWidth() * ((long)this.bmp.getHeight() * Math.max(this.start_time + this.cook_time - l, 0L) / this.cook_time)) {
                nArray[n] = nArray[n] & 0xFF000000 | (nArray[n] & 0xFE0000) / 2 | (nArray[n] & 0xFE00) / 2 | (nArray[n] & 0xFE) / 2;
                ++n;
            }
            graphics.drawImage(Image.createRGBImage((int[])nArray, (int)this.bmp.getWidth(), (int)this.bmp.getHeight(), (boolean)true), 0, 0, 3);
        }
    }
}

