/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.hospital.views;

import com.rocktasticgames.hospital.animated.AnimatedElement;
import com.rocktasticgames.hospital.animated.AnimatedOrder;
import com.rocktasticgames.hospital.animated.StatusBar;
import com.rocktasticgames.hospital.c2m.C2MValues;
import com.rocktasticgames.hospital.main.MainActivity;
import com.rocktasticgames.hospital.utils.ColorMatrixColorFilter;
import com.rocktasticgames.hospital.utils.GraphicsContainer;
import com.rocktasticgames.hospital.utils.List;
import com.rocktasticgames.hospital.utils.MotionEvent;
import com.rocktasticgames.hospital.views.MenuView;
import javax.microedition.lcdui.Image;

public class MapView {
    public static final ColorMatrixColorFilter filter_dark = new ColorMatrixColorFilter(1);
    public static final String[][] house_ids = new String[][]{{"building_1_1", "building_1_2", "building_1_3", "building_1_4", "building_1_5", "building_1_6", "building_1_7"}, {"building_2_1", "building_2_2", "building_2_3", "building_2_4", "building_2_5", "building_2_6", "building_2_7"}, {"building_3_1", "building_3_2", "building_3_3", "building_3_4", "building_3_5", "building_3_6", "building_3_7"}, {"building_4_1", "building_4_2", "building_4_3", "building_4_4", "building_4_5", "building_4_6", "building_4_7"}, {"building_5_1", "building_5_2", "building_5_3", "building_5_4", "building_5_5", "building_5_6", "building_5_7"}, {"building_6_1", "building_6_2", "building_6_3", "building_6_4", "building_6_5", "building_6_6", "building_6_7"}, {"building_7_1", "building_7_2", "building_7_3", "building_7_4", "building_7_5", "building_7_6", "building_7_7"}};
    private AnimatedElement[] deliverers = new AnimatedElement[5];
    private Image[] delivery;
    public static final long LIGHT_FLASH_TIME = 350L;
    private AnimatedElement hosp;
    private AnimatedElement lights1;
    private AnimatedElement lights2;
    private int last_dialog = 0;
    public static final ColorMatrixColorFilter filter_light = new ColorMatrixColorFilter(3);
    public static final float DASH_SIZE = 0.0833333f;
    public static final float TIME_RADIUS = 0.4f;
    public static final float OUT_RADIUS = 0.425f;
    private Image background;
    private MainActivity activity;
    private StatusBar topbar;
    private AnimatedElement pause;
    private AnimatedElement twood;
    private AnimatedElement bwood;
    private AnimatedElement map;
    private AnimatedElement kitchen;
    private AnimatedElement[][] houses;
    private boolean loaded = false;
    private List aelist;
    private List menus;
    private int select_option = 0;
    private int select_delivery = -1;
    private int on_delivery = -1;
    private int select_housej = -1;
    private int select_housei = -1;
    private int dest_housej = -1;
    private int dest_housei = -1;
    private long last_time = 0L;
    private AnimatedElement appplus;
    private boolean upgradeloaded = false;
    private AnimatedElement upcanv;
    private AnimatedElement upimg;
    private AnimatedElement upback;
    private AnimatedElement upupgrade;
    private int upgrade_cost;
    private List drawlist;
    private boolean dialogloaded = false;
    private String[] dialog_lines;
    private int dialog_index;
    private String dialog_res;
    private AnimatedElement dialog_box;
    private AnimatedElement dialog_img;
    private AnimatedElement dialog_btn;
    private int dialog_seq = 0;
    private boolean options_loaded = false;
    private AnimatedElement optioncanv;
    private AnimatedElement quit;
    private AnimatedElement music;
    private AnimatedElement sound;
    private AnimatedElement back;
    private boolean leveluploaded = false;
    private AnimatedElement leveluppanel;
    private AnimatedElement levelupowner;
    private AnimatedElement levelupstar;
    private AnimatedElement levelupok;
    private boolean isvictory = false;
    private AnimatedElement post_dialog_target = null;

    public MapView(MainActivity mainActivity) {
        this.activity = mainActivity;
        this.aelist = new List();
        this.menus = new List();
        try {
            this.background = Image.createImage((String)"/background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawlist = new List();
    }

    public void destroy() {
        int n;
        this.background = null;
        if (this.topbar != null) {
            this.topbar = null;
            this.pause = null;
            this.kitchen = null;
            this.map = null;
            this.topbar = null;
            this.hosp = null;
            this.lights1 = null;
            this.lights2 = null;
        }
        if (this.appplus != null) {
            this.appplus = null;
        }
        this.appplus = null;
        if (this.upgradeloaded) {
            this.unloadUpgrade();
        }
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        if (this.options_loaded) {
            this.unloadOptions();
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
        }
        for (n = 0; n < this.deliverers.length && this.deliverers[n] != null; ++n) {
            this.deliverers[n] = null;
        }
        for (n = 0; n < this.delivery.length && this.delivery[n] != null; ++n) {
            this.delivery[n] = null;
        }
        for (n = 0; n < this.houses.length; ++n) {
            for (int i = 0; i < this.houses[n].length; ++i) {
                this.houses[n][i] = null;
            }
        }
        System.gc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        AnimatedElement animatedElement2 = null;
        boolean bl = false;
        if (!(!this.activity.isPaused() || this.upgradeloaded || this.dialogloaded || this.options_loaded || this.leveluploaded)) {
            return this.pause;
        }
        if (this.leveluploaded) {
            return this.levelupok;
        }
        if (this.dialogloaded) {
            return this.dialog_btn;
        }
        if (this.post_dialog_target != null) {
            AnimatedElement animatedElement3 = this.post_dialog_target;
            this.post_dialog_target = null;
            return animatedElement3;
        }
        switch (n) {
            case 1: {
                int n2;
                int n3;
                if (this.options_loaded) {
                    if (animatedElement != this.back) return this.quit;
                    return this.sound;
                }
                for (n3 = 0; n3 < this.activity.getDeliverers(); ++n3) {
                    if (animatedElement == this.deliverers[n3]) {
                        if (this.appplus != null) {
                            return this.appplus;
                        }
                        if (this.on_delivery == -1) return this.pause;
                        for (n2 = 0; n2 < this.houses.length; ++n2) {
                            for (int i = 0; i < this.houses.length; ++i) {
                                if (this.houses[n2][i].getFilter() != filter_light) continue;
                                return this.houses[n2][i];
                            }
                        }
                        continue;
                    }
                    if (animatedElement != this.kitchen || this.activity.getOrders().size() <= 0) continue;
                    return this.deliverers[n3];
                }
                if (this.appplus != null) {
                    if (animatedElement == this.appplus) {
                        if (this.on_delivery == -1) return this.pause;
                        for (n3 = 0; n3 < this.houses.length; ++n3) {
                            for (n2 = 0; n2 < this.houses.length; ++n2) {
                                if (this.houses[n3][n2].getFilter() != filter_light) continue;
                                return this.houses[n3][n2];
                            }
                        }
                    } else if (animatedElement == this.kitchen) {
                        return this.appplus;
                    }
                }
                if (animatedElement == this.kitchen) {
                    return this.pause;
                }
                for (n3 = 0; n3 < this.houses.length; ++n3) {
                    for (n2 = 0; n2 < this.houses.length; ++n2) {
                        if (animatedElement != this.houses[n3][n2]) continue;
                        return this.pause;
                    }
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (!this.upgradeloaded) return this.kitchen;
                if (animatedElement == this.upupgrade) {
                    return this.upupgrade;
                }
                if (animatedElement != this.upback) return this.kitchen;
                return this.upback;
            }
            case 6: {
                int n4;
                int n5;
                if (this.options_loaded) {
                    if (animatedElement != this.quit) return this.back;
                    return this.sound;
                }
                if (animatedElement == this.pause) {
                    if (this.on_delivery != -1) {
                        for (n5 = 0; n5 < this.houses.length; ++n5) {
                            for (n4 = 0; n4 < this.houses.length; ++n4) {
                                if (this.houses[n5][n4].getFilter() != filter_light) continue;
                                return this.houses[n5][n4];
                            }
                        }
                    } else {
                        animatedElement = this.houses[0][0];
                    }
                }
                for (n5 = 0; n5 < this.houses.length; ++n5) {
                    for (n4 = 0; n4 < this.houses[n5].length; ++n4) {
                        if (animatedElement != this.houses[n5][n4] && (animatedElement != this.appplus || this.appplus == null)) continue;
                        if (this.appplus != null && animatedElement != this.appplus) {
                            return this.appplus;
                        }
                        for (int i = 0; i < this.activity.getDeliverers(); ++i) {
                            if (this.activity.getOrders().size() <= 0) continue;
                            return this.deliverers[i];
                        }
                        return this.kitchen;
                    }
                }
                if (animatedElement == this.kitchen) {
                    return this.kitchen;
                }
                if (!this.upgradeloaded) return this.kitchen;
                if (animatedElement == this.upupgrade) {
                    return this.upupgrade;
                }
                if (animatedElement != this.upback) return this.kitchen;
                return this.upback;
            }
            case 5: {
                int n6;
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.kitchen) {
                    return this.kitchen;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upback;
                    }
                    if (animatedElement == this.upback) {
                        return this.upback;
                    }
                }
                if (animatedElement == this.appplus && this.appplus != null) {
                    return this.appplus;
                }
                if (this.on_delivery != -1) {
                    for (n6 = 0; n6 < this.houses.length; ++n6) {
                        for (int i = 0; i < this.houses[n6].length; ++i) {
                            if (animatedElement == this.houses[n6][i]) {
                                if (animatedElement2 == null) {
                                    animatedElement2 = this.houses[n6][i];
                                }
                                bl = true;
                                continue;
                            }
                            if (this.houses[n6][i].getFilter() != filter_light) continue;
                            animatedElement2 = this.houses[n6][i];
                        }
                    }
                    if (bl) {
                        return animatedElement2;
                    }
                }
                for (n6 = 0; n6 < this.activity.getDeliverers(); ++n6) {
                    if (animatedElement != this.deliverers[n6]) continue;
                    ++n6;
                    while (n6 < this.activity.getDeliverers()) {
                        if (this.activity.getOrders().size() > 0) {
                            return this.deliverers[n6];
                        }
                        ++n6;
                    }
                    return animatedElement;
                }
                return this.kitchen;
            }
            case 2: {
                int n7;
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (animatedElement == this.pause) {
                    return this.pause;
                }
                if (animatedElement == this.kitchen) {
                    return this.kitchen;
                }
                if (this.upgradeloaded) {
                    if (animatedElement == this.upupgrade) {
                        return this.upupgrade;
                    }
                    if (animatedElement == this.upback) {
                        return this.upupgrade;
                    }
                }
                if (animatedElement == this.appplus && this.appplus != null) {
                    return this.appplus;
                }
                if (this.on_delivery != -1) {
                    for (n7 = 0; n7 < this.houses.length; ++n7) {
                        for (int i = 0; i < this.houses[n7].length; ++i) {
                            if (animatedElement == this.houses[n7][i]) {
                                if (animatedElement2 == null) {
                                    animatedElement2 = this.houses[n7][i];
                                }
                                bl = true;
                                continue;
                            }
                            if (this.houses[n7][i].getFilter() != filter_light) continue;
                            animatedElement2 = this.houses[n7][i];
                        }
                    }
                    if (bl) {
                        return animatedElement2;
                    }
                }
                for (n7 = 0; n7 < this.activity.getDeliverers(); ++n7) {
                    if (animatedElement != this.deliverers[n7]) continue;
                    --n7;
                    while (n7 >= 0) {
                        if (this.activity.getOrders().size() > 0) {
                            return this.deliverers[n7];
                        }
                        --n7;
                    }
                    return animatedElement;
                }
                return this.kitchen;
            }
        }
        return animatedElement;
    }

    private void loadResources(float f, float f2, float f3) {
        int n;
        long l = this.last_time;
        this.topbar = new StatusBar(this.activity, this.activity.topbar, 0.44596353f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.pause = new AnimatedElement(this.activity.pausebutton, 0.9433594f, 0.046875f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.05346027f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.kitchen = new AnimatedElement(this.activity.kitchenbutton, 0.24869792f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.91175395f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.map = new AnimatedElement(this.activity.mapbutton, 0.75130206f, 0.9238281f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.91175395f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.bwood = new AnimatedElement(this.activity.wood, 0.5f, 0.8847656f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.8293665f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.hosp = new AnimatedElement(this.activity, "mapscreen_hosp_entrance", 0.5f, 0.75634766f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.7861589f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.lights1 = new AnimatedElement(this.activity, "mapscreen_lights1", 0.5f, 0.6816406f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.67704135f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.lights2 = new AnimatedElement(this.activity, "mapscreen_lights2", 0.5f, 0.6816406f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.67704135f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.houses = new AnimatedElement[7][7];
        this.twood = new AnimatedElement(0.5f, -0.1274414f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) - 0.062614426f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f, f2, f3, 0, l);
        this.twood.setPNG(this.activity.wood);
        for (n = 0; n < this.houses.length; ++n) {
            for (int i = 0; i < this.houses[n].length; ++i) {
                this.houses[n][i] = new AnimatedElement(this.activity, house_ids[n][i], (0.1f + 0.2f * (float)i) * 5.0f / 7.0f, 0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f + f * (0.15f * (float)n - 0.5f) * 5.0f / 7.0f, f2, f3, 0, l);
            }
        }
        this.aelist.addAll(new AnimatedElement[]{this.bwood, this.twood, this.topbar, this.pause, this.kitchen, this.map});
        this.aelist.add(this.hosp);
        this.delivery = new Image[5];
        for (n = 0; n < this.activity.getDeliverers(); ++n) {
            try {
                this.delivery[n] = Image.createImage((String)("/" + MainActivity.delivery_icons[this.activity.getDeliveryUpgrade()] + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deliverers[n] = new AnimatedElement(this.activity, MainActivity.ambulance_pics[this.activity.getDeliveryUpgrade()], 0.25f + (float)n * 0.5f, this.map.getY(0L) / f3 - 0.2233073f * f2 / f3, f2, f3, 0, 0L);
            if (this.activity.getDeliveryState(n) > 2) {
                this.deliverers[n].animateOut(l);
            }
            this.aelist.add(this.deliverers[n]);
        }
        this.activity.getCanvas().setFocus(this.kitchen);
        if (this.activity.getDeliveryUpgrade() < 2 && this.activity.getLevel() >= C2MValues.DELIVERY_UPGRADES[this.activity.getDeliveryUpgrade() * 2] && this.activity.getMoney() >= C2MValues.DELIVERY_UPGRADES[this.activity.getDeliveryUpgrade() * 2 + 1]) {
            this.appplus = new AnimatedElement(this.activity, "upgradeplus", this.houses[6][3].getX(0L) / f2, this.houses[6][3].getY(0L) / f3, f2, f3, 0, l);
            this.menus.add(this.appplus);
            if (!this.activity.getSharedPref().getBoolean("upgrade_shown_D_U" + (this.activity.getDeliveryUpgrade() + 1), false)) {
                this.activity.getPrefEditor().putBoolean("upgrade_shown_D_U" + (this.activity.getDeliveryUpgrade() + 1), true);
                this.activity.getPrefEditor().commit();
                this.loadUpgrade(f, f2, f3, MainActivity.deliveryups[this.activity.getDeliveryUpgrade()], C2MValues.DELIVERY_UPGRADES[this.activity.getDeliveryUpgrade() * 2 + 1]);
            }
        }
        this.loaded = true;
        this.deliveryInit();
    }

    public boolean goBack() {
        this.activity.invalidate();
        if (this.upgradeloaded) {
            this.unloadUpgrade();
            return true;
        }
        if (this.leveluploaded) {
            this.unloadLevelUp();
            return true;
        }
        if (this.dialogloaded) {
            this.unloadDialog();
            return true;
        }
        if (!this.activity.isPaused()) {
            this.activity.togglePause();
            float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
            float f2 = this.background.getWidth() * 3 / 4;
            float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
            this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
            return true;
        }
        this.activity.togglePause();
        this.unloadOptions();
        return true;
    }

    private void loadDialog(float f, float f2, float f3, String string, String string2) {
        this.post_dialog_target = this.activity.getCanvas().getFocus();
        if (this.dialogloaded) {
            this.unloadDialog();
        }
        this.post_dialog_target = this.deliverers[0];
        this.activity.pause();
        this.dialog_res = string;
        this.dialog_index = 0;
        int n = 1;
        float f4 = 0.0f;
        string2 = string2.toUpperCase();
        string2 = string2 + " ";
        int n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                ++n;
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        this.dialog_lines = new String[n];
        this.dialog_lines[0] = " ";
        n = 0;
        f4 = 0.0f;
        n2 = 0;
        while (n2 + 1 < string2.length()) {
            if (f4 + (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                int n3 = n;
                this.dialog_lines[n3] = this.dialog_lines[n3] + string2.substring(n2, string2.indexOf(" ", n2 + 1));
            } else {
                f4 = this.activity.getKomika().measure(string2.substring(n2, string2.indexOf(" ", n2 + 1)));
                this.dialog_lines[++n] = string2.substring(n2, string2.indexOf(" ", n2 + 1));
            }
            n2 = string2.indexOf(" ", n2 + 1);
        }
        long l = this.last_time;
        this.dialog_box = new AnimatedElement(this.activity, "dialoguebox", 0.5f, this.bwood.getY(0L) / f3 + -0.5449219f * f, f2, f3, 0, l);
        this.dialog_img = new AnimatedElement(this.activity, string, 0.69466144f, this.bwood.getY(0L) / f3 + -0.79752606f * f, f2, f3, 0, l);
        this.dialog_btn = this.dialog_lines.length > 3 ? new AnimatedElement(this.activity, "button_dialoguenext", 0.5f, this.bwood.getY(0L) / f3 + -0.35546875f * f, f2, f3, 0, l) : new AnimatedElement(this.activity, "button_dialogueok", 0.5f, this.bwood.getY(0L) / f3 + -0.35546875f * f, f2, f3, 0, l);
        this.menus.addAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialogloaded = true;
        this.activity.getCanvas().setFocus(this.dialog_btn);
    }

    private void unloadDialog() {
        this.menus.removeAll(new AnimatedElement[]{this.dialog_img, this.dialog_box, this.dialog_btn});
        this.dialog_img = null;
        this.dialog_box = null;
        this.dialog_btn = null;
        this.dialogloaded = false;
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
        float f2 = this.background.getWidth() * 3 / 4;
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        if (this.dialog_seq > 0) {
            String string;
            --this.dialog_seq;
            ++this.last_dialog;
            switch (C2MValues.TUTORIAL_SPEAKER[this.last_dialog - 100]) {
                default: {
                    string = "dialogue_admin";
                    break;
                }
                case 1: {
                    string = "dialogue_doctor";
                    break;
                }
                case 2: {
                    string = "dialogue_dispatcher";
                    break;
                }
                case 3: {
                    string = "dialogue_unhappyadmin";
                }
            }
            this.activity.getCanvas().setFocus(this.post_dialog_target);
            this.loadDialog(f2 / f3, f2, f3, string, C2MValues.TUTORIAL_DIALOG[this.activity.getLanguage()][this.last_dialog - 100]);
        } else {
            this.activity.resume();
        }
    }

    private void loadUpgrade(float f, float f2, float f3, String string, int n) {
        this.upgrade_cost = n;
        float f4 = 0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f;
        long l = this.last_time;
        this.upcanv = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "ambulance_upgade_canvas", 0.5f, f4 + -0.032552082f * f, f2, f3, 0, l);
        this.upimg = new AnimatedElement(this.activity, string, 0.5f, f4 + -0.11393229f * f, f2, f3, 0, l);
        this.upback = new AnimatedElement(this.activity, "button_back", 0.65690106f, f4 + 0.2298177f * f, f2, f3, 0, l);
        this.upupgrade = new AnimatedElement(this.activity, "button_upgrade", 0.34114584f, f4 + 0.2298177f * f, f2, f3, 0, l);
        this.menus.addAll(new AnimatedElement[]{this.upcanv, this.upimg, this.upback, this.upupgrade});
        this.activity.getCanvas().setFocus(this.upupgrade);
        this.upgradeloaded = true;
    }

    private void unloadUpgrade() {
        this.menus.removeAll(new AnimatedElement[]{this.upcanv, this.upimg, this.upback, this.upupgrade});
        this.activity.getCanvas().setFocus(this.kitchen);
        this.upgradeloaded = false;
    }

    private void loadOptions(float f, float f2, float f3, long l) {
        this.optioncanv = new AnimatedElement(this.activity, "options_canvas", 0.5f, f * 800.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.quit = new AnimatedElement(this.activity, this.activity.getLanguageCode() + "button_quitgame", 0.5f, f * 678.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity, "toggleon_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l) : new AnimatedElement(this.activity, "toggleoff_sound", 0.5f, f * 879.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.back = new AnimatedElement(this.activity, "button_back", 0.2578125f, f * 1098.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.menus.addAll(new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back});
        this.options_loaded = true;
        this.activity.getCanvas().setFocus(this.sound);
    }

    private void unloadOptions() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.quit, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.menus.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.options_loaded = false;
    }

    public void loadLevelUp(float f, float f2, float f3) {
        this.activity.pause();
        float f4 = f3 * (0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f);
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_levelup", 0.5f, f4 / f3 + 0.2063802f * f, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, f4 / f3 + -0.140625f * f, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.5f, f4 / f3 + 0.22526042f * f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, f4 / f3 + 0.36002603f * f, f2, f3, 0, l);
        this.menus.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.leveluploaded = true;
    }

    public void unloadLevelUp() {
        this.activity.resume();
        this.leveluploaded = false;
        this.menus.removeAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupstar, this.levelupok});
        this.levelupowner.recycle();
        this.leveluppanel.recycle();
        this.levelupstar.recycle();
        this.levelupok.recycle();
        this.deliveryInit();
        this.activity.checkMessage(14);
    }

    public void deliveryInit() {
        if (this.activity.getDeliverers() > this.activity.getSharedPref().getInt("delivery_shown", 1)) {
            float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
            float f2 = this.background.getWidth() * 3 / 4;
            float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
            this.dialog_seq = 0;
            this.select_option = 0;
            this.activity.getPrefEditor().putInt("delivery_shown", this.activity.getDeliverers());
            this.activity.getPrefEditor().commit();
        }
    }

    public void onLevelUp() {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
        float f2 = this.background.getWidth() * 3 / 4;
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        int n = this.activity.getDeliverers() - 1;
        if (this.delivery[n] == null) {
            long l = this.last_time;
            try {
                this.delivery[n] = Image.createImage((String)("/" + MainActivity.delivery_icons[this.activity.getDeliveryUpgrade()] + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.deliverers[n] = new AnimatedElement(this.activity, MainActivity.ambulance_pics[this.activity.getDeliveryUpgrade()], 0.25f + (float)n * 0.5f, this.map.getY(0L) / f3 - 0.2233073f * f2 / f3, f2, f3, 0, 0L);
            this.aelist.add(this.deliverers[n]);
        }
        this.loadLevelUp(f2 / f3, f2, f3);
    }

    public void onVictory() {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
        float f2 = this.background.getWidth() * 3 / 4;
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        float f4 = f2 / f3;
        float f5 = f3 * (0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f);
        this.activity.pause();
        long l = this.last_time;
        this.leveluppanel = new AnimatedElement(this.activity, "panel_victory", 0.5f, f5 / f3 + 0.23828125f * f4, f2, f3, 0, l);
        this.levelupowner = new AnimatedElement(this.activity, "shop_and_owner", 0.5f, f5 / f3 + -0.140625f * f4, f2, f3, 0, l);
        this.levelupstar = new AnimatedElement(this.activity, "star", 0.0f, 0.0f, f2, f3, 0, l);
        this.levelupok = new AnimatedElement(this.activity, "button_dialogueok", 0.5f, f5 / f3 + 0.421875f * f4, f2, f3, 0, l);
        this.menus.addAll(new AnimatedElement[]{this.levelupowner, this.leveluppanel, this.levelupok});
        this.leveluploaded = true;
        this.isvictory = true;
    }

    public boolean checkMessage(int n) {
        String string;
        if (n < 100) {
            return false;
        }
        if (this.activity.getSharedPref().getBoolean("msg_" + (n -= 100), false)) {
            return false;
        }
        this.last_dialog = n + 100;
        if (n == 15) {
            this.dialog_seq = 1;
        } else if (n == 24) {
            this.dialog_seq = 1;
        } else if (n == 35) {
            this.dialog_seq = 1;
        } else if (n == 37) {
            this.dialog_seq = 1;
        } else if (n == 39) {
            this.dialog_seq = 1;
        }
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
        float f2 = this.background.getWidth() * 3 / 4;
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        switch (C2MValues.TUTORIAL_SPEAKER[n]) {
            default: {
                string = "dialogue_admin";
                break;
            }
            case 1: {
                string = "dialogue_doctor";
                break;
            }
            case 2: {
                string = "dialogue_dispatcher";
                break;
            }
            case 3: {
                string = "dialogue_unhappyadmin";
            }
        }
        this.activity.playSound("dialogue_popup");
        this.loadDialog(f2 / f3, f2, f3, string, C2MValues.TUTORIAL_DIALOG[this.activity.getLanguage()][n]);
        this.activity.getPrefEditor().putBoolean("msg_" + n, true);
        this.activity.getPrefEditor().commit();
        return true;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        int n;
        int n2;
        long l = this.activity.getTime();
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
        float f2 = this.background.getWidth() * 3 / 4;
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        if (!this.loaded) {
            this.loadResources(f2 / f3, f2, f3);
        }
        this.activity.refresh(l);
        if (this.activity.getLevel() == 3 && !this.activity.isPaused()) {
            if (this.activity.getDeliveryState(0) <= 2) {
                if (!this.checkMessage(135) && this.on_delivery == -1 && this.activity.getOrders().size() > 0) {
                    if (l % 5000L < 2500L) {
                        this.checkMessage(156);
                    } else {
                        this.activity.getPrefEditor().putBoolean("msg_56", false);
                        this.activity.getPrefEditor().commit();
                    }
                }
            } else {
                this.checkMessage(137);
            }
        }
        graphicsContainer.setColor(-8224126);
        graphicsContainer.fillScreen();
        graphicsContainer.setColor(-9539986);
        float f4 = this.houses[0][1].getX(0L) - this.houses[0][0].getX(0L);
        float f5 = this.houses[1][0].getY(0L) - this.houses[0][0].getY(0L);
        float f6 = 0.12f;
        float f7 = 0.05f;
        int n3 = this.activity.getDeliverers();
        block11: for (n2 = 0; n2 < n3; ++n2) {
            switch (this.activity.getDeliveryState(n2)) {
                case 0: 
                case 1: 
                case 2: {
                    if (!this.deliverers[n2].isAnimatingOut()) continue block11;
                    this.deliverers[n2].animate(4, l);
                    continue block11;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.deliverers[n2].isAnimatingOut()) {
                        this.deliverers[n2].animate(3, l);
                        this.deliverers[n2].animateOut(l);
                    }
                    this.checkMessage(12);
                }
            }
        }
        for (n2 = 0; n2 <= this.houses.length; ++n2) {
            graphicsContainer.fillRect((int)(this.houses[0][0].getX(0L) + f4 * ((float)n2 - 0.5f - f6)), (int)(this.houses[0][0].getY(0L) - f5 * (0.5f - f7 + f6)), (int)(f4 * (2.0f * f6)), (int)(this.houses[this.houses.length - 1][0].getY(0L) + f5 * (0.5f + f7 + f6)) - (int)(this.houses[0][0].getY(0L) - f5 * (0.5f - f7 + f6)));
        }
        for (n2 = 0; n2 <= this.houses[0].length; ++n2) {
            graphicsContainer.fillRect((int)(this.houses[0][0].getX(0L) - f4 * (0.5f + f6)), (int)(this.houses[0][0].getY(0L) + f5 * ((float)n2 - 0.5f + f7 - f6)), (int)(this.houses[0][this.houses[0].length - 1].getX(0L) + f4 * (0.5f + f6)) - (int)(this.houses[0][0].getX(0L) - f4 * (0.5f + f6)), (int)(f5 * (2.0f * f6)));
        }
        for (n2 = 0; n2 < this.houses.length; ++n2) {
            for (int i = 0; i < this.houses[n2].length; ++i) {
                this.houses[n2][i].render(graphicsContainer, l);
            }
        }
        graphicsContainer.setColor(-6711040);
        f6 = 0.015f;
        for (n2 = 0; n2 <= this.houses.length; ++n2) {
            for (float f8 = 0.0f; f8 < (float)this.houses.length; f8 += 0.116666615f) {
                graphicsContainer.fillRect((int)(this.houses[0][0].getX(0L) + f4 * ((float)n2 - 0.5f - f6)), (int)(this.houses[0][0].getY(0L) + f5 * (f8 - 0.5f + f7)), (int)(f4 * (2.0f * f6)), (int)(f5 * 0.058333308f));
            }
        }
        for (n2 = 0; n2 <= this.houses[0].length; ++n2) {
            for (float f9 = 0.0f; f9 < (float)this.houses[0].length; f9 += 0.1666666f) {
                graphicsContainer.fillRect((int)(this.houses[0][0].getX(0L) + f4 * (f9 - 0.5f)), (int)(this.houses[0][0].getY(0L) + f5 * ((float)n2 - 0.5f + f7 - f6)), (int)(f4 * 0.0833333f), (int)(f5 * (2.0f * f6)));
            }
        }
        graphicsContainer.setColor(-9539986);
        f6 = 0.12f;
        for (n2 = 0; n2 <= this.houses.length; ++n2) {
            for (int i = 0; i <= this.houses[0].length; ++i) {
                graphicsContainer.fillRect((int)(this.houses[0][0].getX(0L) + f4 * ((float)n2 - 0.5f - f6)), (int)(this.houses[0][0].getY(0L) + f5 * ((float)i - 0.5f + f7 - f6)), (int)(f4 * (2.0f * f6)), (int)(f5 * (2.0f * f6)));
            }
        }
        for (n2 = 0; n2 < this.aelist.size(); ++n2) {
            ((AnimatedElement)this.aelist.get(n2)).render(graphicsContainer, l);
        }
        if (this.activity.getDeliveryState(0) > 2 || this.activity.getDeliveryState(1) > 2) {
            if (l % 700L < 350L) {
                this.lights1.render(graphicsContainer, l);
            } else {
                this.lights2.render(graphicsContainer, l);
            }
        }
        this.drawlist.clear();
        this.drawlist.addAll(this.activity.getOrders());
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.activity.getDeliveryItem(n2, 0) == null) continue;
            if (!this.activity.getDeliveryItem(n2, 0).isDelivered()) {
                this.drawlist.add(this.activity.getDeliveryItem(n2, 0));
            }
            if (this.activity.getDeliveryItem(n2, 0) == this.activity.getDeliveryItem(n2, 1) || this.activity.getDeliveryItem(n2, 1).isDelivered()) continue;
            this.drawlist.add(this.activity.getDeliveryItem(n2, 1));
        }
        for (n2 = 0; n2 < this.drawlist.size(); ++n2) {
            AnimatedElement animatedElement = this.houses[((AnimatedOrder)this.drawlist.get(n2)).getRow()][((AnimatedOrder)this.drawlist.get(n2)).getColumn()];
            float f10 = 4.0f * ((AnimatedOrder)this.drawlist.get(n2)).getRemaining(l);
            if (animatedElement.getFilter() == filter_dark) {
                graphicsContainer.setColor(-12320768);
            } else {
                graphicsContainer.setColor(-65536);
            }
            graphicsContainer.fillRect((int)(animatedElement.getX(0L) - f4 * 0.425f), (int)(animatedElement.getY(0L) - f5 * 0.425f), (int)(f4 * (float)Math.min(1000, (int)(f10 * 1000.0f)) / 1000.0f * 0.425f * 2.0f), (int)(f4 * 0.05f));
            graphicsContainer.fillRect((int)(animatedElement.getX(0L) + f4 * 0.375f), (int)(animatedElement.getY(0L) - f5 * 0.425f), (int)(f4 * 0.05f), (int)(f5 * ((float)Math.min(2000, Math.max(1000, (int)(f10 * 1000.0f))) / 1000.0f - 1.0f) * 0.425f * 2.0f));
            graphicsContainer.fillRect((int)(animatedElement.getX(0L) - f4 * ((float)Math.min(3000, Math.max(2000, (int)(f10 * 1000.0f))) / 1000.0f - 2.5f) * 0.425f * 2.0f), (int)(animatedElement.getY(0L) + f5 * 0.4f - f4 * 0.025f), (int)(f4 * ((float)Math.min(3000, Math.max(2000, (int)(f10 * 1000.0f))) / 1000.0f - 2.0f) * 0.425f * 2.0f), (int)(f4 * 0.05f));
            graphicsContainer.fillRect((int)(animatedElement.getX(0L) - f4 * 0.425f), (int)(animatedElement.getY(0L) - f5 * ((float)Math.max(3000, (int)(f10 * 1000.0f)) / 1000.0f - 3.5f) * 0.425f * 2.0f), (int)(f4 * 0.05f), (int)(f5 * ((float)Math.max(3000, (int)(f10 * 1000.0f)) / 1000.0f - 3.0f) * 0.425f * 2.0f));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            switch (n2) {
                case 0: {
                    graphicsContainer.setColor(-16750900);
                    break;
                }
                case 1: {
                    graphicsContainer.setColor(-4521984);
                    break;
                }
                case 2: {
                    graphicsContainer.setColor(-16729344);
                    break;
                }
                case 3: {
                    graphicsContainer.setColor(-4474112);
                    break;
                }
                case 4: {
                    graphicsContainer.setColor(-65281);
                }
            }
            graphicsContainer.translate((int)(this.houses[0][0].getX(0L) + f4 * 0.02f * (float)(n2 + 2)), (int)(this.houses[0][0].getY(0L) + f5 * (0.5f + 0.02f * (float)(n2 + 2))));
            this.activity.getPath(n2).render(graphicsContainer, 0.04f * f4, 0.04f * f5);
            graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            graphicsContainer.translate((int)((0.1f + 0.2f * this.activity.getDeliveryX(n2)) * 5.0f / 7.0f * f2), (int)((0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f + f2 / f3 * (0.15f * this.activity.getDeliveryY(n2) - 0.425f) * 5.0f / 7.0f) * f3));
            int[] nArray = new int[this.delivery[n2].getWidth() * this.delivery[n2].getHeight()];
            int[] nArray2 = new int[nArray.length];
            this.delivery[n2].getRGB(nArray, 0, this.delivery[n2].getWidth(), 0, 0, this.delivery[n2].getWidth(), this.delivery[n2].getHeight());
            if (this.activity.getDeliverRot(n2) == 1 || this.activity.getDeliverRot(n2) == 2) {
                for (n = 0; n < this.delivery[n2].getHeight(); ++n) {
                    for (n4 = 0; n4 < this.delivery[n2].getWidth(); ++n4) {
                        nArray2[n * this.delivery[n2].getWidth() + n4] = nArray[(this.delivery[n2].getHeight() - n - 1) * this.delivery[n2].getWidth() + n4];
                    }
                }
                for (n = 0; n < this.delivery[n2].getHeight(); ++n) {
                    for (n4 = 0; n4 < this.delivery[n2].getWidth(); ++n4) {
                        nArray[n * this.delivery[n2].getWidth() + n4] = nArray2[n * this.delivery[n2].getWidth() + n4];
                    }
                }
            }
            if (this.activity.getDeliverRot(n2) % 2 == 1) {
                for (n = 0; n < this.delivery[n2].getHeight(); ++n) {
                    for (n4 = 0; n4 < this.delivery[n2].getWidth(); ++n4) {
                        nArray2[n * this.delivery[n2].getWidth() + n4] = nArray[this.delivery[n2].getWidth() * ((n * this.delivery[n2].getWidth() + n4) % this.delivery[n2].getHeight()) + (n * this.delivery[n2].getWidth() + n4) / this.delivery[n2].getHeight()];
                    }
                }
                for (n = 0; n < this.delivery[n2].getHeight(); ++n) {
                    for (n4 = 0; n4 < this.delivery[n2].getWidth(); ++n4) {
                        nArray[n * this.delivery[n2].getWidth() + n4] = nArray2[n * this.delivery[n2].getWidth() + n4];
                    }
                }
            }
            if (this.activity.getDeliverRot(n2) % 2 == 1) {
                graphicsContainer.drawImage(Image.createRGBImage((int[])nArray, (int)this.delivery[n2].getHeight(), (int)this.delivery[n2].getWidth(), (boolean)true), 0, 0, 3);
            } else {
                graphicsContainer.drawImage(Image.createRGBImage((int[])nArray, (int)this.delivery[n2].getWidth(), (int)this.delivery[n2].getHeight(), (boolean)true), 0, 0, 3);
            }
            graphicsContainer.translate(-((int)((0.1f + 0.2f * this.activity.getDeliveryX(n2)) * 5.0f / 7.0f * f2)), -((int)((0.40185547f * (1.0f - (f3 / f2 - 1.3333334f) * 9.0f / 4.0f) + 0.38484073f * (f3 / f2 - 1.3333334f) * 9.0f / 4.0f + f2 / f3 * (0.15f * this.activity.getDeliveryY(n2) - 0.425f) * 5.0f / 7.0f) * f3)));
        }
        if (this.upgradeloaded || this.dialogloaded) {
            this.activity.pause();
        }
        if (!this.options_loaded) {
            for (n2 = 0; n2 < this.menus.size(); ++n2) {
                ((AnimatedElement)this.menus.get(n2)).render(graphicsContainer, l);
            }
        }
        if (this.leveluploaded) {
            if (this.isvictory) {
                graphicsContainer.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.20507812f * f2));
                this.activity.getBrady().renderString(graphicsContainer, -1, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.20507812f * f2)));
                for (n2 = 0; n2 < C2MValues.TEXT_VICTORY[this.activity.getLanguage()].length; ++n2) {
                    graphicsContainer.translate((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n2].toUpperCase()) / 2)), (int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n2) / 2048.0f * 4.0f / 3.0f * f2));
                    this.activity.getKomika().renderString(graphicsContainer, -1, C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n2].toUpperCase());
                    graphicsContainer.translate(-((int)(f2 / 2.0f - (float)(this.activity.getKomika().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][n2].toUpperCase()) / 2))), -((int)(this.leveluppanel.getY(l) + (-181.0f + 70.0f * (float)n2) / 2048.0f * 4.0f / 3.0f * f2)));
                }
            } else {
                graphicsContainer.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.17317708f * f2));
                this.activity.getBrady().renderString(graphicsContainer, -1, C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_CONGRATULATIONS[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.17317708f * f2)));
                graphicsContainer.translate((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2)), (int)(this.leveluppanel.getY(l) + -0.10221354f * f2));
                this.activity.getBrady().renderString(graphicsContainer, -1, C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]);
                graphicsContainer.translate(-((int)(f2 / 2.0f - (float)(this.activity.getBrady().measure(C2MValues.TEXT_REACHED_LEVEL[this.activity.getLanguage()]) / 2))), -((int)(this.leveluppanel.getY(l) + -0.10221354f * f2)));
                graphicsContainer.translate((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2)), (int)(this.leveluppanel.getY(l) + -0.022786459f * f2));
                this.activity.getCartoon().renderString(graphicsContainer, -16746616, String.valueOf(this.activity.getLevel()));
                graphicsContainer.translate(-((int)(f2 / 2.0f - (float)(this.activity.getCartoon().measure(String.valueOf(this.activity.getLevel())) / 2))), -((int)(this.leveluppanel.getY(l) + -0.022786459f * f2)));
            }
        } else if (this.dialogloaded) {
            for (n2 = 0; n2 < this.menus.size(); ++n2) {
                ((AnimatedElement)this.menus.get(n2)).render(graphicsContainer, l);
            }
            graphicsContainer.translate((int)(f2 * 159.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.71875f * f2));
            if (this.dialog_res == "dialogue_admin") {
                this.activity.getCartoon().renderString(graphicsContainer, -16777216, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][0]);
            } else if (this.dialog_res == "dialogue_doctor") {
                this.activity.getCartoon().renderString(graphicsContainer, -16777216, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][1]);
            } else if (this.dialog_res == "dialogue_dispatcher") {
                this.activity.getCartoon().renderString(graphicsContainer, -16777216, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][2]);
            } else if (this.dialog_res == "dialogue_unhappyadmin") {
                this.activity.getCartoon().renderString(graphicsContainer, -16777216, C2MValues.CHARACTER_NAMES[this.activity.getLanguage()][3]);
            }
            graphicsContainer.translate(-((int)(f2 * 159.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.71875f * f2)));
            graphicsContainer.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.5807292f * f2));
            this.activity.getKomika().renderString(graphicsContainer, -1, this.dialog_lines[this.dialog_index]);
            graphicsContainer.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.5807292f * f2)));
            if (this.dialog_lines.length > this.dialog_index + 1) {
                graphicsContainer.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.52213544f * f2));
                this.activity.getKomika().renderString(graphicsContainer, -1, this.dialog_lines[this.dialog_index + 1]);
                graphicsContainer.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.52213544f * f2)));
            }
            if (this.dialog_lines.length > this.dialog_index + 2) {
                graphicsContainer.translate((int)(f2 * 195.0f / 1536.0f), (int)(this.bwood.getY(0L) + -0.46354166f * f2));
                this.activity.getKomika().renderString(graphicsContainer, -1, this.dialog_lines[this.dialog_index + 2]);
                graphicsContainer.translate(-((int)(f2 * 195.0f / 1536.0f)), -((int)(this.bwood.getY(0L) + -0.46354166f * f2)));
            }
        } else if (this.upgradeloaded) {
            graphicsContainer.translate((int)(this.upcanv.getX(0L) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_UPGRADE_AVAILABLE[this.activity.getLanguage()]) / 2)), (int)(this.upcanv.getY(0L) - (float)this.upcanv.getHeight() * this.activity.getCanvas().getHFactor() * 0.42f));
            this.activity.getCartoon().renderString(graphicsContainer, -16777216, C2MValues.TEXT_UPGRADE_AVAILABLE[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.upcanv.getX(0L) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_UPGRADE_AVAILABLE[this.activity.getLanguage()]) / 2))), -((int)(this.upcanv.getY(0L) - (float)this.upcanv.getHeight() * this.activity.getCanvas().getHFactor() * 0.42f)));
            String string = C2MValues.TEXT_AMBULANCE[this.activity.getLanguage()];
            String[] stringArray = new String[]{C2MValues.TEXT_DELIVERY_SPEED[this.activity.getLanguage()], C2MValues.TEXT_UPTO_1[this.activity.getLanguage()] + string + C2MValues.TEXT_UPTO_2[this.activity.getLanguage()], C2MValues.TEXT_UPGRADE_COST[this.activity.getLanguage()] + "  $" + this.upgrade_cost, C2MValues.TEXT_YOUR_CASH[this.activity.getLanguage()] + "   $" + this.activity.getMoney()};
            float[] fArray = new float[]{-0.79f, -0.615f, 0.521f, 0.685f};
            for (n = 0; n < fArray.length; ++n) {
                if (n < 2) {
                    int n5 = n;
                    fArray[n5] = fArray[n5] + 0.26f;
                    continue;
                }
                int n6 = n;
                fArray[n6] = fArray[n6] + 0.16f;
            }
            for (n = 0; n < 4; ++n) {
                graphicsContainer.translate((int)this.upimg.getX(0L) - this.activity.getBrady().measure(stringArray[n]) / 2, (int)(this.upimg.getY(0L) + (float)this.upimg.getWidth() * fArray[n]));
                this.activity.getBrady().renderString(graphicsContainer, -16777216, stringArray[n]);
                graphicsContainer.translate(-((int)this.upimg.getX(0L)) + this.activity.getBrady().measure(stringArray[n]) / 2, -((int)(this.upimg.getY(0L) + (float)this.upimg.getWidth() * fArray[n])));
            }
        }
        boolean bl = false;
        if (this.activity.isPaused() && !this.upgradeloaded && !this.dialogloaded && !this.leveluploaded) {
            long l2 = System.currentTimeMillis();
            if (!this.options_loaded) {
                this.loadOptions(f2 / f3, f2, f3, l2);
            }
            for (n = 0; n < this.menus.size(); ++n) {
                if (((AnimatedElement)this.menus.get(n)).render(graphicsContainer, l2)) continue;
                bl = true;
            }
            graphicsContainer.translate((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2)), (int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f)));
            this.activity.getCartoon().renderString(graphicsContainer, -1, C2MValues.TEXT_PAUSED[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.optioncanv.getX(l2) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_PAUSED[this.activity.getLanguage()]) / 2))), -((int)(f2 * 408.0f / 1536.0f + f3 * (1.0f - f2 / f3 * 4.0f / 3.0f))));
            graphicsContainer.translate((int)(this.quit.getX(l2) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2)), (int)(this.quit.getY(l2) - (float)(this.activity.getCanvas().getRZHeight() * 7 / 320 / 2)));
            this.activity.getBrady().renderString(graphicsContainer, -1, C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]);
            graphicsContainer.translate(-((int)(this.quit.getX(l2) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2))), -((int)(this.quit.getY(l2) - (float)(this.activity.getCanvas().getRZHeight() * 7 / 320 / 2))));
        }
        if (!this.activity.isPaused() || bl) {
            this.activity.invalidate();
        }
        this.last_time = l;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        if (!this.loaded) {
            return false;
        }
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 21: {
                        this.unloadLevelUp();
                        break;
                    }
                    case 18: {
                        this.activity.loadAll();
                        this.activity.openMainMenu();
                        break;
                    }
                    case 19: {
                        this.activity.getPrefEditor().putBoolean("sound_on", !this.activity.getSharedPref().getBoolean("sound_on", true));
                        this.activity.getPrefEditor().putBoolean("music_on", !this.activity.getSharedPref().getBoolean("music_on", true));
                        this.activity.getPrefEditor().commit();
                        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
                            this.sound.setPNG("toggleon_sound");
                            this.activity.getMusic().startMusic();
                        } else {
                            this.sound.setPNG("toggleoff_sound");
                            this.activity.getMusic().stopMusic();
                        }
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        this.unloadOptions();
                        this.activity.resume();
                        break;
                    }
                    case 8: {
                        this.dialog_index += 3;
                        if (this.dialog_lines.length > this.dialog_index) {
                            if (this.dialog_lines.length <= this.dialog_index + 3) {
                                this.dialog_btn.setPNG("button_dialogueok");
                            }
                            this.dialog_btn.setFilter(null);
                            break;
                        }
                        this.unloadDialog();
                        break;
                    }
                    case 1: {
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) {
                            this.kitchen.setFilter(null);
                            break;
                        }
                        this.activity.openKitchen();
                        break;
                    }
                    case 7: {
                        this.pause.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        this.activity.togglePause();
                        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
                        float f2 = this.background.getWidth() * 3 / 4;
                        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
                        this.loadOptions(f2 / f3, f2, f3, System.currentTimeMillis());
                        break;
                    }
                    case 2: {
                        int n2;
                        this.deliverers[this.select_delivery].setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        if (this.select_delivery == this.on_delivery) {
                            this.on_delivery = -1;
                            this.select_delivery = -1;
                            for (int i = 0; i < this.houses.length; ++i) {
                                for (int j = 0; j < this.houses.length; ++j) {
                                    this.houses[i][j].setFilter(null);
                                }
                            }
                            break;
                        }
                        this.checkMessage(155);
                        for (n2 = 0; n2 < this.houses.length; ++n2) {
                            for (int i = 0; i < this.houses[n2].length; ++i) {
                                this.houses[n2][i].setFilter(filter_dark);
                            }
                        }
                        for (n2 = 0; n2 < this.activity.getOrders().size(); ++n2) {
                            if (((AnimatedOrder)this.activity.getOrders().get(n2)).isTaken()) continue;
                            this.houses[((AnimatedOrder)this.activity.getOrders().get(n2)).getRow()][((AnimatedOrder)this.activity.getOrders().get(n2)).getColumn()].setFilter(filter_light);
                        }
                        this.on_delivery = this.select_delivery;
                        this.select_delivery = -1;
                        this.dest_housej = -1;
                        this.dest_housei = -1;
                        break;
                    }
                    case 3: {
                        int n3;
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        if (this.activity.getDeliveryItem(this.on_delivery, 1) != this.activity.getDeliveryItem(this.on_delivery, 0) && this.dest_housei == -1) {
                            this.dest_housej = this.select_housej;
                            this.dest_housei = this.select_housei;
                            this.select_housej = -1;
                            this.select_housei = -1;
                            this.houses[this.dest_housei][this.dest_housej].setFilter(filter_dark);
                            this.activity.getCanvas().setFocus(this.traverse(this.houses[this.dest_housei][this.dest_housej], 5));
                            if (this.activity.getDeliveryItem(this.on_delivery, 1).getRow() != this.dest_housei || this.activity.getDeliveryItem(this.on_delivery, 1).getColumn() != this.dest_housej) break;
                            this.activity.swapDeliveryOrder(this.on_delivery);
                            break;
                        }
                        for (n3 = 0; n3 < this.houses.length; ++n3) {
                            for (int i = 0; i < this.houses.length; ++i) {
                                this.houses[n3][i].setFilter(null);
                            }
                        }
                        for (n3 = 0; n3 < this.activity.getOrders().size(); ++n3) {
                            if (((AnimatedOrder)this.activity.getOrders().get(n3)).getRow() != this.select_housei || ((AnimatedOrder)this.activity.getOrders().get(n3)).getColumn() != this.select_housej) continue;
                            this.activity.addToDelivery(this.on_delivery, (AnimatedOrder)this.activity.getOrders().get(n3), this.last_time);
                            ((AnimatedOrder)this.activity.getOrders().get(n3)).take();
                        }
                        this.activity.sendOut(this.on_delivery);
                        this.activity.getCanvas().setFocus(this.kitchen);
                        this.select_housej = -1;
                        this.select_housei = -1;
                        this.dest_housej = -1;
                        this.dest_housei = -1;
                        this.on_delivery = -1;
                        break;
                    }
                    case 4: {
                        this.appplus.setFilter(null);
                        if (this.leveluploaded || this.upgradeloaded || this.dialogloaded) break;
                        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
                        float f4 = this.background.getWidth() * 3 / 4;
                        float f5 = (float)this.activity.getCanvas().getRZHeight() / f;
                        this.loadUpgrade(f4 / f5, f4, f5, MainActivity.deliveryups[this.activity.getDeliveryUpgrade()], C2MValues.DELIVERY_UPGRADES[this.activity.getDeliveryUpgrade() * 2 + 1]);
                        break;
                    }
                    case 6: {
                        this.activity.upgradeDelivery();
                        this.menus.remove(this.appplus);
                        this.appplus = null;
                        float f = (float)this.activity.getCanvas().getRZWidth() / (float)(this.background.getWidth() * 3 / 4);
                        float f6 = this.background.getWidth() * 3 / 4;
                        float f7 = (float)this.activity.getCanvas().getRZHeight() / f;
                        this.unloadUpgrade();
                        this.activity.resume();
                        for (int i = 0; i < this.activity.getDeliverers(); ++i) {
                            this.aelist.remove(this.deliverers[i]);
                            this.delivery[i] = null;
                            this.deliverers[i] = null;
                            try {
                                this.delivery[i] = Image.createImage((String)("/" + MainActivity.delivery_icons[this.activity.getDeliveryUpgrade()] + ".png"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.deliverers[i] = new AnimatedElement(this.activity, MainActivity.ambulance_pics[this.activity.getDeliveryUpgrade()], 0.25f + (float)i * 0.5f, this.map.getY(0L) / f7 - 0.2233073f * f6 / f7, f6, f7, 0, 0L);
                            if (this.activity.getDeliveryState(i) > 2) {
                                this.deliverers[i].animateOut(0L);
                            }
                            this.aelist.add(this.deliverers[i]);
                        }
                        break;
                    }
                    case 5: {
                        this.unloadUpgrade();
                        this.activity.resume();
                        this.activity.getCanvas().setFocus(this.kitchen);
                    }
                }
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.leveluploaded) {
                    if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 21;
                        this.levelupok.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.dialogloaded) {
                    if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 8;
                        this.dialog_btn.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.upgradeloaded) {
                    if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 5;
                        this.upback.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.upupgrade.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 6;
                        this.upupgrade.setFilter(MenuView.filter_dark);
                        this.activity.playSound("confirm_upgrade");
                    }
                    return true;
                }
                if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                    this.select_option = 7;
                    this.pause.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                    return true;
                }
                if (this.activity.isPaused()) {
                    if (this.options_loaded) {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                            this.select_option = 18;
                            this.quit.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                            this.select_option = 19;
                            this.sound.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        } else if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                            this.select_option = 20;
                            this.back.setFilter(MenuView.filter_dark);
                            this.activity.playSound("standard_click");
                        }
                    }
                    return true;
                }
                if (this.kitchen.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                    this.select_option = 1;
                    this.kitchen.setFilter(MenuView.filter_dark);
                    this.activity.playSound("standard_click");
                } else {
                    int n4;
                    if (this.appplus != null && this.appplus.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) {
                        this.select_option = 4;
                        this.appplus.setFilter(MenuView.filter_dark);
                        this.activity.playSound("standard_click");
                        return true;
                    }
                    int n5 = 0;
                    for (n4 = 0; n4 < this.deliverers.length && this.deliverers[n4] != null; ++n4) {
                        if (this.deliverers[n4].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight()) && this.activity.getOrders().size() > 0 && !((AnimatedOrder)this.activity.getOrders().get(0)).isTaken()) {
                            this.select_option = 2;
                            this.deliverers[n4].setFilter(MenuView.filter_dark);
                            this.select_delivery = n5;
                            this.activity.playSound("standard_click");
                            return true;
                        }
                        ++n5;
                    }
                    if (this.on_delivery != -1) {
                        for (n4 = 0; n4 < this.houses.length; ++n4) {
                            for (int i = 0; i < this.houses[n4].length; ++i) {
                                if (!this.houses[n4][i].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight()) || this.houses[n4][i].getFilter() != filter_light) continue;
                                this.select_option = 3;
                                this.houses[n4][i].setFilter(filter_dark);
                                this.select_housej = i;
                                this.select_housei = n4;
                                this.activity.playSound("standard_click");
                                return true;
                            }
                        }
                    }
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 21: {
                        if (this.levelupok.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.levelupok.setFilter(null);
                        break;
                    }
                    case 18: {
                        if (this.quit.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.quit.setFilter(null);
                        break;
                    }
                    case 19: {
                        if (this.sound.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.sound.setFilter(null);
                        break;
                    }
                    case 20: {
                        if (this.back.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.back.setFilter(null);
                        break;
                    }
                    case 8: {
                        if (this.dialog_btn.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.dialog_btn.setFilter(null);
                        break;
                    }
                    case 1: {
                        if (this.kitchen.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.kitchen.setFilter(null);
                        break;
                    }
                    case 7: {
                        if (this.pause.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.pause.setFilter(null);
                        break;
                    }
                    case 6: {
                        if (this.upupgrade.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.upupgrade.setFilter(null);
                        break;
                    }
                    case 5: {
                        if (this.upback.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.upback.setFilter(null);
                        break;
                    }
                    case 4: {
                        if (this.appplus.inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.appplus.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.deliverers[this.select_delivery].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.deliverers[this.select_delivery].setFilter(null);
                        this.select_delivery = -1;
                        break;
                    }
                    case 3: {
                        if (this.houses[this.select_housei][this.select_housej].inRange((float)motionEvent.getX() / (float)this.activity.getCanvas().getRZWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getRZHeight())) break;
                        this.select_option = 0;
                        this.houses[this.select_housei][this.select_housej].setFilter(filter_light);
                        this.select_housej = -1;
                        this.select_housei = -1;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int KITCHEN = 1;
        public static final int DELIVERY = 2;
        public static final int HOUSE = 3;
        public static final int PLUS = 4;
        public static final int UP_BACK = 5;
        public static final int UP_UPGRADE = 6;
        public static final int PAUSE = 7;
        public static final int DIALOG = 8;
        public static final int QUIT = 18;
        public static final int SOUND = 19;
        public static final int BACK = 20;
        public static final int LEVELUP_OK = 21;
    }
}

