/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.skiresort.animated;

import com.rocktasticgames.skiresort.animated.AnimatedElement;
import com.rocktasticgames.skiresort.c2m.C2MValues;
import com.rocktasticgames.skiresort.main.MainActivity;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Patient
extends AnimatedElement {
    private static boolean[] active = new boolean[20];
    private static Patient[] saved_empty = new Patient[6];
    private MainActivity activity;
    private String happy;
    private String pain;
    private String angry;
    private int pid;
    private int[] ailments;
    private boolean[] cured;
    private boolean isempty = false;
    private long start_time;
    private long end_time;
    private int procedure = -1;
    private long procedure_start = 0L;
    private long procedure_end = 0L;
    private int state;
    private Image picon;
    private int draw_room = 0;
    private int draw_place = 0;
    private int set_ailment = -1;
    private boolean overstressed = false;
    private Image eroom_base;
    private int eroom = -1;
    private Image heart;
    private long cure_time = -10000L;
    private long speeduptime;
    private boolean speedup = false;

    private Patient(MainActivity mainActivity, String string, String string2, String string3, int n, float f, float f2, float f3, float f4, Image image, boolean bl) {
        super(mainActivity, string, f, f2, f3, f4);
        this.activity = mainActivity;
        this.happy = string;
        this.pain = string2;
        this.angry = string3;
        this.pid = n;
        this.heart = image;
        this.start_time = this.activity.getTime();
        this.ailments = new int[C2MValues.MIN_PROCEDURES_PER_LEVEL[this.activity.getLevel()] + (int)(Patient.makeRandom(531) * (float)(C2MValues.MAX_PROCEDURES_PER_LEVEL[this.activity.getLevel()] - C2MValues.MIN_PROCEDURES_PER_LEVEL[this.activity.getLevel()] + 1))];
        this.cured = new boolean[this.ailments.length];
        for (int i = 0; i < this.ailments.length; ++i) {
            boolean bl2;
            if (bl && i == 0) {
                this.ailments[i] = 10 + (int)(Patient.makeRandom(449) * (float)C2MValues.ITEMS_PER_LEVEL[this.activity.getLevel()][2]);
                this.cured[i] = false;
                ++i;
                if (this.ailments.length == 1) continue;
            }
            do {
                int n2;
                int n3 = i == 0 ? -1 : this.ailments[i - 1] / 5;
                bl2 = false;
                int n4 = (int)(Patient.makeRandom(321) * 50.0f) + 1;
                block2: while (n4 > 0) {
                    for (n2 = 0; n2 < 5; ++n2) {
                        for (int j = 0; j < C2MValues.ITEMS_PER_LEVEL[this.activity.getLevel()][n2] && this.activity.getCapacity(n2) > 0; ++j) {
                            if (--n4 != 0) continue;
                            if (n2 == n3) {
                                n4 += (int)(Patient.makeRandom(839) * 25.0f) + 1;
                                continue;
                            }
                            this.ailments[i] = n2 * 5 + j;
                            break;
                        }
                        if (n4 == 0) continue block2;
                    }
                }
                for (n2 = 0; n2 < i; ++n2) {
                    if (this.ailments[n2] != this.ailments[i]) continue;
                    bl2 = true;
                }
            } while (bl2);
            this.cured[i] = false;
        }
        if (this.activity.getLevel() == 1) {
            if (this.activity.getPatients(5)[0].isEmpty()) {
                this.ailments = new int[]{1};
                this.cured = new boolean[]{false};
            } else {
                this.ailments = new int[]{0, 11};
                this.cured = new boolean[]{false, false};
            }
        }
        this.end_time = this.start_time + (long)(this.ailments.length * C2MValues.PER_PROCEDURE_TTL[this.activity.getLevel()] * 1000);
        if (bl) {
            this.start_time -= (long)((C2MValues.BASE_TTL[this.activity.getLevel()] - C2MValues.EMERGENCY_BASE_TTL[this.activity.getLevel()]) * 1000);
            this.end_time += (long)(C2MValues.EMERGENCY_BASE_TTL[this.activity.getLevel()] * 1000);
        } else {
            this.end_time += (long)(C2MValues.BASE_TTL[this.activity.getLevel()] * 1000);
        }
        this.state = 0;
    }

    public void recycle() {
        super.recycle();
        if (this.picon != null) {
            this.picon = null;
        }
        if (this.eroom_base != null) {
            this.eroom_base = null;
        }
    }

    private static float makeRandom(int n) {
        return (float)(System.currentTimeMillis() % (long)n) / (float)n;
    }

    public static void recycleAll() {
        for (int i = 0; i < saved_empty.length; ++i) {
            Patient.saved_empty[i] = null;
        }
    }

    private Patient(MainActivity mainActivity, String string, float f, float f2, float f3, float f4) {
        super(mainActivity, string, f, f2, f3, f4);
        this.activity = mainActivity;
        this.isempty = true;
    }

    public static Patient create(MainActivity mainActivity, float f, float f2, float f3, Image image, boolean bl) {
        int n;
        int n2 = 0;
        while (active[n = mainActivity.getPoints() < 5 ? (int)(Patient.makeRandom(109) * 10.0f) + 10 : (int)(Patient.makeRandom(227) * 20.0f)] && ++n2 < 15) {
        }
        Patient.active[n] = true;
        String string = n < 10 ? "female" + (n + 1) : "male" + (n - 9);
        mainActivity.playSound("new_patient");
        return new Patient(mainActivity, string + "_happy", string + "_pain", string + "_angry", n, 0.1f, f, f2, f3, image, bl);
    }

    public static Patient getEmpty(MainActivity mainActivity, float f, float f2, float f3, int n) {
        if (saved_empty[n] == null) {
            try {
                switch (n) {
                    case 0: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_skirental", 0.1f, f, f2, f3);
                        break;
                    }
                    case 1: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_trainer", 0.1f, f, f2, f3);
                        break;
                    }
                    case 2: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_clinic", 0.1f, f, f2, f3);
                        break;
                    }
                    case 3: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_spa", 0.1f, f, f2, f3);
                        break;
                    }
                    case 4: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_restaurant", 0.1f, f, f2, f3);
                        break;
                    }
                    case 5: {
                        Patient.saved_empty[n] = new Patient(mainActivity, "slotchair_square", 0.1f, f, f2, f3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved_empty[n];
    }

    public void startProcedure(int n) {
        this.procedure = this.getAilmentForRoom(n);
        this.overstressed = false;
        if (this.procedure != -1) {
            this.procedure_start = this.activity.getTime();
            this.procedure_end = this.speedup ? this.procedure_start + (long)(this.activity.getProcedureTime(n) / 2) : this.procedure_start + (long)this.activity.getProcedureTime(n);
        }
    }

    public void stopProcedure() {
        this.procedure = -1;
    }

    public void finishProcedure(long l) {
        this.procedure = -1;
        this.cure_time = l;
    }

    public float getProgress(long l) {
        if (this.speedup && l - this.speeduptime > 15000L) {
            this.speedUp(false, 0L);
        }
        if (this.procedure == -1) {
            if (this.procedure_start == 0L) {
                return -1.0f;
            }
            return -2.0f;
        }
        return (float)(l - this.procedure_start) / (float)(this.procedure_end - this.procedure_start);
    }

    public void setOverstress(boolean bl) {
        if (bl && !this.overstressed) {
            this.overstressed = true;
            this.procedure_start = (long)((float)this.procedure_start - (float)(this.activity.getTime() - this.procedure_start) * 1.0f);
            this.procedure_end = (long)((float)this.procedure_end + (float)(this.procedure_end - this.activity.getTime()) * 1.0f);
        } else if (!bl && this.overstressed) {
            this.overstressed = false;
            this.procedure_start = (long)((float)this.procedure_start - (float)(this.activity.getTime() - this.procedure_start) * -0.5f);
            this.procedure_end = (long)((float)this.procedure_end + (float)(this.procedure_end - this.activity.getTime()) * -0.5f);
        }
    }

    public float getStress() {
        return (float)(this.activity.getTime() - this.start_time) / (float)(this.end_time - this.start_time);
    }

    public int[] getAilments() {
        return this.ailments;
    }

    public int getAilmentForRoom(int n) {
        for (int i = 0; i < this.ailments.length; ++i) {
            if (this.cured[i] || this.ailments[i] / 5 != n) continue;
            return i;
        }
        return -1;
    }

    public boolean isCured(int n) {
        return this.cured[n];
    }

    public void speedUp(boolean bl, long l) {
        this.speeduptime = l;
        if (bl && !this.speedup) {
            this.speedup = true;
            this.procedure_start = (long)((float)this.procedure_start - (float)(this.activity.getTime() - this.procedure_start) * -0.5f);
            this.procedure_end = (long)((float)this.procedure_end + (float)(this.procedure_end - this.activity.getTime()) * -0.5f);
        } else if (!bl && this.speedup) {
            this.speedup = false;
            this.procedure_start = (long)((float)this.procedure_start - (float)(this.activity.getTime() - this.procedure_start) * 1.0f);
            this.procedure_end = (long)((float)this.procedure_end + (float)(this.procedure_end - this.activity.getTime()) * 1.0f);
        }
    }

    public void calmDown() {
        this.end_time += 15000L;
        this.start_time += 15000L;
        if (this.start_time > this.activity.getTime()) {
            this.end_time -= this.start_time - this.activity.getTime();
            this.start_time = this.activity.getTime();
        }
    }

    public boolean cure() {
        if (this.cured[this.procedure]) {
            return false;
        }
        this.start_time += 10000L;
        this.end_time += 10000L;
        if (this.start_time > this.activity.getTime()) {
            long l = this.start_time - this.activity.getTime();
            this.start_time -= l;
            this.end_time -= l;
        }
        boolean bl = true;
        for (int i = 0; i < this.ailments.length; ++i) {
            if (i == this.procedure) {
                this.cured[i] = true;
            }
            if (this.cured[i]) continue;
            bl = false;
        }
        if (bl) {
            Patient.active[this.pid] = false;
            this.activity.playSound("patient_complete");
            this.activity.addMoney(this.ailments.length * 10);
            this.activity.addPoints(2);
            return true;
        }
        this.activity.playSound("procedure_complete");
        this.activity.addPoints(1);
        return false;
    }

    public Image getBMP() {
        return this.bmp;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public int getStressState() {
        float f = this.getStress();
        if (f > 0.7f) {
            return 2;
        }
        if (f > 0.4f) {
            return 1;
        }
        return 0;
    }

    public int getStressColor() {
        switch (this.getStressState()) {
            default: {
                return -16733696;
            }
            case 1: {
                return -3355648;
            }
            case 2: 
        }
        return -3407872;
    }

    public void renderInPlace(Graphics graphics, long l, int n, int n2) {
        this.draw_room = n2;
        this.draw_place = n;
        this.setX(0.1f + (float)n / 5.0f);
        if (!(this.isempty || this.draw_room != 5 && this.draw_place <= 0)) {
            Patient.getEmpty(this.activity, this.y, this.parent_width, this.parent_height, n2).renderInPlace(graphics, l, n, n2);
        }
        super.render(graphics, l);
    }

    public void draw(Graphics graphics) {
        int n;
        if (!this.isempty) {
            switch (this.getStressState()) {
                case 2: {
                    if (this.state == 2) break;
                    this.state = 2;
                    super.setPNG(this.angry);
                    break;
                }
                case 1: {
                    if (this.state == 1) break;
                    this.state = 1;
                    super.setPNG(this.pain);
                    break;
                }
                case 0: {
                    if (this.state == 0) break;
                    this.state = 0;
                    super.setPNG(this.happy);
                }
            }
        }
        if (this.draw_room < 5 && this.draw_place == 0) {
            if (this.eroom != this.draw_room) {
                if (this.eroom >= 0) {
                    this.eroom_base = null;
                }
                this.eroom = this.draw_room;
                try {
                    switch (this.eroom) {
                        default: {
                            this.eroom_base = Image.createImage((String)"/procedure_slot_skirental.png");
                            break;
                        }
                        case 1: {
                            this.eroom_base = Image.createImage((String)"/procedure_slot_trainer.png");
                            break;
                        }
                        case 2: {
                            this.eroom_base = Image.createImage((String)"/procedure_slot_clinic.png");
                            break;
                        }
                        case 3: {
                            this.eroom_base = Image.createImage((String)"/procedure_slot_spa.png");
                            break;
                        }
                        case 4: {
                            this.eroom_base = Image.createImage((String)"/procedure_slot_restaurant.png");
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            graphics.drawImage(this.eroom_base, -this.eroom_base.getWidth() / 2, -this.eroom_base.getHeight() / 2, 20);
            if (!this.isempty) {
                super.draw(graphics);
            }
        } else if (!this.isempty) {
            super.draw(graphics);
        } else {
            super.draw(graphics);
        }
        if (this.getStress() > 0.0f && !this.isempty) {
            graphics.setColor(-16777216);
            graphics.fillRect(-this.bmp.getWidth() * 9 / 10, this.bmp.getHeight() * 6 / 10, this.bmp.getWidth() * 18 / 10, this.bmp.getHeight() * 2 / 10);
            graphics.setColor(this.getStressColor());
            graphics.fillRect(-this.bmp.getWidth() * 9 / 10, this.bmp.getHeight() * 6 / 10, (int)((float)(this.bmp.getWidth() * 18 / 10) * this.getStress()), this.bmp.getHeight() * 2 / 10);
        }
        if (this.draw_room != 5 && !this.isempty && (n = this.getAilmentForRoom(this.draw_room)) != -1) {
            if (this.set_ailment != n) {
                try {
                    this.picon = Image.createImage((String)("/" + MainActivity.appitems[this.draw_room][this.ailments[n] % MainActivity.appitems[this.draw_room].length] + ".png"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.set_ailment = n;
            }
            graphics.drawImage(this.picon, -this.bmp.getWidth() / 1, -this.bmp.getHeight() / 1, 20);
            if (this.procedure != -1) {
                graphics.setColor(-16777216);
                graphics.fillRect(-this.bmp.getWidth() / 1 + this.picon.getWidth() * 3 / 61, -this.bmp.getHeight() / 1 + this.picon.getHeight() * 9 / 10, this.picon.getWidth() * 55 / 61, this.picon.getHeight() / 10 + 1);
                graphics.setColor(-1);
                graphics.fillRect(-this.bmp.getWidth() / 1 + this.picon.getWidth() * 3 / 61, -this.bmp.getHeight() / 1 + this.picon.getHeight() * 9 / 10, (int)((float)this.picon.getWidth() * (55.0f * this.getProgress(this.activity.getTime())) / 61.0f), this.picon.getHeight() / 10 + 1);
            }
        }
    }

    protected void drawTime(Graphics graphics, long l) {
        super.drawTime(graphics, l);
        if (l < this.cure_time + 1500L) {
            graphics.drawImage(this.heart, 0, (int)((long)(-this.bmp.getWidth() * 2) * (l - this.cure_time) / 500L), 20);
            graphics.drawImage(this.heart, -this.bmp.getWidth() / 1, (int)((long)(-this.bmp.getWidth() * 2) * (l - this.cure_time + 60L) / 400L), 20);
        }
    }
}

