/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.airport.main;

import com.rocktasticgames.airport.animated.AnimatedElement;
import com.rocktasticgames.airport.animated.AnimatedPointer;
import com.rocktasticgames.airport.main.MainActivity;
import com.rocktasticgames.airport.utils.GraphicsContainer;
import com.rocktasticgames.airport.utils.MotionEvent;
import com.rocktasticgames.airport.views.MenuView;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainCanvas
extends Canvas {
    private MainActivity activity;
    private AnimatedElement focus;
    private AnimatedPointer pointer;
    private GraphicsContainer gc = new GraphicsContainer(super.getWidth(), super.getHeight());

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
        try {
            this.pointer = new AnimatedPointer(Image.createImage((String)"/pointerarrow.png"), this.getRZWidth(), this.getRZHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.gc.setSize(n, n2);
    }

    public int getRZHeight() {
        return Math.max(super.getHeight(), Math.min(super.getHeight(), super.getWidth()) * 4 / 3);
    }

    public int getRZWidth() {
        return Math.min(super.getHeight(), super.getWidth());
    }

    public float getHFactor() {
        return Math.min(Math.max((float)super.getWidth() * 4.0f / 3.0f / (float)super.getHeight(), 1.0f), 1.3333334f);
    }

    public void paint(Graphics graphics) {
        this.gc.setGraphics(graphics);
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onDraw(this.gc);
                break;
            }
            case 4: {
                this.activity.getMap().onDraw(this.gc);
                break;
            }
            case 2: {
                this.activity.getMenu().onDraw(this.gc);
                break;
            }
            case 6: {
                this.activity.getSplashOne().onDraw(this.gc);
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onDraw(this.gc);
                break;
            }
            case 8: {
                this.activity.getSoundView().onDraw(this.gc);
                break;
            }
            case 9: {
                this.activity.getLanguageView().onDraw(this.gc);
            }
        }
        if (this.focus != null) {
            this.pointer.setTarget(this.focus);
        } else if (this.activity.getState() == 9) {
            this.focus = this.activity.getLanguageView().traverse(this.focus, 1);
        } else if (this.activity.getState() == 8) {
            this.focus = this.activity.getSoundView().traverse(this.focus, 2);
        } else if (this.activity.getState() == 2) {
            this.focus = this.activity.getMenu().traverse(this.focus, 1);
            if (this.focus != null) {
                this.pointer.setTarget(this.focus);
            }
        }
        if (this.activity.getState() != 6 && this.activity.getState() != 7 && this.focus != null) {
            this.pointer.render(this.gc, 0L);
        }
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                this.activity.getMap().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                this.activity.getMenu().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                this.activity.getSplashOne().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                this.activity.getSoundView().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                this.activity.getLanguageView().onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                return this.activity.getKitchen().traverse(this.focus, n);
            }
            case 4: {
                return this.activity.getMap().traverse(this.focus, n);
            }
            case 2: {
                return this.activity.getMenu().traverse(this.focus, n);
            }
            case 8: {
                return this.activity.getSoundView().traverse(this.focus, n);
            }
            case 9: {
                return this.activity.getLanguageView().traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
        this.focus = animatedElement;
        this.pointer.setTarget(animatedElement);
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
        if (n != 48) {
            if (n == -6) {
                if (this.activity.getState() == 2) {
                    this.activity.getMenu().quitSelect();
                }
                return;
            }
            if (n == -7) {
                if (this.activity.getState() == 3 && !this.activity.isPaused()) {
                    this.activity.openMap();
                } else if (this.activity.getState() == 4 && !this.activity.isPaused()) {
                    this.activity.openKitchen();
                }
                return;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                this.pointer.setFilter(MenuView.filter_dark);
                if (this.focus != null) {
                    this.pointerPressed((int)this.focus.getX(Long.MAX_VALUE), (int)this.focus.getY(Long.MAX_VALUE));
                    break;
                }
                this.pointerPressed(1, 1);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.focus = this.getNeighbor(this.getGameAction(n));
                if (this.focus == null) break;
                this.pointer.setTarget(this.focus);
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        long l = this.activity.getTime();
        switch (this.getGameAction(n)) {
            case 8: {
                if (this.focus != null) {
                    this.pointerReleased((int)this.focus.getX(Long.MAX_VALUE), (int)this.focus.getY(Long.MAX_VALUE));
                } else {
                    this.pointerReleased(1, 1);
                }
                this.pointer.setFilter(null);
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

