/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform.iap;

import com.nokia.payment.NPayListener;
import com.nokia.payment.NPayManager;
import com.nokia.payment.ProductData;
import com.nokia.payment.PurchaseData;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.GameMIDlet;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Storage;
import com.renderedideas.platform.iap.IAPProvider;
import java.util.Random;

public class IAPHandler
extends IAPProvider
implements NPayListener {
    String REMOVE_ADS_IAP = "success-1";
    String[] COIN_PACK_IAP = new String[0];
    public static NPayManager npayManager;
    boolean managerReady = false;

    public IAPHandler() {
        try {
            if (System.getProperty("com.nokia.mid.mnc").toLowerCase().indexOf("404") != -1 || System.getProperty("com.nokia.mid.mnc").toLowerCase().indexOf("405") != -1) {
                this.REMOVE_ADS_IAP = "success-1";
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            npayManager = new NPayManager(GameMIDlet.instance);
            npayManager.setNPayListener(this);
            this.managerReady = true;
        }
        catch (Exception e3) {
            // empty catch block
        }
        try {
            if (this.verifyIAP()) {
                GameMIDlet.iap = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitTillManagerReady() {
        while (!this.managerReady) {
            PlatformService.sleepThread(500);
        }
    }

    public void purchaseCompleted(PurchaseData purchaseResult) {
        this.waitTillManagerReady();
        try {
            if (purchaseResult.getStatus() == 0 || purchaseResult.getStatus() == 2) {
                if (purchaseResult.getProductId().equals(this.REMOVE_ADS_IAP)) {
                    this.gameBought();
                } else {
                    for (int i = 0; i < this.COIN_PACK_IAP.length; ++i) {
                        if (!purchaseResult.getProductId().equals(this.COIN_PACK_IAP[i])) continue;
                        this.coinPackBought(i);
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void productDataReceived(ProductData[] receivedData) {
        this.waitTillManagerReady();
        if (receivedData == null) {
            Debug.print("Product data is null");
            return;
        }
        int resultLength = receivedData.length;
        for (int pos = 0; pos < resultLength; ++pos) {
        }
    }

    public void buyGame() {
        try {
            if (!npayManager.isNPayAvailable()) {
                npayManager.launchNPaySetup();
                return;
            }
            npayManager.purchaseProduct(this.REMOVE_ADS_IAP);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buyCoinPack(int packNumber) {
        try {
            if (!npayManager.isNPayAvailable()) {
                npayManager.launchNPaySetup();
                return;
            }
            npayManager.purchaseProduct(this.COIN_PACK_IAP[packNumber]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void gameBought() {
        GameMIDlet.iap = true;
        int uid = Integer.parseInt(Storage.readData("iap_uid"));
        Storage.saveData("iap_status", this.getHash(uid) + "");
    }

    private void coinPackBought(int packNumber) {
    }

    private boolean verifyIAP() {
        if (Storage.readData("iap_uid") == null) {
            this.createIAPUID();
        }
        int uid = Integer.parseInt(Storage.readData("iap_uid"));
        return Storage.readData("iap_status").equals(this.getHash(uid) + "");
    }

    private void createIAPUID() {
        Random r = new Random(System.currentTimeMillis());
        r.nextInt();
        r.nextInt();
        r.nextInt();
        Storage.saveData("iap_uid", Math.abs(r.nextInt()) + "");
        Storage.saveData("iap_status", "0");
    }

    long getHash(long number) {
        number /= 3L;
        number += 500L;
        number -= 445L;
        number *= 2L;
        number /= 3L;
        return number -= 776L;
    }
}

