/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.CreditCategory;
import com.renderedideas.yourgamename.CreditComponent;
import com.renderedideas.yourgamename.CreditContent;
import com.renderedideas.yourgamename.Game;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class CreditView
extends GameView3D {
    public static final int SCROLL_SPEED = 1;
    public static final float START_POSITION = (float)GameManager.screenHeight * 0.7f;
    public static final float TOUCH_SENSITIVITY = 1.0f;
    public static final float KEY_SENSITIVITY = 2.0f;
    public static final int CONTENT_OFFSET = 5;
    public static final int HEADING_OFFSET = 10;
    private float positionY;
    private float currentScrollSpeed;
    private float dragDistance;
    private float prevDragY;
    private CreditComponent creditFullText;
    private Bitmap back;
    private Bitmap creditScreen;
    private Point backBtnPoint;

    public CreditView() {
        this.ID = Constants.VIEW_ID_CREDIT;
        this.currentScrollSpeed = 1.0f;
        this.positionY = START_POSITION;
        this.setFontsAndOffset();
        this.initScrollText();
        this.initBitmapsAndPoints();
    }

    private void setFontsAndOffset() {
        CreditCategory.setFont(new GameFont("fonts/font"), 10);
        CreditContent.setFont(new GameFont("fonts/commonFonts"), 5);
    }

    private void initScrollText() {
        CreditCategory gameName = new CreditCategory("Archery3D");
        ((CreditComponent)gameName).add(new CreditContent("Version 1.0.0"));
        CreditComponent companyInfo = this.getCompanyInfo();
        CreditComponent credits = this.getCredits();
        CreditCategory fb = new CreditCategory("LIKE US ON FACEBOOK");
        ((CreditComponent)fb).add(new CreditContent("facebook.com/RenderedIdeas"));
        this.creditFullText = new CreditCategory("");
        this.creditFullText.add(gameName);
        this.creditFullText.add(companyInfo);
        this.creditFullText.add(new CreditCategory(""));
        this.creditFullText.add(credits);
        this.creditFullText.add(new CreditCategory(""));
        this.creditFullText.add(fb);
        this.creditFullText.add(new CreditCategory(""));
        this.creditFullText.add(new CreditCategory("THANKS FOR PLAYING!!"));
        this.creditFullText.setPositionY((int)this.positionY);
    }

    public void update() {
        this.positionY -= this.currentScrollSpeed;
        this.positionY += this.dragDistance * 1.0f;
        this.creditFullText.setPositionY(this.positionY);
        if (this.creditFullText.bottom < 0.0f) {
            this.positionY = GameManager.screenHeight;
        }
    }

    public void paint(Graphics g2, float extrapolationFactor) {
        Bitmap.drawBitmap(g2, this.creditScreen, GameManager.screenWidth / 2 - this.creditScreen.getWidth() / 2, GameManager.screenHeight / 2 - this.creditScreen.getHeight() / 2);
        this.creditFullText.paint(g2);
        Bitmap.drawBitmap(g2, this.back, (int)this.backBtnPoint.X, (int)this.backBtnPoint.Y);
    }

    public void keyPressed(int keyID) {
        if (keyID == 114 || keyID == 105) {
            this.currentScrollSpeed *= 2.0f;
        } else if (keyID == 115 || keyID == 105) {
            this.currentScrollSpeed = -this.currentScrollSpeed * 2.0f;
        } else if (keyID == 101) {
            this.goBack();
        }
    }

    public void keyReleased(int keyID) {
        if (keyID == 114 || keyID == 115 || keyID == 105 || keyID == 111) {
            this.currentScrollSpeed = 1.0f;
        }
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pointerID, int x, int y) {
        if ((float)x > this.backBtnPoint.X - 8.0f && (float)x < (float)this.back.getWidth() + this.backBtnPoint.X + 8.0f && (float)y > this.backBtnPoint.Y - 8.0f && (float)y < this.backBtnPoint.Y + (float)this.back.getHeight() + 8.0f) {
            this.goBack();
            Game.clickSound.play();
        } else {
            this.prevDragY = y;
            this.dragDistance = 0.0f;
        }
    }

    public void pointerReleased(int pointerID, int x, int y) {
        this.dragDistance = 0.0f;
    }

    public void pointerDragged(int pointerID, int x, int y) {
        this.dragDistance = (float)y - this.prevDragY;
        this.prevDragY = y;
        if (this.isOutOfScreenBounds(x, y)) {
            this.pointerReleased(pointerID, x, y);
        }
    }

    public void onBackKey() {
        this.goBack();
    }

    public void handleSwipe(int direction) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        CreditCategory.deallocate();
        CreditContent.deallocate();
    }

    private boolean isOutOfScreenBounds(int x, int y) {
        return (float)y < (float)GameManager.screenHeight * 0.1f || (float)y > (float)GameManager.screenHeight * 0.9f || (float)x < (float)GameManager.screenWidth * 0.1f || (float)x > (float)GameManager.screenWidth * 0.9f;
    }

    private CreditComponent getPrivacyPolicy() {
        CreditCategory privacy = new CreditCategory("Privacy Policy");
        ((CreditComponent)privacy).add(new CreditContent("renderedideas.com"));
        ((CreditComponent)privacy).add(new CreditContent("support@renderedideas"));
        ((CreditComponent)privacy).add(new CreditContent(""));
        ((CreditComponent)privacy).add(new CreditContent("rigamez.com/privacy"));
        return privacy;
    }

    private CreditComponent getCredits() {
        CreditCategory lead = new CreditCategory("Project Lead");
        ((CreditComponent)lead).add(new CreditContent("Ramizuddin Shaikh"));
        ((CreditComponent)lead).add(new CreditContent("Sameeruddin Shaikh"));
        CreditCategory programmers = new CreditCategory("Programmers");
        ((CreditComponent)programmers).add(new CreditContent("Pushkar G. Dhande"));
        ((CreditComponent)programmers).add(new CreditContent("Tanaya V. Rajmane"));
        CreditCategory artists = new CreditCategory("Artists");
        ((CreditComponent)artists).add(new CreditContent("Somesh Saroj"));
        ((CreditComponent)artists).add(new CreditContent("Shashank Sanjay Dalvi"));
        ((CreditComponent)artists).add(new CreditContent("Akansha Shrivastava"));
        ((CreditComponent)artists).add(new CreditContent("Arun Gaud"));
        CreditCategory testing = new CreditCategory("Testers");
        testing.add(new CreditContent("Akshay Khairnar"));
        testing.add(new CreditContent("Mahesh Chauhan"));
        CreditCategory QA = new CreditCategory("Quality Assurance");
        QA.add(new CreditContent("Sameeruddin Shaikh"));
        QA.add(new CreditContent("Ramizuddin Shaikh"));
        CreditCategory credits = new CreditCategory("CREDITS");
        ((CreditComponent)credits).add(new CreditCategory(""));
        ((CreditComponent)credits).add(programmers);
        ((CreditComponent)credits).add(artists);
        ((CreditComponent)credits).add(testing);
        ((CreditComponent)credits).add(QA);
        return credits;
    }

    private CreditComponent getCompanyInfo() {
        CreditCategory copyright = new CreditCategory("Copyright 2016");
        CreditCategory renderedIdeas = new CreditCategory("Rendered Ideas");
        CreditCategory infoSupport = new CreditCategory("Info and Support");
        ((CreditComponent)infoSupport).add(new CreditContent("www.renderedideas.com"));
        ((CreditComponent)infoSupport).add(new CreditContent("support@renderedideas.com"));
        CreditComponent privacy = this.getPrivacyPolicy();
        CreditCategory companyInfo = new CreditCategory("");
        ((CreditComponent)companyInfo).add(copyright);
        ((CreditComponent)companyInfo).add(new CreditCategory(""));
        ((CreditComponent)companyInfo).add(renderedIdeas);
        ((CreditComponent)companyInfo).add(new CreditCategory(""));
        ((CreditComponent)companyInfo).add(infoSupport);
        ((CreditComponent)companyInfo).add(new CreditCategory(""));
        ((CreditComponent)companyInfo).add(privacy);
        return companyInfo;
    }

    private void initBitmapsAndPoints() {
        this.back = new Bitmap("menu/back-button.png");
        this.creditScreen = new Bitmap("backGround/bgZoomed.png");
        this.backBtnPoint = new Point();
        this.backBtnPoint.X = (int)(0.05f * (float)GameManager.screenWidth);
        this.backBtnPoint.Y = (int)(0.8f * (float)GameManager.screenHeight);
    }

    private void goBack() {
        Game.changeView(Constants.VIEW_ID_MENU);
    }

    public void paint2D_before(Graphics g2) {
    }

    public void paint3D_before(Graphics3D g2) {
    }

    public void paint2D_after(Graphics g2) {
    }

    public void paint3D_after(Graphics3D g2) {
    }
}

