/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;
import com.renderedideas.yourgamename.HelpView;
import com.renderedideas.yourgamename.LevelBlock;
import com.renderedideas.yourgamename.LevelInfo;
import com.renderedideas.yourgamename.Selector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class LevelSelectView
extends GameView3D {
    private Bitmap bitmapNeXtButton;
    private Bitmap bitmapBackButton;
    private Bitmap bitmapLevelSelectBG;
    private Bitmap bitmapSelectLevelLabel;
    private Point bitmapBackPos;
    private Point bitmapNeXtPos;
    private Point bitmapLevelSelectScreenPos;
    private Point bitmapLevelSelectLabelPos;
    LevelBlock[] levelBlocks;
    private int currentPage = 1;
    private boolean moveToNeXtPage;
    private float[] oldX;
    private int noOfPages;
    int rows;
    int columns;
    private boolean moveToPrevPage;
    private final float SCROLL_SPEED = 0.06f * (float)GameManager.screenWidth;
    private boolean isSwiping;
    private boolean pointerPressedInsideThisView;
    private GameFont pageNumberFont;
    float firstPreOffsetX = 23.5f;
    float firstPreOffsetY = 25.2f;
    float postOffsetX = 8.0f;
    float postOffsetY = 4.0f;

    public LevelSelectView() {
        this.ID = Constants.LEVEL_SELECT_VIEW_ID;
        LevelInfo.retrieveStoredLevelData();
        this.setRowAndColumns();
        this.loadBitmaps();
        this.initializeBitmapPositions();
        PlatformService.enableGestures();
    }

    private void setRowAndColumns() {
        this.rows = 3;
        this.columns = 2;
    }

    public void update() {
        int i;
        if (this.moveToNeXtPage) {
            for (i = 0; i < 30; ++i) {
                this.levelBlocks[i].updateX(-this.SCROLL_SPEED);
                if (!(this.oldX[i] - this.levelBlocks[i].blockPosition.X >= (float)GameManager.screenWidth)) continue;
                this.levelBlocks[i].blockPosition.X = (int)(this.oldX[i] - (float)GameManager.screenWidth);
                this.levelBlocks[i].resetFontAndStarPositions();
                this.moveToNeXtPage = false;
            }
        }
        if (this.moveToPrevPage) {
            for (i = 0; i < 30; ++i) {
                this.levelBlocks[i].updateX(this.SCROLL_SPEED);
                if (!(this.levelBlocks[i].blockPosition.X - this.oldX[i] >= (float)GameManager.screenWidth)) continue;
                this.levelBlocks[i].blockPosition.X = (int)((float)GameManager.screenWidth + this.oldX[i]);
                this.levelBlocks[i].resetFontAndStarPositions();
                this.moveToPrevPage = false;
            }
        }
        Selector.update();
    }

    public void paint(Graphics g2, float eX) {
        Bitmap.drawBitmap(g2, this.bitmapLevelSelectBG, (int)this.bitmapLevelSelectScreenPos.X, (int)this.bitmapLevelSelectScreenPos.Y);
        Bitmap.drawBitmap(g2, this.bitmapSelectLevelLabel, (int)this.bitmapLevelSelectLabelPos.X, (int)this.bitmapLevelSelectLabelPos.Y);
        for (int i = 0; i < 30; ++i) {
            this.levelBlocks[i].drawLevelBlock(g2);
        }
        Bitmap.drawBitmap(g2, this.bitmapBackButton, (int)this.bitmapBackPos.X, (int)this.bitmapBackPos.Y);
        if (this.currentPage < this.noOfPages) {
            Bitmap.drawBitmap(g2, this.bitmapNeXtButton, (int)this.bitmapNeXtPos.X, (int)this.bitmapNeXtPos.Y);
        }
        this.pageNumberFont.drawString(this.currentPage + " / " + this.noOfPages, g2, GameManager.screenWidth / 2 - this.pageNumberFont.stringWidth(this.currentPage + " / " + this.noOfPages) / 2, LevelSelectView.getScreenHeightPercent(95.0f) - this.pageNumberFont.stringHeight());
        Selector.paint(g2);
    }

    public void keyPressed(int keyID) {
        this.pointerPressedInsideThisView = true;
        Selector.keyPressed(keyID);
        if (keyID == 102) {
            this.selectNeXt();
        } else if (keyID == 101) {
            this.selectBack();
        } else if ((keyID == 108 || keyID == 103) && Selector.position != null) {
            this.pointerReleased(keyID, (int)Selector.position.X, (int)Selector.position.Y);
        }
    }

    public void keyReleased(int keYID) {
        if (Selector.position != null) {
            Selector.keyReleased(keYID);
        }
    }

    public void keyRepeated(int keYID) {
    }

    public void pointerPressed(int pointerID, int X, int Y) {
        this.pointerPressedInsideThisView = true;
    }

    private void selectLevel(int levelID) {
        LevelInfo.currentLevelID = levelID;
        LevelInfo.setLevelInfo(levelID);
        if (levelID <= 3) {
            HelpView.fromGamePlayView = true;
            Game.changeView(Constants.VIEW_ID_HELP);
        } else {
            Game.changeView(Constants.VIEW_ID_GAMEPLAY_VIEW);
        }
    }

    private void selectNeXt() {
        if (!this.moveToNeXtPage && !this.moveToPrevPage && this.currentPage < this.noOfPages) {
            this.saveLevelBlockPositons();
            ++this.currentPage;
            this.moveToNeXtPage = true;
            Game.playClickSound();
        }
    }

    private void selectBack() {
        if (!this.moveToPrevPage && !this.moveToNeXtPage) {
            if (this.currentPage == 1) {
                Game.changeView(Constants.VIEW_ID_MENU);
                return;
            }
            this.saveLevelBlockPositons();
            this.moveToPrevPage = true;
            --this.currentPage;
            Game.playClickSound();
        }
    }

    private void saveLevelBlockPositons() {
        for (int i = 0; i < this.levelBlocks.length; ++i) {
            this.oldX[i] = this.levelBlocks[i].blockPosition.X;
        }
    }

    public void pointerReleased(int pointerID, int X, int Y) {
        if (!this.pointerPressedInsideThisView) {
            return;
        }
        if (this.isSwiping) {
            this.isSwiping = false;
            return;
        }
        if ((float)X > this.bitmapBackPos.X && (float)Y > this.bitmapBackPos.Y && (float)X < this.bitmapBackPos.X + (float)this.bitmapBackButton.getWidth() && (float)Y < this.bitmapBackPos.Y + (float)this.bitmapBackButton.getHeight()) {
            this.selectBack();
        } else if ((float)X > this.bitmapNeXtPos.X && (float)Y > this.bitmapNeXtPos.Y && (float)X < this.bitmapNeXtPos.X + (float)this.bitmapNeXtButton.getWidth() && (float)Y < this.bitmapNeXtPos.Y + (float)this.bitmapNeXtButton.getHeight()) {
            this.selectNeXt();
        } else {
            for (int i = 0; i < this.levelBlocks.length; ++i) {
                if (!((float)X > this.levelBlocks[i].blockPosition.X) || !((float)Y > this.levelBlocks[i].blockPosition.Y) || !((float)X < this.levelBlocks[i].blockPosition.X + (float)LevelBlock.bitmapOpenBlock.getWidth()) || !((float)Y < this.levelBlocks[i].blockPosition.Y + (float)LevelBlock.bitmapOpenBlock.getHeight()) || this.levelBlocks[i].isLocked) continue;
                Game.playClickSound();
                this.selectLevel(this.levelBlocks[i].levelID);
                return;
            }
        }
    }

    public void pointerDragged(int pointerID, int X, int Y) {
    }

    public void onBackKeY() {
        this.selectBack();
    }

    public void handleSwipe(int direction) {
        this.isSwiping = true;
        if (direction == 118) {
            this.selectNeXt();
        } else if (direction == 119) {
            this.selectBack();
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        for (int i = 0; i < this.levelBlocks.length; ++i) {
            this.levelBlocks[i].deallocate();
        }
        this.levelBlocks = null;
        LevelBlock.deallocateBitmaps();
        PlatformService.disableGestures();
        this.bitmapNeXtButton = null;
        this.bitmapBackButton = null;
        this.bitmapLevelSelectBG = null;
        this.bitmapSelectLevelLabel = null;
        this.bitmapLevelSelectScreenPos = null;
        this.bitmapLevelSelectLabelPos = null;
        this.bitmapBackPos = null;
        this.bitmapNeXtPos = null;
        this.pageNumberFont = null;
    }

    public void accelerometerData(double X, double Y, double z, double min, double maX) {
    }

    private void loadBitmaps() {
        this.bitmapNeXtButton = new Bitmap("level select/forward-button.png");
        this.bitmapBackButton = new Bitmap("level select/back-button.png");
        this.bitmapLevelSelectBG = new Bitmap("backGround/bgZoomed");
        this.bitmapSelectLevelLabel = new Bitmap("level select/level_select_text.png");
        this.pageNumberFont = new GameFont("fonts/commonFonts");
        LevelBlock.loadBitmaps();
    }

    private void initializeBitmapPositions() {
        this.bitmapLevelSelectLabelPos = new Point(LevelSelectView.getScreenWidthPercent(50.0f) - this.bitmapSelectLevelLabel.getWidth() / 2, LevelSelectView.getScreenHeightPercent(10.0f) - this.bitmapSelectLevelLabel.getHeight() / 2);
        this.bitmapLevelSelectScreenPos = new Point(0.0f, 0.0f);
        this.bitmapBackPos = new Point(0.04f * (float)GameManager.screenWidth, (float)GameManager.screenHeight * 0.9f - (float)this.bitmapBackButton.getHeight());
        this.bitmapNeXtPos = new Point((float)(GameManager.screenWidth - this.bitmapNeXtButton.getWidth()) - 0.04f * (float)GameManager.screenWidth, (float)GameManager.screenHeight * 0.9f - (float)this.bitmapNeXtButton.getHeight());
        this.initializeLevelBlocks();
    }

    private void initializeLevelBlocks() {
        int levelsPerPage = this.rows * this.columns;
        this.noOfPages = this.getNoOfPages(30, levelsPerPage);
        this.levelBlocks = new LevelBlock[30];
        this.oldX = new float[this.levelBlocks.length];
        Point firstPreOffset = new Point(LevelSelectView.getScreenWidthPercent(this.firstPreOffsetX), LevelSelectView.getScreenHeightPercent(this.firstPreOffsetY));
        Point preOffset = new Point(firstPreOffset.X, firstPreOffset.Y);
        Point postOffset = new Point(LevelSelectView.getScreenWidthPercent(this.postOffsetX), LevelSelectView.getScreenWidthPercent(this.postOffsetY));
        Point position = new Point();
        byte levelID = 1;
        int levelIndeX = 0;
        for (int page = 0; page < this.noOfPages; ++page) {
            preOffset.X = firstPreOffset.X + (float)(GameManager.screenWidth * page);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    byte levelStatus = LevelInfo.getLevelStatus(levelID);
                    position = new Point(preOffset.X + (float)j * ((float)LevelBlock.bitmapLockedBlock.getWidth() + postOffset.X), preOffset.Y + (float)i * ((float)LevelBlock.bitmapLockedBlock.getHeight() + postOffset.Y));
                    this.levelBlocks[levelIndeX] = new LevelBlock(position, levelID, levelStatus);
                    levelIndeX = (byte)(levelIndeX + 1);
                    if ((levelID = (byte)(levelID + 1)) <= 30) continue;
                    return;
                }
            }
        }
    }

    private int getNoOfPages(int noOfLevels, int levelsPerPage) {
        if (noOfLevels % levelsPerPage == 0) {
            return noOfLevels / levelsPerPage;
        }
        return noOfLevels / levelsPerPage + 1;
    }

    public void paint(Graphics g2) {
        this.paint(g2, 1.0f);
    }

    public static int getScreenWidthPercent(float i) {
        return (int)((float)GameManager.screenWidth * i / 100.0f);
    }

    public static int getScreenHeightPercent(float i) {
        return (int)((float)GameManager.screenHeight * i / 100.0f);
    }

    public void onBackKey() {
        Game.changeView(Constants.VIEW_ID_MENU);
    }

    public void paint2D_before(Graphics g2) {
    }

    public void paint3D_before(Graphics3D g2) {
    }

    public void paint2D_after(Graphics g2) {
    }

    public void paint3D_after(Graphics3D g2) {
    }
}

