/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Event {
    public static final int TYPE_BODY_POSITION = 0;
    public static final int TYPE_BODY_VELOCITY = 1;
    public static final int TYPE_BODY_ROTATION = 2;
    public static final int TYPE_BODY_ANGULARVELOCITY = 3;
    public static final int TYPE_BODY_COLLISION = 4;
    public static final int TYPE_BODY_COLLISION_RELATIVE = 6;
    public static final int TYPE_BODY_SENSOR = 5;
    public static final int TYPE_CONSTRAINT_FORCE = 10;
    private int b;
    int a = -1;
    private boolean c = false;
    private float d;
    private float e;
    private float f;
    private float g;
    private Object h;
    private Body i;
    private Shape j;
    private Constraint k;
    private Script l;
    private Vector m = null;
    protected UserData mUserData = null;
    private static FXMatrix n = new FXMatrix();
    private static FXVector o = new FXVector();
    private static FXVector p = new FXVector();

    public static Event createBodyEvent(Body body, Shape shape, int n, int n2, int n3, int n4, int n5) {
        return new Event(body, shape, null, n, n2, n3, n4, n5, null);
    }

    public static Event createCollisionRelativeEvent(Body body, Shape shape, int n, int n2) {
        float f2 = (float)n * (float)Math.PI / 180.0f;
        float f3 = (float)n2 * (float)Math.PI / 180.0f;
        f3 = FXUtil.wrapAngleFX((f3 - f2) / 2.0f);
        f3 = FXUtil.wrapAngleFX(f2 + f3);
        Event.n.setRotationMatrix(f3);
        Event.n.mult(FXVector.M_UNITY, o);
        Event.n.setRotationMatrix(f2);
        Event.n.mult(FXVector.M_UNITY, p);
        f2 = Event.o.xFX * Event.p.xFX + Event.o.yFX * Event.p.yFX;
        return new Event(body, shape, null, 6, f3, f2, 0.0f, 0.0f, null);
    }

    public static Event createBodySensorEvent(Body body, Shape shape, Body body2) {
        body2.calculateAABB(0.0f);
        return new Event(body, shape, null, 5, 0.0f, 0.0f, 0.0f, 0.0f, body2);
    }

    public static Event createConstraintEvent(Constraint constraint, int n, int n2, int n3) {
        return new Event(null, null, constraint, n, n2, n3, 0.0f, 0.0f, null);
    }

    protected Event(Body body, Shape shape, Constraint constraint, int n, float f2, float f3, float f4, float f5, Object object) {
        this.a = -1;
        this.b = n;
        this.h = object;
        switch (n) {
            case 2: 
            case 3: {
                this.d = f2 * (float)Math.PI / 180.0f;
                this.e = f3 * (float)Math.PI / 180.0f;
                break;
            }
            case 1: {
                this.d = f2 * f2;
                this.e = f3 * f3;
                break;
            }
            case 6: {
                this.d = f2;
                this.e = f3;
                break;
            }
            default: {
                this.d = f2;
                this.e = f3;
                this.f = f4;
                this.g = f5;
            }
        }
        this.i = body;
        this.j = shape;
        this.k = constraint;
    }

    protected Event(Event event, Body[] bodyArray) {
        this(bodyArray != null && event.i != null ? bodyArray[event.i.mId] : event.i, event.j, event.k, event.b, 0.0f, 0.0f, 0.0f, 0.0f, event.h != null && event.h instanceof Body && bodyArray != null && ((Body)event.h).mId >= 0 ? bodyArray[((Body)event.h).mId] : event.h);
        this.d = event.d;
        this.e = event.e;
        this.f = event.f;
        this.g = event.g;
        if (event.mUserData != null) {
            this.mUserData = event.mUserData.copy();
        }
        this.setTriggerOnce(event.c);
    }

    protected Event(int n) {
        this.b = n;
    }

    public Event copy(Body[] object) {
        object = new Event(this, (Body[])object);
        return object;
    }

    public static Event loadEvent(PhysicsFileReader physicsFileReader, World world, UserData userData) {
        int n;
        int n2 = physicsFileReader.next();
        int n3 = physicsFileReader.getVersion();
        if ((n3 & 0xFF00) < 1024) {
            physicsFileReader.next();
        }
        Event event = new Event(n2);
        if ((n3 & 0xFF00) >= 1024) {
            event.setTriggerOnce(physicsFileReader.next() > 0);
        }
        if ((n = physicsFileReader.next()) >= 0 && n != 255) {
            event.i = world.getBodies()[n];
        }
        if ((n = physicsFileReader.next()) >= 0 && n != 255) {
            event.j = (Shape)world.getShapeSet().getShapes().elementAt(n);
        }
        if ((n3 & 0xFF00) >= 1024 && (n3 = physicsFileReader.next()) >= 0 && n3 != 255) {
            event.k = world.getConstraints()[n3];
        }
        event.d = physicsFileReader.nextIntFX();
        event.e = physicsFileReader.nextIntFX();
        event.f = physicsFileReader.nextIntFX();
        event.g = physicsFileReader.nextIntFX();
        if (event.b == 5) {
            Body body = Body.loadBody(physicsFileReader, world.mShapeSet.getShapes(), userData);
            event.h = body;
        }
        if (physicsFileReader.getVersion() > 1792) {
            String string = physicsFileReader.nextString();
            if (userData != null) {
                event.mUserData = userData.createNewUserData(string, 3);
            }
        }
        return event;
    }

    public int getIdentifier() {
        return this.a;
    }

    public int type() {
        return this.b;
    }

    public void setScript(Script script) {
        this.l = script;
    }

    public void setBodyFilter(Body body) {
        this.i = body;
    }

    public Body getBodyFilter() {
        return this.i;
    }

    public void setShapeFilter(Shape shape) {
        this.j = shape;
    }

    public Shape getShapeFilter() {
        return this.j;
    }

    public Object getTargetObject() {
        return this.h;
    }

    protected void setConstraintFilter(Constraint constraint) {
        this.k = constraint;
    }

    public Constraint getConstraintFilter() {
        return this.k;
    }

    protected float targetAFX() {
        return this.d;
    }

    protected float targetBFX() {
        return this.e;
    }

    protected float targetCFX() {
        return this.f;
    }

    protected float targetDFX() {
        return this.g;
    }

    protected void setTargetsFX(float f2, float f3, float f4, float f5) {
        this.d = f2;
        this.e = f3;
        this.f = f4;
        this.g = f5;
    }

    public void setTriggerOnce(boolean bl) {
        this.c = bl;
        if (bl) {
            this.m = new Vector();
            return;
        }
        this.m = null;
    }

    public boolean getTriggerOnce() {
        return this.c;
    }

    public boolean checkEvent(World world, PhysicsEventListener physicsEventListener) {
        if (physicsEventListener == null) {
            return false;
        }
        boolean bl = false;
        switch (this.b) {
            case 10: {
                if (this.k != null) {
                    bl = this.a(this.k, physicsEventListener);
                    break;
                }
                for (int i = 0; i < world.g; ++i) {
                    bl |= this.a(world.h[i], physicsEventListener);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                for (int i = 0; i < world.a; ++i) {
                    bl |= this.a(world, world.b[i], physicsEventListener);
                }
                break;
            }
            case 5: {
                if (this.i != null) {
                    bl = this.a(world, this.i, physicsEventListener);
                    break;
                }
                Body[] bodyArray = world.b;
                Body body = (Body)this.h;
                for (int i = 0; i < world.a; ++i) {
                    if (!bodyArray[i].a || bodyArray[i].g > body.h || body.g > bodyArray[i].h || bodyArray[i].e > body.f || body.e > bodyArray[i].f) continue;
                    bl |= this.a(world, bodyArray[i], physicsEventListener);
                }
                break;
            }
        }
        return bl;
    }

    private final boolean a(World world, Body body, PhysicsEventListener physicsEventListener) {
        if (this.j != null && body.mShape != this.j) {
            return false;
        }
        Object object = null;
        boolean bl = false;
        block0 : switch (this.b) {
            case 0: {
                if (!(this.d <= body.mPositionFX.xFX) || !(body.mPositionFX.xFX <= this.f) || !(this.e <= body.mPositionFX.yFX) || !(body.mPositionFX.yFX <= this.g)) break;
                bl = true;
                object = body;
                break;
            }
            case 1: {
                float f2 = body.mVelocityFX.lengthSquareFX();
                if (!(this.d <= f2) || !(f2 <= this.e)) break;
                bl = true;
                object = body;
                break;
            }
            case 2: {
                if (!(this.d <= body.mRotation2FX) || !(body.mRotation2FX <= this.e)) break;
                bl = true;
                object = body;
                break;
            }
            case 3: {
                if (!(this.d <= body.mAngularVelocity2FX) || !(body.mAngularVelocity2FX <= this.e)) break;
                bl = true;
                object = body;
                break;
            }
            case 4: {
                Contact[] contactArray = body.getContacts();
                for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
                    if (!(this.d > 0.0f && contactArray[i].e.yFX < body.mPositionFX.yFX || this.e > 0.0f && contactArray[i].e.xFX > body.mPositionFX.xFX || this.f > 0.0f && contactArray[i].e.yFX > body.mPositionFX.yFX) && (!(this.g > 0.0f) || !(contactArray[i].e.xFX < body.mPositionFX.xFX))) continue;
                    bl = true;
                    object = contactArray[i];
                    break block0;
                }
                break;
            }
            case 6: {
                float f3 = FXUtil.wrapAngleFX(this.d + body.rotation2FX());
                n.setRotationMatrix(f3);
                n.mult(FXVector.M_UNITY, o);
                Contact[] contactArray = body.getContacts();
                for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
                    p.assignDiff(body.mPositionFX, contactArray[i].e);
                    p.normalize();
                    if (Event.o.xFX * Event.p.xFX + Event.o.yFX * Event.p.yFX >= this.e) {
                        bl = true;
                        object = contactArray[i];
                        break block0;
                    }
                    if (contactArray[i].isSingle()) continue;
                    p.assignDiff(body.mPositionFX, contactArray[i].f);
                    p.normalize();
                    if (!(Event.o.xFX * Event.p.xFX + Event.o.yFX * Event.p.yFX >= this.e)) continue;
                    bl = true;
                    object = contactArray[i];
                    break block0;
                }
                break;
            }
            case 5: {
                if (Collision.detectCollision(body, (Body)this.h) == null) break;
                bl = true;
                object = body;
            }
        }
        if (bl) {
            if (!this.c || this.a(object)) {
                if (this.l == null) {
                    physicsEventListener.eventTriggered(this, object);
                } else {
                    this.l.applyToBody(body, world);
                }
            }
        } else if (this.c) {
            this.b(object);
        }
        return bl;
    }

    private final boolean a(Constraint constraint, PhysicsEventListener physicsEventListener) {
        switch (this.b) {
            case 10: {
                float f2 = constraint.getImpulseFX();
                if (this.d <= f2 && f2 <= this.e) {
                    if (!this.c || this.a(constraint)) {
                        physicsEventListener.eventTriggered(this, constraint);
                    }
                    return true;
                }
                if (!this.c) break;
                this.b(constraint);
            }
        }
        return false;
    }

    private boolean a(Object object) {
        if (this.m.contains(object)) {
            return false;
        }
        this.m.addElement(object);
        return true;
    }

    private void b(Object object) {
        this.m.removeElement(object);
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

