/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static String encode(String s) {
        return URLEncoder.encode(s, System.getProperty("microedition.encoding"));
    }

    public static String encode(String s, String enc) {
        ByteArrayInputStream bIn;
        if (s == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        try {
            bIn = new ByteArrayInputStream(s.getBytes(enc));
        }
        catch (UnsupportedEncodingException e2) {
            bIn = new ByteArrayInputStream(s.getBytes());
        }
        int c2 = bIn.read();
        StringBuffer ret = new StringBuffer();
        while (c2 >= 0) {
            if (c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57 || c2 == 46 || c2 == 45 || c2 == 42 || c2 == 95) {
                ret.append((char)c2);
            } else if (c2 == 32) {
                ret.append("%20");
            } else if (c2 < 128) {
                ret.append(URLEncoder.getHexChar(c2));
            } else if (c2 < 224) {
                ret.append(URLEncoder.getHexChar(c2));
                ret.append(URLEncoder.getHexChar(bIn.read()));
            } else if (c2 < 240) {
                ret.append(URLEncoder.getHexChar(c2));
                ret.append(URLEncoder.getHexChar(bIn.read()));
                ret.append(URLEncoder.getHexChar(bIn.read()));
            }
            c2 = bIn.read();
        }
        return ret.toString();
    }

    private static String getHexChar(int c2) {
        return (c2 < 16 ? "%0" : "%") + Integer.toHexString(c2).toUpperCase();
    }

    private URLEncoder() {
    }
}

