/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D.util;

public class FXVector {
    public float xFX = 0.0f;
    public float yFX = 0.0f;
    private static FXVector a = new FXVector();
    private static FXVector b = new FXVector();
    public static final FXVector M_UNITY = new FXVector(1.0f, 0.0f);

    public FXVector() {
    }

    public FXVector(float f2, float f3) {
        this.xFX = f2;
        this.yFX = f3;
    }

    public FXVector(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public static FXVector newVector(int n, int n2) {
        return new FXVector(n, n2);
    }

    public final void assign(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public final void assignFX(float f2, float f3) {
        this.xFX = f2;
        this.yFX = f3;
    }

    public final void assignDiff(FXVector fXVector, FXVector fXVector2) {
        this.xFX = fXVector.xFX - fXVector2.xFX;
        this.yFX = fXVector.yFX - fXVector2.yFX;
    }

    public final void assignScaledFX(FXVector fXVector, float f2) {
        this.xFX = f2 * fXVector.xFX;
        this.yFX = f2 * fXVector.yFX;
    }

    public boolean equals(Object object) {
        if (object instanceof FXVector) {
            return this.xFX == ((FXVector)object).xFX && this.yFX == ((FXVector)object).yFX;
        }
        return false;
    }

    public final void add(FXVector fXVector) {
        this.xFX += fXVector.xFX;
        this.yFX += fXVector.yFX;
    }

    public final void add(FXVector fXVector, float f2) {
        this.xFX += f2 * fXVector.xFX;
        this.yFX += f2 * fXVector.yFX;
    }

    public final void addFX(float f2, float f3, float f4) {
        this.xFX += f4 * f2;
        this.yFX += f4 * f3;
    }

    public final void add2FX(FXVector fXVector, float f2) {
        this.xFX += f2 * fXVector.xFX;
        this.yFX += f2 * fXVector.yFX;
    }

    public final void subtract(FXVector fXVector) {
        this.xFX -= fXVector.xFX;
        this.yFX -= fXVector.yFX;
    }

    public final void multFX(float f2) {
        this.xFX = f2 * this.xFX;
        this.yFX = f2 * this.yFX;
    }

    public final void mult(int n) {
        this.xFX *= (float)n;
        this.yFX *= (float)n;
    }

    public final FXVector timesFX(float f2) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = f2 * this.xFX;
        fXVector.yFX = f2 * this.yFX;
        return fXVector;
    }

    public final FXVector times(int n) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = this.xFX * (float)n;
        fXVector.yFX = this.yFX * (float)n;
        return fXVector;
    }

    public final FXVector dividedByFX(float f2) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = this.xFX / f2;
        fXVector.yFX = this.yFX / f2;
        return fXVector;
    }

    public final void divideByFX(float f2) {
        this.xFX /= f2;
        this.yFX /= f2;
    }

    public final void divideBy(int n) {
        this.xFX /= (float)n;
        this.yFX /= (float)n;
    }

    public final void transpose() {
        float f2 = this.xFX;
        this.xFX = this.yFX;
        this.yFX = f2;
    }

    public final void turnRight() {
        float f2 = this.xFX;
        this.xFX = this.yFX;
        this.yFX = -f2;
    }

    public final int lengthSquare() {
        return (int)(this.xFX * this.xFX + this.yFX * this.yFX);
    }

    public final float lengthSquareFX() {
        return this.xFX * this.xFX + this.yFX * this.yFX;
    }

    public final float lengthFX() {
        return (float)Math.sqrt(this.xFX * this.xFX + this.yFX * this.yFX);
    }

    public final float preciseLengthFX() {
        return (float)Math.sqrt(this.xFX * this.xFX + this.yFX * this.yFX);
    }

    public static final float fastLengthFX(float f2, float f3) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    public final float fastLengthFX() {
        return (float)Math.sqrt(this.xFX * this.xFX + this.yFX * this.yFX);
    }

    public final float distFX(FXVector fXVector) {
        a.assignDiff(fXVector, this);
        return a.lengthFX();
    }

    public final void normalize() {
        float f2 = this.lengthFX();
        if (f2 == 0.0f) {
            return;
        }
        this.xFX /= f2;
        this.yFX /= f2;
    }

    public final void normalizePrecise() {
        float f2 = this.preciseLengthFX();
        if (f2 == 0.0f) {
            return;
        }
        this.xFX /= f2;
        this.yFX /= f2;
    }

    public final void normalizeFast() {
        float f2 = this.fastLengthFX();
        if (f2 == 0.0f) {
            return;
        }
        this.xFX /= f2;
        this.yFX /= f2;
    }

    public final float dotFX(FXVector fXVector) {
        return this.xFX * fXVector.xFX + this.yFX * fXVector.yFX;
    }

    public final float crossFX(FXVector fXVector) {
        return this.xFX * fXVector.yFX - this.yFX * fXVector.xFX;
    }

    public final void crossScalarFX(float f2) {
        float f3 = this.xFX;
        this.xFX = f2 * this.yFX;
        this.yFX = -(f2 * f3);
    }

    public final void crossScalar2FX(float f2) {
        float f3 = this.xFX;
        this.xFX = f2 * this.yFX;
        this.yFX = -(f2 * f3);
    }

    public final float distanceFX(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, float f2) {
        float f3;
        a.assignDiff(this, fXVector);
        float f4 = FXVector.a.xFX * fXVector3.xFX + FXVector.a.yFX * fXVector3.yFX;
        if (f3 < 0.0f) {
            return 2.1474836E9f;
        }
        if (f4 > f2) {
            return 2.1474836E9f;
        }
        return Math.abs(FXVector.a.xFX * fXVector3.yFX - FXVector.a.yFX * fXVector3.xFX);
    }

    public final float distanceFX(FXVector fXVector, FXVector fXVector2) {
        b.assignDiff(fXVector2, fXVector);
        b.normalize();
        return this.distanceFX(fXVector, fXVector2, b, fXVector.distFX(fXVector2));
    }

    public final boolean leftOf(FXVector fXVector, FXVector fXVector2) {
        a.assignDiff(fXVector2, fXVector);
        b.assignDiff(this, fXVector);
        return FXVector.a.xFX * FXVector.b.yFX - FXVector.a.yFX * FXVector.b.xFX > 0.0f;
    }

    public static boolean intersect(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, FXVector fXVector4, FXVector fXVector5) {
        FXVector fXVector6 = a;
        FXVector fXVector7 = b;
        fXVector6.assignDiff(fXVector2, fXVector);
        fXVector7.assignDiff(fXVector4, fXVector3);
        float f2 = fXVector7.xFX * fXVector6.yFX - fXVector7.yFX * fXVector6.xFX;
        if (f2 == 0.0f) {
            return false;
        }
        float f3 = fXVector.xFX * fXVector6.yFX - fXVector.yFX * fXVector6.xFX - fXVector3.crossFX(fXVector6);
        float f4 = fXVector.xFX * fXVector7.yFX - fXVector.yFX * fXVector7.xFX - fXVector3.crossFX(fXVector7);
        if (f2 > 0.0f && (f3 < -f2 || f3 > f2 || f4 < -f2 || f4 > f2) || f2 < 0.0f && (f3 > -f2 || f3 < f2 || f4 > -f2 || f4 < f2)) {
            return false;
        }
        float f5 = fXVector.xFX + f4 * fXVector6.xFX / f2;
        float f6 = fXVector3.xFX + f3 * fXVector7.xFX / f2;
        fXVector5.xFX = (f5 + f6) / 2.0f;
        f5 = fXVector.yFX + f4 * fXVector6.yFX / f2;
        f6 = fXVector3.yFX + f3 * fXVector7.yFX / f2;
        fXVector5.yFX = (f5 + f6) / 2.0f;
        return true;
    }

    public final void maxFX(float f2) {
        this.xFX = Math.max(this.xFX, f2);
        this.yFX = Math.max(this.yFX, f2);
    }

    public final void minFX(float f2) {
        this.xFX = Math.min(this.xFX, f2);
        this.yFX = Math.min(this.yFX, f2);
    }

    public final void max(FXVector fXVector) {
        this.xFX = Math.max(this.xFX, fXVector.xFX);
        this.yFX = Math.max(this.yFX, fXVector.yFX);
    }

    public final void min(FXVector fXVector) {
        this.xFX = Math.min(this.xFX, fXVector.xFX);
        this.yFX = Math.min(this.yFX, fXVector.yFX);
    }

    public final boolean isInRect(FXVector fXVector, FXVector fXVector2) {
        return this.xFX >= fXVector.xFX && this.yFX >= fXVector.yFX && this.xFX <= fXVector2.xFX && this.yFX <= fXVector2.yFX;
    }

    public final int xAsInt() {
        if (this.xFX >= 0.0f) {
            return (int)this.xFX;
        }
        return (int)this.xFX;
    }

    public final int yAsInt() {
        if (this.yFX >= 0.0f) {
            return (int)this.yFX;
        }
        return (int)this.yFX;
    }
}

