/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.TrackingURL;

public abstract class Request {
    private String appId;
    private int domainHash;
    private int userId;
    private long firstVisitTimestamp;
    private long lastVisitTimestamp;
    private long currentVisitTimestamp;
    private int visitNumber;
    private int screenHeight = -1;
    private int screenWidth = -1;
    private int numberOfColors = -1;

    static int getColorDepth(int numberOfColors) {
        switch (numberOfColors) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 256: {
                return 8;
            }
            case 65536: {
                return 16;
            }
            case 0x1000000: {
                return 24;
            }
        }
        return 32;
    }

    String getAppId() {
        return this.appId;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    int getUserId() {
        return this.userId;
    }

    void setUserId(int userId) {
        this.userId = userId;
    }

    int getDomainHash() {
        return this.domainHash;
    }

    void setDomainHash(int domainHash) {
        this.domainHash = domainHash;
    }

    long getFirstVisitTimestamp() {
        return this.firstVisitTimestamp;
    }

    void setFirstVisitTimestamp(long firstVisitTimestamp) {
        this.firstVisitTimestamp = firstVisitTimestamp;
    }

    long getLastVisitTimestamp() {
        return this.lastVisitTimestamp;
    }

    void setLastVisitTimestamp(long lastVisitTimestamp) {
        this.lastVisitTimestamp = lastVisitTimestamp;
    }

    long getCurrentVisitTimestamp() {
        return this.currentVisitTimestamp;
    }

    void setCurrentVisitTimestamp(long currentVisitTimestamp) {
        this.currentVisitTimestamp = currentVisitTimestamp;
    }

    int getVisitNumber() {
        return this.visitNumber;
    }

    void setVisitNumber(int visitNumber) {
        this.visitNumber = visitNumber;
    }

    int getScreenHeight() {
        return this.screenHeight;
    }

    void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    int getScreenWidth() {
        return this.screenWidth;
    }

    void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    int getNumberOfColors() {
        return this.numberOfColors;
    }

    void setNumberOfColors(int numberOfColors) {
        this.numberOfColors = numberOfColors;
    }

    String getUTMACookie() {
        String cookie = "__utma%3D" + this.domainHash + "." + this.userId + "." + this.firstVisitTimestamp + "." + this.lastVisitTimestamp + "." + this.currentVisitTimestamp + "." + this.visitNumber + ";";
        return cookie;
    }

    TrackingURL trackingURL() {
        TrackingURL turl = new TrackingURL();
        turl.addParameter("utmac", this.appId);
        turl.addParameter("utmcc", this.getUTMACookie());
        if (this.screenWidth != -1 && this.screenHeight != -1) {
            turl.addParameter("utmsr", this.screenWidth + "x" + this.screenHeight);
        }
        if (this.numberOfColors != -1) {
            turl.addParameter("utmsc", Request.getColorDepth(this.numberOfColors) + "-bit");
        }
        return turl;
    }
}

