/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class PropertyStore {
    private String filename;
    private Vector propsKeys;
    private Vector propsValues;

    public PropertyStore(String filename) {
        this.filename = filename;
        this.propsKeys = new Vector(5);
        this.propsValues = new Vector(5);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        String key = null;
        Object value = null;
        RecordStore rsProps = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            for (int i = this.propsKeys.size() - 1; i >= 0; --i) {
                key = this.propsKeys.elementAt(i).toString();
                value = this.propsValues.elementAt(i);
                dos.writeUTF(key);
                if (value instanceof String) {
                    dos.writeUTF("string");
                    dos.writeUTF(value.toString());
                    continue;
                }
                if (value instanceof Integer) {
                    dos.writeUTF("integer");
                    dos.writeInt((Integer)value);
                    continue;
                }
                if (!(value instanceof Long)) continue;
                dos.writeUTF("long");
                dos.writeLong((Long)value);
            }
            dos.writeUTF("eof");
            rsProps = RecordStore.openRecordStore((String)this.filename, (boolean)true);
            byte[] data = baos.toByteArray();
            if (rsProps.getNumRecords() == 0) {
                rsProps.addRecord(data, 0, data.length);
            } else {
                RecordEnumeration re = rsProps.enumerateRecords(null, null, false);
                rsProps.setRecord(re.nextRecordId(), data, 0, data.length);
            }
        }
        catch (IOException e2) {
        }
        catch (RecordStoreException e3) {
        }
        finally {
            if (rsProps != null) {
                try {
                    rsProps.closeRecordStore();
                }
                catch (RecordStoreException e4) {}
            }
        }
    }

    public void putString(String key, String value) {
        this.set(key, value);
    }

    public void putInt(String key, int value) {
        this.set(key, new Integer(value));
    }

    public void putLong(String key, long value) {
        this.set(key, new Long(value));
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public int getInt(String key) {
        Object v = this.get(key);
        if (v != null) {
            return (Integer)v;
        }
        return Integer.MIN_VALUE;
    }

    public long getLong(String key) {
        Object v = this.get(key);
        if (v != null) {
            return (Long)v;
        }
        return Long.MIN_VALUE;
    }

    public int size() {
        return this.propsKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        RecordStore rsProps = null;
        try {
            rsProps = RecordStore.openRecordStore((String)this.filename, (boolean)true);
            if (rsProps.getNumRecords() == 1) {
                RecordEnumeration re = rsProps.enumerateRecords(null, null, false);
                int recordID = re.nextRecordId();
                byte[] record = rsProps.getRecord(recordID);
                String key = null;
                String type = null;
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(record));
                while (!(key = dis.readUTF()).equals("eof")) {
                    type = dis.readUTF();
                    if (type.equals("string")) {
                        this.propsKeys.addElement(key);
                        this.propsValues.addElement(dis.readUTF());
                        continue;
                    }
                    if (type.equals("integer")) {
                        this.propsKeys.addElement(key);
                        this.propsValues.addElement(new Integer(dis.readInt()));
                        continue;
                    }
                    if (!type.equals("long")) continue;
                    this.propsKeys.addElement(key);
                    this.propsValues.addElement(new Long(dis.readLong()));
                }
            }
        }
        catch (IOException e2) {
        }
        catch (RecordStoreException e3) {
        }
        finally {
            if (rsProps != null) {
                try {
                    rsProps.closeRecordStore();
                }
                catch (RecordStoreException e4) {}
            }
        }
    }

    private void set(String key, Object value) {
        int index = this.propsKeys.indexOf(key);
        if (index != -1) {
            this.propsValues.setElementAt(value, index);
        } else {
            this.propsKeys.addElement(key);
            this.propsValues.addElement(value);
        }
    }

    private Object get(String key) {
        int index = this.propsKeys.indexOf(key);
        if (index != -1) {
            return this.propsValues.elementAt(index);
        }
        return null;
    }
}

