/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.GameView3D;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Storage;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;
import com.renderedideas.yourgamename.StorageHandler;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Graphics3D;

public class ScoreView
extends GameView3D
implements Runnable {
    private final String URL;
    String postData;
    String str;
    private Bitmap backButton;
    private Bitmap yesButton;
    private Bitmap noButton;
    private Bitmap background;
    private GameFont subTitleFont;
    private boolean retry;
    private boolean conn;
    private boolean info;
    private String[] names;
    private String[] scores;
    private String globalRank;
    private Point yesBtnPoint;
    private boolean loading;
    private boolean runOnlyOnce;

    public ScoreView() {
        this.URL = "http://www.renderedideas.com/scores/Archery3D.php";
        this.ID = Constants.SCORE_VIEW_ID;
        this.runOnlyOnce = true;
        this.loading = true;
    }

    private void prepareBitmapPositions() {
        this.yesBtnPoint = new Point(GameManager.screenWidth - this.yesButton.getWidth(), GameManager.screenHeight - this.yesButton.getHeight());
    }

    public void update() {
        if (this.runOnlyOnce) {
            Debug.print("runOnlyOnce Code");
            this.load();
            this.prepareAttributes();
            this.prepareBitmapPositions();
            this.checkUUIDStatus();
            this.downloadScores();
            this.runOnlyOnce = false;
        }
    }

    public void paint(Graphics g2) {
        this.paint(g2, 1.0f);
    }

    public void paint(Graphics g2, float exf) {
        if (this.loading) {
            String s = "Loading...";
            Bitmap.fillColor(g2, 0, 0, GameManager.screenWidth, GameManager.screenHeight, 0, 0, 0);
            Bitmap.drawString(g2, s, GameManager.screenWidth / 2 - s.length() / 2, GameManager.screenHeight / 2, 255, 255, 255);
            return;
        }
        Bitmap.fillColor(g2, 0, 0, GameManager.screenWidth, GameManager.screenHeight, 187, 97, 47);
        this.subTitleFont.drawString("Global Hi-scores", g2, GameManager.screenWidth / 2 - this.subTitleFont.stringWidth("Global hi-scores") / 2, GameManager.screenHeight / 30);
        if (this.conn) {
            this.subTitleFont.drawString("Loading", g2, GameManager.screenWidth / 2 - this.subTitleFont.stringWidth("Loading") / 2, GameManager.screenHeight / 2 - this.subTitleFont.stringHeight() / 2);
            Bitmap.drawBitmap(g2, this.backButton, 0, GameManager.screenHeight - this.backButton.getHeight());
        } else if (this.retry) {
            String text = "Connection to server failed. Retry?";
            this.subTitleFont.drawString(text, g2, GameManager.screenWidth / 2 - this.subTitleFont.stringWidth(text) / 2, GameManager.screenHeight / 2);
            Bitmap.drawBitmap(g2, this.noButton, 0, GameManager.screenHeight - this.noButton.getHeight());
            Bitmap.drawBitmap(g2, this.yesButton, (int)this.yesBtnPoint.X, (int)this.yesBtnPoint.Y);
        } else if (this.info) {
            Bitmap.drawBitmap(g2, this.backButton, 2, this.backButton.getHeight() / 4);
            for (int i = 0; i < 10; ++i) {
                this.subTitleFont.drawString(i + 1 + ".", g2, GameManager.screenWidth / 15, 45 + 17 * i);
                this.subTitleFont.drawString(this.names[i], g2, GameManager.screenWidth / 6, 45 + 17 * i);
                this.subTitleFont.drawString(this.scores[i], g2, 220, 45 + 17 * i);
            }
            this.subTitleFont.drawString("Your rank: " + this.globalRank, g2, GameManager.screenWidth / 2 - this.subTitleFont.stringWidth("Your rank: " + this.globalRank) / 2, (int)((float)GameManager.screenHeight * 0.98f - (float)(this.subTitleFont.stringHeight() * 2)));
        }
    }

    public void keyPressed(int keyID) {
        if (keyID == 107 || keyID == 116 || keyID == 101) {
            this.goBack();
        } else if (this.retry && (keyID == 109 || keyID == 117 || keyID == 102)) {
            this.executeRetryYesButtonAction();
        }
        if (keyID == 103 || keyID == 102 || keyID == 108) {
            // empty if block
        }
    }

    public void keyReleased(int keyID) {
        if (keyID == 103 || keyID == 102 || keyID == 108) {
            // empty if block
        }
    }

    public void keyRepeated(int keyID) {
    }

    public void pointerPressed(int pointerID, int x, int y) {
        if (x > 0 && x < this.backButton.getWidth() && y > 0 && y < this.backButton.getWidth() / 4 + this.backButton.getWidth() / 2) {
            this.goBack();
        } else if (this.retry && x > GameManager.screenWidth - this.backButton.getWidth() - 10 && x < GameManager.screenWidth && y > GameManager.screenHeight - this.backButton.getHeight() - 10 && y < GameManager.screenHeight) {
            this.executeRetryYesButtonAction();
        } else if (x > 0 && x < this.backButton.getWidth() + 10 && y > GameManager.screenHeight - this.backButton.getHeight() - 10 && y < GameManager.screenHeight) {
            this.goBack();
        }
    }

    private void executeRetryYesButtonAction() {
        this.downloadScores();
        this.conn = true;
        this.retry = false;
    }

    private void goBack() {
        Game.changeView(Constants.VIEW_ID_MENU);
    }

    public void pointerReleased(int pointerID, int x, int y) {
    }

    public void pointerDragged(int pointerID, int x, int y) {
    }

    public void onBackKey() {
        this.goBack();
    }

    public void handleSwipe(int direction, int pointerID) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void deallocate() {
        this.deallocateBitmaps();
        this.subTitleFont = null;
        this.names = null;
        this.scores = null;
        this.globalRank = null;
        this.yesBtnPoint = null;
    }

    public void accelerometerData(double x, double y, double z, double min, double max) {
    }

    private void loadBitmaps() {
        this.backButton = new Bitmap("roundQuit.png");
        this.yesButton = new Bitmap("level select/yes_button.png");
        this.noButton = new Bitmap("level select/no_button.png");
        this.background = new Bitmap("backGround/bg0.png");
    }

    private void deallocateBitmaps() {
        this.backButton = null;
        this.yesButton = null;
        this.noButton = null;
        this.background = null;
    }

    private void prepareAttributes() {
        this.retry = false;
        this.conn = true;
        this.info = false;
        this.names = new String[50];
        this.scores = new String[50];
        this.globalRank = "NA";
    }

    private void checkUUIDStatus() {
        Debug.print("checkUUIDStatus-before isUUIDObtained: " + GameManager.isUUIDObtained);
        while (!GameManager.isUUIDObtained) {
            GameManager.instance.processUUID(PlatformService.nextInt(GameManager.screenWidth), PlatformService.nextInt(GameManager.screenHeight));
        }
        Debug.print("checkUUIDStatus-after isUUIDObtained: " + GameManager.isUUIDObtained);
        Debug.print("checkUUIDStatus UUID: " + GameManager.UUID);
    }

    private void downloadScores() {
        this.retry = false;
        this.info = false;
        this.conn = true;
        Thread scoreThread = new Thread(this);
        scoreThread.start();
    }

    public void run() {
        this.loadScoresFromServer();
        if (!this.retry) {
            this.info = true;
            this.conn = false;
            this.retry = false;
        }
    }

    private void loadScoresFromServer() {
        this.str = "";
        Debug.print(" ======  Submitting Score: " + Storage.readData("SCORE") + " with Username: " + Storage.readData("PLAYER"));
        this.postData = "UUID=" + GameManager.UUID + "&fname=" + StorageHandler.getPlayerName() + "&score=" + StorageHandler.getPlayerScore("PLAYER");
        this.str = PlatformService.getStringResponseFromServer("http://www.renderedideas.com/scores/Archery3D.php", this.postData);
        Debug.print("str: " + this.str);
        try {
            if (this.str != null) {
                this.getScores(this.str);
            } else {
                this.retry = true;
                this.conn = false;
                this.info = false;
            }
        }
        catch (Exception e2) {
            this.retry = true;
            this.conn = false;
            this.info = false;
        }
    }

    private void getScores(String str) {
        int startIndex = 0;
        for (int i = 0; i < 30; ++i) {
            this.names[i] = str.substring(startIndex, str.indexOf("|", startIndex));
            startIndex = str.indexOf("|", startIndex) + 1;
            this.scores[i] = str.substring(startIndex, str.indexOf("|", startIndex));
            startIndex = str.indexOf("|", startIndex) + 1;
        }
        this.globalRank = str.substring(startIndex, str.indexOf("|", startIndex));
    }

    private void load() {
        Debug.print("loading bitmaps .... ");
        this.loading = true;
        PlatformService.startLoadingThread();
        this.loadBitmaps();
        this.subTitleFont = Game.commonFont;
        PlatformService.stopLoadingThread();
        this.loading = false;
    }

    public void handleSwipe(int direction) {
    }

    public void paint2D_before(Graphics g2) {
    }

    public void paint3D_before(Graphics3D g2) {
    }

    public void paint2D_after(Graphics g2) {
    }

    public void paint3D_after(Graphics3D g2) {
    }
}

