/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import at.emini.physics2D.util.FXVector;
import com.renderedideas.gamemanager.Utility3D;
import com.renderedideas.gamemanager.Vector3;
import com.renderedideas.platform.ArrayList;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.DictionaryKeyValue;
import javax.microedition.m3g.Graphics3D;

class Polygon {
    public float[] position;
    public float[] dimensions;
    public short[] vertices;
    public int[] strips;
    public short[] uvs;
    public Bitmap bitmap;
    public DictionaryKeyValue attributes;

    private static short[] getShortArray(int[] triangles) {
        short[] inShort = new short[triangles.length];
        for (int i = 0; i < 100; ++i) {
            inShort[i] = (short)triangles[i];
        }
        return inShort;
    }

    public Polygon(float[] position, float[] dimensions, Vector3[] vertices, int[] triangles, FXVector[] uvs, Bitmap texture, DictionaryKeyValue attributes) {
        this.position = position;
        this.dimensions = dimensions;
        short[] verts = new short[vertices.length * 3];
        int j = 0;
        for (int i = 0; i < vertices.length; ++i) {
            verts[j++] = (short)vertices[i].x;
            verts[j++] = (short)vertices[i].y;
            verts[j++] = (short)vertices[i].z;
        }
        this.vertices = verts;
        this.strips = triangles;
        short[] uv = new short[uvs.length * 2];
        j = 0;
        for (int i = 0; i < uvs.length; ++i) {
            uv[j++] = (short)(uvs[i].xFX * 255.0f);
            uv[j++] = (short)(uvs[i].yFX * 255.0f);
        }
        this.uvs = uv;
        ArrayList list = Utility3D.getTrianglesFromStrip(this.vertices, this.uvs, this.strips);
        this.vertices = (short[])list.elementAt(0);
        this.uvs = (short[])list.elementAt(1);
        this.strips = (int[])list.elementAt(2);
        this.bitmap = texture;
        this.attributes = attributes;
    }

    public void draw(Graphics3D target, int offsetX, int offsetY, int offsetZ) {
        Bitmap.drawTexturedPolygon(target, this.vertices, this.uvs, this.position[0], this.position[1], this.position[2], 0.0f, this.strips, this.bitmap, 1.0f, 1.0f);
    }
}

