/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.gamemanager.Utility3D;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.LoadResources;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public final class Model3D {
    public VertexBuffer vertexBuffer;
    public IndexBuffer indexBuffer;
    public Appearance[] appearance;
    public float[] dimensions;
    public VertexArray vertexArray;
    public VertexArray texArray;

    public Model3D(String path, Bitmap[] bitmaps, Appearance[] appearances, float[] translate, float[] scale, float[] textureScale, boolean isMutableTexture) {
        if (translate == null) {
            translate = Utility3D.getNewVector(0.0f, 0.0f, 0.0f);
        }
        if (scale == null) {
            scale = Utility3D.getNewVector(1.0f, 1.0f, 1.0f);
        }
        if (textureScale == null) {
            textureScale = Utility3D.getNewVector(1.0f, 1.0f, 1.0f);
        }
        this.dimensions = Utility3D.getDimensions(Utility3D.scaleArrayElements(Utility3D.translateArrayElements(this.getVerts(path), translate), scale));
        this.makeGeometry(path, translate, scale, textureScale);
        if (appearances != null) {
            this.appearance = appearances;
        } else if (bitmaps != null) {
            this.appearance = new Appearance[bitmaps.length];
            for (int i = 0; i < bitmaps.length; ++i) {
                this.appearance[i] = this.makeAppearance(bitmaps[i], isMutableTexture);
            }
        } else {
            this.appearance = new Appearance[1];
            this.appearance[0] = this.makeAppearance(new Bitmap(path + "texture.png"), isMutableTexture);
        }
    }

    void makeGeometry(String path, float[] translation, float[] scale, float[] textureScale) {
        short[] verts = this.getVerts(path);
        verts = Utility3D.scaleArrayElements(Utility3D.translateArrayElements(verts, translation), scale);
        this.vertexArray = new VertexArray(verts.length / 3, 3, 2);
        this.vertexArray.set(0, verts.length / 3, verts);
        byte[] norms = this.getNormals(path);
        VertexArray normArray = new VertexArray(norms.length / 3, 3, 1);
        normArray.set(0, norms.length / 3, norms);
        short[] tcs = Utility3D.scaleArrayElements(this.getTexCoordsRev(path), textureScale);
        this.texArray = new VertexArray(tcs.length / 2, 2, 2);
        this.texArray.set(0, tcs.length / 2, tcs);
        this.vertexBuffer = new VertexBuffer();
        float[] pbias = new float[]{0.003921569f, 0.003921569f, 0.003921569f};
        this.vertexBuffer.setPositions(this.vertexArray, 0.007843138f, pbias);
        this.vertexBuffer.setNormals(normArray);
        this.vertexBuffer.setTexCoords(0, this.texArray, 0.003921569f, null);
        this.indexBuffer = new TriangleStripArray(0, this.getStripLengths(path));
    }

    short[] getTexCoordsRev(String path) {
        short[] tcs = this.getTexCoords(path);
        for (int i = 1; i < tcs.length; i += 2) {
            tcs[i] = (short)(255 - tcs[i]);
        }
        return tcs;
    }

    public short[] getTexCor(String path) {
        return this.getTexCoordsRev(path);
    }

    Appearance makeAppearance(Bitmap textureBitmap, boolean isMutableTexture) {
        try {
            Image2D image2D = null;
            if (isMutableTexture) {
                image2D = new Image2D(99, textureBitmap.getWidth(), textureBitmap.getHeight());
                image2D.set(0, 0, textureBitmap.getWidth(), textureBitmap.getHeight(), Bitmap.getRGB_byte(textureBitmap));
            } else {
                image2D = new Image2D(99, (Object)textureBitmap.image);
            }
            Texture2D tex = new Texture2D(image2D);
            tex.setFiltering(208, 210);
            tex.setWrapping(241, 241);
            tex.setBlending(228);
            Appearance app = new Appearance();
            app.setTexture(0, tex);
            app.setMaterial(this.setMatColours());
            PolygonMode polygonMode = new PolygonMode();
            polygonMode.setCulling(160);
            app.setPolygonMode(polygonMode);
            return app;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            e2.printStackTrace();
            return null;
        }
    }

    short[] getVerts(String path) {
        return LoadResources.loadArrayFromFile_returnShort(path + "vertices.dat");
    }

    byte[] getNormals(String path) {
        return LoadResources.loadArrayFromFile_returnByte(path + "normals.dat");
    }

    short[] getTexCoords(String path) {
        return LoadResources.loadArrayFromFile_returnShort(path + "texture.dat");
    }

    int[] getStripLengths(String path) {
        return LoadResources.loadArrayFromFile_returnInt(path + "strip.dat");
    }

    Material setMatColours() {
        Material mat = new Material();
        mat.setColor(1024, -1);
        mat.setColor(4096, -1);
        mat.setColor(2048, -1);
        mat.setColor(8192, -1);
        mat.setShininess(96.07843f);
        return mat;
    }
}

