/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.platform;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.platform.AntiCrack;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.GameMIDlet;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class GameCanvas
extends Canvas
implements Runnable,
CommandListener {
    public final int LEFTSOFT_KEY;
    public final int RIGHTSOFT_KEY;
    public final int MIDDLESOFT_KEY;
    public final int KEYNUM_1;
    public final int KEYNUM_2;
    public final int KEYNUM_3;
    public final int KEYNUM_4;
    public final int KEYNUM_5;
    public final int KEYNUM_6;
    public final int KEYNUM_7;
    public final int KEYNUM_8;
    public final int KEYNUM_9;
    public final int KEYNUM_0;
    public final int UPKEY;
    public final int DOWNKEY;
    public final int LEFTKEY;
    public final int RIGHTKEY;
    public final int LEFTSWIPE;
    public final int RIGHTSWIPE;
    public final int UPSWIPE;
    public final int DOWNSWIPE;
    public GameMIDlet gamemidlet;
    public Thread mainThread;
    public boolean running = true;
    public GameManager gameManager;
    public int period;
    public long lag;
    public int fps;
    public int bgFps = this.fps = 30;
    public boolean wrongOrientation = false;
    private long lastTimeFpsUpdate = 0L;
    long lastTimePaint = 0L;
    boolean runningLoadingScreen = false;
    private int paintFps;
    private int paintFpsAverage;
    public Command backCommand;

    public GameCanvas(GameMIDlet gamemidlet) {
        this.LEFTSOFT_KEY = 101;
        this.RIGHTSOFT_KEY = 102;
        this.MIDDLESOFT_KEY = 103;
        this.KEYNUM_1 = 104;
        this.KEYNUM_2 = 105;
        this.KEYNUM_3 = 106;
        this.KEYNUM_4 = 107;
        this.KEYNUM_5 = 108;
        this.KEYNUM_6 = 109;
        this.KEYNUM_7 = 110;
        this.KEYNUM_8 = 111;
        this.KEYNUM_9 = 112;
        this.KEYNUM_0 = 113;
        this.UPKEY = 114;
        this.DOWNKEY = 115;
        this.LEFTKEY = 116;
        this.RIGHTKEY = 117;
        this.LEFTSWIPE = 118;
        this.RIGHTSWIPE = 119;
        this.UPSWIPE = 120;
        this.DOWNSWIPE = 121;
        this.gamemidlet = gamemidlet;
        this.setFullScreenMode(true);
    }

    public void start() {
        this.gameManager = new GameManager();
        this.mainThread = new Thread(this);
        this.mainThread.start();
        this.sizeChanged(this.getWidth(), this.getHeight());
        if (this.hasPointerEvents()) {
            this.backCommand = new Command("Back", 2, 1);
            this.addCommand(this.backCommand);
        }
        this.setCommandListener(this);
    }

    public void run() {
        AntiCrack.checkInternetConnection();
        this.gameManager.startGame();
        this.period = 1000 / this.fps;
        long previous = System.currentTimeMillis();
        this.lag = 0L;
        String wm = "99999334co333py444rig988ht r7999end0074ere434d34 22id5567e344a3423s";
        if (wm.equals("A")) {
            return;
        }
        while (this.running) {
            long current = System.currentTimeMillis();
            long elapsed = current - previous;
            previous = current;
            if (elapsed > (long)(this.period * 5)) {
                elapsed = this.period;
            }
            this.lag += elapsed;
            while (this.lag >= (long)this.period) {
                this.gameManager.update();
                this.lag -= (long)this.period;
            }
            if (this.gamemidlet.myGesture != null) {
                this.gamemidlet.myGesture.process();
            }
            this.repaint();
            this.serviceRepaints();
            int sleepTime = this.period - (int)(System.currentTimeMillis() - previous);
            if (sleepTime <= 0) {
                sleepTime = 1;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e2) {}
        }
    }

    public void startLoadingThread() {
        this.runningLoadingScreen = true;
        Thread t = new Thread(){

            public void run() {
                int period = 1000 / GameCanvas.this.fps;
                while (GameCanvas.this.runningLoadingScreen) {
                    long beforeTime = System.currentTimeMillis();
                    GameCanvas.this.repaint();
                    GameCanvas.this.serviceRepaints();
                    long timeDiff = System.currentTimeMillis() - beforeTime;
                    long sleepTime = (long)period - timeDiff;
                    if (sleepTime <= 5L) {
                        sleepTime = 10L;
                    }
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (Exception e2) {}
                }
            }
        };
        t.start();
    }

    public void setFps(int FPS) {
        this.fps = FPS;
    }

    public void setBgFps(int FPS) {
        this.bgFps = FPS;
    }

    public void paint(Graphics g2) {
        if (!this.wrongOrientation) {
            this.gameManager.paint(g2, this.lag / (long)this.period);
        } else {
            g2.setColor(0, 0, 0);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(255, 255, 255);
            Bitmap.drawMultilineString2(g2, "Please rotate your device or download correct version of this game.", this.getWidth() / 10, this.getHeight() / 2 - Bitmap.getMultilineStringHeight("Please rotate your device.", this.getWidth() * 8 / 10) / 2, this.getWidth() * 8 / 10);
        }
        if (this.gamemidlet.isShowFps) {
            long current = System.currentTimeMillis();
            if (current != this.lastTimePaint) {
                this.paintFpsAverage += (int)(1000L / (current - this.lastTimePaint));
            }
            this.paintFpsAverage /= 2;
            if (System.currentTimeMillis() - this.lastTimeFpsUpdate > 1000L) {
                this.paintFps = this.paintFpsAverage;
                this.lastTimeFpsUpdate = current;
            }
            g2.setColor(255, 0, 0);
            g2.drawString("Fps:" + this.paintFps, 0, 0, 0);
            this.lastTimePaint = current;
        }
    }

    public void keyPressed(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (i == 49 || i == 114) {
            this.gameManager.keyPressed(104);
        } else if (i == 50 || i == 116) {
            this.gameManager.keyPressed(105);
        } else if (i == 51 || i == 121) {
            this.gameManager.keyPressed(106);
        } else if (i == 52 || i == 102) {
            this.gameManager.keyPressed(107);
        } else if (i == 53 || i == 103) {
            this.gameManager.keyPressed(108);
        } else if (i == 54 || i == 104) {
            this.gameManager.keyPressed(109);
        } else if (i == 55 || i == 118) {
            this.gameManager.keyPressed(110);
        } else if (i == 56 || i == 98) {
            this.gameManager.keyPressed(111);
        } else if (i == 57 || i == 110) {
            this.gameManager.keyPressed(112);
        } else if (i == 48 || i == 109) {
            this.gameManager.keyPressed(113);
        } else if (j == 1) {
            this.gameManager.keyPressed(114);
        } else if (j == 6) {
            this.gameManager.keyPressed(115);
        } else if (j == 2) {
            this.gameManager.keyPressed(116);
        } else if (j == 5) {
            this.gameManager.keyPressed(117);
        } else if (i == 53 || i == -6 || i == -10) {
            this.gameManager.keyPressed(101);
        } else if (i == -5) {
            this.gameManager.keyPressed(103);
        } else if (i == -7 || i == 49) {
            this.gameManager.keyPressed(102);
        }
    }

    public void keyReleased(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (i == 49 || i == 114) {
            this.gameManager.keyReleased(104);
        } else if (i == 50 || i == 116) {
            this.gameManager.keyReleased(105);
        } else if (i == 51 || i == 121) {
            this.gameManager.keyReleased(106);
        } else if (i == 52 || i == 102) {
            this.gameManager.keyReleased(107);
        } else if (i == 53 || i == 103) {
            this.gameManager.keyReleased(108);
        } else if (i == 54 || i == 104) {
            this.gameManager.keyReleased(109);
        } else if (i == 55 || i == 118) {
            this.gameManager.keyReleased(110);
        } else if (i == 56 || i == 98) {
            this.gameManager.keyReleased(111);
        } else if (i == 57 || i == 110) {
            this.gameManager.keyReleased(112);
        } else if (i == 48 || i == 109) {
            this.gameManager.keyReleased(113);
        } else if (j == 1) {
            this.gameManager.keyReleased(114);
        } else if (j == 6) {
            this.gameManager.keyReleased(115);
        } else if (j == 2) {
            this.gameManager.keyReleased(116);
        } else if (j == 5) {
            this.gameManager.keyReleased(117);
        } else if (i == 53 || i == -6 || i == -10) {
            this.gameManager.keyReleased(101);
        } else if (i == -5) {
            this.gameManager.keyReleased(103);
        } else if (i == -7 || i == 49) {
            this.gameManager.keyReleased(102);
        }
    }

    public void keyRepeated(int i) {
        if (this.wrongOrientation) {
            return;
        }
        int j = this.getGameAction(i);
        if (i == 49 || i == 114) {
            this.gameManager.keyRepeated(104);
        } else if (i == 50 || i == 116) {
            this.gameManager.keyRepeated(105);
        } else if (i == 51 || i == 121) {
            this.gameManager.keyRepeated(106);
        } else if (i == 52 || i == 102) {
            this.gameManager.keyRepeated(107);
        } else if (i == 53 || i == 103) {
            this.gameManager.keyRepeated(108);
        } else if (i == 54 || i == 104) {
            this.gameManager.keyRepeated(109);
        } else if (i == 55 || i == 118) {
            this.gameManager.keyRepeated(110);
        } else if (i == 56 || i == 98) {
            this.gameManager.keyRepeated(111);
        } else if (i == 57 || i == 110) {
            this.gameManager.keyRepeated(112);
        } else if (i == 48 || i == 109) {
            this.gameManager.keyRepeated(113);
        } else if (j == 1) {
            this.gameManager.keyRepeated(114);
        } else if (j == 6) {
            this.gameManager.keyRepeated(115);
        } else if (j == 2) {
            this.gameManager.keyRepeated(116);
        } else if (j == 5) {
            this.gameManager.keyRepeated(117);
        } else if (i == 53 || i == -6 || i == -10) {
            this.gameManager.keyRepeated(101);
        } else if (i == -5) {
            this.gameManager.keyRepeated(103);
        } else if (i == -7 || i == 49) {
            this.gameManager.keyRepeated(102);
        }
    }

    public void pointerPressed(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        String pointerId = System.getProperty("com.nokia.pointer.number");
        if (!this.gamemidlet.isMultitouchEnabled) {
            if (pointerId != null) {
                this.gamemidlet.isSecondaryMultitouchEnabled = true;
                this.gameManager.pointerPressed(Integer.parseInt(pointerId), xx, yy);
            } else {
                this.gameManager.pointerPressed(0, xx, yy);
            }
        }
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.touchStart();
            this.gamemidlet.myGesture.addPoint(xx, yy);
        }
    }

    public void pointerReleased(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        String pointerId = System.getProperty("com.nokia.pointer.number");
        if (!this.gamemidlet.isMultitouchEnabled) {
            if (pointerId != null) {
                this.gamemidlet.isSecondaryMultitouchEnabled = true;
                this.gameManager.pointerReleased(Integer.parseInt(pointerId), xx, yy);
            } else {
                this.gameManager.pointerReleased(0, xx, yy);
            }
        }
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.addPoint(xx, yy);
            this.gamemidlet.myGesture.touchRelease();
        }
    }

    public void pointerDragged(int xx, int yy) {
        if (this.wrongOrientation) {
            return;
        }
        String pointerId = System.getProperty("com.nokia.pointer.number");
        if (!this.gamemidlet.isMultitouchEnabled) {
            if (pointerId != null) {
                this.gamemidlet.isSecondaryMultitouchEnabled = true;
                this.gameManager.pointerDragged(Integer.parseInt(pointerId), xx, yy);
            } else {
                this.gameManager.pointerDragged(0, xx, yy);
            }
        }
        if (this.gamemidlet.myGesture != null) {
            this.gamemidlet.myGesture.addPoint(xx, yy);
        }
    }

    public void hideNotify() {
        this.gameManager.pause();
        this.period = 1000 / this.bgFps;
    }

    public void showNotify() {
        this.gameManager.resume();
        this.period = 1000 / this.fps;
    }

    protected void sizeChanged(int newWidth, int newHeight) {
    }

    public void commandAction(Command c2, Displayable d2) {
        if (c2 == this.backCommand) {
            this.gameManager.onBackKey();
        } else {
            System.out.println("pass");
            this.gameManager.commandAction(c2);
        }
    }

    public void handleSwipe(int direction) {
        this.gameManager.handleSwipe(direction);
    }
}

