/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.Utility;
import com.renderedideas.platform.Bitmap;
import javax.microedition.lcdui.Graphics;

public class Selector {
    private static int SELECTOR_SPEED;
    public static Bitmap selectorBitmap;
    public static Point position;
    private static boolean rightPress;
    private static boolean upPress;
    private static boolean leftPress;
    private static boolean downPress;

    public static void initialize() {
        SELECTOR_SPEED = (int)((float)GameManager.screenWidth * 0.01f);
        selectorBitmap = new Bitmap("selector.png");
        position = new Point(GameManager.screenWidth / 2, GameManager.screenHeight / 2);
    }

    public static void paint(Graphics g2) {
        if (selectorBitmap != null && position != null) {
            Bitmap.drawBitmap(g2, selectorBitmap, (int)Selector.position.X, (int)Selector.position.Y);
        }
    }

    public static void reset() {
        if (position != null) {
            leftPress = false;
            downPress = false;
            upPress = false;
            rightPress = false;
            Selector.position.X = GameManager.screenWidth / 2;
            Selector.position.Y = GameManager.screenHeight / 2;
        }
    }

    public static void update() {
        if (position != null) {
            if (rightPress) {
                Selector.position.X += (float)SELECTOR_SPEED;
            }
            if (upPress) {
                Selector.position.Y -= (float)SELECTOR_SPEED;
            }
            if (leftPress) {
                Selector.position.X -= (float)SELECTOR_SPEED;
            }
            if (downPress) {
                Selector.position.Y += (float)SELECTOR_SPEED;
            }
            Selector.position.X = Utility.clamp(Selector.position.X, 0.0f, GameManager.screenWidth);
            Selector.position.Y = Utility.clamp(Selector.position.Y, 0.0f, GameManager.screenHeight);
        }
    }

    public static void keyPressed(int key) {
        switch (key) {
            case 117: {
                rightPress = true;
                break;
            }
            case 109: {
                rightPress = true;
                break;
            }
            case 116: {
                leftPress = true;
                break;
            }
            case 107: {
                leftPress = true;
                break;
            }
            case 114: {
                upPress = true;
                break;
            }
            case 105: {
                upPress = true;
                break;
            }
            case 115: {
                downPress = true;
                break;
            }
            case 111: {
                downPress = true;
            }
        }
    }

    public static void keyReleased(int key) {
        switch (key) {
            case 117: {
                rightPress = false;
                break;
            }
            case 109: {
                rightPress = false;
                break;
            }
            case 116: {
                leftPress = false;
                break;
            }
            case 107: {
                leftPress = false;
                break;
            }
            case 114: {
                upPress = false;
                break;
            }
            case 105: {
                upPress = false;
                break;
            }
            case 115: {
                downPress = false;
                break;
            }
            case 111: {
                downPress = false;
            }
        }
    }
}

