/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.components;

import com.am.activity.interfaces.ButtonInterface;
import com.am.activity.main.Activity;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CopyOfTextArea
implements ButtonInterface {
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 0;
    private final int SCROLL_STEP;
    private int scrollbarWidth = 4;
    private int scrollbarHeight = 0;
    private boolean scrollbarVisible = true;
    private int scrollbarTop = 0;
    private int scrollbarColor = 0;
    private int borderWidth = 1;
    private Font textFont = Font.getDefaultFont();
    private int textColor = 0;
    private int padding = 0;
    private int interline = 2;
    private int width = 0;
    private int height = 0;
    private int innerWidth = 0;
    private int innerHeight = 0;
    private int currentY = 0;
    private int textHeight = 0;
    private int currY = 0;
    private String[] textRows = null;
    private int posX;
    private int posY;
    private boolean draggedOn = true;

    public static CopyOfTextArea CreateMultiLineText(Activity activity, String text, int width, int height) {
        return new CopyOfTextArea(activity, text, width, height);
    }

    public static CopyOfTextArea CreateMultiLineText(Activity activity, String text, int width, int height, int posX, int posY) {
        return new CopyOfTextArea(activity, text, width, height, posX, posY);
    }

    private CopyOfTextArea(Activity activity, String text, int width, int height) {
        this.SCROLL_STEP = 5;
        activity.addTextField(this);
        this.scrollableTextFieldExt(width, height);
        this.setText(text);
        this.posX = 0;
        this.posY = 0;
        this.currY = 0;
    }

    private CopyOfTextArea(Activity activity, String text, int width, int height, int posX, int posY) {
        this.SCROLL_STEP = 5;
        activity.addTextField(this);
        this.posX = posX;
        this.posY = posY;
        this.currY = posY;
        this.scrollableTextFieldExt(width, height);
        this.setText(text);
    }

    public CopyOfTextArea(String text, int width, int height, int posX, int posY) {
        this.SCROLL_STEP = 5;
        this.posX = posX;
        this.posY = posY;
        this.currY = posY;
        this.scrollableTextFieldExt(width, height);
        this.setText(text);
    }

    private void scrollableTextFieldExt(int width, int height) {
        this.width = width;
        this.height = height;
        this.innerWidth = width - 2 * this.getBorderWidth() - 2 * this.padding - this.scrollbarWidth;
        this.innerHeight = height - 2 * this.getBorderWidth() - 2 * this.padding - this.posY;
    }

    public void setText(String text) {
        this.textRows = this.getTextRows(text, this.getTextFont(), this.innerWidth - this.posX);
        this.textHeight = this.textRows.length * (this.interline + this.getTextFont().getHeight());
        this.scrollbarHeight = Math.min(this.innerHeight, this.innerHeight * this.innerHeight / this.textHeight);
        this.scrollbarTop = this.posY;
        this.currentY = -this.posY;
    }

    private String[] getTextRows(String text, Font font, int width) {
        char spaceChar = ' ';
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer currentRowText = new StringBuffer();
        int prevIndex = 0;
        int currIndex = text.indexOf(spaceChar);
        if (currIndex == -1) {
            currIndex = text.length();
        }
        int rowWidth = 0;
        boolean tokenWidth = false;
        int whitespaceWidth = font.stringWidth(" ");
        String currentToken = null;
        while (currIndex != -1) {
            currentToken = text.substring(prevIndex, currIndex);
            int var15 = font.stringWidth(currentToken);
            rowWidth += var15;
            if (currentRowText.length() > 0) {
                rowWidth += whitespaceWidth;
            }
            if (currentRowText.length() > 0 && rowWidth > width) {
                rowsVector.addElement(currentRowText.toString());
                currentRowText.setLength(0);
                currentRowText.append(currentToken);
                rowWidth = var15;
            } else {
                if (currentRowText.length() > 0) {
                    currentRowText.append(spaceChar);
                }
                currentRowText.append(currentToken);
            }
            if (currIndex == text.length()) break;
            prevIndex = currIndex + 1;
            if ((currIndex = text.indexOf(spaceChar, prevIndex)) != -1) continue;
            currIndex = text.length();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText.toString());
        }
        String[] rowsArray = new String[rowsVector.size()];
        for (int i = 0; i < rowsArray.length; ++i) {
            rowsArray[i] = (String)rowsVector.elementAt(i);
        }
        return rowsArray;
    }

    private void scroll(int delta) {
        this.currentY += 5 * delta / 20;
        if (this.currentY < -1 * this.posY) {
            this.currentY = -this.posY;
        } else if (this.currentY > this.textHeight - this.innerHeight - this.posY) {
            this.currentY = Math.max(this.posY, this.textHeight - this.innerHeight - this.posY);
        }
        this.scrollbarTop = this.posY + this.innerHeight * (this.posY + this.currentY) / this.textHeight;
    }

    public void paint(Graphics g) {
        g.setColor(this.getTextColor());
        g.setFont(this.getTextFont());
        g.translate(this.getBorderWidth() + this.padding, this.getBorderWidth() + this.padding);
        g.setClip(0, this.posY, this.innerWidth, this.innerHeight);
        if (this.textRows != null) {
            for (int i = 0; i < this.textRows.length; ++i) {
                g.drawString(this.textRows[i], this.posX, i * (this.getTextFont().getHeight() + this.interline) - this.currentY, 20);
            }
        }
        g.setClip(0, 0, 500, 500);
        if (this.textRows.length * (this.getTextFont().getHeight() + this.interline) < this.height) {
            this.scrollbarVisible = false;
        }
        if (this.scrollbarVisible) {
            g.setColor(this.getScrollbarColor());
            g.fillRect(this.innerWidth, this.scrollbarTop, this.scrollbarWidth, this.scrollbarHeight);
        }
        g.translate(-(this.borderWidth + this.padding), -(this.borderWidth + this.padding));
    }

    public boolean pointerPressed(int x, int y) {
        if (x > this.posX && x < this.posX + this.width && y > this.posY && y < this.posY + this.height) {
            this.currY = y;
        }
        return true;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.draggedOn) {
            this.scroll(this.currY - y);
        }
        return true;
    }

    public int getScrollbarColor() {
        return this.scrollbarColor;
    }

    public void setScrollbarColor(int scrollbarColor) {
        this.scrollbarColor = scrollbarColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setScrollbarVisible(boolean scrollbarVisible) {
        this.scrollbarVisible = scrollbarVisible;
    }

    public boolean pointerReleased(int x, int y) {
        return false;
    }

    public boolean getDraggedIOn() {
        return this.draggedOn;
    }

    public void setDraggedOn(boolean dragggedOn) {
        this.draggedOn = dragggedOn;
    }
}

