/*
 * Decompiled with CFR 0.152.
 */
package com.am.poo.game;

import com.am.activity.components.NewButton;
import com.am.activity.interfaces.ActivityInterface;
import com.am.activity.interfaces.ActivityListener;
import com.am.activity.main.Activity;
import com.am.poo.ActivityCanvas;
import com.am.poo.game.Poo;
import com.am.tools.AudioManager;
import com.am.tools.ImageHelper;
import com.am.tools.Logger;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;

public class Game
extends Activity
implements ActivityInterface,
ActivityListener {
    public static final int HEIGHT_BANNER = 40;
    private static final int EVENT_START_NEW_GAME = 100;
    public static final int EVENT_GAME_OVER = 666;
    public static final Font myFont = Font.getFont((int)64, (int)2, (int)0);
    public static final Font smalFont = Font.getFont((int)64, (int)2, (int)8);
    public static final Font largeFont = Font.getFont((int)64, (int)2, (int)16);
    public static final Sprite BACKGROUND = new Sprite(ImageHelper.loadCached("/img/fon.png"), 240, 400);
    private int currentLevel = 0;
    private ActivityListener listener;
    private NewButton buttonPause;
    private int pointsInt;
    private String currentPointsStr;
    public int pressesBut = 0;
    public boolean pause = true;
    private NewButton eatButton;
    private NewButton playButton;
    private NewButton sleepButton;
    private NewButton travelButton;
    private Poo poo;
    private Random random = new Random();
    private AudioManager audioManager;
    int space = 0;
    private float time = 0.0f;

    public Game(ActivityListener l, int width, int height) {
        super(width, height);
        Logger.log("Game()");
        this.listener = l;
        this.poo = new Poo((Activity)this, ImageHelper.loadCached("/img/wait.png"), 251, 220);
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(0);
        g.fillRect(0, 0, this.activityWidth, this.activityHeight);
        super.paint(g, x, y);
    }

    protected void showNotify() {
        Logger.log("ActivityCanvas.showNotify()");
        Logger.increaseIndent();
        Logger.decreaseIndent();
    }

    protected void hideNotify() {
        Logger.log("ActivityCanvas.hideNotify()");
        Logger.increaseIndent();
        Logger.decreaseIndent();
    }

    public void initResources() {
        Logger.log("Game.initResources()");
        this.buttonPause = NewButton.createButtonWithImage(this, ImageHelper.loadImage("/img/btns/pause.png"));
        this.buttonPause.setPosition(2, 2);
        this.audioManager = AudioManager.getInstance();
        this.eatButton = NewButton.createButtonWithImage(this, ImageHelper.loadImage("/img/eat.png"));
        this.playButton = NewButton.createButtonWithImage(this, ImageHelper.loadImage("/img/play.png"));
        this.sleepButton = NewButton.createButtonWithImage(this, ImageHelper.loadImage("/img/sleep.png"));
        this.travelButton = NewButton.createButtonWithImage(this, ImageHelper.loadImage("/img/travel.png"));
        this.space = this.getActivityWidth() - this.eatButton.getWidth() - this.playButton.getWidth() - this.sleepButton.getWidth() - this.travelButton.getWidth();
        this.playButton.setPosition(this.space / 8, this.getActivityHeight() - 5 - this.playButton.getHeight() - 0);
        this.eatButton.setPosition(this.playButton.getX() + this.playButton.getWidth() + this.space / 4, this.getActivityHeight() - 5 - this.eatButton.getHeight() - 0);
        this.sleepButton.setPosition(this.eatButton.getX() + this.eatButton.getWidth() + this.space / 4, this.getActivityHeight() - 5 - this.sleepButton.getHeight() - 0);
        this.travelButton.setPosition(this.sleepButton.getX() + this.sleepButton.getWidth() + this.space / 4, this.getActivityHeight() - 5 - this.travelButton.getHeight() - 0);
        this.append((Layer)this.poo);
        this.poo.setPosition(this.getActivityWidth() / 2 - this.poo.getWidth() / 2, this.getActivityHeight() / 2 - this.poo.getHeight() / 2);
        this.append((Layer)BACKGROUND);
    }

    public void refreshResources() {
    }

    public void resumeGame() {
        this.pause = false;
    }

    public void pauseGame() {
        this.pause = true;
    }

    public void startGame() {
        this.pause = false;
        this.handleEvent(100);
    }

    public void updateGame() {
        if (!this.pause) {
            this.time += ActivityCanvas.deltaTime;
            if (0.5 < (double)this.time) {
                this.poo.updateTime();
                this.time = 0.0f;
            }
            this.poo.update();
            this.checkEnableButton();
        }
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        Logger.log("Game.handleEvent( " + event + " )");
        Logger.increaseIndent();
        switch (event) {
            case 100: {
                this.pointsInt = 0;
            }
        }
        Logger.decreaseIndent();
    }

    public void buttonIsPressed(int index) {
        Logger.log("Game.buttonIsPressed( " + index + " )");
        Logger.increaseIndent();
        Logger.decreaseIndent();
    }

    public void buttonIsReleased(int index) {
        Logger.log("Game.buttonIsReleased( " + index + " )");
        Logger.increaseIndent();
        if (index == this.buttonPause.getID()) {
            this.listener.handleEvent(2);
        }
        if (index == this.eatButton.getID()) {
            this.poo.setEnableButton(0);
            this.checkEnableButton();
            this.poo.handleEvent(-1);
            this.time = 0.0f;
        }
        if (index == this.playButton.getID()) {
            int i = Math.abs(this.random.nextInt(1999)) / 1000;
            System.out.println("EVENT#" + i);
            switch (i) {
                case 0: {
                    this.listener.handleEvent(100500);
                    break;
                }
                case 1: {
                    this.listener.handleEvent(228);
                }
            }
        }
        if (index == this.sleepButton.getID()) {
            this.poo.setEnableButton(0);
            this.checkEnableButton();
            this.poo.handleEvent(4);
            this.time = 0.0f;
        }
        if (index == this.travelButton.getID()) {
            this.poo.setEnableButton(0);
            this.checkEnableButton();
            this.poo.handleEvent(5);
            this.time = 0.0f;
            BACKGROUND.nextFrame();
        }
        Logger.decreaseIndent();
    }

    public void buttonIsDragged(int index, int x, int y) {
        Logger.log("Game.buttonIsReleased( " + index + " )");
        Logger.increaseIndent();
    }

    public void checkEnableButton() {
        switch (this.poo.getEnableButton()) {
            case -1: {
                this.eatButton.enable();
                this.playButton.enable();
                this.sleepButton.enable();
                this.poo.enable();
                break;
            }
            case 0: {
                this.eatButton.disable();
                this.playButton.disable();
                this.sleepButton.disable();
                this.poo.disable();
            }
        }
    }

    public void returnState(int arg0, int arg1) {
    }
}

