/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class TextReader {
    private static TextReader instance;
    private static String ENCODE;

    public static TextReader getInstance() {
        if (instance == null) {
            instance = new TextReader();
        }
        return instance;
    }

    public String readTextToString(String filename) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        String result = "";
        try {
            while ((line = this.readLine(reader)) != null) {
                result = result + line;
            }
        }
        catch (IOException var7) {
            var7.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException var6) {
            var6.printStackTrace();
        }
        return result;
    }

    public String readFile(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        String result = null;
        while ((line = this.readLine(reader)) != null) {
            result = result + line;
        }
        reader.close();
        return result;
    }

    public String[] readFileToArray(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(filename), ENCODE);
        String line = null;
        Vector<String> str = new Vector<String>();
        while ((line = this.readLine(reader)) != null) {
            str.addElement(line);
        }
        String[] result = new String[str.size()];
        if (str.size() > 0) {
            for (int loop = 0; loop < str.size(); ++loop) {
                result[loop] = (String)str.elementAt(loop);
            }
        }
        reader.close();
        return result;
    }

    private String readLine(Reader reader) throws IOException {
        int readChar = reader.read();
        if (readChar == -1) {
            return null;
        }
        StringBuffer string = new StringBuffer("");
        while (readChar != -1 && readChar != 10) {
            if (readChar != 13) {
                string.append((char)readChar);
            }
            readChar = reader.read();
        }
        return string.toString();
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
            }
        }
        return result;
    }

    public static String[] splitStringByWidth(String stringToSplit, Font font, int width) {
        StringBuffer strBuf = new StringBuffer();
        Vector<String> strResult = new Vector<String>();
        String[] workStr = TextReader.split(stringToSplit, " ");
        strBuf.append(workStr[0]);
        for (int result = 1; result < workStr.length; ++result) {
            if (font.stringWidth(strBuf.toString()) + font.stringWidth(workStr[result]) <= width) {
                strBuf.append(" ").append(workStr[result]);
            } else {
                strResult.addElement(strBuf.toString());
                strBuf.delete(0, strBuf.length());
                strBuf.append(workStr[result]);
            }
            if (!(font.stringWidth(strBuf.toString()) <= width & result == workStr.length - 1)) continue;
            strResult.addElement(strBuf.toString());
            strBuf.delete(0, strBuf.length());
        }
        strBuf.delete(0, strBuf.length());
        String[] var8 = new String[strResult.size()];
        if (strResult.size() > 0) {
            for (int loop = 0; loop < strResult.size(); ++loop) {
                var8[loop] = (String)strResult.elementAt(loop);
            }
        }
        return var8;
    }

    static {
        ENCODE = "UTF-8";
    }
}

