/*
 * Decompiled with CFR 0.152.
 */
package com.academmedia.radiantjewels;

import com.am.activity.components.NewButton;
import com.am.activity.main.Activity;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NewButtonExt
extends NewButton {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    private final int DEFAULT_TEXT_COLOR;
    private final Font DEFAULT_FONT = Font.getDefaultFont();
    protected Activity activity;
    private String labeltext;
    private int labelColor = 0xFFFFFF;
    private Font labelFont = Font.getFont((int)64, (int)2, (int)16);
    private Font defaultFont = Font.getDefaultFont();
    private int fontColor = 0;
    private int buttonID;
    private int xPos;
    private int yPos;
    private boolean marked;
    private boolean hasText;
    private int btnNum;
    private Image image;
    boolean enabled = true;
    boolean pressed = false;

    public static NewButtonExt createButtonWithImage(Activity view, Image image, int btnNum) {
        return new NewButtonExt(view, image, btnNum);
    }

    public static NewButtonExt createButtonWithImage(Activity view, Image image, int width, int height, int btnNum) {
        return new NewButtonExt(view, image, width, height, btnNum);
    }

    public static NewButton createButtonWithText(Activity view, String text) {
        Font defFont = Font.getFont((int)64, (int)2, (int)16);
        int ww = defFont.stringWidth(text) + 5;
        int hh = defFont.getHeight() + 6;
        int[] srcMap = new int[ww * hh];
        for (int destImgNull = 0; destImgNull < srcMap.length; ++destImgNull) {
            srcMap[destImgNull] = 0;
        }
        Image var7 = Image.createRGBImage((int[])srcMap, (int)ww, (int)hh, (boolean)true);
        return new NewButtonExt(view, var7, text);
    }

    private NewButtonExt(Activity activity, Image image, String text) {
        super(activity, image);
        this.DEFAULT_TEXT_COLOR = 0;
        this.labeltext = text;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
        this.setHasText(true);
    }

    private NewButtonExt(Activity activity, Image image, int btnNum) {
        super(activity, image);
        this.DEFAULT_TEXT_COLOR = 0;
        this.image = image;
        this.btnNum = btnNum;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
        this.setHasText(false);
    }

    private NewButtonExt(Activity activity, Image image, int width, int height, int btnNum) {
        super(activity, image, width, height);
        this.DEFAULT_TEXT_COLOR = 0;
        this.image = image;
        this.btnNum = btnNum;
        this.activity = activity;
        this.activity.addButton(this);
        this.buttonID = activity.getID(this);
        this.setHasText(false);
    }

    public boolean pointerPressed(int x, int y) {
        if (this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = true;
            this.activity.buttonIsPressed(this.getBtnNum());
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.pressed && this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = false;
            this.activity.buttonIsReleased(this.getBtnNum());
            return true;
        }
        this.pressed = false;
        return false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    private boolean contains(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    public void setText(String text, Font font, int color) {
        this.labeltext = text;
        this.labelColor = color;
        this.labelFont = font;
        this.xPos = this.getX() + this.getWidth() / 2;
        this.yPos = this.getY() + this.getHeight() / 2 - this.labelFont.getHeight() / 2;
        this.setHasText(true);
    }

    public void setText(String text) {
        this.setText(text, this.labelFont, this.labelColor);
        this.setHasText(true);
    }

    public void printText(Graphics g) {
        this.xPos = this.getX() + this.getWidth() / 2;
        this.yPos = this.getY() + this.getHeight() / 2 - this.labelFont.getHeight() / 2;
        g.setColor(this.labelColor);
        g.setFont(this.labelFont);
        g.drawString(this.labeltext, this.xPos, this.yPos, 17);
        g.setColor(0);
        g.setFont(this.DEFAULT_FONT);
    }

    public void setImage(Image img, int frameWidth, int frameHeight) {
        super.setImage(img, frameWidth, frameHeight);
        this.image = img;
    }

    public int getBtnNum() {
        return this.btnNum;
    }

    public Image getImage() {
        return this.image;
    }

    public void setBtnNum(int btnNum) {
        this.btnNum = btnNum;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public boolean pointerDragged(int arg0, int arg1) {
        return false;
    }
}

