/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.base.Core;
import com.creativenorth.base.Timekeeper;
import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNMosaic;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.Menu;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import com.creativenorth.util.math.CNRandom;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import schoolfriends.CNSound;
import schoolfriends.CNTextbox;
import schoolfriends.CharacterViewer;
import schoolfriends.Credits;
import schoolfriends.Data;
import schoolfriends.FriendList;
import schoolfriends.Headshot;
import schoolfriends.MultiOptiList;
import schoolfriends.SchoolMidlet;
import schoolfriends.Scripts;
import schoolfriends.games.MiniGame;
import schoolfriends.games.NumberGame;
import schoolfriends.graphics.Engine;
import schoolfriends.graphics.Render;
import schoolfriends.loading.CNSaveData;
import schoolfriends.loading.LoadingBar;
import schoolfriends.loading.LoadingRequirement;
import schoolfriends.menu.MenuScripts;

public class SchoolCore
extends Core {
    public static final int COL_BLUE_1 = 40951;
    public static final int COL_BLUE_2 = 4373754;
    public static final int COL_BLUE_3 = 7983099;
    public static final int COL_BLUE_4 = 10217215;
    public static final int COL_ORANGE = 16742656;
    public static final int COL_YELLOW = 16775587;
    public static final int COL_PURPLE = 10289329;
    public static final int COL_FUSHIA = 15567871;
    public static final int COL_ORANGE_RED = 16209455;
    public static final int COL_GREY = 0xA0A0A0;
    public static final int COL_GREYORANGE = 14522720;
    public static final String g_textPath = "/text.dat";
    public static SchoolCore me;
    protected SchoolMidlet m_midlet;
    public static final int MAX_ROOMS_IN_LIST = 10;
    public static CNGraphics g_graphics;
    public CNSaveData m_rms;
    private int m_iPrerunLoadPhase = 0;
    public static boolean splashshown;
    public static Image LOGO;
    public static Image SPLASH;
    public static int LanguageIndex;
    public static String RMS_STORENAME;
    public static int RMSRECORD_GAME;
    public static boolean m_bSavedDataExists;
    int superHighlight;
    static boolean scriptdone;
    public static int ScriptDone;
    public boolean flag_ = false;
    boolean m_bEditName = false;
    public static final int LOADING_BAR = 1;
    public static final int MAIN_GAME = 2;
    public static final int CONVERSE_CROSS = 3;
    public static final int STATS = 4;
    public static final int CHARACTER_VIEWER = 7;
    public static final int TEXTBOX = 8;
    public static final int HEADSHOT = 9;
    public static final int FRIENDLIST = 10;
    public static final int STATLIST = 11;
    public static final int MOLLY = 12;
    public static final int CINEMATIC = 13;
    public static final int MINIGAME = 14;
    public static final int MSGLIST = 15;
    public static final int CREDITS = 16;
    public static final int NUMBERGAME = 17;
    CNTextbox textbox;
    Credits credits;
    public static boolean snd_check;
    int[] productMvars = new int[]{0};
    public static String version_temp;
    long messagetimer = 0L;
    private int day = 1;
    int m_iQueryText;
    int m_iQueryTitle;
    static String FILE_GMG_TEXTS;
    public static boolean GMG;
    public static boolean GMG_ON;
    public static Image GMG_STATIC_IMAGE;
    public static boolean GMG_STATIC;
    public static boolean GMG_WAP;
    public static boolean GMG_MENU;
    public static boolean GMG_BOOT;
    public static boolean GMG_EXIT;
    public static boolean GMG_CLOSE;
    public static String GMG_URL;
    public static String GMG_TITLE_TEXT;
    public static String GMG_PROMPT_TEXT;
    public static String GMG_CLOSE_TEXT;
    boolean m_bVibration = false;
    CNSound bgm;

    public SchoolCore(SchoolMidlet midlet) {
        this.m_midlet = midlet;
        me = this;
        SchoolCore.QueryGMGParameters();
    }

    public void prerunLoad() {
        switch (this.m_iPrerunLoadPhase) {
            case 1: {
                this.constructStatics();
                this.setLoadPercent(20);
                break;
            }
            case 2: {
                this.primeMenu();
                this.setLoadPercent(80);
                break;
            }
            case 3: {
                this.getJadStrings();
                this.setLoadPercent(90);
                break;
            }
            case 4: {
                this.setLoadPercent(95);
            }
            case 5: {
                super.prerunLoad();
                this.setLoadPercent(100);
                if (splashshown) break;
                this.menuScripts.runAction(9999);
                splashshown = true;
            }
        }
        ++this.m_iPrerunLoadPhase;
    }

    public void hideNotify() {
        super.hideNotify();
        CNSound.stopall();
    }

    public void constructStatics() {
        Timekeeper.me = new Timekeeper();
    }

    private void primeScrollbars() {
        int size;
        int text;
        ScreenObject scrobject;
        CNText.setFont(0);
        if (Menu.inMenu(88)) {
            scrobject = ScreenObject.getObject(94);
            scrobject.setHeight(scrobject.getHeight() - scrobject.getHeight() % CNText.m_fontHeight);
            text = scrobject.getTextRef();
            scrobject.enableScrollBar(11, 0, 10217215, 40951, 10217215);
            size = CNText.recalcNewlines(text, scrobject.getWidth());
            scrobject.setScrollBarMaximum(size * CNText.m_fontHeight, scrobject.getHeight());
        }
        if (Menu.inMenu(115)) {
            scrobject = ScreenObject.getObject(122);
            scrobject.setHeight(scrobject.getHeight() - scrobject.getHeight() % CNText.m_fontHeight);
            text = scrobject.getTextRef();
            scrobject.enableScrollBar(11, 0, 10217215, 40951, 10217215);
            size = CNText.recalcNewlines(text, scrobject.getWidth()) + 2;
            scrobject.setScrollBarMaximum(size * CNText.m_fontHeight, scrobject.getHeight());
        }
    }

    public static void selectLanguage() {
        block19: {
            SchoolCore.me.m_iState = 1;
            me.setLoadPercent(50);
            try {
                if (Menu.m_iSelectedButton == 0) {
                    CNText.load(g_textPath, 1);
                } else if (Menu.m_iSelectedButton == 1) {
                    CNText.load("/FRENCH/text.dat", 1);
                } else if (Menu.m_iSelectedButton == 2) {
                    CNText.load("/ITALIAN/text.dat", 1);
                } else if (Menu.m_iSelectedButton == 3) {
                    CNText.load("/GERMAN/text.dat", 1);
                } else if (Menu.m_iSelectedButton == 4) {
                    CNText.load("/SPANISH/text.dat", 1);
                } else if (Menu.m_iSelectedButton == 5) {
                    CNText.load("/PORTUGUESE/text.dat", 1);
                }
                LanguageIndex = Menu.m_iSelectedButton;
                me.setLoadPercent(80);
                try {
                    if (LanguageIndex == 3) {
                        SPLASH = Image.createImage((String)"/Splash_German.png");
                        LOGO = Image.createImage((String)"/de.png");
                        break block19;
                    }
                    LOGO = Image.createImage((String)"/eng.png");
                }
                catch (Exception e) {
                    System.out.println("e " + e.toString());
                }
            }
            catch (Exception e) {
                System.out.println("french " + e);
            }
        }
        if (GMG) {
            LanguageIndex = Menu.m_iSelectedButton;
            SchoolCore.LoadGMGTexts();
            SchoolCore.InitGMG();
        }
        if (GMG && GMG_BOOT) {
            SchoolCore.handleGMGFlow();
        } else {
            Menu.gotoMenu(43);
        }
    }

    public void primeMenu() {
        this.m_bInitialLoad = true;
        this.setMenuScripts(new MenuScripts());
        this.setLoadPercent(20);
        try {
            CNText.load(g_textPath, 1);
        }
        catch (Exception e) {
            Log.addExeption("Issue loading text.dat file.", e);
        }
        this.setLoadPercent(35);
        Menu.load("/menu.cmb");
        this.setLoadPercent(50);
        Menu.m_iGameMenu = 53;
        Menu.m_pauseMenuID = 79;
        this.menuScripts.runAction(9999);
        this.m_bInitialLoad = false;
        this.setLoadPercent(60);
        this.setupRMS();
        if (!m_bSavedDataExists) {
            ScreenObject loadButton = ScreenObject.getObject(18);
            if (loadButton != null) {
                loadButton.disable();
            }
        } else {
            ScreenObject loadButton = ScreenObject.getObject(18);
            if (loadButton != null) {
                loadButton.enable();
            }
        }
        this.setLoadPercent(70);
    }

    public void listSetup() {
    }

    public void endCore() {
        Timekeeper.me = null;
        super.endCore();
    }

    private void setupRMS() {
        this.m_rms = new CNSaveData();
        this.m_rms.open(RMS_STORENAME);
        RMSRECORD_GAME = this.m_rms.setupRecord();
        m_bSavedDataExists = this.m_rms.beginRead(RMSRECORD_GAME);
        this.m_rms.close();
        this.superHighlight = -1;
    }

    public void save(int _record) {
        try {
            this.m_rms.open(RMS_STORENAME);
            this.m_rms.beginWrite();
            if (_record == RMSRECORD_GAME) {
                Data.getCharacter(0).save(this.m_rms);
                this.m_rms.writeArrayU16(Scripts.overrides);
                this.m_rms.writeArrayU16(Scripts.cvar);
                this.m_rms.writeU16(Engine.g_iCurrentRoomIndex);
                this.m_rms.writeS16(Engine.getHighlightedIndex());
                this.m_rms.writeU32(Engine.g_iTimedScriptTimer);
            }
            this.m_rms.endWrite(_record);
            this.m_rms.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m_bSavedDataExists = true;
    }

    public void load(int _record) {
        try {
            this.m_rms.open(RMS_STORENAME);
            if (!this.m_rms.beginRead(_record)) {
                return;
            }
            if (_record == RMSRECORD_GAME) {
                Data.getCharacter(0).load(this.m_rms);
                Scripts.overrides = this.m_rms.readArrayU16();
                Scripts.cvar = this.m_rms.readArrayU16();
                int room = this.m_rms.readU16();
                this.superHighlight = this.m_rms.readS16();
                Engine.g_iTimedScriptTimer = this.m_rms.readU32();
                Engine.KillAllScripts();
                Render.resetRasters();
                Engine.g_bControlsEnabled = true;
                Engine.LoadRoom(room);
                while (LoadingBar.isLoading()) {
                    this.repaint();
                    this.serviceRepaints();
                }
                Engine.setHighlightedIndex(this.superHighlight);
            }
            this.m_rms.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void newGame() {
        try {
            LoadingRequirement lr = new LoadingRequirement();
            me.showLoading(lr, 30);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetScripts();
        if (MiniGame.g_bMinigameShown) {
            MiniGame.g_bMinigameShown = false;
        }
        if (MiniGame.g_bNumberGameShown) {
            MiniGame.g_bNumberGameShown = false;
        }
    }

    public void cleanLists() {
    }

    public void autosave() {
        this.save(RMSRECORD_GAME);
        m_bSavedDataExists = true;
    }

    public void autoload() {
        if (m_bSavedDataExists) {
            this.resetScripts();
            this.showLoading(new LoadingRequirement(), 53);
            while (LoadingBar.isLoading()) {
                this.repaint();
                this.serviceRepaints();
            }
            this.load(RMSRECORD_GAME);
        }
    }

    public void resetData() {
        this.m_rms.reset(RMS_STORENAME);
        m_bSavedDataExists = false;
    }

    public void testRMS() {
    }

    public void resetScripts() {
        Engine.g_iTimedScriptTimer = 0;
        Scripts.overrides = null;
        if (Scripts.cvar != null) {
            int i = Scripts.cvar.length;
            while (i-- > 0) {
                Scripts.cvar[i] = 0;
            }
        }
        Engine.g_crontab = new Data.CronJob[0];
        Scripts.setMission(2, true);
    }

    public void showLoading(LoadingRequirement loading, int _subsequentMenu) {
        Menu.gotoMenu(46);
        CNRandom.Seed = System.currentTimeMillis();
        this.hideSoftkeys();
        LoadingBar.setNeeded(loading, _subsequentMenu);
    }

    public boolean loadingShown() {
        return Menu.iCurrentMenu == 46;
    }

    public void showGame() {
        Menu.unload();
    }

    public void setScreenSize(int width, int height) {
    }

    public Image createImageFromCommand(int command) {
        return null;
    }

    public void drawButton(CNGraphics graphics, int textref, int button, int totalButtons, boolean selected) {
    }

    public void drawSoftkey(CNGraphics graphics, int textref, int position) {
    }

    public boolean onKeyDown(int keymask) {
        int pos;
        if (Menu.inMenu(30)) {
            if (keymask == 2 || keymask == 54) {
                if (Data.mchrs[0].partsets[0] == 0) {
                    Menu.highlightNext();
                    Data.mchrs[0].partsets[0] = 1;
                }
            } else if (keymask == 8 || keymask == 52) {
                if (Data.mchrs[0].partsets[0] == 1) {
                    Menu.highlightPrev();
                    Data.mchrs[0].partsets[0] = 0;
                }
            } else if (keymask == 4 || keymask == 56 || keymask == 1 || keymask == 50) {
                Data.mchrs[0].partsets[0] = Data.mchrs[0].partsets[0] == 1 ? 0 : 1;
            }
        }
        if (Menu.inMenu(46)) {
            LoadingBar.me.onKeyDown(keymask);
            return true;
        }
        if (Menu.inMenu(53)) {
            if (ScreenObject.isVisible(58)) {
                return NumberGame.me.onKeyDown(keymask);
            }
            if (MiniGame.g_bMinigameShown) {
                if ((keymask & 0x800) == 2048) {
                    MiniGame.HideMinigame();
                } else {
                    MiniGame.g_minigame.onKeyDown(keymask);
                }
                return true;
            }
            if (MultiOptiList.me.onKeyDown(keymask)) {
                return true;
            }
            if (Engine.me.onKeyDown(keymask)) {
                return true;
            }
        }
        if (Menu.inMenu(88)) {
            pos = ScreenObject.getObject(94).getScrollBarPosition();
            if (keymask == 4) {
                ScreenObject.getObject(94).setScrollBarPosition(pos += CNText.m_fontHeight);
            } else if (keymask == 1) {
                ScreenObject.getObject(94).setScrollBarPosition(pos -= CNText.m_fontHeight);
            }
        }
        if (Menu.inMenu(115)) {
            pos = ScreenObject.getObject(122).getScrollBarPosition();
            if (keymask == 4) {
                ScreenObject.getObject(122).setScrollBarPosition(pos += CNText.m_fontHeight);
            } else if (keymask == 1) {
                ScreenObject.getObject(122).setScrollBarPosition(pos -= CNText.m_fontHeight);
            }
        }
        return false;
    }

    public boolean onKeyUp(int keymask) {
        if (Menu.inMenu(46)) {
            return true;
        }
        if (MiniGame.g_bMinigameShown) {
            MiniGame.g_minigame.onKeyUp(keymask);
            return true;
        }
        if (Menu.inMenu(53)) {
            MultiOptiList.me.onKeyUp(keymask);
            Engine.me.onKeyUp(keymask);
        }
        return false;
    }

    public boolean onKeyHeld(int keymask) {
        return false;
    }

    public ScreenObject loadUniqueScreenObject(int game, Stream stream) throws IOException {
        switch (game) {
            case 1: {
                LoadingBar bar = new LoadingBar();
                bar.load(stream);
                return bar;
            }
            case 2: {
                if (Engine.me != null) {
                    Engine.me.load(stream);
                    Render.setDrawCoords(Engine.g_currentroom, Engine.me.getX(), Engine.me.getY(), Engine.me.getWidth(), Engine.me.getHeight());
                    return Engine.me;
                }
                Engine maingame = new Engine();
                ((ScreenObject)maingame).load(stream);
                Render.setDrawCoords(Engine.g_currentroom, Engine.me.getX(), Engine.me.getY(), Engine.me.getWidth(), Engine.me.getHeight());
                return maingame;
            }
            case 7: {
                CharacterViewer characterViewer = new CharacterViewer();
                characterViewer.load(stream);
                return characterViewer;
            }
            case 8: {
                this.textbox = new CNTextbox();
                this.textbox.load(stream);
                return this.textbox;
            }
            case 9: {
                Headshot hs = new Headshot();
                hs.load(stream);
                return hs;
            }
            case 10: {
                FriendList fl = new FriendList();
                ((ScreenObject)fl).load(stream);
                return fl;
            }
            case 12: {
                MultiOptiList molly = new MultiOptiList();
                ((ScreenObject)molly).load(stream);
                return molly;
            }
            case 14: {
                ScreenObject mini = new ScreenObject();
                mini.load(stream);
                if (MiniGame.g_bMinigameShown) {
                    return MiniGame.g_minigame;
                }
                return mini;
            }
            case 16: {
                this.credits = new Credits();
                this.credits.load(stream);
                return this.credits;
            }
            case 17: {
                NumberGame numgame = new NumberGame();
                numgame.load(stream);
                return numgame;
            }
        }
        return null;
    }

    public void onMenuChange() {
        try {
            this.listSetup();
            this.primeScrollbars();
            if (Menu.iCurrentMenu == 107) {
                this.credits.reset();
            }
            if (Menu.iCurrentMenu == 53) {
                CNMosaic.mosaics[0].load();
            } else {
                CNMosaic.mosaics[0].unload();
            }
            if (Menu.iCurrentMenu == 30) {
                Menu.m_iSelectedButton = 0;
            }
            if (Menu.inMenu(88)) {
                ScreenObject.wrap(94);
                ScreenObject.getObject(94).setScrollBarPosition(0);
            }
            if (Menu.iCurrentMenu == 96) {
                if (CNSound.isSoundEnabled()) {
                    ScreenObject.setText(105, 511);
                } else {
                    ScreenObject.setText(105, 468);
                }
            }
            if (Menu.inMenu(79)) {
                // empty if block
            }
            if (Menu.inMenu(115)) {
                CNText.setVar(7, version_temp);
                ScreenObject.wrap(122);
                ScreenObject.getObject(122).setScrollBarPosition(0);
            }
            if (Menu.inMenu(53)) {
                Menu.flyLoad(53);
                Engine.g_bRepaint = true;
                Engine.g_lLastFrameTime = 0L;
                if (MiniGame.g_bMinigameShown) {
                    MiniGame.g_minigame.setTimeOffset(System.currentTimeMillis());
                }
                Engine.me.hideMessageBox();
                this.showSoftkeys();
            }
            if (Menu.iCurrentMenu == 53 && this.bgm != null && this.bgm.isPlaying()) {
                this.bgm.stop();
            }
            if (Menu.iCurrentMenu == 14) {
                Engine.KillAllScripts();
                this.resetScripts();
                if (CNSound.isSoundEnabled() && !this.bgm.isPlaying()) {
                    this.bgm = new CNSound("/SD_Theme_4.mid");
                    this.bgm.loop();
                }
                if (Menu.iCurrentMenu == 14 || Menu.iCurrentMenu == 96 || Menu.iCurrentMenu == 88 || Menu.iCurrentMenu == 115 && snd_check) {
                    if (CNSound.isSoundEnabled() && !this.bgm.isPlaying()) {
                        this.bgm = new CNSound("/SD_Theme_4.mid");
                        this.bgm.loop();
                    }
                    snd_check = false;
                }
                if (m_bSavedDataExists) {
                    ScreenObject.getObject(18).enable();
                } else {
                    ScreenObject.getObject(18).disable();
                }
            }
            if (Menu.getPreviousMenuID() == 53) {
                Engine.g_bRepaint = true;
            }
        }
        catch (Exception e) {
            Log.addExeption("Error switching menu.", e);
        }
    }

    public Graphics getGraphics() {
        return this.m_graphics.m_graphics;
    }

    public boolean onNumberKey(int number) {
        if (Menu.inMenu(53) && ScreenObject.isVisible(58)) {
            return NumberGame.me.onNumberKey(number);
        }
        return false;
    }

    public void onListChange(int listId, int selectedIndex, int _dir) {
    }

    public void getJadStrings() {
        version_temp = this.m_midlet.getAppProperty("MIDlet-Version");
        int i = 1;
        String product = this.m_midlet.getAppProperty("Product-" + i);
        while (product != null) {
            CNText.setVar(this.productMvars[i - 1], product);
            product = this.m_midlet.getAppProperty("Product-" + ++i);
        }
        if (GMG) {
            SchoolCore.LoadGMGTexts();
            SchoolCore.InitGMG();
        }
    }

    public static void freePaletteshiftedElements() {
        Render.generated_image_sets = null;
        System.gc();
        Render.generated_image_sets = new Vector();
    }

    public static void freeAllTiles() {
        if (Data.tiles != null) {
            for (int i = Data.tiles.length - 1; i >= 0; --i) {
                Data.tiles[i] = null;
            }
        }
    }

    public static void freeRasteredCharacters() {
        try {
            for (int i = Data.mchrs.length - 1; i >= 0; ++i) {
                if (Data.mchrs[i] == null) continue;
                Data.mchrs[i].frames = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void gameSetupDebug() {
        CNText.setVar(0, "Sam");
        Data.playerCharacter.ingamename = CNText.getVarString(0);
        Data.mchrs[1].ingamename = 105;
        Data.mchrs[11].ingamename = 8;
        Data.mchrs[2].ingamename = 2;
        Data.mchrs[4].ingamename = 106;
        Data.mchrs[5].ingamename = 4;
        Data.mchrs[6].ingamename = 24;
        Data.mchrs[7].ingamename = 25;
        Data.mchrs[8].ingamename = 31;
        Data.mchrs[9].ingamename = 51;
        Data.mchrs[12].ingamename = 27;
        Data.mchrs[13].ingamename = 19;
    }

    private void setHelp(int _scrobject, int _help) {
        ScreenObject.setText(_scrobject, _help);
        ScreenObject.getObject(_scrobject).enableWrapBounce();
    }

    public boolean afterKeyPressed(int keymask) {
        return false;
    }

    public void hideSoftkeys() {
        super.hideSoftkeys();
        if (Menu.inMenu(53)) {
            ScreenObject.hide(62);
            ScreenObject.hide(64);
        } else if (Menu.inMenu(46)) {
            ScreenObject.setText(47, 484);
            ScreenObject.setAsUnselected(47);
            ScreenObject.hide(50);
            ScreenObject.hide(51);
        }
    }

    public void showSoftkeys() {
        super.showSoftkeys();
        if (Menu.inMenu(53)) {
            ScreenObject.show(60);
            ScreenObject.show(62);
            ScreenObject.show(64);
        } else if (Menu.inMenu(46)) {
            ScreenObject.setAsSelected(47);
            ScreenObject.show(50);
            ScreenObject.show(51);
        }
    }

    public void queryShow(int _strRefTitle, int _strRefText) {
        Menu.gotoMenu(0);
        this.m_iQueryTitle = _strRefTitle;
        ScreenObject.setText(3, this.m_iQueryTitle);
        this.m_iQueryText = _strRefText;
        if (_strRefText > 0) {
            ScreenObject.setText(2, this.m_iQueryText);
            ScreenObject.show(2);
            int textHeight = ScreenObject.wrap(2) * CNText.m_fontHeight;
            ScreenObject.setHeight(1, textHeight + 20 + 18);
        } else {
            ScreenObject.hide(2);
            ScreenObject.setHeight(1, 20);
        }
        if (_strRefTitle == 559) {
            ScreenObject.hide(8);
            ScreenObject.hide(6);
        } else {
            ScreenObject.show(8);
            ScreenObject.show(6);
        }
    }

    public void ScreenAfterGameSplash() {
        if (GMG && GMG_BOOT) {
            SchoolCore.handleGMGFlow();
        } else {
            Menu.gotoMenu(14);
        }
    }

    public void queryCancel() {
        switch (this.m_iQueryTitle) {
            case 448: {
                SchoolCore.GMGWapQuery(false);
                break;
            }
            case 501: {
                Menu.gotoMenu(14);
                break;
            }
            case 504: {
                Menu.gotoMenu(79);
                break;
            }
            case 440: {
                Menu.gotoMenu(79);
                break;
            }
            case 506: {
                Menu.gotoMenu(96);
                break;
            }
            case 560: {
                Menu.gotoMenu(79);
                break;
            }
            case 503: {
                Menu.gotoMenu(79);
            }
        }
    }

    public void WAPrequest(String url) {
        CNSound.stopall();
        CNSound.killall();
        try {
            this.m_midlet.platformRequest(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void QueryGMGParameters() {
        String zGMGType;
        GMG = false;
        String zGMGOperationMode = SchoolCore.me.m_midlet.getAppProperty("GMG-Modes");
        if (zGMGOperationMode == null) {
            zGMGOperationMode = SchoolCore.me.m_midlet.getAppProperty("GMG-Mode");
        }
        if (zGMGOperationMode != null) {
            if (zGMGOperationMode.equals("Off")) {
                GMG = false;
            } else if (zGMGOperationMode.equals("On")) {
                GMG = true;
                GMG_ON = true;
            }
        }
        if (!GMG) {
            return;
        }
        String zGMGAppState = SchoolCore.me.m_midlet.getAppProperty("GMG-AppState");
        if (zGMGAppState != null) {
            if (zGMGAppState.equals("Close")) {
                GMG_CLOSE = true;
            }
        } else {
            GMG_CLOSE = true;
        }
        if ((zGMGType = SchoolCore.me.m_midlet.getAppProperty("GMG-Type")) != null) {
            if (zGMGType.equals("WAP")) {
                GMG_WAP = true;
            } else if (zGMGType.equals("Static")) {
                GMG_STATIC = true;
            }
        } else {
            GMG_WAP = true;
        }
        GMG_URL = SchoolCore.me.m_midlet.getAppProperty("GMG-URLT");
        String tempURLT = GMG_URL;
        if (GMG_WAP && GMG_URL == null || GMG_ON && GMG_WAP && GMG_URL == null) {
            GMG = false;
            return;
        }
        String zGMGLocation = SchoolCore.me.m_midlet.getAppProperty("GMG-Location");
        if (zGMGLocation != null) {
            if (zGMGLocation.equals("Exit")) {
                GMG_EXIT = true;
            } else if (zGMGLocation.equals("Menu")) {
                GMG_MENU = true;
            } else if (zGMGLocation.equals("Boot")) {
                GMG_BOOT = true;
            }
        } else {
            GMG_EXIT = true;
            return;
        }
        SchoolCore.LoadGMGResources();
    }

    static void LoadGMGTexts() {
        try {
            int iLastChar;
            InputStream zInputStream = null;
            zInputStream = Core.me.getClass().getResourceAsStream(FILE_GMG_TEXTS);
            StringBuffer buff = new StringBuffer();
            Vector<String> zVectorLines = new Vector<String>();
            while ((iLastChar = zInputStream.read()) != -1) {
                char cChar = (char)iLastChar;
                if (cChar == '\r') {
                    zVectorLines.addElement(buff.toString());
                    buff.delete(0, buff.length());
                    continue;
                }
                if (cChar == '\n') continue;
                buff.append(cChar);
            }
            if (buff != null) {
                zVectorLines.addElement(buff.toString());
            }
            zInputStream.close();
            buff = null;
            SchoolCore.parseLines(zVectorLines);
        }
        catch (IOException ex) {
            GMG = false;
        }
    }

    static void parseLines(Vector _zLines) {
        int iTotalLines = _zLines.size();
        for (int i = 0; i < iTotalLines; ++i) {
            String ms_zGMGClose_Message;
            String zTempLine = (String)_zLines.elementAt(i);
            if (zTempLine.equals("")) continue;
            if (zTempLine.startsWith("[GMG-Prompt-en]")) {
                String ms_zGMGPrompt = SchoolCore.convertUnicodeString(zTempLine.substring(15));
                if (ms_zGMGPrompt == null) continue;
                GMG_PROMPT_TEXT = ms_zGMGPrompt;
                continue;
            }
            if (zTempLine.startsWith("[GMG-Menu-en]")) {
                String ms_zGMGMenu = SchoolCore.convertUnicodeString(zTempLine.substring(13));
                if (ms_zGMGMenu == null) continue;
                GMG_TITLE_TEXT = ms_zGMGMenu;
                continue;
            }
            if (!zTempLine.startsWith("[GMG-Close-en]") || (ms_zGMGClose_Message = SchoolCore.convertUnicodeString(zTempLine.substring(14))) == null) continue;
            GMG_CLOSE_TEXT = ms_zGMGClose_Message;
        }
    }

    static String convertUnicodeString(String s) {
        if (s == null) {
            return null;
        }
        int i = 0;
        int numberOfChars = s.length();
        StringBuffer s1 = new StringBuffer();
        while (i < numberOfChars) {
            char c = s.charAt(i);
            if (c == '\\' && i + 6 <= numberOfChars && s.charAt(i + 1) == 'u') {
                String unicode = s.substring(i + 2, i + 6);
                char t = (char)Integer.parseInt(unicode, 16);
                s1.append(t);
                i += 6;
                continue;
            }
            s1.append(c);
            ++i;
        }
        return s1.toString();
    }

    public void GMGRSKaction() {
        if (GMG_BOOT) {
            Menu.gotoMenu(14);
            SchoolCore.freeGMGResources();
        } else if (GMG_EXIT) {
            this.endCore();
        } else if (GMG_MENU) {
            Menu.gotoMenu(14);
        }
    }

    public static void InitGMG() {
        CNText.setVar(10, GMG_PROMPT_TEXT);
        if (GMG_CLOSE) {
            CNText.setVar(10, GMG_CLOSE_TEXT + " " + GMG_PROMPT_TEXT);
        }
        CNText.setVar(9, GMG_TITLE_TEXT);
    }

    public static void freeGMGResources() {
        if (GMG_STATIC_IMAGE != null) {
            GMG_STATIC_IMAGE = null;
        }
        try {
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void LoadGMGResources() {
        try {
            GMG_STATIC_IMAGE = Image.createImage((String)"/GMG/imgt.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String convertGMGString(String Txt) {
        return Txt;
    }

    public static void GMGWapQuery(boolean ok) {
        System.out.println("val " + GMG_EXIT + " " + GMG_MENU);
        if (GMG_CLOSE && ok) {
            me.endCore();
        } else if (GMG_BOOT) {
            Menu.gotoMenu(14);
        } else if (GMG_MENU) {
            Menu.gotoMenu(14);
        } else if (GMG_EXIT) {
            me.endCore();
        }
    }

    public static void handleGMGFlow() {
        if (GMG) {
            if (GMG_ON) {
                if (GMG_STATIC) {
                    if (GMG_BOOT) {
                        Menu.gotoMenu(10);
                    } else if (GMG_EXIT || GMG_MENU) {
                        if (GMG_MENU) {
                            CNText.setVar(1, "  Back");
                        } else {
                            CNText.setVar(1, "Confirm");
                        }
                        Menu.gotoMenu(10);
                    }
                } else if (GMG_WAP) {
                    me.queryShow(448, 562);
                }
            }
        } else {
            return;
        }
    }

    public void queryOK() {
        switch (this.m_iQueryTitle) {
            case 448: {
                this.WAPrequest(GMG_URL);
                SchoolCore.GMGWapQuery(true);
                break;
            }
            case 501: {
                if (GMG && GMG_EXIT) {
                    SchoolCore.handleGMGFlow();
                    break;
                }
                this.endCore();
                break;
            }
            case 504: {
                this.autoload();
                break;
            }
            case 440: {
                this.autosave();
                this.queryShow(503, -1);
                break;
            }
            case 506: {
                this.resetData();
                this.queryShow(559, -1);
                break;
            }
            case 560: {
                Engine.g_currentroom = null;
                Menu.gotoMenu(14);
                break;
            }
            case 503: {
                Menu.gotoMenu(79);
                break;
            }
            case 559: {
                Menu.gotoMenu(96);
            }
        }
    }

    public void enableSounds() {
        CNSound.setSoundEnabled(true);
        ScreenObject.setText(105, 511);
        this.bgm = new CNSound("/SD_Theme_4.mid");
        this.bgm.loop();
    }

    public void disableSounds() {
        CNSound.setSoundEnabled(false);
        ScreenObject.setText(105, 468);
    }

    public void toggleSound() {
        if (CNSound.isSoundEnabled()) {
            this.disableSounds();
        } else {
            this.enableSounds();
        }
    }

    static {
        splashshown = false;
        RMS_STORENAME = "CN_SchoolFriends";
        scriptdone = false;
        FILE_GMG_TEXTS = "/GMG/GMG_settings.txt";
        GMG = false;
        GMG_ON = false;
        GMG_STATIC_IMAGE = null;
        GMG_STATIC = false;
        GMG_WAP = false;
        GMG_MENU = false;
        GMG_BOOT = false;
        GMG_EXIT = false;
        GMG_CLOSE = false;
    }
}

