/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.games;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.gui.Menu;
import com.creativenorth.gui.ScreenObject;
import schoolfriends.SchoolCore;
import schoolfriends.Scripts;
import schoolfriends.games.NumberGame;
import schoolfriends.games.NumberSnake;
import schoolfriends.games.Snap;
import schoolfriends.graphics.Engine;

public abstract class MiniGame
extends ScreenObject {
    protected int m_nDrawX;
    protected int m_nDrawY;
    protected int m_nDrawW;
    protected int m_nDrawH;
    protected int m_nPlayerScore = 0;
    protected int m_nCpuScore = 0;
    protected int m_nGameAction;
    protected boolean m_bCanEnd = false;
    protected CNImage[] m_images;
    protected long m_time;
    public static boolean g_bMinigameShown = false;
    public static boolean g_bNumberGameShown = false;
    public static MiniGame g_minigame = null;
    public static NumberGame g_numbergame = null;
    public static CNImage[] snakegfx;

    public MiniGame(int x, int y, int w, int h) {
        this.m_nDrawX = x;
        this.m_nDrawY = y;
        this.m_nDrawW = w;
        this.m_nDrawH = h;
        this.m_nGameAction = 0;
        this.m_bCanEnd = false;
    }

    public void setTimeOffset(long _time) {
        if (this.m_time < _time) {
            this.m_time += _time - this.m_time;
        }
    }

    public abstract void reset();

    public abstract void run();

    public abstract void paint(CNGraphics var1);

    public final boolean onKeyDown(int action) {
        this.m_nGameAction = action;
        return true;
    }

    public final boolean onKeyUp(int action) {
        this.m_nGameAction = 0;
        return true;
    }

    public final boolean setImages(CNImage[] images) {
        this.m_images = images;
        return true;
    }

    public final void render(CNGraphics graphics) {
        if (!g_bMinigameShown) {
            return;
        }
        super.render(graphics);
        this.run();
        graphics.resetClip();
        graphics.setColor(255);
        graphics.clear();
        if (this.m_images != null && this.m_images.length > 0) {
            CNImage img = this.m_images[0];
            int x = this.m_nDrawX + this.m_nDrawW;
            while (x > this.m_nDrawX) {
                x -= img.getWidth();
                int y = this.m_nDrawY + this.m_nDrawH;
                while (y > this.m_nDrawY) {
                    graphics.drawImage(img, x, y -= img.getHeight(), 0);
                }
            }
        }
        this.paint(graphics);
    }

    public int getGPA() {
        return this.m_nPlayerScore;
    }

    public int getScore() {
        return this.m_nPlayerScore;
    }

    public boolean isFinished() {
        return this.m_bCanEnd;
    }

    public static void ShowMinigame(Scripts.ScriptThread script, int number, int level) {
        MiniGame.ShowMinigame(number, level);
        Engine.Wait(script, 500, false);
        while (g_bMinigameShown || g_bNumberGameShown) {
            script.lockme();
        }
    }

    public static void ShowMinigame(int number, int level) {
        if (number == 2) {
            g_numbergame = new NumberGame();
            if (level > 0) {
                g_numbergame.newGameLimited(level);
            } else {
                g_numbergame.newGame();
            }
            ScreenObject.set(58, g_numbergame);
            ScreenObject.show(58);
            g_bNumberGameShown = true;
        } else {
            ScreenObject.hide(60);
            if (number == 0) {
                Menu.flyLoad(53);
                g_minigame = new NumberSnake(0, 0, CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT, level, 87, 82, 83, 84, 85, 88, 80, 89, 81);
                g_minigame.setImages(snakegfx);
            } else {
                CNImage[] snapgfx = new CNImage[]{snakegfx[0], new CNImage("/cardBack.png"), new CNImage("/orangeFlask.png"), new CNImage("/blueFlask.png"), new CNImage("/greenFlask.png"), new CNImage("/orangeTestTube.png"), new CNImage("/blueTestTube.png"), new CNImage("/greenTestTube.png"), new CNImage("/orangeBeaker.png"), new CNImage("/blueBeaker.png"), new CNImage("/greenBeaker.png")};
                Menu.flyLoad(53);
                g_minigame = new Snap(0, 0, CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT, snapgfx, level, 86, 80, 81);
            }
            ScreenObject.set(59, g_minigame);
            ScreenObject.show(59);
            SchoolCore.me.showSoftkeys();
            ScreenObject.hide(27);
            g_bMinigameShown = true;
        }
    }

    public static void HideMinigame() {
        Engine.g_iLastMinigameScore = g_minigame.getScore();
        g_bMinigameShown = false;
        SchoolCore.me.showSoftkeys();
        ScreenObject.hide(59);
    }
}

