/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.graphics;

import com.creativenorth.base.Timekeeper;
import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.Game;
import com.creativenorth.gui.Menu;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import java.util.Vector;
import schoolfriends.CNSound;
import schoolfriends.Data;
import schoolfriends.Headshot;
import schoolfriends.MessageList;
import schoolfriends.MultiOptiList;
import schoolfriends.SchoolCore;
import schoolfriends.Scripts;
import schoolfriends.games.MiniGame;
import schoolfriends.graphics.Render;
import schoolfriends.loading.LoadingRequirement;

public class Engine
extends Game {
    public static final String[] ANIMFILES = new String[]{"", "", "", "", "", "", "", "", "", "", "", "Flashy.png", "", "", "", "", "", "OiHere.png"};
    public static final String[] MIDIFILES = new String[]{"SD_Theme_4.mid", "SD_Bar_4.mid", "SD_Cinema_4_3.mid", "SD_Dance_4.mid", "SD_Home_2.mid", "SD_School_3.mid", "SD_SFX_Stats_negative_3.mid", "SD_SFX_Stats_positive.mid", "SD_Shopping_Center_4.mid", "SD_Sports_Ground_4.mid"};
    public static final int PLAYER_SPEED = 4;
    public static final int TICK_TIME = 32;
    public static Engine me;
    public Object lock = new Object();
    public static Data.AssignedScript g_selectedobjscript;
    public static Data.CronJob[] g_crontab;
    public static Data.PlacedObject g_selectedobj;
    public static Data.Room g_currentroom;
    public static Vector scripts;
    public static boolean bEveryOtherMove;
    public static boolean g_bCameraBLvalid;
    public static boolean g_bCameraBRvalid;
    public static boolean g_bCameraSliding;
    public static boolean g_bCameraTLvalid;
    public static boolean g_bCameraTRvalid;
    public static boolean g_bEnableAdvCamera;
    public static boolean g_bControlsEnabled;
    public static boolean g_bInProximity;
    public static boolean g_bLastVertUp;
    public static boolean g_bMayFlipDirection;
    public static boolean g_bNeedsDecrease;
    public static boolean g_bRepaint;
    public static boolean g_bScriptDone;
    public static boolean g_bSoundPlayed;
    public static boolean m_bHideSelection;
    public static boolean m_playerNaked;
    public static int g_bPlayerGiftCount;
    public static int g_iArrowNumber;
    public static int g_iCameraX;
    public static int g_iCameraY;
    public static int g_iCameraMaxX;
    public static int g_iCameraMaxY;
    public static int g_iCameraMinX;
    public static int g_iCameraMinY;
    public static int g_iCurrentRoomIndex;
    public static int g_iElapsedCounter;
    public static int g_iElapsedMovement;
    public static int g_iKey;
    public static int g_iLastMinigameScore;
    public static int g_iMoney;
    public static int g_iMugCount;
    public static int g_iSelectedChr;
    public static int g_iSelectedObjectX;
    public static int g_iSelectedObjectY;
    public static int g_iSelectedRoomObjectIndex;
    public static int g_iTalkRelationshipScript;
    public static int g_iTalkStars;
    public static int g_iTimedScriptDuration;
    public static int g_iTimedScriptScript;
    public static int g_iTimedScriptTimer;
    public static int g_lMoveTime;
    public static long g_iArrowTimer;
    public static long g_lLastFrameTime;
    public static long g_lRealtimeTimer;
    private int m_iPlayerAnimation = -1;
    public static final int MESSAGETYPE_NONE = 0;
    public static final int MESSAGETYPE_PLAYER = 1;
    public static final int MESSAGETYPE_NPC = 2;
    public static final int MESSAGETYPE_MISSION = 3;
    public static final int MESSAGETYPE_INFORMATION = 4;
    public static final int MESSAGETYPE_CONGRATS = 5;
    public static final int MESSAGETYPE_WARNING = 6;
    public static final int MESSAGETYPE_VOICEOVER = 7;
    final int m_scrollHeight;
    private int m_keyDown = 0;
    final int KEY_NOT_DOWN;
    final int KEY_DOWN;
    final int KEY_UP;

    public Engine() {
        this.m_scrollHeight = 6;
        this.KEY_NOT_DOWN = 0;
        this.KEY_DOWN = 1;
        this.KEY_UP = 2;
        Engine.ClearDestinationList();
        me = this;
        Data.player = new Data.PlacedObject(32, 40, 0, 0, true, 0, null);
        scripts = new Vector();
    }

    public void load(Stream stream) throws IOException {
        super.load(stream);
        Engine.setupCam();
        Data.exclamation = new CNImage("/Exclamation.png");
        Data.animations = new CNImage[ANIMFILES.length];
        for (int i = 0; i < ANIMFILES.length; ++i) {
            if (ANIMFILES[i].equals("")) continue;
            Data.animations[i] = new CNImage("/" + ANIMFILES[i]);
        }
        g_bRepaint = true;
        this.lock = new Object();
    }

    public static void loadSounds() {
        if (CNSound.isSoundEnabled()) {
            Data.sounds = new CNSound[MIDIFILES.length];
            for (int i = 0; i < MIDIFILES.length; ++i) {
                Data.sounds[i] = new CNSound("/" + MIDIFILES[i]);
            }
        }
    }

    public void refresh() {
        g_bRepaint = true;
    }

    public static void setGameTimeVars() {
    }

    public void setPlayerAnimation(int _anim) {
        this.m_iPlayerAnimation = _anim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gameLogic() {
        int i;
        if (g_currentroom == null) {
            g_bRepaint = true;
            return;
        }
        if (MiniGame.g_bMinigameShown && MiniGame.g_minigame.isFinished()) {
            Engine.HideMinigame();
        }
        long time = System.currentTimeMillis();
        if (g_lLastFrameTime != 0L) {
            g_iElapsedCounter = (int)((long)g_iElapsedCounter + (time - g_lLastFrameTime));
            g_iElapsedMovement = 4 * g_iElapsedCounter / 32;
            if ((g_lRealtimeTimer += time - g_lLastFrameTime) > 10000L) {
                g_lRealtimeTimer = 0L;
            }
            if (g_iTimedScriptTimer > 0 && (g_iTimedScriptTimer = (int)((long)g_iTimedScriptTimer - (time - g_lLastFrameTime))) <= 0) {
                Engine.CallScript(g_iTimedScriptScript);
            }
        }
        g_lLastFrameTime = time;
        Data.player.chr_anim = this.m_iPlayerAnimation >= 0 ? this.m_iPlayerAnimation : 1;
        this.playerMovement();
        for (i = 0; i < scripts.size(); ++i) {
            Scripts.ScriptThread script = (Scripts.ScriptThread)scripts.elementAt(i);
            if (script.isAlive()) {
                g_bScriptDone = false;
                Object object = script.lock;
                synchronized (object) {
                    if (!Menu.inMenu(46)) {
                        script.lock.notify();
                    }
                }
                if (!g_bScriptDone) {
                    try {
                        object = this.lock;
                        synchronized (object) {
                            this.lock.wait(200L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (script.isAlive() || i >= scripts.size()) continue;
                scripts.removeElementAt(i);
                --i;
                continue;
            }
            scripts.removeElementAt(i);
            --i;
        }
        Data.player.frame_timer += g_iElapsedCounter;
        LoadingRequirement.VerifyAnimation(Data.player.chr_anim);
        if (Data.player.frame_timer > Data.frames[Data.player.chr_anim][Data.player.frame % Data.frames[Data.player.chr_anim % Data.frames.length].length].time) {
            if (Data.player.chr_anim == 57) {
                // empty if block
            }
            ++Data.player.frame;
            if (Data.player.frame > Data.frames[Data.player.chr_anim].length) {
                Data.player.frame = 0;
            }
            Data.player.frame_timer = 0;
            g_bRepaint = true;
        }
        if (g_currentroom != null && Engine.g_currentroom.objs != null) {
            for (i = 0; i < Engine.g_currentroom.objs.length; ++i) {
                if (Engine.g_currentroom.objs[i].type) {
                    Engine.g_currentroom.objs[i].frame_timer += g_iElapsedCounter;
                    int anim = Engine.g_currentroom.objs[i].chr_anim % Data.frames.length;
                    LoadingRequirement.VerifyAnimation(anim);
                    Data.Frame[] f = Data.frames[anim];
                    int frame = Math.abs(Engine.g_currentroom.objs[i].frame % f.length);
                    if (Engine.g_currentroom.objs[i].frame_timer > f[frame].time) {
                        ++Engine.g_currentroom.objs[i].frame;
                        Engine.g_currentroom.objs[i].frame_timer = 0;
                        g_bRepaint = true;
                    }
                }
                this.animate(Engine.g_currentroom.objs[i]);
            }
        }
        this.animate(Data.player);
        g_iElapsedCounter %= 32;
        Engine.setCamera(Data.player.x, Data.player.y);
    }

    public boolean genderMale() {
        return Data.mchrs[0].partsets[0] == 0 || Data.mchrs[0].partsets[0] == 2 || Data.mchrs[0].partsets[0] == 3;
    }

    public void render(CNGraphics graphics) {
        try {
            this.gameLogic();
            if (g_bRepaint) {
                long time;
                int draw_y;
                int draw_x;
                graphics.resetClip();
                if (g_currentroom != null) {
                    if (Render.depth_stack == null) {
                        Render.updateDepthSort(g_currentroom);
                    }
                    Render.paintRoom(graphics, g_currentroom);
                }
                if (g_selectedobj != null) {
                    if (Engine.g_selectedobj.ingamename > 0) {
                        ScreenObject.getObject(63).enableWrapBounce();
                        CNText.setVar(4, Engine.g_selectedobj.ingamename, 2);
                    }
                } else if (Engine.messageBoxIsVisible()) {
                    ScreenObject.getObject(63).enableWrapBounce();
                    CNText.setVar(4, 454, 2);
                } else {
                    CNText.setVar(4, -1, 2);
                }
                g_bRepaint = false;
                if (g_selectedobj != null && g_selectedobj != Data.Room.g_highlightedobject && !m_bHideSelection && g_bControlsEnabled) {
                    draw_x = Render.worldToScreenX(Engine.g_selectedobj.x, Engine.g_selectedobj.y) + Engine.g_selectedobj.sel_x;
                    draw_y = Render.worldToScreenY(Engine.g_selectedobj.x, Engine.g_selectedobj.y) + Engine.g_selectedobj.sel_y + (5 - g_iArrowNumber * 2);
                    if (!Engine.g_selectedobj.type) {
                        draw_x += Data.tile_w_half;
                    }
                    if (Engine.g_selectedobj.type) {
                        Data.MasterCharacter mas = Data.getCharacter(Engine.g_selectedobj.gfx);
                    } else {
                        graphics.drawImage(Data.exclamation, draw_x, draw_y, 33);
                    }
                    time = System.currentTimeMillis();
                    if (g_iArrowTimer < time) {
                        g_iArrowNumber = (g_iArrowNumber + 1) % 4;
                        g_iArrowTimer = time + 100L;
                        g_bRepaint = true;
                    }
                }
                if (Data.Room.g_highlightedobject != null && !Engine.messageBoxIsVisible()) {
                    draw_x = Render.worldToScreenX(Data.Room.g_highlightedobject.x, Data.Room.g_highlightedobject.y) + Data.Room.g_highlightedobject.sel_x + Data.tile_w_half;
                    draw_y = Render.worldToScreenY(Data.Room.g_highlightedobject.x, Data.Room.g_highlightedobject.y) + Data.Room.g_highlightedobject.sel_y;
                    graphics.drawImage(Data.animations[17], draw_x, draw_y, 3);
                    time = System.currentTimeMillis();
                    if (time % 1000L < 500L) {
                        graphics.drawImage(Data.animations[11], draw_x, draw_y - 15, 3);
                    }
                }
                if (g_iTimedScriptTimer > 0) {
                    graphics.resetClip();
                    graphics.setColor(0xFFFFCF);
                    int y = this.boundsY + this.boundsHeight - 25 - 15;
                    graphics.drawRect(this.boundsX + 4, y, this.boundsWidth - 4, 10);
                    graphics.fillRect(this.boundsX + 6, y + 2, (this.boundsWidth - 6) * g_iTimedScriptTimer / g_iTimedScriptDuration, 6);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void animate(Data.PlacedObject o) {
        if (o.anim && Data.animations != null && (System.currentTimeMillis() < o.anim_duration || o.anim_duration == 0L)) {
            if (o.anim_start != o.anim_end) {
                boolean anim = true;
                if (o.anim_delay > 0) {
                    o.anim_delay_counter += g_iElapsedCounter;
                    if (o.anim_delay_counter > o.anim_delay) {
                        o.anim_delay_counter = 0;
                    } else {
                        anim = false;
                    }
                } else if (o.anim_delay < 0) {
                    --o.anim_delay_counter;
                    if (o.anim_delay_counter < o.anim_delay) {
                        o.anim_delay_counter = 0;
                    } else {
                        anim = false;
                    }
                }
                if (anim) {
                    if (o.anim_frame == o.anim_start && !o.anim_forwards) {
                        if (o.anim_loop) {
                            o.anim_forwards = true;
                        } else {
                            o.anim = false;
                        }
                    } else if (o.anim_frame == o.anim_end && o.anim_forwards) {
                        if (o.anim_reverse) {
                            o.anim_forwards = false;
                        } else if (o.anim_loop) {
                            o.anim_frame = o.anim_start + (o.anim_start < o.anim_end ? -1 : 1);
                        } else {
                            o.anim = false;
                        }
                    }
                    o.anim_frame = o.anim_frame + (o.anim_start < o.anim_end == o.anim_forwards ? 1 : -1);
                    g_bRepaint = true;
                }
            }
        } else {
            o.anim = false;
        }
    }

    private void playerMovement() {
        if (g_iKey != 0) {
            if (!Engine.messageBoxIsVisible()) {
                if (g_iKey == 16) {
                    Engine.hideMessageBox();
                }
                if (g_bControlsEnabled) {
                    boolean moved = false;
                    int i = Math.min(g_iElapsedMovement * 3 / 4, 8);
                    while (i-- > 0) {
                        if (g_iKey == 2) {
                            moved = this.moveDirection(1, 0);
                        } else if (g_iKey == 8) {
                            moved = this.moveDirection(-1, 0);
                        } else if (g_iKey == 4) {
                            moved = this.moveDirection(0, 1);
                        } else if (g_iKey == 1) {
                            moved = this.moveDirection(0, -1);
                        } else if (g_iKey == 128) {
                            Data.player.left = true;
                            moved = Engine.attemptMove(Data.player.x - 1, Data.player.y - (bEveryOtherMove ? 1 : 0));
                        } else if (g_iKey == 256) {
                            Data.player.left = false;
                            moved = Engine.attemptMove(Data.player.x + 1, Data.player.y - (bEveryOtherMove ? 1 : 0));
                        } else if (g_iKey == 512) {
                            Data.player.left = true;
                            moved = Engine.attemptMove(Data.player.x - 1, Data.player.y + (bEveryOtherMove ? 1 : 0));
                        } else if (g_iKey == 1024) {
                            Data.player.left = false;
                            moved = Engine.attemptMove(Data.player.x + 1, Data.player.y + (bEveryOtherMove ? 1 : 0));
                        }
                        bEveryOtherMove = !bEveryOtherMove;
                    }
                    if (moved) {
                        Data.player.chr_anim = 0;
                        m_bHideSelection = false;
                        boolean onProximityTrigger = false;
                        if (Engine.g_currentroom.objs != null) {
                            int mindist;
                            g_selectedobj = null;
                            int bestdist = mindist = Data.tile_w * Data.tile_h * 3;
                            for (int i2 = 0; i2 < Engine.g_currentroom.objs.length; ++i2) {
                                if (Engine.g_currentroom.objs[i2].hidden) continue;
                                int override_onclick = Scripts.checkOverride(g_iCurrentRoomIndex, i2, 5);
                                if (Engine.g_currentroom.objs[i2].scripts == null && override_onclick == -1) continue;
                                int dx = Engine.g_currentroom.objs[i2].x - Data.player.x;
                                int dy = Engine.g_currentroom.objs[i2].y - Data.player.y;
                                int dist = dx * dx + dy * dy;
                                dist = Engine.g_currentroom.objs[i2].type ? (dist /= 4) : (dist /= 3);
                                if (dist >= mindist) continue;
                                if (bestdist == 0 || dist < bestdist) {
                                    int scriptnum = Scripts.checkOverride(g_iCurrentRoomIndex, i2, 5);
                                    if (scriptnum >= 0) {
                                        g_iSelectedRoomObjectIndex = i2;
                                        g_iSelectedObjectX = Engine.g_currentroom.objs[i2].x;
                                        g_iSelectedObjectY = Engine.g_currentroom.objs[i2].y;
                                        g_iSelectedChr = -1;
                                        g_selectedobj = Engine.g_currentroom.objs[i2];
                                        try {
                                            if (Engine.g_selectedobj.type) {
                                                g_iSelectedChr = Engine.g_selectedobj.gfx;
                                            }
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                        Data.AssignedScript a = new Data.AssignedScript();
                                        a.script = scriptnum;
                                        a.trigger = 5;
                                        g_selectedobjscript = a;
                                        bestdist = dist;
                                    } else if (Engine.g_currentroom.objs[i2].scripts != null) {
                                        for (int j = 0; j < Engine.g_currentroom.objs[i2].scripts.length; ++j) {
                                            if (Engine.g_currentroom.objs[i2].scripts[j].trigger != 5) continue;
                                            g_iSelectedRoomObjectIndex = i2;
                                            g_iSelectedObjectX = Engine.g_currentroom.objs[i2].x;
                                            g_iSelectedObjectY = Engine.g_currentroom.objs[i2].y;
                                            g_iSelectedChr = -1;
                                            g_selectedobj = Engine.g_currentroom.objs[i2];
                                            try {
                                                if (Engine.g_selectedobj.type) {
                                                    g_iSelectedChr = Engine.g_selectedobj.gfx;
                                                }
                                            }
                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                            g_selectedobjscript = Engine.g_currentroom.objs[i2].scripts[j];
                                            bestdist = dist;
                                        }
                                    }
                                }
                                if (Engine.g_currentroom.objs[i2].scripts == null) continue;
                                for (int j = 0; j < Engine.g_currentroom.objs[i2].scripts.length; ++j) {
                                    if (Engine.g_currentroom.objs[i2].scripts[j].trigger != 4) continue;
                                    onProximityTrigger = true;
                                    if (g_bInProximity) continue;
                                    boolean found = false;
                                    for (int k = 0; k < scripts.size(); ++k) {
                                        if (((Scripts.ScriptThread)scripts.elementAt(k)).getID() != Engine.g_currentroom.objs[i2].scripts[j].script) continue;
                                        found = true;
                                    }
                                    if (found) continue;
                                    int scriptnum = Scripts.checkOverride(g_iCurrentRoomIndex, i2, 4);
                                    if (scriptnum < 0) {
                                        scriptnum = Engine.g_currentroom.objs[i2].scripts[j].script;
                                    }
                                    scripts.addElement(Scripts.runScriptThreaded(scriptnum, Engine.g_currentroom.objs[i2]));
                                }
                            }
                            g_bInProximity = onProximityTrigger;
                        }
                    }
                    Engine.setCamera(Data.player.x, Data.player.y);
                    Render.Resort(Data.player);
                    if (g_selectedobj != null && g_selectedobjscript != null && !m_bHideSelection) {
                        if (Engine.g_selectedobj.type) {
                            // empty if block
                        }
                        if (g_iKey == 16) {
                            int scriptnum;
                            g_iTalkRelationshipScript = Scripts.checkOverride(g_iCurrentRoomIndex, g_iSelectedRoomObjectIndex, 3);
                            if (g_iTalkRelationshipScript == -1 && Engine.g_selectedobj.scripts != null) {
                                for (i = 0; i < Engine.g_selectedobj.scripts.length; ++i) {
                                    if (Engine.g_selectedobj.scripts[i].trigger != 3) continue;
                                    g_iTalkRelationshipScript = Engine.g_selectedobj.scripts[i].script;
                                    break;
                                }
                            }
                            if (g_iTalkRelationshipScript == -1 && Engine.g_selectedobj.type && Engine.g_selectedobj.gfx < Data.mchrs.length && Data.mchrs[Engine.g_selectedobj.gfx].scripts != null) {
                                for (i = 0; i < Data.mchrs[Engine.g_selectedobj.gfx].scripts.length; ++i) {
                                    if (Data.mchrs[Engine.g_selectedobj.gfx].scripts[i].trigger != 3) continue;
                                    g_iTalkRelationshipScript = Engine.g_selectedobj.scripts[i].script;
                                    break;
                                }
                            }
                            if ((scriptnum = Scripts.checkOverride(g_iCurrentRoomIndex, g_iSelectedRoomObjectIndex, 5)) < 0) {
                                scriptnum = Engine.g_selectedobjscript.script;
                            }
                            scripts.addElement(Scripts.runScriptThreaded(scriptnum, g_selectedobj));
                            g_iKey = 0;
                            m_bHideSelection = true;
                            g_selectedobj = null;
                        }
                    }
                }
            } else {
                if (g_iKey == 16) {
                    Engine.hideMessageBox();
                }
                g_iKey = 0;
            }
            g_bRepaint = true;
        }
    }

    private boolean moveDirection(int x, int y) {
        int y_inverse;
        int x_inverse;
        int n = y != 0 ? (Data.player.left ? -1 : 1) : (x_inverse = 0);
        int n2 = x != 0 ? (g_bLastVertUp ? -1 : 1) : (y_inverse = 0);
        if (x != 0) {
            Data.player.left = x < 0;
        } else {
            boolean bl = g_bLastVertUp = y < 0;
        }
        if (Engine.attemptMove(Data.player.x + x, Data.player.y + y)) {
            g_bMayFlipDirection = true;
            return true;
        }
        if (Engine.attemptMove(Data.player.x + x_inverse, Data.player.y + y_inverse)) {
            g_bMayFlipDirection = false;
            return true;
        }
        if (g_bMayFlipDirection) {
            g_bMayFlipDirection = false;
            if (Engine.attemptMove(Data.player.x - x_inverse, Data.player.y - y_inverse)) {
                if (x != 0) {
                    g_bLastVertUp = !g_bLastVertUp;
                } else {
                    Data.player.left = !Data.player.left;
                }
                return true;
            }
        }
        return false;
    }

    public boolean onKeyDown(int key) {
        g_iKey = key;
        return true;
    }

    public void onKeyUp(int key) {
        this.m_keyDown = 0;
        if (g_iKey == key) {
            g_iKey = 0;
        }
    }

    public static void LoadRoom(int room) {
        g_iCurrentRoomIndex = room;
        SchoolCore.me.showLoading(new LoadingRequirement(room), 53);
    }

    public static void SetRoom(int room) {
        if (g_currentroom != null && Engine.g_currentroom.objs != null) {
            for (int i = 0; i < Engine.g_currentroom.objs.length; ++i) {
                if (Engine.g_currentroom.objs[i].scripts == null) continue;
                for (int j = 0; j < Engine.g_currentroom.objs[i].scripts.length; ++j) {
                    if (Engine.g_currentroom.objs[i].scripts[j].trigger != 6) continue;
                    scripts.addElement(Scripts.runScriptThreaded(Engine.g_currentroom.objs[i].scripts[j].script, Engine.g_currentroom.objs[i]));
                }
            }
            int scriptnum = Scripts.checkOverride(g_iCurrentRoomIndex, -1, 6);
            if (scriptnum >= 0) {
                scripts.addElement(Scripts.runScriptThreaded(scriptnum, null));
            }
        }
        g_currentroom = Data.rooms[room];
        Data.player.x = Render.tileToWorldX(Engine.g_currentroom.spawnX, Engine.g_currentroom.spawnY);
        Data.player.y = Render.tileToWorldY(Engine.g_currentroom.spawnX, Engine.g_currentroom.spawnY);
        g_selectedobj = null;
        boolean day = Timekeeper.me.isDaytime();
        if (Engine.g_currentroom.objs != null) {
            for (int i = 0; i < Engine.g_currentroom.objs.length; ++i) {
                if (Engine.g_currentroom.objs[i].scripts == null) continue;
                for (int j = 0; j < Engine.g_currentroom.objs[i].scripts.length; ++j) {
                    if (Engine.g_currentroom.objs[i].scripts[j].trigger != 1) continue;
                    scripts.addElement(Scripts.runScriptThreaded(Engine.g_currentroom.objs[i].scripts[j].script, Engine.g_currentroom.objs[i]));
                }
            }
            int scriptnum = Scripts.checkOverride(room, -1, 1);
            if (scriptnum >= 0) {
                scripts.addElement(Scripts.runScriptThreaded(scriptnum, null));
            }
        }
        Render.updateDepthSort(g_currentroom);
        Engine.setCamera(Data.player.x, Data.player.y);
        g_bRepaint = true;
        g_bSoundPlayed = false;
    }

    public static CNImage[] getNeededImages(int room) {
        int n;
        int i;
        boolean[] bNeeded = new boolean[Data.tiles.length];
        for (int i2 = 0; i2 < bNeeded.length; ++i2) {
            bNeeded[i2] = false;
        }
        Data.Room r = Data.rooms[room];
        if (r.floor != null) {
            for (int y = 0; y < r.floor.length; ++y) {
                for (int x = 0; x < r.floor[y].length; ++x) {
                    int n2 = Math.abs(r.floor[y][x]);
                    if (n2 <= 0 || n2 >= 127) continue;
                    bNeeded[n2 - 1] = true;
                }
            }
        }
        if (r.walls != null) {
            for (i = 0; i < r.walls.length; ++i) {
                n = r.walls[i].tile;
                if (n <= 0) continue;
                bNeeded[n - 1] = true;
            }
        }
        if (r.objs != null) {
            for (i = 0; i < r.objs.length; ++i) {
                if (r.objs[i].type || (n = r.objs[i].gfx) <= 0 || n > bNeeded.length) continue;
                bNeeded[n - 1] = true;
            }
        }
        int needed_count = 0;
        for (int i3 = 0; i3 < bNeeded.length; ++i3) {
            if (!bNeeded[i3]) continue;
            ++needed_count;
        }
        CNImage[] aImages = new CNImage[needed_count];
        int index = 0;
        for (int i4 = 0; i4 < bNeeded.length; ++i4) {
            if (!bNeeded[i4] || Data.tiles[i4] == null) continue;
            aImages[index] = Data.tiles[i4].img;
            ++index;
        }
        return aImages;
    }

    public static int[] getCharacters(int room) {
        Vector<Integer> genimgs = new Vector<Integer>();
        Data.Room r = Data.rooms[room];
        try {
            for (int i = r.objs.length - 1; i >= 0; --i) {
                if (!r.objs[i].type) continue;
                genimgs.addElement(new Integer(r.objs[i].gfx));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        genimgs.addElement(new Integer(0));
        int[] array = new int[genimgs.size()];
        for (int _ = genimgs.size() - 1; _ >= 0; --_) {
            array[_] = (Integer)genimgs.elementAt(_);
        }
        return array;
    }

    public static Data.RequiredAnimation[] getRequiredAnimations(int room) {
        Vector<Data.RequiredAnimation> genimgs = new Vector<Data.RequiredAnimation>();
        Data.Room r = Data.rooms[room];
        try {
            for (int i = r.objs.length - 1; i >= 0; --i) {
                if (!r.objs[i].type) continue;
                genimgs.addElement(new Data.RequiredAnimation(r.objs[i].gfx, r.objs[i].idle_anim));
                r.objs[i].chr_anim = r.objs[i].idle_anim;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Data.RequiredAnimation[] array = new Data.RequiredAnimation[genimgs.size()];
        for (int _ = genimgs.size() - 1; _ >= 0; --_) {
            array[_] = (Data.RequiredAnimation)genimgs.elementAt(_);
        }
        return array;
    }

    public static void MovePlayer(Scripts.ScriptThread script, int x, int y, int room, boolean relative, boolean tile) {
        Engine.ClearDestinationList();
        if (tile) {
            int xx = x;
            int yy = y;
            x = Render.tileToWorldX(xx, yy) + Data.tile_w_half;
            y = Render.tileToWorldY(xx, yy);
            if (relative) {
                x += Render.worldToTileX(Data.player.x, Data.player.y);
                y += Render.worldToTileY(Data.player.x, Data.player.y);
            }
        } else if (relative) {
            x += Data.player.x;
            y += Data.player.y;
        }
        if (room == -1) {
            while (Data.player.x != x || Data.player.y != y) {
                Data.player.chr_anim = 0;
                int speed = g_iElapsedMovement;
                if (Data.player.x > x + speed) {
                    Data.player.left = true;
                    Data.player.x -= speed;
                } else if (Data.player.x < x - speed) {
                    Data.player.left = false;
                    Data.player.x += speed;
                } else {
                    Data.player.x = x;
                }
                Data.player.y = Data.player.y > y + speed ? (Data.player.y -= speed) : (Data.player.y < y - speed ? (Data.player.y += speed) : y);
                g_bRepaint = true;
                Render.updateDepthSort(g_currentroom);
                Engine.setCamera(Data.player.x, Data.player.y);
                script.lockme();
            }
            Data.player.chr_anim = 1;
        } else {
            Data.Room.g_highlightedobject = null;
            if (room != g_iCurrentRoomIndex) {
                g_lMoveTime = (int)((long)g_lMoveTime + 300000L);
                Engine.LoadRoom(room);
                if (script != null) {
                    script.lockme();
                }
            }
            Data.player.x = x;
            Data.player.y = y;
            Engine.setCamera(Data.player.x, Data.player.y);
            Render.updateDepthSort(g_currentroom);
        }
    }

    public static void SetPlayerDirection(boolean left) {
        Data.player.left = left;
    }

    public static void SetControls(boolean enabled) {
        g_bControlsEnabled = enabled;
    }

    public static void SetRoomLocked(int room, boolean locked) {
        Data.roomlocked[room] = locked;
    }

    public static void SetAreaLocked(int area, boolean locked) {
        for (int i = 7; i < Scripts.DESTINATIONS[area].length; ++i) {
            Data.roomlocked[Scripts.DESTINATIONS[area][i]] = locked;
        }
    }

    public static void ShowMessageUltra(int _type, Scripts.ScriptThread _script, int _strRefMessage, int _mchrID) {
        int textHeight;
        if (_script != null) {
            while (ScreenObject.isVisible(65) || MiniGame.g_bMinigameShown) {
                _script.lockme();
            }
        }
        m_bHideSelection = true;
        if (_type == 2 || _type == 1 || _type == 7) {
            Data.MasterCharacter mchr = null;
            mchr = _type == 1 ? Data.playerCharacter : Data.getCharacter(_mchrID);
            if (_type != 7) {
                Headshot.setCharacter(mchr);
                CNText.setVar(3, mchr.ingamename, 2);
            }
            CNText.setVar(2, _strRefMessage, 2);
            textHeight = ScreenObject.wrap(56) * CNText.m_fontHeight;
            ScreenObject.setHeight(56, textHeight);
            ScreenObject.setHeight(55, textHeight + 8 + 18);
            ScreenObject.show(55);
        } else if (_type == 4 || _type == 3 || _type == 5 || _type == 6) {
            int strRefTitle = 0;
            if (_type == 3) {
                strRefTitle = 508;
                if (MessageList.me != null) {
                    MessageList.me.addMessage(strRefTitle, _strRefMessage);
                }
            } else {
                strRefTitle = _type == 6 ? 510 : (_type == 5 ? 508 : 509);
            }
            CNText.setVar(6, _strRefMessage, 2);
            CNText.setVar(5, strRefTitle, 2);
            textHeight = ScreenObject.wrap(67) * CNText.m_fontHeight;
            ScreenObject.setHeight(65, textHeight + 34 + 18);
            ScreenObject.setHeight(67, textHeight);
            if (_type == 4) {
                ScreenObject.setBackground(68, 4, 1);
            } else if (_type == 6) {
                ScreenObject.setBackground(68, 4, 2);
            } else {
                ScreenObject.setBackground(68, 4, 0);
            }
            ScreenObject.show(65);
            ScreenObject.hide(55);
        }
        while (_script != null && Engine.messageBoxIsVisible()) {
            _script.lockme();
        }
        m_bHideSelection = false;
    }

    public static void ShowMessageUltra(int _type, Scripts.ScriptThread _script, int _strRefMessage) {
        Engine.ShowMessageUltra(_type, _script, _strRefMessage, 0);
    }

    public static void ShowMessageUltra(int _type, Scripts.ScriptThread _script, int _strRefMessage, int _mchrID, boolean _ignoreAnim) {
        if (!_ignoreAnim) {
            me.setPlayerAnimation(-1);
        }
        Engine.ShowMessageUltra(_type, _script, _strRefMessage, _mchrID);
    }

    public static void ShowMessage(Scripts.ScriptThread _script, int _speaker, int _strRefMessage, int _mchrID) {
        Engine.ShowMessageUltra(2, _script, _strRefMessage, _mchrID);
    }

    public static boolean messageBoxIsVisible() {
        return ScreenObject.isVisible(55) || ScreenObject.isVisible(65);
    }

    public static void hideMessageBox() {
        ScreenObject.hide(55);
        ScreenObject.hide(65);
    }

    public static void Wait(Scripts.ScriptThread script, int delay, boolean frames) {
        if (frames) {
            while (delay >= 0) {
                script.lockme();
                --delay;
            }
        } else {
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() < time + (long)delay) {
                script.lockme();
            }
        }
    }

    public static void MoveCharacter(Scripts.ScriptThread script, int character, int x, int y, int room, boolean relative, boolean tile) {
        if (Engine.g_currentroom.objs == null) {
            return;
        }
        Data.PlacedObject obj = null;
        for (int i = 0; i < Engine.g_currentroom.objs.length; ++i) {
            if (!Engine.g_currentroom.objs[i].type || Engine.g_currentroom.objs[i].gfx != character) continue;
            obj = Engine.g_currentroom.objs[i];
        }
        if (obj == null) {
            return;
        }
        if (tile) {
            int xx = x;
            int yy = y;
            x = Render.tileToWorldX(xx, yy) + Data.tile_w_half;
            y = Render.tileToWorldY(xx, yy);
            if (relative) {
                x += Render.worldToTileX(obj.x, obj.y);
                y += Render.worldToTileY(obj.x, obj.y);
            }
        } else if (relative) {
            x += obj.x;
            y += obj.y;
        }
        if (room == -1) {
            obj.chr_anim = 0;
            while (obj.x != x || obj.y != y) {
                int speed = g_iElapsedMovement / 2;
                if (obj.x > x + speed) {
                    obj.left = true;
                    obj.x -= speed;
                } else if (obj.x < x - speed) {
                    obj.left = false;
                    obj.x += speed;
                } else {
                    obj.x = x;
                }
                obj.y = obj.y > y + speed ? (obj.y -= speed) : (obj.y < y - speed ? (obj.y += speed) : y);
                g_bRepaint = true;
                Render.Resort(obj);
                int sx = Render.isoToScreenX(obj.x, obj.y);
                int sy = Render.isoToScreenY(obj.x, obj.y);
                int px = Render.isoToScreenX(Data.player.x, Data.player.y);
                int py = Render.isoToScreenY(Data.player.x, Data.player.y);
                script.lockme();
            }
            obj.chr_anim = obj.idle_anim;
        } else {
            obj.x = x;
            obj.y = y;
            Render.Resort(obj);
        }
    }

    public static void SetCharacterDirection(int character, boolean left, boolean locked) {
        int i = Engine.g_currentroom.objs.length;
        while (i-- > 0) {
            if (!Engine.g_currentroom.objs[i].type || Engine.g_currentroom.objs[i].gfx != character) continue;
            Engine.g_currentroom.objs[i].left = left;
            Engine.g_currentroom.objs[i].directionlocked = locked;
        }
    }

    public static void SetPlayerAnim(Scripts.ScriptThread script, int start, int end, int duration, int framedelay, boolean async, boolean loop, boolean reverse) {
        Engine.setPlacedObjectAnim(Data.player, start, end, duration, framedelay, loop, reverse);
        if (!async) {
            while (Data.player.anim) {
                g_bRepaint = true;
                script.lockme();
            }
        }
    }

    public static void AnimatePlayer(int anim) {
        me.setPlayerAnimation(anim);
    }

    public static void SetCharacterAnim(Scripts.ScriptThread script, int character, int start, int end, int duration, int framedelay, boolean async, boolean loop, boolean reverse) {
        Data.PlacedObject obj = null;
        int i = Engine.g_currentroom.objs.length;
        while (i-- > 0) {
            if (!Engine.g_currentroom.objs[i].type || Engine.g_currentroom.objs[i].gfx != character) continue;
            obj = Engine.g_currentroom.objs[i];
        }
        if (obj != null) {
            Engine.setPlacedObjectAnim(obj, start, end, duration, framedelay, loop, reverse);
            if (!async) {
                while (obj.anim) {
                    g_bRepaint = true;
                    script.lockme();
                }
            }
        }
    }

    public static void AnimateCharacter(int character, int anim) {
        int i = Engine.g_currentroom.objs.length;
        while (i-- > 0) {
            if (!Engine.g_currentroom.objs[i].type || Engine.g_currentroom.objs[i].gfx != character) continue;
            Engine.g_currentroom.objs[i].chr_anim = anim;
        }
    }

    private static void setPlacedObjectAnim(Data.PlacedObject obj, int start, int end, int duration, int framedelay, boolean loop, boolean reverse) {
        obj.anim = true;
        obj.anim_start = obj.anim_frame = start;
        obj.anim_end = end;
        obj.anim_duration = duration > 0 ? System.currentTimeMillis() + (long)duration : 0L;
        obj.anim_loop = loop;
        obj.anim_reverse = reverse;
        obj.anim_delay = framedelay;
        obj.anim_delay_counter = 0;
        g_bRepaint = true;
    }

    public static void StopPlayerAnim() {
        Data.player.anim = false;
    }

    public static void StopCharacterAnim(int character) {
        int i = Engine.g_currentroom.objs.length;
        while (i-- > 0) {
            if (!Engine.g_currentroom.objs[i].type || Engine.g_currentroom.objs[i].gfx != character) continue;
            Engine.g_currentroom.objs[i].anim = false;
        }
    }

    public static void SetObjectAnim(Scripts.ScriptThread script, int objnum, int start, int end, int duration, int framedelay, boolean async, boolean loop, boolean reverse) {
        if (objnum >= 0 && objnum < Engine.g_currentroom.objs.length) {
            Engine.setPlacedObjectAnim(Engine.g_currentroom.objs[objnum], start, end, duration, framedelay, loop, reverse);
            if (!async) {
                while (Engine.g_currentroom.objs[objnum].anim) {
                    g_bRepaint = true;
                    script.lockme();
                }
            }
        } else {
            Log.addError("Invalid objs num: " + objnum + " / " + Engine.g_currentroom.objs.length);
        }
    }

    public static void StopObjectAnim(int objnum) {
        if (objnum >= 0 && objnum < Engine.g_currentroom.objs.length) {
            Engine.g_currentroom.objs[objnum].anim = false;
        } else {
            Log.addError("Invalid objs num: " + objnum + " / " + Engine.g_currentroom.objs.length);
        }
    }

    public static Scripts.ScriptThread CallScript(int num) {
        Scripts.ScriptThread st = Scripts.runScriptThreaded(num, null);
        scripts.addElement(st);
        return st;
    }

    public static void KillScript(int num) {
        int i = scripts.size();
        while (i-- > 0) {
            if (((Scripts.ScriptThread)scripts.elementAt(i)).getID() != num) continue;
            scripts.removeElementAt(i);
        }
    }

    public static void KillAllScripts() {
        MiniGame.g_bMinigameShown = false;
        scripts.removeAllElements();
    }

    public static void KillAllScripts(Scripts.ScriptThread _script) {
        int i = scripts.size();
        while (i-- > 0) {
            scripts.removeElementAt(i);
        }
    }

    public static void PlaySound(int num) {
        if (Data.sounds != null && num >= 0 && num < Data.sounds.length) {
            Data.sounds[num].play();
        }
    }

    public static void AddMoney(int _cash) {
        me.setMoney(g_iMoney + _cash);
    }

    public void setMoney(int _cash) {
        g_iMoney = _cash;
    }

    public static void AddCron(int scriptID, int min, int hour, int day, int month, int year, boolean relmin, boolean relhour, boolean relday, boolean relmonth, boolean some_arbitrary_parameter_from_inliving_yeah_thanks_for_that_guys) {
        if (relday) {
            day = (int)((long)day + Timekeeper.me.getDaysInLife());
        }
        if (relhour) {
            hour += Timekeeper.me.getHourOfDay();
        }
        if (relmin) {
            min += Timekeeper.me.getMinuteOfHour();
        }
        long time = 0L;
        time += (long)min * 60000L;
        time += (long)hour * 3600000L;
        Data.CronJob[] temp = new Data.CronJob[g_crontab.length + 1];
        System.arraycopy(g_crontab, 0, temp, 0, g_crontab.length);
        temp[Engine.g_crontab.length] = new Data.CronJob(time += (long)day * 86400000L, scriptID);
        g_crontab = temp;
    }

    public static void StartTimer(int script, int timer) {
        g_iTimedScriptScript = script;
        g_iTimedScriptTimer = g_iTimedScriptDuration = timer;
    }

    public static void AbortTimer() {
        g_iTimedScriptTimer = -1;
    }

    public static int FindCharacter(int mchr) {
        boolean day = Timekeeper.me.isDaytime();
        Data.PlacedObject p = null;
        int i = Data.rooms.length;
        while (i-- > 0) {
            if (Data.rooms[i].objs == null) continue;
            int j = Data.rooms[i].objs.length;
            while (j-- > 0) {
                p = Data.rooms[i].objs[j];
                if (p.gfx != mchr || !p.type || (!day || !p.day) && (day || !p.night)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void ClearOptionList() {
        Data.options.removeAllElements();
    }

    public static void RemoveCharacter(int _character) {
        g_currentroom.RemoveCharacter(_character);
    }

    public static void RemoveObject(int _objnum) {
        g_currentroom.RemoveObject(_objnum);
    }

    public static void RemoveObjectID(int _objnum) {
        g_currentroom.RemoveObjectID(_objnum);
    }

    public static boolean attemptMove(int _x, int _y) {
        return g_currentroom.attemptMove(_x, _y);
    }

    public static void ShowCharacter(int _character, int _x, int _y, boolean _relative, boolean _tile) {
        g_currentroom.ShowCharacter(_character, _x, _y, _relative, _tile);
    }

    public static void HideAllCharactersInRoom() {
        g_currentroom.HideAllCharactersInRoom();
    }

    public static void HideObjectID(int _start, int _end) {
        g_currentroom.HideObjectID(_start, _end);
    }

    public static void ShowObjectID(int _start, int _end) {
        g_currentroom.ShowObjectID(_start, _end);
    }

    public static void UnhideAll() {
        g_currentroom.UnhideAll();
    }

    public static void SetSelectedObject(int _objnum) {
        g_currentroom.SetSelectedObject(_objnum);
    }

    public static void SetSelectedCharacter(int _character) {
        g_currentroom.SetSelectedCharacter(_character);
    }

    public static void setHighlightedIndex(int _index) {
        g_currentroom.setHighlightedIndex(_index);
    }

    public static int getHighlightedIndex() {
        return g_currentroom.getHighlightedIndex();
    }

    public static void UnsetSelectedObject() {
        g_currentroom.UnsetSelectedObject();
    }

    public static void SetSelectedObjectID(int _number) {
        g_currentroom.SetSelectedObjectID(_number);
    }

    public static void ClearDestinationList() {
        MultiOptiList.ClearDestinationList();
    }

    public static void SetDestination(int num, int room, int x, int y, boolean tile) {
        MultiOptiList.SetDestination(num, room, x, y, tile);
    }

    public static void AddDestination(int room, int x, int y, boolean tile) {
        MultiOptiList.AddDestination(room, x, y, tile);
    }

    public static void ShowDestinationList(Scripts.ScriptThread script) {
        MultiOptiList.ShowDestinationList(script);
    }

    public static void AddOption(int txt) {
        MultiOptiList.AddOption(txt);
    }

    public static int ShowOptionList() {
        return MultiOptiList.ShowOptionList();
    }

    public static void ShowOptionList(Scripts.ScriptThread script, boolean yet_another_arbritrary_parameter_thanks_for_telling_us_first_guys) {
        MultiOptiList.ShowOptionList(script, yet_another_arbritrary_parameter_thanks_for_telling_us_first_guys);
    }

    public static void ShowMinigame(Scripts.ScriptThread script, int number, int level) {
        MiniGame.ShowMinigame(script, number, level);
    }

    public static void ShowMinigame(int number, int level) {
        MiniGame.ShowMinigame(number, level);
    }

    public static void HideMinigame() {
        MiniGame.HideMinigame();
    }

    public static int numberScore() {
        return MiniGame.g_numbergame.level - 1;
    }

    public static void CheckCrons() {
    }

    public static void setupCam() {
        g_iCameraX = 0;
        g_iCameraY = 0;
        g_iCameraMinX = 0;
        g_iCameraMaxX = Render.tileToWorldX(Engine.g_currentroom.tileCountX, Engine.g_currentroom.tileCountY);
        g_iCameraMinY = Render.tileToWorldY(Engine.g_currentroom.tileCountX, 0) - 100;
        g_iCameraMaxY = Render.tileToWorldY(0, Engine.g_currentroom.tileCountY);
        int camPanSize = g_iCameraMaxX - g_iCameraMinX;
        int camPitchSize = g_iCameraMaxY - g_iCameraMinY;
        if (camPanSize <= Engine.me.boundsWidth) {
            g_iCameraMinX = g_iCameraMaxX = camPanSize / 2;
        } else {
            g_iCameraMinX += Engine.me.boundsWidth / 2;
            g_iCameraMaxX -= Engine.me.boundsWidth / 2;
        }
        if (camPitchSize <= Engine.me.boundsHeight) {
            g_iCameraMaxY = -50;
            g_iCameraMinY = -50;
        } else {
            g_iCameraMinY += Engine.me.boundsHeight / 2;
            g_iCameraMaxY -= Engine.me.boundsHeight / 2;
        }
    }

    public static void setCamera(int _x, int _y) {
        if (_x < g_iCameraMinX) {
            _x = g_iCameraMinX;
        }
        if (_x > g_iCameraMaxX) {
            _x = g_iCameraMaxX;
        }
        if (_y < g_iCameraMinY) {
            _y = g_iCameraMinY;
        }
        if (_y > g_iCameraMaxY) {
            _y = g_iCameraMaxY;
        }
        g_iCameraX = _x;
        g_iCameraY = _y;
    }

    public static void MoveCamera(Scripts.ScriptThread _thread, int _x, int _y, boolean _relative, boolean _tileBasedCoords) {
        if (_tileBasedCoords) {
            _x = Render.tileToScreenX(_x, _y);
            _y = Render.tileToScreenY(_x, _y);
        }
        Engine.setCamera(_x, _y);
    }

    static {
        g_crontab = new Data.CronJob[0];
        scripts = new Vector();
        g_bControlsEnabled = true;
        g_bInProximity = false;
        g_bMayFlipDirection = true;
        g_bNeedsDecrease = false;
        g_bRepaint = true;
        g_bScriptDone = false;
        g_bSoundPlayed = false;
        m_bHideSelection = false;
        m_playerNaked = false;
        g_bPlayerGiftCount = 0;
        g_iArrowNumber = 0;
        g_iElapsedCounter = 0;
        g_iElapsedMovement = 0;
        g_iLastMinigameScore = 0;
        g_iMoney = 0;
        g_iMugCount = 0;
        g_iSelectedChr = -1;
        g_iTalkRelationshipScript = -1;
        g_lMoveTime = 0;
        g_iArrowTimer = 0L;
        g_lLastFrameTime = 0L;
        g_lRealtimeTimer = 0L;
    }
}

