/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends.loading;

import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.gui.Menu;
import com.creativenorth.gui.ScreenObject;
import schoolfriends.SchoolCore;
import schoolfriends.games.MiniGame;
import schoolfriends.loading.LoadingRequirement;

public class LoadingBar
extends ScreenObject {
    public static LoadingBar me;
    protected static int m_nProgressMax;
    protected static int m_nProgress;
    protected static LoadingRequirement m_loader;
    static int m_subsequentMenu;

    public LoadingBar() {
        me = this;
        m_nProgressMax = 100;
    }

    public static void setNeeded(LoadingRequirement loader, int _subsequentMenu) {
        m_loader = loader;
        m_nProgressMax = 100;
        m_nProgress = 0;
        m_subsequentMenu = _subsequentMenu;
    }

    private final void loadNextItem() {
        if (m_loader == null) {
            return;
        }
        if (!m_loader.loadSector()) {
            m_nProgress = (m_loader.getState() * 100 + m_loader.getStateProgress()) / m_loader.getMaxStates();
        } else {
            m_nProgress = m_nProgressMax;
            m_loader = null;
            SchoolCore.me.showSoftkeys();
        }
    }

    public void renderMeDebug(CNGraphics _graphics) {
        this.render(_graphics);
    }

    public void render(CNGraphics graphics) {
        int col = graphics.m_graphics.getColor();
        graphics.setColor(16753467);
        int x = this.boundsX;
        int y = this.boundsY + (this.boundsHeight - 10) / 2;
        int w1 = 10 + (this.boundsWidth - 20) * m_nProgress / m_nProgressMax;
        int w2 = (this.boundsWidth - 20) * m_nProgress / m_nProgressMax + 4;
        graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        if (w2 >= 0) {
            graphics.fillRect(x + 9, y, w2, 10);
            graphics.setColor(0);
            graphics.drawRect(x + 9, y, w2, 10);
        }
        if (MiniGame.snakegfx != null && MiniGame.snakegfx[1] != null && MiniGame.snakegfx[2] != null) {
            graphics.m_graphics.drawRegion(MiniGame.snakegfx[2].getImage(), 0, 0, 10, 10, 2, x, y, 0);
            graphics.m_graphics.drawRegion(MiniGame.snakegfx[1].getImage(), 0, 0, 10, 10, 2, x + w1, y, 0);
        }
        int txt = 484;
        if (m_nProgress >= m_nProgressMax) {
            txt = 514;
        }
        ScreenObject.setText(47, txt);
        this.loadNextItem();
    }

    public void onKeyDown(int keymask) {
        if ((keymask == 16 || keymask == 64) && m_loader == null) {
            Menu.gotoMenu(m_subsequentMenu);
        }
    }

    public static int getProgress() {
        return m_nProgress;
    }

    public static boolean isLoading() {
        return m_loader != null;
    }

    static {
        m_nProgressMax = 100;
        m_nProgress = 0;
        m_subsequentMenu = 0;
    }
}

